import { notificaciontoast } from "../../common/method_toast.js";
import { confirmation_sweetAlert } from "../../common/method_sweetAlert.js";
import { getButtonsSchema, languageSchema } from '../../common/schemas.js';

$(document).ready(function () {

    const tableName = "Equivalencias entre Planes";

    var dt_idsemester = "0", dt_idplan = "1", dt_idplanequivalence = "0", dt_idplan1 = "0", dt_idplan2 = "0";
    var formModal, formData;

    // LISTAR DATATABLE
    var table = $('#datatableGeneral').DataTable({
        createdRow: function (row, data, index) {
            $(row).addClass("selected");
        },
        order: [],
        ajax: {
            headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
            type: 'POST',
            url: '/admin/planes_estudio/equivalencias/list',
        },
        searching: true,
        pageLength: 12, // 12 filas
        dom: "Bfrtip",
        select: false,
        lengthChange: false,
        responsive: true,
        language: languageSchema,
        buttons: getButtonsSchema(tableName),
        columns: [
            { data: 'idplanequivalence', className: 'text-center', },
            { data: 'equivalencia_plan1', className: 'text-center', },
            { data: 'equivalencia_plan2', className: 'text-center', },
            { data: "documento", sortable: false, className: "text-center",
                render: function (data, type, all, meta) {
                    if (all.documento == null) {
                        return "--";
                    } else if (all.documento == "--") {
                        return `
                        <div class="d-flex justify-content-center">
                            <a href="javascript:void(0);"
                            class="btnVerEquivalenciasCursos btn btn-info shadow btn-xs sharp me-3"
                            data-idplanequivalence="${all.idplanequivalence}"
                            data-idplan1="${all.plan_id1}"
                            data-idplan2="${all.plan_id2}"
                            data-bs-placement="top"
                            title="Ver cursos">
                            <i class="fas fa-eye fa-lg"></i>
                            </a>

                            <a href="javascript:void(0);"
                            class="btn btn-danger shadow btn-xs sharp disabled"
                            data-bs-placement="top"
                            title="No hay documento">
                            <i class="fas fa-xmark fa-lg"></i>
                            </a>

                        </div>
                        `;
                    } else {
                        return `
                        <div class="d-flex justify-content-center">
                            <a href="javascript:void(0);"
                            class="btnVerEquivalenciasCursos btn btn-info shadow btn-xs sharp me-3"
                            data-idplanequivalence="${all.idplanequivalence}"
                            data-idplan1="${all.plan_id1}"
                            data-idplan2="${all.plan_id2}"
                            data-bs-placement="top"
                            title="Ver Curso">
                            <i class="fas fa-eye fa-lg"></i>
                            </a>

                            <a href="/verDocumentoEquivalencia/${all.idplanequivalence}"
                            class="btnVerDocumento btn btn-info shadow btn-xs sharp"
                            target="_blank"
                            data-bs-placement="top"
                            title="Ver Documento">
                            <i class="fas fa-file-lines fa-lg"></i>
                            </a>
                        </div>
                        `;
                    }
                },
            },
            {
                data: "idplanequivalence", className: "text-center noExport", sortable: false,
                searchable: false,
                render: function (data, type, all, meta) {
                    return `
                            <div class="d-flex justify-content-center">

                                <a href="javascript:void(0);" class="editBtn btn btn-warning shadow btn-xs sharp me-3"
                                data-idplanequivalence="${all.idplanequivalence}"
                                data-bs-placement="top"
                                title="Editar registro">
                                <i class="fas fa-pencil-alt"></i>
                                </a>

                                <a href="javascript:void(0);" class="deleteBtn btn btn-danger shadow btn-xs sharp"
                                data-idplanequivalence="${all.idplanequivalence}"
                                data-bs-placement="top"
                                title="Eliminar registro">
                                <i class="fas fa-trash"></i>
                                </a>

                            </div>

                            `;
                },
            },
        ],
    });

    // Agregar una columna de números automáticos
    table.on('order.dt search.dt', function () {
        table.column(0, { search: 'applied', order: 'applied' }).nodes().each(function (cell, i) {
            cell.innerHTML = i + 1;
        });
    }).draw();

    cb_plans1();
    cb_plans2();

    // listar planes
    function cb_plans1() {
        $("#txt-plans1").find("option").remove().end() // delete options
        $.ajax({
            type: "GET",
            url: '/ajax_all/plans_programs',
            dataType: 'json',
            beforeSend: function () { },
            success: function (response) {
                $("#txt-plans1").append('<option selected disabled value="">Seleccione plan</option>');
                response.forEach((elemento) => {
                    $("#txt-plans1").append('<option ' +
                        ' value="' + elemento.id + '"' +
                        ' data-nombre="' + elemento.nombre + '"' +
                        ' data-tipo="' + elemento.tipo + '"' +
                        ' data-modalidad="' + elemento.modalidad + '"' +
                        ' data-enfoque="' + elemento.enfoque + '"' +
                        ' >' + elemento.nombre + " - " + elemento.nombreprograma + '</option>');
                })
                $("#txt-plans1").selectpicker("refresh");
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    function cb_plans2() {
        $("#txt-plans2").find("option").remove().end() // delete options
        $.ajax({
            type: "GET",
            url: '/ajax_all/plans_programs',
            dataType: 'json',
            beforeSend: function () { },
            success: function (response) {
                $("#txt-plans2").append('<option selected disabled value="">Seleccione plan</option>');
                response.forEach((elemento) => {
                    $("#txt-plans2").append('<option ' +
                        ' value="' + elemento.id + '"' +
                        ' data-nombre="' + elemento.nombre + '"' +
                        ' data-tipo="' + elemento.tipo + '"' +
                        ' data-modalidad="' + elemento.modalidad + '"' +
                        ' data-enfoque="' + elemento.enfoque + '"' +
                        ' >' + elemento.nombre + " - " + elemento.nombreprograma + '</option>');
                })
                $("#txt-plans2").selectpicker("refresh");
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }


    var valbtn, formCheck;

    // INICIO - MODAL CREATE
    $("#btnCreateModal").click(function () {
        // change value
        $("#btnCreateUpdate").attr("value", "Create");
        $("#btnCreateUpdate").html("Registrar");
        $("#modalCreateUpdateLabel").html("Registrar nueva Equivalencia");
        // mostrar div
        $("#div-txt-programs").removeAttr("style");
        $("#txt-programs").attr("required", "true");    // agregar required
        $("#div-txt-plans1").removeAttr("style");
        $("#txt-plans1").attr("required", "true");    // agregar required
        $("#div-txt-plans2").removeAttr("style");
        $("#txt-plans2").attr("required", "true");    // agregar required
        $("#div-txt-document").removeAttr("style");
        $("#txt-document").attr("required", "true");    // agregar required
        clearForm();    // limpiar formulario
        // limpiar validaciones
        formCheck = $("#formModal")[0];
        $(formCheck).removeClass('was-validated'); // remover validaciones
    });
    // FIN - MODAL CREATE

    // INICIO - MODAL UPDATE
    $("#datatableGeneral tbody").on("click", ".editBtn", function (e) {
        // limpiar validaciones
        formCheck = $("#formModal")[0];
        $(formCheck).removeClass('was-validated'); // remover validaciones
        //cambiar el text del button
        $("#btnCreateUpdate").attr("value", "Update");
        $("#btnCreateUpdate").html("Actualizar");
        $("#modalCreateUpdateLabel").html("Actualizar equivalencia");
        // ocultar div
        $("#div-txt-programs").css("display", "none");
        $("#txt-programs").removeAttr("required");  // para poder pasar el check validity
        $("#div-txt-plans1").css("display", "none");
        $("#txt-plans1").removeAttr("required");  // para poder pasar el check validity
        $("#div-txt-plans2").css("display", "none");
        $("#txt-plans2").removeAttr("required");  // para poder pasar el check validity
        $('#txt-document').val('');
        $("#txt-document").removeAttr("required");  // para poder pasar el check validity
        // setear data de usuario
        $("#txt-idplanequivalence").val($(this).data("idplanequivalence"));
        // $("#txt-fecha").val($(this).data("fechadocument"));
        // show form
        $("#modalCreateUpdate").modal("show");

    });
    // FIN - MODAL UPDATE

    // INICIO - MODAL DELETE
    $("#datatableGeneral tbody").on("click", ".deleteBtn", function (e) {
        let idplanequivalence = $(this).data("idplanequivalence")
        // confirmacion
        confirmation_sweetAlert("Deseas continuar?", "Se procederá a eliminar el registro de la base de datos", "warning")
            .then(function (isConfirm) {
                if (isConfirm.value) {
                    // enviando el parametro de la data que se procede a delete
                    destroy(idplanequivalence);
                } else {
                    console.log("Cancelado");
                }
            });
    });
    // FIN - MODAL DELETE

    // INICIO - FUNCION CREATE O UPDATE
    $("#btnCreateUpdate").on("click", function (event) {
        event.preventDefault();
        // Iterar sobre los formularios y evitar la acción predeterminada si no son válidos
        formCheck = $("#formModal")[0];
        if (!formCheck.checkValidity()) {
            event.preventDefault();
            event.stopPropagation();
        } else {
            valbtn = $("#btnCreateUpdate").val();
            // FUNCION CREAR
            if (valbtn === "Create") {
                // insertar
                store();
            }
            // FUNCION ACTUALIZAR
            if (valbtn === "Update") {
                // actualizar
                update($("#txt-idplanequivalence").val());
            }
        }
        $(formCheck).addClass('was-validated'); // añadir validaciones
    });
    // FIN - FUNCION CREATE O UPDATE


    function store() {
        formData = new FormData(document.getElementById('formModal'));
        $.ajax({
            headers: { "X-CSRF-TOKEN": $('input[name="_token"]').val() },
            type: "POST",
            url: '/admin/planes_estudio/equivalencias/store',
            data: formData,
            processData: false,
            contentType: false,
            beforeSend: function () {
                $('#btnCreateUpdate').addClass('disabled');
            },
            success: function (data) {
                if (data.status == true) {
                    table.ajax.reload();
                    setTimeout(function () {
                        notificaciontoast("info", data.mensaje, "Éxito!");
                        $("#modalCreateUpdate").modal("hide");
                        $('#btnCreateUpdate').removeClass('disabled');
                    }, 1000); // ocultar despues de 1 sec
                } else {
                    table.ajax.reload();
                    notificaciontoast("error", data.mensaje, "Error!");
                    notificaciontoast("info", "Registrando equivalencia sin documento", "Exito!");
                    $('#btnCreateUpdate').removeClass('disabled');
                }
            },
            error: function (error) {
                console.log("Error", error);
                $('#btnCreateUpdate').removeClass('disabled');
            },
        });
    }

    function update(idplanequivalence) {
        formData = new FormData(document.getElementById('formModal'));
        $.ajax({
            headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
            type: "POST",
            url: '/admin/planes_estudio/equivalencias/update/' + idplanequivalence,
            data: formData,
            processData: false,
            contentType: false,
            beforeSend: function () {
                $('#btnCreateUpdate').addClass('disabled');
            },
            success: function (data) {
                if (data.status == true) {
                    table.ajax.reload();
                    setTimeout(function () {
                        notificaciontoast("info", data.mensaje, "Éxito!");
                        $("#modalCreateUpdate").modal("hide");
                        $('#btnCreateUpdate').removeClass('disabled');
                    }, 1000);   // ocultar despues de 1 sec
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                    $('#btnCreateUpdate').removeClass('disabled');
                }
            },
            error: function (error) {
                console.log("Error", error);
                $('#btnCreateUpdate').removeClass('disabled');
            },
        });
    }

    function destroy(idplanequivalence) {
        $.ajax({
            headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
            type: "DELETE",
            url: '/admin/planes_estudio/equivalencias/destroy/' + idplanequivalence,
            beforeSend: function () { },
            success: function (data) {
                if (data.status == true) {
                    table.ajax.reload();
                    notificaciontoast("info", data.mensaje, "Éxito!");
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }


    // LIMPIAR FORMULARIO
    function clearForm() {
        $('#txt-idplanequivalence').val('');
        $('#txt-programs').selectpicker('val', '');
        $('#txt-plans1').selectpicker('val', '');
        $('#txt-plans2').selectpicker('val', '');
        $('#txt-document').val('');
    }



    // LISTAR DATATABLE 2
    var table2 = $('#datatableGeneral2').DataTable({
        createdRow: function (row, data, index) {
            $(row).addClass("selected");
        },
        order: [],
        ajax: {
            headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
            type: 'POST',
            url: '/admin/planes_estudio/equivalencias_cursos/list_by_idplanequivalence',
            data: function (d) {
                d.idplanequivalence = dt_idplanequivalence;
            },
        },
        searching: false,
        paging: false, // Deshabilita la paginación
        info: false, // Oculta la información de entradas
        pageLength: 12, // 12 filas
        select: false,
        lengthChange: false,
        responsive: true,
        language: languageSchema,
        columns: [
            { data: 'idcourseequivalence', className: 'text-center' },
            {
                data: "nombrecurso1",
                className: "text-center",
                render: function (data, type, all, meta) {
                    return 'Periodo: ' + all.numeroperiodo1 + ' - ' + all.nombrecurso1 + ' (COD: ' + all.codcurso1 + ')';
                },
            },
            {
                data: "nombrecurso2",
                className: "text-center",
                render: function (data, type, all, meta) {
                    return 'Periodo: ' + all.numeroperiodo2 + ' - ' + all.nombrecurso2 + ' (COD: ' + all.codcurso2 + ')';
                },
            },
            {
                data: "idcourseequivalence",
                className: "text-center noExport",
                sortable: false,
                searchable: false,
                render: function (data, type, all, meta) {
                    return `
                            <div class="d-flex justify-content-center">

                                <a href="javascript:void(0);" class="deleteBtn btn btn-danger shadow btn-xs sharp"
                                data-idcourseequivalence="${all.idcourseequivalence}"
                                data-bs-placement="top"
                                title="Eliminar registro">
                                <i class="fas fa-trash"></i>
                                </a>

                            </div>

                            `;
                },
            },
        ],
    });

    // Agregar una columna de números automáticos
    table2.on('order.dt search.dt', function () {
        table2.column(0, { search: 'applied', order: 'applied' }).nodes().each(function (cell, i) {
            cell.innerHTML = i + 1;
        });
    }).draw();




    // INICIO - MODAL VER EQUIVALENCIAS CURSOS
    $("#datatableGeneral tbody").on("click", ".btnVerEquivalenciasCursos", function (e) {
        dt_idplanequivalence = $(this).data("idplanequivalence");
        $('#txt-idplanequivalence2').val(dt_idplanequivalence);
        dt_idplan1 = $(this).data("idplan1");
        dt_idplan2 = $(this).data("idplan2");
        // cargar tabla
        table2.ajax.reload();
        setTimeout(function () { $("#modalDetalleEquivalencias").modal("show"); }, 10); // mostrar despues de x sec
        // mostrar modal
    });
    // FIN - MODAL VER EQUIVALENCIAS CURSOS

    // INICIO - MODAL DELETE EQUIVALENCIAS CURSOS
    $("#datatableGeneral2 tbody").on("click", ".deleteBtn", function (e) {
        let idcourseequivalence = $(this).data("idcourseequivalence")
        // confirmacion
        confirmation_sweetAlert("Deseas continuar?", "Se procederá a eliminar el registro de la base de datos", "warning")
            .then(function (isConfirm) {
                if (isConfirm.value) {
                    // enviando el parametro de la data que se procede a delete
                    destroy_courseequivalence(idcourseequivalence);
                } else {
                    console.log("Cancelado");
                }
            });
    });
    // FIN - MODAL DELETE EQUIVALENCIAS CURSOS

    function destroy_courseequivalence(idcourseequivalence) {
        $.ajax({
            headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
            type: "DELETE",
            url: '/admin/planes_estudio/equivalencias_cursos/destroy/' + idcourseequivalence,
            beforeSend: function () { },
            success: function (data) {
                if (data.status == true) {
                    table2.ajax.reload();
                    notificaciontoast("info", data.mensaje, "Éxito!");
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }


    // INICIO - CREAR EQUIVALENCIA DE CURSOS
    $("#btnCreateModal2").on("click", function (e) {
        formCheck = $("#formModal3")[0];
        $(formCheck).removeClass('was-validated'); // remover validaciones
        cb_course1(dt_idplan1);
        cb_course2(dt_idplan2);
        setTimeout(function () { $("#modalCreate2").modal("show"); }, 500); // mostrar despues de x sec
        // mostrar modal
    });
    // FIN - CREAR EQUIVALENCIA DE CURSOS

    // listar cursos
    function cb_course1(idplan) {
        $("#txt-course1").find("option").remove().end() // delete options
        $.ajax({
            type: "GET",
            url: '/ajax_all/course/by_idplan/' + idplan,
            dataType: 'json',
            beforeSend: function () { },
            success: function (response) {
                $("#txt-course1").append('<option selected disabled value="">Seleccione curso</option>');
                response.forEach((elemento) => {
                    $("#txt-course1").append('<option ' +
                        ' value="' + elemento.idcourse + '"' +
                        ' data-tipo="' + elemento.tipo + '"' +
                        ' data-codcurso="' + elemento.codcurso + '"' +
                        ' data-nombre="' + elemento.nombre + '"' +
                        ' data-codpredecesor="' + elemento.codpredecesor + '"' +
                        ' data-horas="' + elemento.horas + '"' +
                        ' data-creditos="' + elemento.creditos + '"' +
                        ' > Periodo: ' + elemento.numero + ' - ' + elemento.nombre + ' (COD: ' + elemento.codcurso + ')' + '</option>');
                })
                $("#txt-course1").selectpicker("refresh");
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    // listar cursos
    function cb_course2(idplan) {
        $("#txt-course2").find("option").remove().end() // delete options
        $.ajax({
            type: "GET",
            url: '/ajax_all/course/by_idplan/' + idplan,
            dataType: 'json',
            beforeSend: function () { },
            success: function (response) {
                $("#txt-course2").append('<option selected disabled value="">Seleccione curso</option>');
                response.forEach((elemento) => {
                    $("#txt-course2").append('<option ' +
                        ' value="' + elemento.idcourse + '"' +
                        ' data-tipo="' + elemento.tipo + '"' +
                        ' data-codcurso="' + elemento.codcurso + '"' +
                        ' data-nombre="' + elemento.nombre + '"' +
                        ' data-codpredecesor="' + elemento.codpredecesor + '"' +
                        ' data-horas="' + elemento.horas + '"' +
                        ' data-creditos="' + elemento.creditos + '"' +
                        ' > Periodo: ' + elemento.numero + ' - ' + elemento.nombre + ' (COD: ' + elemento.codcurso + ')' + '</option>');
                })
                $("#txt-course2").selectpicker("refresh");
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    // INICIO - FUNCION CREATE O UPDATE
    $("#btnCreate2").on("click", function (event) {
        event.preventDefault();
        // Iterar sobre los formularios y evitar la acción predeterminada si no son válidos
        formCheck = $("#formModal3")[0];
        if (!formCheck.checkValidity()) {
            event.preventDefault();
            event.stopPropagation();
        } else {
            store_courseequivalence();
        }
        $(formCheck).addClass('was-validated'); // añadir validaciones
    });
    // FIN - FUNCION CREATE O UPDATE


    function store_courseequivalence() {
        formData = new FormData(document.getElementById('formModal3'));
        $.ajax({
            headers: { "X-CSRF-TOKEN": $('input[name="_token"]').val() },
            type: "POST",
            url: '/admin/planes_estudio/equivalencias_cursos/store',
            data: formData,
            processData: false,
            contentType: false,
            beforeSend: function () {
                $('#btnCreate2').addClass('disabled');
            },
            success: function (data) {
                if (data.status == true) {
                    table2.ajax.reload();
                    setTimeout(function () {
                        notificaciontoast("info", data.mensaje, "Éxito!");
                        $("#modalCreate2").modal("hide");
                        $('#btnCreate2').removeClass('disabled');
                    }, 1000); // ocultar despues de 1 sec
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                    $('#btnCreate2').removeClass('disabled');
                }
            },
            error: function (error) {
                console.log("Error", error);
                $('#btnCreate2').removeClass('disabled');
            },
        });
    }

});


