import { notificaciontoast } from "../../common/method_toast.js";
import { confirmation_sweetAlert } from "../../common/method_sweetAlert.js";
import { getButtonsSchema, languageSchema } from '../../common/schemas.js';
import { tl_programs, tl_plans} from "../../common/timeline/programs.js";

$(document).ready(function () {

    const tableName = "Asignaturas";
    var dt_idsemester = "0", dt_idsubject = "0", dt_idstudent = "0";
    var formModal, formData, formCheck;
    // LISTAR DATATABLE

    var table = $('#datatableGeneral').DataTable({
        createdRow: function (row, data, index) {
            $(row).addClass("selected");
        },
        order: [],
        ajax: {
            headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
            type: 'POST',
            url: '/admin/notas/list_nota_asignatura',
            data: function (d) {
                d.idsemester = dt_idsemester;
                d.idsubject = dt_idsubject;
            },
        },
        searching: true,
        pageLength: 12, // 12 filas
        dom: "Bfrtip",
        select: false,
        lengthChange: false,
        responsive: true,
        language: languageSchema,
        buttons: getButtonsSchema(tableName),
        columns: [
            { data: "idstudent", className: "text-center bg-primary", sortable: false },
            { data: "identificacion", className: "text-center bg-primary", sortable: false },
            { data: "estudiante", className: "text-center bg-primary", sortable: false },
            { data: "idstudent", sortable: false, className: "text-center",
                render: function (data, type, all, meta) {
                    return `
                    <div class="d-flex justify-content-center">
                        <a href="javascript:void(0);" class="btnViewEvaluations btn btn-success shadow btn-xs sharp"
                            data-idstudent="${all.idstudent}"
                            data-estudiante="${all.estudiante}"
                            data-idsubject="${all.idsubject}"
                            data-bs-placement="top"
                            title="Ver Evaluaciones">
                            <i class="fa-solid fa-eye fa-fade fa-xl"></i>
                        </a>
                    </div>
                    `;
                },
            },
            { data: "promedio_final", className: "text-center bg-primary", sortable: false },
            { data: "promedio_final", className: "text-center", sortable: false,
                render: function (data, type, all, meta) {
                    if (all.promedio_final == 0) {
                        return `<span class="badge light badge-dark">Sin Evaluar</span>`;
                    } else if (all.promedio_final < 12.5) {
                        return `<span class="badge light badge-danger">Desaprobado</span>`;
                    } else if (all.promedio_final >= 12.5){
                        return `<span class="badge light badge-success">Aprobado</span>`;
                    }
                },
            },
        ]
    });

    // Agregar una columna de números automáticos
    table.on('order.dt search.dt', function () {
        table.column(0, { search: 'applied', order: 'applied' }).nodes().each(function (cell, i) {
            cell.innerHTML = i + 1;
        });
    }).draw();

    var selectedOption;

    // on change semesters
    $(document).on("click", ".btnSemester", function () {
        dt_idsemester = $(this).attr("data-idsemester");
        $(".divsemester").removeClass("dark").addClass("primary");
        $(this).prev("div").removeClass("primary").addClass("dark");
        notificaciontoast("info", "Consultando a la  base de datos!", "Mensaje!");
        table.ajax.reload();
    });


    // on change programas
    $(document).on("click", ".btnProgram", function () {
        let idprogram = $(this).attr("data-idprogram");
        $(".divprogram").removeClass("dark").addClass("primary");
        $(this).prev("div").removeClass("primary").addClass("dark");
        document.getElementById("tlplan").innerHTML = "";
        document.getElementById("tlsubject").innerHTML = "";
        tl_plans(idprogram);
        // limpiar tabla
        dt_idsubject = "0"
        table.ajax.reload();
    });


    // on change planes
    $(document).on("click", ".btnPlan", function () {
        let idplan = $(this).attr("data-idplan");
        $(".divplan").removeClass("dark").addClass("primary");
        $(this).prev("div").removeClass("primary").addClass("dark");
        tl_subjects(idplan, dt_idsemester);
    });

    // listar periodos por plan
    function tl_subjects(idplan, idsemester) {
        document.getElementById("tlsubject").innerHTML = "";
        $.ajax({
            type: "GET",
            url: "/ajax_all/subjects/" + idplan + "/" + idsemester,
            dataType: "json",
            beforeSend: function () {},
            success: function (response) {
                response.forEach((elemento) => {
                    document.getElementById("tlsubject").innerHTML +=
                        "<li class=''>" +
                        "<div class='divperiod timeline-badge primary'></div>" +
                        "<a class='btnSubject timeline-panel text-muted px-2 py-1 mr-4 ml-2' href='javascript:void(0);' " +
                            "data-idperiod='" + elemento.idperiod + "'" +
                            "data-idsubject='" + elemento.idsubject + "'" +

                        ">" +
                        "<strong class='text-dark'>" + elemento.curso + "</strong><br>" +
                        "<strong class='text-dark'>Periodo: " + elemento.periodo + ", Sección: " + elemento.seccion + "</strong><br>" +
                        "</a>" +
                        "</li>";
                });
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    // on change periodos
    $(document).on("click", ".btnSubject", function () {
        dt_idsubject = $(this).attr("data-idsubject");

        $(".divperiod").removeClass("dark").addClass("primary");
        $(this).prev("div").removeClass("primary").addClass("dark");
        //info Toast
        notificaciontoast("info", "Consultando a la  base de datos!", "Mensaje!");
        table.ajax.reload();
    });



    // INICIO - MODAL VER Curso
    $("#datatableGeneral tbody").on("click", ".btnViewEvaluations", function (e) {
        dt_idstudent = $(this).data("idstudent");
        document.getElementById("modalDetalleNotasLabel").innerHTML = "Detalle notas del alumno: " + $(this).data("estudiante")
        // cargar tabla
        table_evaluations.ajax.reload();
        setTimeout(function () { $("#modalDetalleNotas").modal("show"); }, 500); // mostrar despues de x sec
        // mostrar modal
    });
    // FIN - MODAL VER Curso


    // LISTAR DATATABLE 2
    var table_evaluations = $('#datatableGeneralEvaluaciones').DataTable({
        createdRow: function (row, data, index) {
            $(row).addClass("selected");
        },
        order: [],
        ajax: {
            headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
            type: 'POST',
            url: '/admin/notas/list_detalle_nota',
            data: function (d) {
                d.idstudent = dt_idstudent,
                d.idsubject = dt_idsubject;
            },
        },
        searching: false,
        paging: false, // Deshabilita la paginación
        info: false, // Oculta la información de entradas
        pageLength: 20, // 20 filas
        select: false,
        lengthChange: false,
        responsive: true,
        language: languageSchema,
        columns: [
            { data: "prom_final", sortable: false, className: "text-center", name: 'primero',
                render: function (data, type, all, meta) {
                    return `
                        <h4>Promedio Final</h4>
                        <h4>${all.prom_final}</h4>
                    `;
                },
            },
            { data: "indicador", sortable: false, className: "text-center", name: 'primero',
                render: function (data, type, all, meta) {
                    if (all.indicador == "--") {
                        return `
                            --
                        `;
                    } else {
                        return `
                            <h6>${all.indicador}</h6>
                            <b>Promedio: ${all.prom_indicador}</b>
                        `;
                    }
                },
            },
            { data: "actividad", sortable: false, className: "text-center", name: 'segundo',
                render: function (data, type, all, meta) {
                    if (all.actividad == "--") {
                        return `
                            --
                        `;
                    } else {
                        return `
                            <h6>${all.actividad}</h6>
                            <b>Promedio: ${all.prom_actividad}</b>
                        `;
                    }
                },
            },
            { data: "porcentaje", sortable: false, className: "text-center", name: 'tercero',
                render: function (data, type, all, meta) {
                    if (all.nombre_nota == "--") {
                        return `
                            --
                        `;
                    } else {
                        return `
                            <h6>${all.nombre_nota} (${all.porcentaje*100}%)</h6>
                            <b>Promedio: ${all.nota_estudiante}</b>
                        `;
                    }
                },
            },
        ],
        rowsGroup: [
            'primero:name',
            'segundo:name',
            'tercero:name',
        ],
    });


    // // Agregar una columna de números automáticos
    // table_evaluations.on('order.dt search.dt', function () {
    //     table_evaluations.column(0, { search: 'applied', order: 'applied' }).nodes().each(function (cell, i) {
    //         cell.innerHTML = i + 1;
    //     });
    // }).draw();

    //REPORTE ACTA OFICIAL DE NOTAS
    $(document).on("click", "#btnActaOficial", function () {
        setTimeout(function () {
            window.open('/reportes/acta_oficial_notas/'+dt_idsubject, '_blank');
        }, 2000);
    });

    //REPORTE ACTA AUXILIAR DE NOTAS
    $(document).on("click", "#btnActaAuxiliar", function () {
        setTimeout(function () {
            window.open('/reportes/acta_auxiliar_notas/'+dt_idsubject, '_blank');
        }, 2000);
    });

});


