import { notificaciontoast } from "../../common/method_toast.js";
import { confirmation_sweetAlert } from "../../common/method_sweetAlert.js";
import { getButtonsSchema, languageSchema } from '../../common/schemas.js';
import { tl_plans, } from "../../common/timeline/programs.js";

$(document).ready(function () {

    const tableName = "Matricula Alumno y Curso";

    var dt_idsemester = "0", dt_idstudent = "0", dt_idplan ="0", dt_idsubject ="0";
    var formModal, formData;

    // LISTAR DATATABLE
    var table = $('#datatableGeneral').DataTable({
        createdRow: function (row, data, index) {
            $(row).addClass("selected");
        },
        order: [],
        ajax: {
            headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
            type: 'POST',
            url: '/admin/notas/list_nota_alumno',
            data: function (d) {
                d.idsemester = dt_idsemester;
                d.idstudent = dt_idstudent;
            },
        },
        searching: true,
        pageLength: 12, // 12 filas
        dom: "Bfrtip",
        select: false,
        lengthChange: false,
        responsive: true,
        language: languageSchema,
        buttons: getButtonsSchema(tableName),
        columns: [
            { data: "plan", className: "text-center bg-info", sortable: false,
                render: function (data, type, all, meta) {
                        return `<h5 class="badge light badge-info">` + all.plan + `</h5>`
                },
            },
            { data: "periodo", className: "text-center bg-info", sortable: false,
                render: function (data, type, all, meta) {
                        return `<h5>` + all.periodo + `</h5>`
                },
            },
            { data: "codcurso", className: "text-center bg-primary", sortable: false,
                render: function (data, type, all, meta) {
                        return `<h5>` + all.codcurso + `</h5>`
                },
            },
            { data: "curso", className: "text-center bg-primary", sortable: false,
                render: function (data, type, all, meta) {
                        return `<h5>` + all.curso + `</h5>`
                },
            },
            { data: "creditos_horas", className: "text-center bg-primary", sortable: false,
                render: function (data, type, all, meta) {
                        return `<h5>` + all.creditos_horas + `</h5>`
                },
            },
            { data: "condicion", className: "text-center bg-primary", sortable: false,
                render: function (data, type, all, meta) {
                        return `<h5>` + all.condicion + `</h5>`
                },
            },
            { data: "seccion", className: "text-center bg-primary", sortable: false,
                render: function (data, type, all, meta) {
                        return `<h5>` + all.seccion + `</h5>`
                },
            },
            { data: "turno", className: "text-center bg-primary", sortable: false,
                render: function (data, type, all, meta) {
                        return `<h5>` + all.turno + `</h5>`
                },
            },
            { data: "idstudent", sortable: false, className: "text-center",
                render: function (data, type, all, meta) {
                    return `
                    <div class="d-flex justify-content-center">
                        <a href="javascript:void(0);" class="btnViewEvaluations btn btn-success shadow btn-xs sharp"
                            data-idstudent="${all.idstudent}"
                            data-idsubject="${all.idsubject}"
                            data-bs-placement="top"
                            title="Ver Evaluaciones">
                            <i class="fa-solid fa-eye fa-fade fa-xl"></i>
                        </a>
                    </div>
                    `;
                },
            },
            { data: "promedio_final", className: "text-center bg-dark", sortable: false,
                render: function (data, type, all, meta) {
                        return `<h5>` + all.promedio_final + `</h5>`
                },
            },
            { data: "promedio_final", className: "text-center bg-dark", sortable: false,
                render: function (data, type, all, meta) {
                    if (all.promedio_final == 0) {
                        return `<span class="badge light badge-dark">Sin Evaluar</span>`;
                    }
                    else if (all.promedio_final < 12.5) {
                        return `<span class="badge light badge-danger">Desaprobado</span>`;
                    } else if (all.promedio_final > 12.5){
                        return `<span class="badge light badge-success">Aprobado</span>`;
                    }
                },
            }
        ],
    });

    const integer_to_roman = (num) => {
        if (typeof num !== 'number')
            return false;

        var digits = String(+num).split(""),
            key = ["", "C", "CC", "CCC", "CD", "D", "DC", "DCC", "DCCC", "CM",
                "", "X", "XX", "XXX", "XL", "L", "LX", "LXX", "LXXX", "XC",
                "", "I", "II", "III", "IV", "V", "VI", "VII", "VIII", "IX"],
            roman_num = "",
            i = 3;
        while (i--)
            roman_num = (key[+digits.pop() + (i * 10)] || "") + roman_num;
        return Array(+digits.join("") + 1).join("M") + roman_num;
    };


    // Agregar una columna de números automáticos
    // table.on('order.dt search.dt', function () {
    //     table.column(0, { search: 'applied', order: 'applied' }).nodes().each(function (cell, i) {
    //         cell.innerHTML = i + 1;
    //     });
    // }).draw();


    // INICIO - SELECCIONAR PERIODO LECTIVO
    $("#tlsemester").on("click", ".btnSemester", function (e) {
        dt_idsemester = $(this).data("idsemester");
        //Colorear la opcion seleccionada
        $('.divsemester').removeClass("dark").addClass("primary");
        $(this).prev('div').removeClass("primary").addClass("dark");
        //info Toast
        notificaciontoast("info", "Consultando a la  base de datos!", "Mensaje!");
        // CARGAR TABLA
        table.ajax.reload();
        cb_students(dt_idplan);
    });
    // FIN - SELECCIONAR PERIODO LECTIVO


    // // INICIO - SELECCIONAR PROGRAMA
    $("#tlprogram").on("click", ".btnProgram", function (e) {
        dt_idstudent = "0";
        cleanInfoAlumno();
        //Colorear la opcion seleccionada
        $('.divprogram').removeClass("dark").addClass("primary");
        $(this).prev('div').removeClass("primary").addClass("dark");
        // listar planes
        tl_plans($(this).data("idprogram"));
        // limpiar alumnos
        $("#txt-students").find("option").remove().end() // delete options
        $("#txt-students").append('<option selected disabled value="">Buscar alumno</option>');
        $("#txt-students").selectpicker("refresh");
        // CARGAR TABLA
        table.ajax.reload();
    });
    // FIN - SELECCIONAR PROGRAMA


    // // INICIO - SELECCIONAR PLAN
    $("#tlplan").on("click", ".btnPlan", function (e) {
        dt_idstudent = "0";
        cleanInfoAlumno();
        //Colorear la opcion seleccionada
        $('.divplan').removeClass("dark").addClass("primary");
        $(this).prev('div').removeClass("primary").addClass("dark");
        // listar alumnos
        dt_idplan=$(this).data("idplan");
        cb_students(dt_idplan);
        //info Toast
        notificaciontoast("info", "Consultando a la  base de datos!", "Mensaje!");
        // CARGAR TABLA
        table.ajax.reload();
    });
    // // FIN - SELECCIONAR PLAN


    function cb_students(idplan) {
        let apenom;
        $("#txt-students").find("option").remove().end() // delete options
        $.ajax({
            type: "GET",
            url: '/ajax_all/students/' + idplan,
            data:{
                idsemester: dt_idsemester,
            },
            dataType: 'json',
            beforeSend: function () { },
            success: function (response) {
                $("#txt-students").append('<option selected disabled value="">Buscar alumno</option>');
                response.forEach((elemento) => {
                    apenom = elemento.apellido_pa + " " + elemento.apellido_ma + ", " + elemento.nombres;
                    $("#txt-students").append('<option' +
                        ' value="' + elemento.idstudent + '" ' +
                        ' data-subtext="' + elemento.nroidenti + '" ' +
                        ' data-idstudent="' + elemento.idstudent + '" ' +
                        ' data-apellido_pa="' + elemento.apellido_pa + '" ' +
                        ' data-apellido_ma="' + elemento.apellido_ma + '" ' +
                        ' data-nombres="' + elemento.nombres + '" ' +
                        ' data-tipoidenti="' + elemento.tipoidenti + '" ' +
                        ' data-nroidenti="' + elemento.nroidenti + '" ' +
                        ' data-celular="' + elemento.celular + '" ' +
                        ' data-anho_ingreso="' + elemento.anho_ingreso + '" ' +
                        ' data-estado="' + elemento.estado + '" ' +
                        '>' + apenom + '</option>');
                })
                $("#txt-students").selectpicker("refresh");
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    var selectedOption;

    // on change students
    $("#txt-students").on('change', function () {
        // setear idstudent
        dt_idstudent = $(this).val();
        // insertar info en card
        selectedOption = $(this).find('option:selected');
        let apenom = selectedOption.data('apellido_pa') + " " + selectedOption.data('apellido_ma') + ", " + selectedOption.data('nombres');
        $('#txt-info-nombres').html(apenom);
        $('#txt-info-id').html(selectedOption.data('tipoidenti')+': '+selectedOption.data('nroidenti'));
        $('#txt-info-anho_ingreso').html(selectedOption.data('anho_ingreso'));

        // CARGAR TABLA
        table.ajax.reload();
    });


    function cleanInfoAlumno(){
        $('#txt-info-nombres').html('--');
        $('#txt-info-id').html('--');
        $('#txt-info-anho_ingreso').html('--');
    }



     // INICIO - MODAL VER Curso
    $("#datatableGeneral tbody").on("click", ".btnViewEvaluations", function (e) {
        dt_idsubject = $(this).data("idsubject");
        document.getElementById("modalDetalleNotasLabel").innerHTML = "Detalle notas del alumno: " + $(this).data("estudiante")
        // cargar tabla
        table_evaluations.ajax.reload();
        setTimeout(function () { $("#modalDetalleNotas").modal("show"); }, 500); // mostrar despues de x sec
        // mostrar modal
    });
    // FIN - MODAL VER Curso


    // LISTAR DATATABLE 2
    var table_evaluations = $('#datatableGeneralEvaluaciones').DataTable({
        createdRow: function (row, data, index) {
            $(row).addClass("selected");
        },
        order: [],
        ajax: {
            headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
            type: 'POST',
            url: '/admin/notas/list_detalle_nota',
            data: function (d) {
                d.idstudent = dt_idstudent,
                d.idsubject = dt_idsubject;
            },
        },
        searching: false,
        paging: false,
        info: false,
        pageLength: 12,
        select: false,
        lengthChange: false,
        responsive: true,
        language: languageSchema,
        columns: [
            { data: 'idstudentgrade', className: 'text-center' },
            { data: 'indicador', className: 'text-center', name: 'primero' },
            { data: 'actividad', className: 'text-center', name: 'primero' },
            { data: 'tipo_nota', className: 'text-center', name: 'segundo' },
            { data: "porcentaje", sortable: false, className: "text-center", name: 'segundo',
                render: function (data, type, all, meta) {
                    return `
                    <div class="d-flex justify-content-center">
                        ${all.porcentaje*100}%
                    </div>
                    `;
                },
            },
            { data: 'nombre_nota', className: 'text-center' },
            { data: 'nota_estudiante', className: 'text-center' },
        ],
        rowsGroup: [
            'primero:name',
            'segundo:name',
        ],
    });


    // Agregar una columna de números automáticos
    table_evaluations.on('order.dt search.dt', function () {
        table_evaluations.column(0, { search: 'applied', order: 'applied' }).nodes().each(function (cell, i) {
            cell.innerHTML = i + 1;
        });
    }).draw();


    $(document).on("click", "#btnPromedioAlumno", function () {
        setTimeout(function () {
            window.open('/reportes/promedio_asignaturas/'+dt_idstudent+'/'+dt_idsemester, '_blank');
        }, 2000);
    });
});


