//"use strict";
import { notificaciontoast } from "../../common/method_toast.js";
import { confirmation_sweetAlert } from "../../common/method_sweetAlert.js";
import { getButtonsSchema, languageSchema } from '../../common/schemas.js';
import { tl_semesters } from "../../common/timeline/semesters.js";

$(document).ready(function () {
    const tableName = "Reportes ";

    var idsubject = "null",  idsemester = "null", curso = "null";

    var table = $("#datatableGeneral").DataTable({
        createdRow: function (row, data, index) {
            $(row).addClass("selected");
        },
        order: [],
        ajax: {
            headers: { "X-CSRF-TOKEN": $('input[name="_token"]').val() },
            type: "POST",
            url: "/admin/notas/gestionar_nota/students_by_idsubject",
            data: function (d) {
                d.idsubject = idsubject;
            },
        },
        searching: true,
        dom: "Bfrtip",
        pageLength: 12, // 12 filas
        select: false,
        lengthChange: false,
        responsive: true,
        language: languageSchema,
        buttons: [
            {
                extend: "excel",
                title: function () {
                    return (
                        "Reporte de notas del curso: " + curso
                    );
                },
                type: "button",
                orientation: "landscape",
                className: "btn btn-sm btn-arounded",
                exportOptions: {
                    columns: ":visible",
                    orthogonal: "print",
                },
                customize: function (xlsx) {
                    var sheet = xlsx.xl.worksheets["sheet1.xml"];

                    // Establecer el ancho de las columnas si es necesario
                    var columnStyles = {
                        A: { style: 25 },
                        B: { style: 25 },
                        C: { style: 25 },
                        D: { style: 25 },
                        E: { style: 25 },
                    };

                    // Eliminar la columna 'E'
                    delete columnStyles.E;

                    for (var col in columnStyles) {
                        var style = columnStyles[col];
                        $('row c[r^="' + col + '"]', sheet).attr(
                            "s",
                            style.style
                        );
                    }

                    var rowCount = 0;
                    $("row c", sheet).each(function () {
                        var row = this;
                        if (rowCount == 0) {
                            $('c[r="A1"]', sheet).attr("s", "51");
                        }
                        // Centrar el titulo

                        var cellValue = $(this).text();

                        // Verifica si el valor de la celda es "Lunes" y aplica un estilo de fondo.
                        if (
                            cellValue === "DNI" ||
                            cellValue === "Estudiante" ||
                            cellValue === "Nota" ||
                            cellValue === "Estado"
                        ) {
                            $(this).attr("s", "47"); // Aplica un estilo con fondo de color.
                        }
                    });
                },
            },
            {
                extend: "pdf",
                title: "Reporte de " + tableName,
                type: "button",
                orientation: "landscape",
                className: "btn btn-sm btn-arounded ",
                exportOptions: {
                    columns: ":visible",
                    orthogonal: "print",
                },
            },
            {
                extend: "print",
                title: "Reporte de " + tableName,
                type: "button",
                orientation: "landscape",
                className: "btn btn-sm btn-arounded",
                exportOptions: {
                    columns: ":visible",
                    orthogonal: "print",
                },
            },
            {
                extend: "colvis",
                text: "Seleccionar celdas",
                title: "Reporte de " + tableName,
                type: "button",
                orientation: "landscape",
                className: "btn btn-sm btn-arounded",
                exportOptions: {
                    columns: ":visible",
                    orthogonal: "print",
                },
            },
        ],
        columns: [
            { data: "nroidenti", className: "text-center",
                render: function (data, type, all, meta) {
                    return "<h6>" + all.nroidenti + "</h6>"
                },
            },
            { data: "estudiante", className: "text-center",
                render: function (data, type, all, meta) {
                    return "<h6>" + all.estudiante + "</h6>"
                },
            },
            { data: "nota", className: "text-center",
                render: function (data, type, all, meta) {
                    if (all.nota == null) {
                        return "<h6>Sin nota</h6>"
                    } else {
                        return "<h6>" + all.nota + "</h6>"
                    }
                },  
            },
            {
                data: "estado",
                sortable: false,
                className: "text-center",
                render: function (data, type, all, meta) {
                    if (all.estado == "0") {
                        return `<span class="badge light badge-danger">Desaprobado</span>`;
                    } else if (all.estado == "1") {
                        return `<span class="badge light badge-success">Aprobado</span>`;
                    } else if (all.estado == "2") {
                        return `<span class="badge light badge-warning">Sin evaluar</span>`;
                    }
                },
            },
            {
                data: "idsubjectenrollment",
                className: "text-center noExport",
                sortable: false,
                searchable: false,
                render: function (data, type, all, meta) {
                    return `
                            <div class="d-flex justify-content-center">

                                <a href="javascript:void(0);" class="editBtn btn btn-warning shadow btn-xs sharp me-1"
                                data-nroidenti="${all.nroidenti}"
                                data-estudiante="${all.estudiante}"
                                data-curso="${all.curso}"
                                data-idsubjectenrollment="${all.idsubjectenrollment}"
                                data-idsubject="${all.idsubject}"
                                data-idstudent="${all.idstudent}"
                                data-nota="${all.nota}"
                                data-estado="${all.estado}"
                                data-bs-placement="top"
                                title="Editar nota">
                                <i class="fas fa-pencil-alt"></i>
                                </a>
                            </div>

                            `;
                },
            },
        ],
    });

    //---------T I M E L I N E S   Y   F U N C I O N E S--------------//
    tl_programs();
    function tl_programs() {
        $.ajax({
            type: "GET",
            url: "/ajax_all/programs",
            dataType: "json",
            beforeSend: function () {},
            success: function (response) {
                response.forEach((elemento) => {
                    document.getElementById("tlprogram").innerHTML +=
                        "<li class=''>" +
                        "<div class='divprogram timeline-badge primary'></div>" +
                        "<a class='btnProgram timeline-panel text-muted px-2 py-1 mr-4 ml-2' href='javascript:void(0);' " +
                            "data-idprogram='" + elemento.id + "'" +
                            "data-codprograma='" + elemento.codprograma + "'" +
                            "data-nombre='" + elemento.nombre + "'" +
                            "data-nivel_formativo='" + elemento.nivel_formativo + "'" +
                        ">" +
                        "<h6 class='mb-0 fs-14'>" + "<strong class='text-dark'>" + elemento.codprograma + "</strong>" +
                        " <br> " + elemento.nombre +
                        "</h6>" +
                        "</a>" +
                        "</li>";
                });
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    // on change programas
    $(document).on("click", ".btnProgram", function () {
        let idprogram = $(this).attr("data-idprogram");
        $(".divprogram").removeClass("dark").addClass("primary");
        $(this).prev("div").removeClass("primary").addClass("dark");
        document.getElementById("tlplan").innerHTML = "";
        document.getElementById("tlsubject").innerHTML = "";
        tl_plans(idprogram);
    });

    // listar planes
    function tl_plans(idprogram) {
        document.getElementById("tlplan").innerHTML = "";
        $.ajax({
            type: "GET",
            url: "/ajax_all/plans/" + idprogram,
            dataType: "json",
            beforeSend: function () {},
            success: function (response) {
                response.forEach((elemento) => {
                    document.getElementById("tlplan").innerHTML +=
                        "<li class=''>" +
                        "<div class='divplan timeline-badge primary'></div>" +
                            "<a class='btnPlan timeline-panel text-muted px-2 py-1 mr-4 ml-2' href='javascript:void(0);' " +
                            "data-idplan='" + elemento.id + "'" +
                            "data-nombre='" + elemento.nombre + "'" +
                            "data-tipo='" + elemento.tipo + "'" +
                            "data-modalidad='" + elemento.modalidad + "'" +
                            "data-enfoque='" + elemento.enfoque + "'" +
                            ">" +
                                "<h6 class='mb-0 fs-14'>" + "<strong class='text-dark'>" + elemento.nombre + "</strong>" + " <br> " + elemento.tipo +
                                "</h6>" +
                            "</a>" +
                        "</li>";
                });
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    // on change planes
    $(document).on("click", ".btnPlan", function () {
        let idplan = $(this).attr("data-idplan");
        $(".divplan").removeClass("dark").addClass("primary");
        $(this).prev("div").removeClass("primary").addClass("dark");
        tl_subjects(idplan, idsemester);
    });

    // listar periodos por plan
    function tl_subjects(idplan, idsemester) {
        document.getElementById("tlsubject").innerHTML = "";
        $.ajax({
            type: "GET",
            url: "/ajax_all/subjects/" + idplan + "/" + idsemester,
            dataType: "json",
            beforeSend: function () {},
            success: function (response) {
                response.forEach((elemento) => {
                    document.getElementById("tlsubject").innerHTML +=
                        "<li class=''>" +
                        "<div class='divperiod timeline-badge primary'></div>" +
                        "<a class='btnSubject timeline-panel text-muted px-2 py-1 mr-4 ml-2' href='javascript:void(0);' " +
                            "data-idperiod='" + elemento.idperiod + "'" +
                            "data-idsubject='" + elemento.idsubject + "'" +
                            "data-curso='" + elemento.curso + "'" +
                        ">" +
                        "<strong class='text-dark'>" + elemento.curso + "</strong><br>" +
                        "<strong class='text-dark'>Periodo: " + elemento.periodo + ", Tipo: " + elemento.tipo + "</strong><br>" +
                        "</a>" +
                        "</li>";
                });
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    // on change periodos
    $(document).on("click", ".btnSubject", function () {
        idsubject = $(this).attr("data-idsubject");
        curso = $(this).attr("data-curso");
        $(".divperiod").removeClass("dark").addClass("primary");
        $(this).prev("div").removeClass("primary").addClass("dark");
        //info Toast
        notificaciontoast("info", "Consultando a la  base de datos!", "Mensaje!");
        table.ajax.reload();
    });


    // on change semester
    $(document).on("click", ".btnSemester", function () {
        idsemester = $(this).attr("data-idsemester");
        $(".divsemester").removeClass("dark").addClass("primary");
        $(this).prev("div").removeClass("primary").addClass("dark");
        //info Toast
        notificaciontoast("info", "Consultando a la  base de datos!", "Mensaje!");
        table.ajax.reload();
    });

    // Editar Nota
    $("#datatableGeneral tbody").on("click", ".editBtn", function (e) {

        $("#txt-idsubjectenrollment").val($(this).data("idsubjectenrollment"));
        $("#txt-curso").val($(this).data("curso"));
        $("#txt-estudiante").val($(this).data("estudiante"));
        $("#txt-nota").val($(this).data("nota"));

        // show form
        $("#modalCreateUpdate").modal("show");
    });



    var formCheck;

    // INICIO - FUNCION CREATE O UPDATE
    $("#btnCreateUpdate").on("click", function (event) {
        event.preventDefault();
        // Iterar sobre los formularios y evitar la acción predeterminada si no son válidos
        formCheck = $("#formModal")[0];
        if (!formCheck.checkValidity()) {
            event.preventDefault();
            event.stopPropagation();
            $(formCheck).addClass('was-validated'); // añadir validaciones
        } else {
            // actualizar
            update_nota();
        }
    });
    // FIN - FUNCION CREATE O UPDATE

    var formModal;

    function update_nota() {
        formModal = $('#formModal');
        var id = document.getElementById("txt-idsubjectenrollment").value;
        $.ajax({
            headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
            type: 'PUT',
            url: '/admin/notas/gestionar_nota/update_nota/' + id,
            data: formModal.serialize(),
            dataType: 'json',
            beforeSend: function () { },
            success: function (data) {
                if (data.status == true) {
                    table.ajax.reload();
                    formModal.addClass("was-validated");
                    notificaciontoast("info", data.mensaje, "Éxito!");
                    setTimeout(function () { $("#modalUpdate").modal("hide"); }, 500);
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
            error: function (error) {
                console.log('Error', error)
            }
        });
    }

    //Borrar campos
    function clearForm() {
        $("#txt-idsubjectenrollment").val("");
        $("#txt-curso").val("");
        $("#txt-estudiante").val("");
        $("#txt-nota").val("");
    }

});
