//"use strict";
import { notificaciontoast } from "../../common/method_toast.js";
import { confirmation_sweetAlert } from "../../common/method_sweetAlert.js";
import { getButtonsSchema, languageSchema } from '../../common/schemas.js';
import { tl_semesters } from "../../common/timeline/semesters.js";

$(document).ready(function () {
    const tableName = "Reportes ";

    var idsubject = "null", idsemester = "null";

    var table = $("#datatableGeneral").DataTable({
        createdRow: function (row, data, index) {
            $(row).addClass("selected");
        },
        order: [],
        ajax: {
            headers: { "X-CSRF-TOKEN": $('input[name="_token"]').val() },
            type: "POST",
            url: "/admin/notas/indicadores/list",                  
            data: function (d) {
                d.idsubject = idsubject;
                d.idsemester = idsemester;
            },
        },
        searching: true,
        dom: "Bfrtip",
        pageLength: 30, 
        select: false,
        lengthChange: false,
        responsive: true,
        language: languageSchema,
        buttons: [
            {
                extend: "excel",
                title: function () {
                    return (
                        "Reporte de notas del curso: " + curso
                    );
                },
                type: "button",
                orientation: "landscape",
                className: "btn btn-sm btn-arounded",
                exportOptions: {
                    columns: ":visible",
                    orthogonal: "print",
                },
                customize: function (xlsx) {
                    var sheet = xlsx.xl.worksheets["sheet1.xml"];

                    // Establecer el ancho de las columnas si es necesario
                    var columnStyles = {
                        A: { style: 25 },
                        B: { style: 25 },
                        C: { style: 25 },
                        D: { style: 25 },
                        E: { style: 25 },
                    };

                    // Eliminar la columna 'E'
                    delete columnStyles.E;

                    for (var col in columnStyles) {
                        var style = columnStyles[col];
                        $('row c[r^="' + col + '"]', sheet).attr(
                            "s",
                            style.style
                        );
                    }

                    var rowCount = 0;
                    $("row c", sheet).each(function () {
                        var row = this;
                        if (rowCount == 0) {
                            $('c[r="A1"]', sheet).attr("s", "51");
                        }
                        // Centrar el titulo

                        var cellValue = $(this).text();

                        // Verifica si el valor de la celda es "Lunes" y aplica un estilo de fondo.
                        if (
                            cellValue === "DNI" ||
                            cellValue === "Estudiante" ||
                            cellValue === "Nota" ||
                            cellValue === "Estado"
                        ) {
                            $(this).attr("s", "47"); // Aplica un estilo con fondo de color.
                        }
                    });
                },
            },
            {
                extend: "pdf",
                title: "Reporte de " + tableName,
                type: "button",
                orientation: "landscape",
                className: "btn btn-sm btn-arounded ",
                exportOptions: {
                    columns: ":visible",
                    orthogonal: "print",
                },
            },
            {
                extend: "print",
                title: "Reporte de " + tableName,
                type: "button",
                orientation: "landscape",
                className: "btn btn-sm btn-arounded",
                exportOptions: {
                    columns: ":visible",
                    orthogonal: "print",
                },
            },
            {
                extend: "colvis",
                text: "Seleccionar celdas",
                title: "Reporte de " + tableName,
                type: "button",
                orientation: "landscape",
                className: "btn btn-sm btn-arounded",
                exportOptions: {
                    columns: ":visible",
                    orthogonal: "print",
                },
            },
        ],
        columns: [
            { data: "indicador", className: "text-center", name: "primero",
                render: function (data, type, all, meta) {
                    return `
                    <h6>${all.indicador}</h6>                    
                    <div class="d-flex justify-content-center">
                        <a href="javascript:void(0);" class="editBtnIndicador btn btn-warning shadow btn-xs sharp me-1"
                        data-idsubject="${all.idsubject}"
                        data-idindicator="${all.idindicator}"
                        data-nombre="${all.indicador}"
                        data-descripcion="${all.indicador_descripcion}"
                        data-bs-placement="top"
                        title="Editar indicador">
                        <i class="fas fa-pencil-alt"></i>
                        </a>

                        <a href="javascript:void(0);" class="deleteBtnIndicador btn btn-danger shadow btn-xs sharp me-1"
                        data-idindicator="${all.idindicator}"
                        data-bs-placement="top"
                        title="Eliminar indicador">
                        <i class="fas fa-trash"></i>
                        </a>

                        <a href="javascript:void(0);" class="createBtnActividad btn btn-success shadow btn-xs sharp me-1"
                        data-idindicator="${all.idindicator}"
                        data-bs-placement="top"
                        title="Añadir actividad">
                        <i class="fas fa-solid fa-plus"></i>
                        </a>
                    </div>
                    `
                },
            },
            { data: "actividad", className: "text-center bg-primary", name: "segundo",
                render: function (data, type, all, meta) {
                    if (all.idactivity != 0) {
                        return `
                            <h6>${all.actividad}</h6>                    
                            <div class="d-flex justify-content-center">
                                    <a href="javascript:void(0);" class="editBtnActividad btn btn-warning shadow btn-xs sharp me-1"
                                    data-idactivity="${all.idactivity}"
                                    data-nombre="${all.actividad}"
                                    data-bs-placement="top"
                                    title="Editar actividad">
                                    <i class="fas fa-pencil-alt"></i>
                                    </a>
                                    
                                    <a href="javascript:void(0);" class="deleteBtnActividad btn btn-danger shadow btn-xs sharp me-1"
                                    data-idactivity="${all.idactivity}"
                                    data-bs-placement="top"
                                    title="Eliminar actividad">
                                    <i class="fas fa-trash"></i>
                                    </a>
                                    
                                    <a href="javascript:void(0);" class="createBtnNota btn btn-success shadow btn-xs sharp me-1"
                                        data-idactivity="${all.idactivity}"
                                        data-bs-placement="top"
                                        title="Añadir nota">
                                        <i class="fas fa-solid fa-plus"></i>
                                    </a>
                            </div>
                        `;
                    } else {
                        return ``;
                    }
                },
            },
            { data: "nota", className: "text-center",
                render: function (data, type, all, meta) {
                    if (all.idgrade != 0) {
                        return "<h6>" + all.nota + " - " + (all.porcentaje * 100) + "%</h6>"
                    } else {
                        return ``;
                    }
                },
            },
            { data: "idgrade", className: "text-center", sortable: false, searchable: false,
                render: function (data, type, all, meta) {
                    if (all.idgrade != 0) {
                        return `
                            <div class="d-flex justify-content-center">
                                
                                <a href="javascript:void(0);" class="editBtnNota btn btn-warning shadow btn-xs sharp me-1"
                                data-idgrade="${all.idgrade}"
                                data-nombre="${all.nota}"
                                data-porcentaje="${all.porcentaje}"
                                data-bs-placement="top"
                                title="Editar nota">
                                <i class="fas fa-pencil-alt"></i>
                                </a>
                                
                                <a href="javascript:void(0);" class="deleteBtnNota btn btn-danger shadow btn-xs sharp"
                                data-idgrade="${all.idgrade}"
                                data-bs-placement="top"
                                title="Eliminar nota">
                                <i class="fas fa-trash"></i>
                                </a>
                                
                            </div>
                            `;
                    } else {
                        return ``;
                    }
                },
            },
        ],
        rowsGroup: [
            'primero:name',
            'segundo:name',
        ],
        //orderFixed: [0, 'asc'], // Fija el orden por defecto de la primera columna
    });



    //---------T I M E L I N E S   Y   F U N C I O N E S--------------//
    tl_programs();
    function tl_programs() {
        $.ajax({
            type: "GET",
            url: "/ajax_all/programs",
            dataType: "json",
            beforeSend: function () {},
            success: function (response) {
                response.forEach((elemento) => {
                    document.getElementById("tlprogram").innerHTML +=
                        "<li class=''>" +
                        "<div class='divprogram timeline-badge primary'></div>" +
                        "<a class='btnProgram timeline-panel text-muted px-2 py-1 mr-4 ml-2' href='javascript:void(0);' " +
                            "data-idprogram='" + elemento.id + "'" +
                            "data-codprograma='" + elemento.codprograma + "'" +
                            "data-nombre='" + elemento.nombre + "'" +
                            "data-nivel_formativo='" + elemento.nivel_formativo + "'" +
                        ">" +
                        "<h6 class='mb-0 fs-14'>" + "<strong class='text-dark'>" + elemento.codprograma + "</strong>" +
                        " <br> " + elemento.nombre +
                        "</h6>" +
                        "</a>" +
                        "</li>";
                });
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    // on change programas
    $(document).on("click", ".btnProgram", function () {
        let idprogram = $(this).attr("data-idprogram");
        $(".divprogram").removeClass("dark").addClass("primary");
        $(this).prev("div").removeClass("primary").addClass("dark");
        // document.getElementById("tlsubject").innerHTML = "";
        tl_subjects(idprogram, idsemester);
    });


    // listar periodos por plan
    function tl_subjects(idprogram, idsemester) {   
        document.getElementById("tlsubject").innerHTML = "";
        $.ajax({
            type: "GET",
            url: "/ajax_all/subjectsAdmin/" + idprogram + "/" + idsemester,
            dataType: "json",
            beforeSend: function () {},
            success: function (response) {
                response.forEach((elemento) => {
                    document.getElementById("tlsubject").innerHTML +=
                        "<li class=''>" +
                        "<div class='divperiod timeline-badge primary'></div>" +
                        "<a class='btnSubject timeline-panel text-muted px-2 py-1 mr-4 ml-2' href='javascript:void(0);' " +
                            "data-idperiod='" + elemento.idperiod + "'" +
                            "data-idsubject='" + elemento.idsubject + "'" +
                        ">" +
                        "<strong class='text-dark'>" + elemento.curso + "</strong><br>" +
                        "<strong class='text-dark'>Plan: " + elemento.plan + "; Periodo: " + elemento.periodo + "; Tipo: " + elemento.tipo + "</strong><br>" +
                        "</a>" +
                        "</li>";
                });
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    // on change periodos
    $(document).on("click", ".btnSubject", function () {
        idsubject = $(this).attr("data-idsubject");

        $(".divperiod").removeClass("dark").addClass("primary");
        $(this).prev("div").removeClass("primary").addClass("dark");
        //info Toast
        notificaciontoast("info", "Consultando a la  base de datos!", "Mensaje!");
        table.ajax.reload();
    });


    // on change semester
    $(document).on("click", ".btnSemester", function () {
        idsemester = $(this).attr("data-idsemester");
        $(".divsemester").removeClass("dark").addClass("primary");
        $(this).prev("div").removeClass("primary").addClass("dark");
        //info Toast
        notificaciontoast("info", "Consultando a la  base de datos!", "Mensaje!");
        table.ajax.reload();
    });



    //--------- MODALS INDICADOR - ACTIVIDAD Y NOTA --------------//

    // - - - - - - - - - - M O D A L S - - - - - - - - - -
    var valbtn, formCheck;

    // INICIO - MODAL CREATE
    $("#btnCreateIndicador").click(function () {
        //Change Value
        document.getElementById("btnCU_Indicador").setAttribute("value", "Create");
        document.getElementById("btnCU_Indicador").innerHTML = "Guardar";
        document.getElementById("modalCU_IndicadorLabel").innerHTML = "Registrar datos del indicador";

        //Remover validaciones
        formCheck = $("#formModalIndicador")[0];
        $(formCheck).removeClass('was-validated');

        //Limpiar campos
        document.getElementById("txt-i_nombre").value = "";
        document.getElementById("txt-i_descripcion").value = "";
    });
    // FIN - MODAL CREATE


    // INICIO - MODAL UPDATE
    $("#datatableGeneral tbody").on("click", ".editBtnIndicador", function (e) {
        //Remover validaciones
        formCheck = $("#formModalIndicador")[0];
        $(formCheck).removeClass('was-validated');
        
        //cambiar el text del button
        document.getElementById("btnCU_Indicador").innerHTML = "Actualizar";
        document.getElementById("modalCU_IndicadorLabel").innerHTML = "Actualizar datos del indicador";
        // setear data de cargo
        // document.getElementById("txt-idsubject").value = $(this).attr("data-idsubject");
        document.getElementById("txt-idindicator").value = $(this).attr("data-idindicator");
        document.getElementById("txt-i_nombre").value = $(this).attr("data-nombre");
        document.getElementById("txt-i_descripcion").value = $(this).attr("data-descripcion");
        // show form
        $("#modalCU_Indicador").modal("show");
        // change value
        document.getElementById("btnCU_Indicador").setAttribute("value", "Update");
    });
    // FIN - MODAL UPDATE


    // INICIO - FUNCION CREATE O UPDATE
    $("#btnCU_Indicador").on("click", function (event) {
        event.preventDefault();
        formCheck = $("#formModalIndicador")[0];
        if (!formCheck.checkValidity()) {
            event.preventDefault();
            event.stopPropagation();
            $(formCheck).addClass('was-validated'); // añadir validaciones
        } else {
            // obtener valor del boton
            valbtn = $("#btnCU_Indicador").val()
            // FUNCION CREAR
            if (valbtn === "Create") {
                // insertar tabla cargo
                store_indicator();
            }
            // FUNCION ACTUALIZAR
            if (valbtn === "Update") {
                // actualizar tabla cargo
                update_indicator();
            }
        }
    });
    // FIN - FUNCION CREATE O UPDATE


    // INICIO - MODAL DELETE
    $("#datatableGeneral tbody").on("click", ".deleteBtnIndicador", function (e) {
        var id = $(this).attr("data-idindicator");
        // confirmacion
        confirmation_sweetAlert("Deseas continuar?", "Se procederá a eliminar el registro de la base de datos", "warning")
            .then(function (isConfirm) {
                if (isConfirm.value) {
                    // enviando el parametro de la data que se procede a delete
                    destroy_indicator(id);
                } else {
                    console.log("Cancelado");
                }
            });
    });

    var formModalIndicador;

    // - - - - - - - - - - F U N C I O N E S - - - - - - - - - -
    function store_indicator() {
        document.getElementById("txt-idsubject").value = idsubject;
        formModalIndicador = $('#formModalIndicador');
        $.ajax({
            type: "POST",
            url: '/admin/notas/indicadores/store',
            data: formModalIndicador.serialize(),
            dataType: 'json',
            beforeSend: function () { },
            success: function (data) {
                if (data.status == true) {
                    table.ajax.reload();
                    formModalIndicador.addClass("was-validated");    // añadir validaciones
                    notificaciontoast("info", data.mensaje, "Éxito!");
                    setTimeout(function () { $("#modalCU_Indicador").modal("hide"); }, 1000); // ocultar despues de 1 sec
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    function update_indicator() {
        formModalIndicador = $('#formModalIndicador');
        var id = document.getElementById("txt-idindicator").value;
        var formData = $('#formModalIndicador').serialize();
        $.ajax({
            type: "PUT",
            url: '/admin/notas/indicadores/update/' + id,
            data: formData,
            dataType: 'json',
            beforeSend: function () { },
            success: function (data) {
                if (data.status == true) {
                    table.ajax.reload();
                    formModalIndicador.addClass("was-validated");    // añadir validaciones
                    notificaciontoast("info", data.mensaje, "Éxito!");
                    setTimeout(function () { $("#modalCU_Indicador").modal("hide"); }, 1000);   // ocultar despues de 1 sec
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    function destroy_indicator(id) {
        $.ajax({
            headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
            type: "DELETE",
            url: '/admin/notas/indicadores/destroy/' + id,
            beforeSend: function () { },
            success: function (data) {
                if (data.status == true) {
                    notificaciontoast("info", data.mensaje, "Éxito!");
                    table.ajax.reload();
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }





    // - - - - - - - - - - MODALS - ACTIVITYS - - - - - - - - - -
    var valbtn, formCheck;

    // INICIO - MODAL CREATE
    $("#datatableGeneral tbody").on("click", ".createBtnActividad", function (e) {
        //Change Value
        document.getElementById("btnCU_Actividad").setAttribute("value", "Create");
        document.getElementById("btnCU_Actividad").innerHTML = "Guardar";
        document.getElementById("modalCU_ActividadLabel").innerHTML = "Registrar datos de la actividad";

        //Remover validaciones
        formCheck = $("#formModalActividad")[0];
        $(formCheck).removeClass('was-validated');

        document.getElementById("txt-a_idindicator").value = $(this).attr("data-idindicator");

        // show form
        $("#modalCU_Actividad").modal("show");

        //Limpiar campos
        document.getElementById("txt-a_nombre").value = "";
    });
    // FIN - MODAL CREATE


    // INICIO - MODAL UPDATE
    $("#datatableGeneral tbody").on("click", ".editBtnActividad", function (e) {
       //Remover validaciones
        formCheck = $("#formModalActividad")[0];
        $(formCheck).removeClass('was-validated');
        
        //cambiar el text del button
        document.getElementById("btnCU_Actividad").innerHTML = "Actualizar";
        document.getElementById("modalCU_ActividadLabel").innerHTML = "Actualizar datos de la actividad";
        // setear data de cargo
        document.getElementById("txt-a_idactivity").value = $(this).attr("data-idactivity");
        document.getElementById("txt-a_nombre").value = $(this).attr("data-nombre");
        // show form
        $("#modalCU_Actividad").modal("show");
        // change value
        document.getElementById("btnCU_Actividad").setAttribute("value", "Update");
    });
    // FIN - MODAL UPDATE


    // INICIO - FUNCION CREATE O UPDATE
    $("#btnCU_Actividad").on("click", function (event) {
        event.preventDefault();
        formCheck = $("#formModalActividad")[0];
        if (!formCheck.checkValidity()) {
            event.preventDefault();
            event.stopPropagation();
            $(formCheck).addClass('was-validated'); // añadir validaciones
        } else {
            // obtener valor del boton
            valbtn = $("#btnCU_Actividad").val()
            // FUNCION CREAR
            if (valbtn === "Create") {
                // insertar tabla cargo
                store_activity();
            }
            // FUNCION ACTUALIZAR
            if (valbtn === "Update") {
                // actualizar tabla cargo
                update_activity();
            }
        }
    });
    // FIN - FUNCION CREATE O UPDATE


    // INICIO - MODAL DELETE
    $("#datatableGeneral tbody").on("click", ".deleteBtnActividad", function (e) {
        var id = $(this).attr("data-idactivity");
        // confirmacion
        confirmation_sweetAlert("Deseas continuar?", "Se procederá a eliminar el registro de la base de datos", "warning")
            .then(function (isConfirm) {
                if (isConfirm.value) {
                    // enviando el parametro de la data que se procede a delete
                    destroy_activity(id);
                } else {
                    console.log("Cancelado");
                }
            });
    });

    var formModalActividad;

    // - - - - - - - - - - F U N C I O N E S - - - - - - - - - -
    function store_activity() {
        formModalActividad = $('#formModalActividad');
        $.ajax({
            type: "POST",
            url: '/admin/notas/actividades/store',
            data: formModalActividad.serialize(),
            dataType: 'json',
            beforeSend: function () { },
            success: function (data) {
                if (data.status == true) {
                    table.ajax.reload();
                    formModalActividad.addClass("was-validated");    // añadir validaciones
                    notificaciontoast("info", data.mensaje, "Éxito!");
                    setTimeout(function () { $("#modalCU_Actividad").modal("hide"); }, 1000); // ocultar despues de 1 sec
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }


    function update_activity() {
        formModalActividad = $('#formModalActividad');
        var id = document.getElementById("txt-a_idactivity").value;
        var formData = $('#formModalActividad').serialize();
        $.ajax({
            type: "PUT",
            url: '/admin/notas/actividades/update/' + id,
            data: formData,
            dataType: 'json',
            beforeSend: function () { },
            success: function (data) {
                if (data.status == true) {
                    table.ajax.reload();
                    formModalActividad.addClass("was-validated");    // añadir validaciones
                    notificaciontoast("info", data.mensaje, "Éxito!");
                    setTimeout(function () { $("#modalCU_Actividad").modal("hide"); }, 1000);   // ocultar despues de 1 sec
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    function destroy_activity(id) {
        $.ajax({
            headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
            type: "DELETE",
            url: '/admin/notas/actividades/destroy/' + id,
            beforeSend: function () { },
            success: function (data) {
                if (data.status == true) {
                    notificaciontoast("info", data.mensaje, "Éxito!");
                    table.ajax.reload();
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }







        // - - - - - - - - - - MODALS - GRADES - - - - - - - - - -
        var valbtn, formCheck;

        // INICIO - MODAL CREATE
        $("#datatableGeneral tbody").on("click", ".createBtnNota", function (e) {
            //Change Value
            document.getElementById("btnCU_Nota").setAttribute("value", "Create");
            document.getElementById("btnCU_Nota").innerHTML = "Guardar";
            document.getElementById("modalCU_NotaLabel").innerHTML = "Registrar datos de la nota";

            //Remover validaciones
            formCheck = $("#formModalNota")[0];
            $(formCheck).removeClass('was-validated');

            document.getElementById("txt-g_idactivity").value = $(this).attr("data-idactivity");

            // show form
            $("#modalCU_Nota").modal("show");

            //Limpiar campos
            document.getElementById("txt-g_nombre").value = "";
            $("#txt-g_porcentaje").selectpicker("val", "0");
        });
        // FIN - MODAL CREATE


        // INICIO - MODAL UPDATE
        $("#datatableGeneral tbody").on("click", ".editBtnNota", function (e) {
           //Remover validaciones
            formCheck = $("#formModalNota")[0]; 
            $(formCheck).removeClass('was-validated');
            
            //cambiar el text del button
            document.getElementById("btnCU_Nota").innerHTML = "Actualizar";
            document.getElementById("modalCU_NotaLabel").innerHTML = "Actualizar datos de la nota";
            // setear data de cargo
            document.getElementById("txt-g_idgrade").value = $(this).attr("data-idgrade");
            document.getElementById("txt-g_nombre").value = $(this).attr("data-nombre");
            $("#txt-g_porcentaje").selectpicker("val", $(this).attr("data-porcentaje"));

            let tipo = 
            // show form    
            $("#modalCU_Nota").modal("show");
            // change value
            document.getElementById("btnCU_Nota").setAttribute("value", "Update");
        });
        // FIN - MODAL UPDATE


        // INICIO - FUNCION CREATE O UPDATE
        $("#btnCU_Nota").on("click", function (event) {
            event.preventDefault();
            formCheck = $("#formModalNota")[0];
            if (!formCheck.checkValidity()) {
                event.preventDefault();
                event.stopPropagation();
                $(formCheck).addClass('was-validated'); // añadir validaciones
            } else {
                // obtener valor del boton
                valbtn = $("#btnCU_Nota").val()
                // FUNCION CREAR
                if (valbtn === "Create") {
                    // insertar tabla cargo
                    store_grade();
                }
                // FUNCION ACTUALIZAR
                if (valbtn === "Update") {
                    // actualizar tabla cargo
                    update_grade();
                }
            }
        });
        // FIN - FUNCION CREATE O UPDATE


        // INICIO - MODAL DELETE
        $("#datatableGeneral tbody").on("click", ".deleteBtnNota", function (e) {
            var id = $(this).attr("data-idgrade");
            // confirmacion
            confirmation_sweetAlert("Deseas continuar?", "Se procederá a eliminar el registro y tambien las notas de los estudiantes ", "warning")
                .then(function (isConfirm) {
                    if (isConfirm.value) {
                        // enviando el parametro de la data que se procede a delete
                        destroy_grade(id);
                    } else {
                        console.log("Cancelado");
                    }
                });
        });

        var formModalNota;

        // - - - - - - - - - - F U N C I O N E S - - - - - - - - - -
        function store_grade() {
            formModalNota = $('#formModalNota');
            $.ajax({
                type: "POST",
                url: '/admin/notas/notas/store',
                data: formModalNota.serialize(),
                dataType: 'json',
                beforeSend: function () { },
                success: function (data) {
                    if (data.status == true) {
                        table.ajax.reload();
                        formModalNota.addClass("was-validated");    // añadir validaciones
                        notificaciontoast("info", data.mensaje, "Éxito!");
                        setTimeout(function () { $("#modalCU_Nota").modal("hide"); }, 1000); // ocultar despues de 1 sec
                    } else {
                        notificaciontoast("error", data.mensaje, "Error!");
                    }
                },
                error: function (error) {
                    console.log("Error", error);
                },
            });
        }


        function update_grade() {
            formModalNota = $('#formModalNota');
            var id = document.getElementById("txt-g_idgrade").value;
            var formData = $('#formModalNota').serialize();
            $.ajax({
                type: "PUT",
                url: '/admin/notas/notas/update/' + id,
                data: formData,
                dataType: 'json',
                beforeSend: function () { },
                success: function (data) {
                    if (data.status == true) {
                        table.ajax.reload();
                        formModalNota.addClass("was-validated");    // añadir validaciones
                        notificaciontoast("info", data.mensaje, "Éxito!");
                        setTimeout(function () { $("#modalCU_Nota").modal("hide"); }, 1000);   // ocultar despues de 1 sec
                    } else {
                        notificaciontoast("error", data.mensaje, "Error!");
                    }
                },
                error: function (error) {
                    console.log("Error", error);
                },
            });
        }

        function destroy_grade(id) {
            $.ajax({
                headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
                type: "DELETE",
                url: '/admin/notas/notas/destroy/' + id,
                beforeSend: function () { },
                success: function (data) {
                    if (data.status == true) {
                        notificaciontoast("info", data.mensaje, "Éxito!");
                        table.ajax.reload();
                    } else {
                        notificaciontoast("error", data.mensaje, "Error!");
                    }
                },
                error: function (error) {
                    console.log("Error", error);
                },
            });
        }
});
