import { notificaciontoast } from "../../common/method_toast.js";
import { confirmation_sweetAlert } from "../../common/method_sweetAlert.js";
import { getButtonsSchema, languageSchema } from '../../common/schemas.js';

$(document).ready(function () {

    const tableName = "Reservas y Licencias";

    var dt_idsemester = "0", dt_idplan = "1";
    var formModal, formData;

    // LISTAR DATATABLE
    var table = $('#datatableGeneral').DataTable({
        createdRow: function (row, data, index) {
            $(row).addClass("selected");
        },
        order: [],
        ajax: {
            headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
            type: 'POST',
                url: '/admin/matricula/reservas_licencias/list',
        },
        searching: true,
        pageLength: 12, // 12 filas
        dom: "Bfrtip",
        select: false,
        lengthChange: false,
        responsive: true,
        language: languageSchema,
        buttons: getButtonsSchema(tableName),
        columns: [
            { data: 'idstudent', className: 'text-center' },
            { data: "programa_plan", className: "text-center" },
            { data: "estudiante", className: "text-center",
                render: function (data, type, all, meta) {
                    return all.identificacion + " - " + all.estudiante;
                },
            },
            { data: "nombredocument", className: "text-center",
                render: function (data, type, all, meta) {
                    if (all.nombredocument == null) {
                        return "--";
                    }
                    else {
                        return all.nombredocument;
                    }
                },
            },
            { data: "fecha_inicio2", className: "text-center", 
                render: function (data, type, all, meta) {
                    return all.fecha_inicio2 + " (" + all.estado_licencia + ")";
                },
            },
            { data: "ruta", sortable: false, className: "text-center",
                render: function (data, type, all, meta) {
                    if (all.ruta == null) {
                        return "--";
                    } else if (all.ruta == "--") {
                        return "--";
                    } else {
                        return `
                        <div class="d-flex justify-content-center">
                            <a href="/verDocumentoEstudiante/${all.idstudent}/${all.idstudentdocument}" class="btnVerBoucher btn btn-info shadow btn-xs sharp me-1"
                            target="_blank"
                            data-bs-placement="top"
                            title="Ver Resolución">
                            <i class="fas fa-file-lines fa-lg"></i>
                            </a>
                        </div>
                        `;
                    }
                },
            },
            { data: "estado_pago", className: "text-center",
                render: function (data, type, all, meta) {
                    if (all.estado_pago == "1") {
                        return `<span class="badge light badge-success">Pagado</span>`;
                    } else if (all.estado_pago == "2") {
                        return `<span class="badge light badge-warning">Pendiente</span>`;
                    } else if (all.estado_pago == "0") {
                        return `<span class="badge light badge-danger">No Pagado</span>`;
                    } else {
                        return "--";
                    }
                },
            },
            { data: "estadoregistro", sortable: false, className: "text-center",
                render: function (data, type, all, meta) {
                    if (all.estadoregistro == "0") {
                        return `<span class="badge light badge-danger">Inactivo</span>`;
                    } else  if (all.estadoregistro == "1") {
                        return `<span class="badge light badge-success">Activo</span>`;
                    }
                },
            },
            { data: "idstudentdocument", className: "text-center noExport", sortable: false, searchable: false,
                render: function (data, type, all, meta) {
                    return `
                            <div class="d-flex justify-content-center">
                                <a href="javascript:void(0);" class="estadobtn btn btn-primary shadow btn-xs sharp me-1"
                                data-idstudent="${all.idstudent}"
                                data-idstudentdocument="${all.idstudentdocument}"
                                data-estado="${all.estadoregistro}"
                                data-bs-placement="top"
                                title="Editar estado">
                                <i class="fa-solid fa-toggle-on"></i>
                                </a>

                                <a href="javascript:void(0);" class="editBtn btn btn-warning shadow btn-xs sharp me-1"
                                data-idstudentdocument="${all.idstudentdocument}"
                                data-fecha_solicitud="${all.fecha_solicitud}"
                                data-fecha_inicio="${all.fecha_inicio}"
                                data-nombredocument="${all.nombredocument}"
                                data-descripcion="${all.descripcion}"
                                data-bs-placement="top"
                                title="Editar registro">
                                <i class="fas fa-pencil-alt"></i>
                                </a>

                                <a href="javascript:void(0);" class="deleteBtn btn btn-danger shadow btn-xs sharp"
                                data-idstudentdocument="${all.idstudentdocument}"
                                data-bs-placement="top"
                                title="Eliminar registro">
                                <i class="fas fa-trash"></i>
                                </a>
                            </div>
                            `;
                },
            },
        ],
    });

    // Agregar una columna de números automáticos
    table.on('order.dt search.dt', function () {
        table.column(0, { search: 'applied', order: 'applied' }).nodes().each(function (cell, i) {
            cell.innerHTML = i + 1;
        });
    }).draw();


    // // INICIO - SELECCIONAR PROGRAMA
    // $("#tlprogram").on("click", ".btnProgram", function (e) {
    //     dt_idplan = "0";
    //     //Colorear la opcion seleccionada
    //     $('.divprogram').removeClass("dark").addClass("primary");
    //     $(this).prev('div').removeClass("primary").addClass("dark");
    //     // listar planes
    //     tl_plans($(this).data("idprogram"));
    //     // CARGAR TABLA
    //     table.ajax.reload();
    // });
    // // FIN - SELECCIONAR PROGRAMA


    // // INICIO - SELECCIONAR PLAN
    // $("#tlplan").on("click", ".btnPlan", function (e) {
    //     dt_idplan = $(this).data("idplan");
    //     //Colorear la opcion seleccionada
    //     $('.divplan').removeClass("dark").addClass("primary");
    //     $(this).prev('div').removeClass("primary").addClass("dark");
    //     // CARGAR TABLA
    //     table.ajax.reload();
    // });
    // // FIN - SELECCIONAR PLAN


    var valbtn, formCheck;

    // INICIO - MODAL CREATE
    $("#btnCreateModal").click(function () {
        $('#btnCreateUpdate').removeClass('disabled');
        // change value
        $("#btnCreateUpdate").attr("value", "Create");
        $("#btnCreateUpdate").html("Registrar");
        $("#modalCreateUpdateLabel").html("Registrar nueva reserva/licencia");
        // mostrar div
        $("#div-txt-students").removeAttr("style");
        $("#txt-students").attr("required", "true");    // agregar required
        $("#div-txt-document").removeAttr("style");
        $("#txt-document").attr("required", "true");    // agregar required
        clearForm();    // limpiar formulario
        // limpiar validaciones
        formCheck = $("#formModal")[0];
        $(formCheck).removeClass('was-validated'); // remover validaciones
    });
    // FIN - MODAL CREATE

    // INICIO - MODAL UPDATE
    $("#datatableGeneral tbody").on("click", ".editBtn", function (e) {
        // limpiar validaciones
        formCheck = $("#formModal")[0];
        $(formCheck).removeClass('was-validated'); // remover validaciones
        //cambiar el text del button
        $("#btnCreateUpdate").attr("value", "Update");
        $("#btnCreateUpdate").html("Actualizar");
        $("#modalCreateUpdateLabel").html("Actualizar reserva/licencia");
        // ocultar div
        $("#div-txt-students").css("display", "none");
        $("#txt-students").removeAttr("required");  // para poder pasar el check validity
        // $("#div-txt-document").css("display", "none");
        $('#txt-document').val('');
        $("#txt-document").removeAttr("required");  // para poder pasar el check validity
        // setear data de usuario
        $("#txt-idstudentdocument").val($(this).data("idstudentdocument"));
        $("#txt-fecha_solicitud").val($(this).data("fecha_solicitud"));
        $("#txt-fecha_inicio").val($(this).data("fecha_inicio"));
        $("#txt-nombre").selectpicker('val', $(this).data("nombredocument"));
        $("#txt-nombre").selectpicker('refresh');
        $("#txt-descripcion").val($(this).data("descripcion"));
        // show form
        $("#modalCreateUpdate").modal("show");

    });
    // FIN - MODAL UPDATE

        // INICIO - MODAL UPDATE
        $("#datatableGeneral tbody").on("click", ".estadobtn", function (e) {
            // limpiar validaciones
            formCheck = $("#formestado")[0];
            $(formCheck).removeClass('was-validated'); // remover validaciones
            $("#txt-idstudentdocument").val($(this).data("idstudentdocument"));
            $("#txt-estado").selectpicker("val", $(this).attr("data-estado"));
            // show form
            $("#modalupdateestado").modal("show");

        });
        // FIN - MODAL UPDATE

    // INICIO - MODAL DELETE
    $("#datatableGeneral tbody").on("click", ".deleteBtn", function (e) {
        let idstudentdocument = $(this).data("idstudentdocument")
        // confirmacion
        confirmation_sweetAlert("Deseas continuar?", "Se procederá a eliminar el registro de la base de datos", "warning")
            .then(function (isConfirm) {
                if (isConfirm.value) {
                    // enviando el parametro de la data que se procede a delete
                    destroy(idstudentdocument);
                } else {
                    console.log("Cancelado");
                }
            });
    });
    // FIN - MODAL DELETE


    // INICIO - FUNCION CREATE O UPDATE
    $("#btnCreateUpdate").on("click", function (event) {
        event.preventDefault();
        // Iterar sobre los formularios y evitar la acción predeterminada si no son válidos
        formCheck = $("#formModal")[0];
        if (!formCheck.checkValidity()) {
            event.preventDefault();
            event.stopPropagation();
        } else {
            valbtn = $("#btnCreateUpdate").val();
            // FUNCION CREAR
            if (valbtn === "Create") {
                // insertar
                store();
            }
            // FUNCION ACTUALIZAR
            if (valbtn === "Update") {
                // actualizar
                update($("#txt-idstudentdocument").val());
            }
        }
        $(formCheck).addClass('was-validated'); // añadir validaciones
    });
    // FIN - FUNCION CREATE O UPDATE

    // INICIO - FUNCION CREATE O UPDATE
    $("#btnCambiarestado").on("click", function (event) {
        event.preventDefault();
        // Iterar sobre los formularios y evitar la acción predeterminada si no son válidos
        formCheck = $("#formestado")[0];
        if (!formCheck.checkValidity()) {
            event.preventDefault();
            event.stopPropagation();
        } else {
            let  idstudentdocument = $("#txt-idstudentdocument").val();
            formModal = $('#formestado');
            $.ajax({
                headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
                type: 'PUT',
                url: '/admin/matricula/reservas_licencias/update/estado/' + idstudentdocument,
                data: formModal.serialize(),
                dataType: 'json',
                beforeSend: function () { },
                success: function (data) {
                    if (data.status == true) {
                        table.ajax.reload();
                        formModal.addClass("was-validated");    // añadir validaciones
                        notificaciontoast("info", data.mensaje, "Éxito!");
                        setTimeout(function () { $("#modalupdateestado").modal("hide"); }, 1000);   // ocultar despues de 1 sec
                    } else {
                        notificaciontoast("error", data.mensaje, "Error!");
                    }
                },
                error: function (error) {
                    console.log('Error', error)
                }
            })
        }
        $(formCheck).addClass('was-validated'); // añadir validaciones
    });
    // FIN - FUNCION CREATE O UPDATE

    var formModal;


    function store() {
        formData = new FormData(document.getElementById('formModal'));
        $.ajax({
            headers: { "X-CSRF-TOKEN": $('input[name="_token"]').val() },
            type: "POST",
            url: '/admin/matricula/reservas_licencias/store',
            data: formData,
            processData: false,
            contentType: false,
            beforeSend: function () {
                $('#btnCreateUpdate').addClass('disabled');
            },
            success: function (data) {
                if (data.status == true) {
                    table.ajax.reload();
                    setTimeout(function () {
                        $("#modalCreateUpdate").modal("hide");
                        notificaciontoast("info", data.mensaje, "Éxito!");
                        $('#btnCreateUpdate').removeClass('disabled');
                    }, 1000); // ocultar despues de 1 sec
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                    $('#btnCreateUpdate').removeClass('disabled');
                }
            },
            error: function (error) {
                console.log("Error", error);
                $('#btnCreateUpdate').removeClass('disabled');
            },
        });
    }

    function update(idstudentdocument) {
        formData = new FormData(document.getElementById('formModal'));
        $.ajax({
            headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
            type: "POST",
            url: '/admin/matricula/reservas_licencias/update/' + idstudentdocument,
            data: formData,
            processData: false,
            contentType: false,
            beforeSend: function () {
                $('#btnCreateUpdate').addClass('disabled');
            },
            success: function (data) {
                if (data.status == true) {
                    table.ajax.reload();
                    setTimeout(function () {
                        notificaciontoast("info", data.mensaje, "Éxito!");
                        $("#modalCreateUpdate").modal("hide");
                        $('#btnCreateUpdate').removeClass('disabled');
                    }, 1000);   // ocultar despues de 1 sec
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                    $('#btnCreateUpdate').removeClass('disabled');
                }
            },
            error: function (error) {
                console.log("Error", error);
                $('#btnCreateUpdate').removeClass('disabled');
            },
        });
    }

    function destroy(idstudentdocument) {
        $.ajax({
            headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
            type: "DELETE",
            url: '/admin/matricula/reservas_licencias/destroy/' + idstudentdocument,
            beforeSend: function () { },
            success: function (data) {
                if (data.status == true) {
                    table.ajax.reload();
                    notificaciontoast("info", data.mensaje, "Éxito!");
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }


    // LIMPIAR FORMULARIO
    function clearForm() {
        $('#txt-idstudentdocument').val('');
        $('#txt-students').selectpicker('val', '');
        $('#txt-fecha').val('');
        $('#txt-nombre').selectpicker('val', '');
        $('#txt-document').val('');
        $('#txt-descripcion').val('');
    }






});


