import { notificaciontoast } from "../../common/method_toast.js";
import { confirmation_sweetAlert } from "../../common/method_sweetAlert.js";
import { getButtonsSchema, languageSchema } from "../../common/schemas.js";
import { cb_programs, cb_plans } from "../../common/combobox/programs.js";

$(document).ready(function () {
    //
    const tableName = "Alumnos por Perido Lectivo";
    var dt_idplan = 0, dt_idstudent = 0, formModal, formData;

    // LISTAR DATATABLE
    var table = $('#datatableGeneral').DataTable({
        createdRow: function (row, data, index) {
            $(row).addClass("selected");
        },
        order: [],
        ajax: {
            headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
            type: 'POST',
            url: '/admin/matricula/alumnos_semestre/list',
            data: function (d) {
                d.idplan = dt_idplan;
            },
        },
        searching: true,
        pageLength: 20,
        dom: "Bfrtip",
        select: false,
        lengthChange: false,
        responsive: true,
        language: languageSchema,
        buttons: getButtonsSchema(tableName),
        columns: [
            { data: "semestre", className: "text-center" },
            { data: "identificacion", className: "",
                render: function (data, type, all, meta) {
                    return `${all.identificacion} - ${all.estudiante}`;
                }
            },
            { data: "estado_matricula", sortable: false, className: "text-center",
                render: function (data, type, all, meta) {
                    if (all.relacion_estado == "1" && all.estado_licencia == 0) {
                        return `<span class="badge light badge-success">Matriculado</span>`;
                    } else if (all.estado_licencia != 0) {
                            return `<span class="badge light badge-primary">Licencia (${all.estado_vigencia})</span>`;
                    } else {
                        return `<span class="badge light badge-danger">No Matriculado</span>`;
                    }
                },
            },
            { data: "fechamatricula2", className: "text-center",
                render: function (data, type, all, meta) {
                    if (all.fechamatricula2 == null) {
                        return "--";
                    } else {
                        return all.fechamatricula2;
                    }
                }
            },
            { data: "estadopago", sortable: false, className: "text-center",
                render: function (data, type, all, meta) {
                    if (all.estadopago == "1") {
                        return `
                        <span class="badge light badge-success">Pagado</span>
                        `;
                    } else if (all.estadopago == "0") {
                        return `
                        <span class="badge light badge-danger">No Pagado</span>
                        `;
                    } else if (all.estadopago == "2") {
                        return `
                        <span class="badge light badge-warning">Pendiente</span>
                        `;
                    } else {
                        return "--";
                    }
                },
            },
            { data: "estado_matricula", sortable: false, className: "text-center",
                render: function (data, type, all, meta) {
                    if (all.relacion_estado == "1" && all.estado_licencia == 0) {
                        return `
                            <div class="d-flex justify-content-center">
                                <a href="javascript:void(0);" class="btnVerCursos btn btn-skype shadow btn-xs sharp me-1"
                                    data-idstudent="${all.idstudent}"
                                    data-bs-placement="top"
                                    title="Ver Cursos Matriculados">
                                    <i class="fas fa-eye fa-lg"></i>
                                </a>
                                
                                <a href="javascript:void(0);" class="btnMatricularCursos btn btn-success shadow btn-xs sharp me-1"
                                    data-idperiod="${all.idperiod}"
                                    data-idstudent="${all.idstudent}"
                                    data-bs-placement="top"
                                    title="Matricular en Cursos">
                                    <i class="fa-solid fa-plus fa-lg"></i>
                                </a>
                                
                                <!-- <a href="javascript:void(0);" class="editBtn btn btn-warning shadow btn-xs sharp me-1"
                                data-idsemesterenrollment="${all.idsemesterenrollment}"
                                data-fechamatricula="${all.fechamatricula}"
                                data-estadopago="${all.estadopago}"
                                data-bs-placement="top"
                                title="Editar registro">
                                <i class="fas fa-pencil-alt"></i>
                                </a> -->
                                
                                <a href="javascript:void(0);" class="btnDesmatricular btn btn-danger shadow btn-xs sharp"
                                data-idsemesterenrollment="${all.idsemesterenrollment}"
                                data-idstudent="${all.idstudent}"
                                data-identificacion="${all.identificacion}"
                                data-estudiante="${all.estudiante}"
                                data-bs-placement="top"
                                title="Desmatricular">
                                <i class="fas fa-trash fa-lg"></i>
                                </a>
                            </div>
                            `;
                    } else if (all.estado_licencia != 0) {
                            return `--`;
                    } else {
                        return `
                            <div class="d-flex justify-content-center">
                                <a href="javascript:void(0);" class="btnMatricular btn btn-success shadow btn-xs sharp"
                                data-idstudent="${all.idstudent}"
                                data-identificacion="${all.identificacion}"
                                data-estudiante="${all.estudiante}"
                                data-bs-placement="top"
                                title="Matricular">
                                <i class="fas fa-link fa-beat fa-lg"></i>
                                </a>
                            </div>
                            `;
                    }
                },
            },
        ],
    });

    const integer_to_roman = (num) => {
        if (typeof num !== 'number')
            return false;
        
        var digits = String(+num).split(""),
            key = ["", "C", "CC", "CCC", "CD", "D", "DC", "DCC", "DCCC", "CM",
                "", "X", "XX", "XXX", "XL", "L", "LX", "LXX", "LXXX", "XC",
                "", "I", "II", "III", "IV", "V", "VI", "VII", "VIII", "IX"],
            roman_num = "",
            i = 3;
        while (i--)
            roman_num = (key[+digits.pop() + (i * 10)] || "") + roman_num;
        return Array(+digits.join("") + 1).join("M") + roman_num;
    };

    // SELECCIONAR PROGRAMA
    $("#txt-programs").on("change", function (e) {
        dt_idplan = "0";
        cb_plans($(this).val());
        table.ajax.reload();
    });

    // SELECCIONAR PLAN
    $("#txt-plans").on("change", function (e) {
        dt_idplan = $(this).val();
        notificaciontoast("info", "Consultando a la  base de datos!", "Mensaje!");
        table.ajax.reload();
    });

    var valbtn, formCheck;

    //  BOTON MATRICULAR
    $("#datatableGeneral tbody").on("click", ".btnMatricular", function (e) {
        let idstudent = $(this).data("idstudent");
        $("#btnCreateUpdate").attr("value", "Create");  //cambiar el text del button
        $("#btnCreateUpdate").html("Registrar");
        $("#modalCreateUpdateLabel").html("Registrar nueva matricula");
        clearForm();    // limpiar formulario
        formCheck = $("#formModal")[0]; // limpiar validaciones
        $(formCheck).removeClass('was-validated'); // remover validaciones
        $("#txt-idstudent").val(idstudent)
        $("#modalCreateUpdate").modal("show");
    });


    // BOTON ACTUALIZAR MATRICULA
    $("#datatableGeneral tbody").on("click", ".editBtn", function (e) {
        formCheck = $("#formModal")[0]; // limpiar validaciones
        $(formCheck).removeClass('was-validated'); // remover validaciones
        $("#btnCreateUpdate").attr("value", "Update"); //cambiar el text del button
        $("#btnCreateUpdate").html("Actualizar");
        $("#modalCreateUpdateLabel").html("Actualizar matricula");
        $("#txt-idsemesterenrollment").val($(this).data("idsemesterenrollment"));
        $("#txt-fecha").val($(this).data("fechamatricula"));
        $("#modalCreateUpdate").modal("show");
    });


    // BOTON DESMATRICULAR
    $("#datatableGeneral tbody").on("click", ".btnDesmatricular", function (e) {
        let idsemesterenrollment = $(this).data("idsemesterenrollment");
        let mensaje = 'Se procederá a quitar la matricula al alumno "' 
            + $(this).data('estudiante') + '" identificado con "' 
            + $(this).data('identificacion') + '" al periodo lectivo "' 
            + $(this).data('anho') + ' - ' + $(this).data('numero') + '"';
        confirmation_sweetAlert("Deseas continuar?", mensaje, "warning")
            .then(function (isConfirm) {
                if (isConfirm.value) {
                    destroy(idsemesterenrollment);
                } else {
                    console.log("Cancelado");
                }
            });
    });


    // FUNCION CREATE O UPDATE
    $("#btnCreateUpdate").on("click", function (event) {
        event.preventDefault(); // Iterar sobre los formularios y evitar la acción predeterminada si no son válidos
        formCheck = $("#formModal")[0];
        if (!formCheck.checkValidity()) {
            event.preventDefault();
            event.stopPropagation();
        } else {
            valbtn = $("#btnCreateUpdate").val();
            if (valbtn === "Create") {
                store();
            } else if (valbtn === "Update") {
                update($("#txt-idsemesterenrollment").val());
            }
        }
        $(formCheck).addClass('was-validated'); // añadir validaciones
    });


    function store() {
        formData = new FormData(document.getElementById('formModal'));
        $.ajax({
            type: "POST",
            url: '/admin/matricula/alumnos_semestre/store',
            data: formData,
            processData: false,
            contentType: false,
            beforeSend: function () {
                $('#btnCreateUpdate').addClass('disabled');
            },
            success: function (data) {
                if (data.status == true) {
                    table.ajax.reload();
                    setTimeout(function () {
                        notificaciontoast("info", data.mensaje, "Éxito!");
                        $("#modalCreateUpdate").modal("hide");
                        $('#btnCreateUpdate').removeClass('disabled');
                    }, 1000); // ocultar despues de 1 sec
                } else {
                    table.ajax.reload();
                    setTimeout(function () {
                        notificaciontoast("error", data.mensaje, "Error!");
                        $('#btnCreateUpdate').removeClass('disabled');
                    }, 1000); // ocultar despues de 1 sec
                }
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    function update(idsemesterenrollment) {
        formData = new FormData(document.getElementById('formModal'));
        $.ajax({
            headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
            type: "POST",
            url: '/admin/matricula/alumnos_semestre/update/' + idsemesterenrollment,
            data: formData,
            processData: false,
            contentType: false,
            beforeSend: function () { },
            success: function (data) {
                if (data.status == true) {
                    table.ajax.reload();
                    setTimeout(function () {
                        notificaciontoast("info", data.mensaje, "Éxito!");
                        $("#modalCreateUpdate").modal("hide");
                    }, 1000);   // ocultar despues de 1 sec
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    function destroy(idsemesterenrollment) {
        formModal = $('#formModal');
        $.ajax({
            headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
            type: "DELETE",
            url: '/admin/matricula/alumnos_semestre/destroy/' + idsemesterenrollment,
            beforeSend: function () { },
            success: function (data) {
                if (data.status == true) {
                    table.ajax.reload();
                    notificaciontoast("info", data.mensaje, "Éxito!");
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    function clearForm() {
        $('#txt-fecha').val('');
    }

    // LISTAR DATATABLE 2
    var table2 = $('#datatableGeneral2').DataTable({
        createdRow: function (row, data, index) {
            $(row).addClass("selected");
        },
        order: [],
        ajax: {
            headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
            type: 'POST',
            url: '/admin/matricula/alumnos_semestre/list_courses_by_student',
            data: function (d) {
                d.idstudent = dt_idstudent;
            },
        },
        searching: false,
        pageLength: 10, 
        dom: "Bfrtip",
        select: false,
        lengthChange: false,
        responsive: true,
        language: languageSchema,
        buttons: [],
        columns: [
            { data: "periodo", className: "text-center",
                render: function (data, type, all, meta) {
                    return integer_to_roman(all.periodo);
                }
            },
            { data: "codcurso", className: "text-center" },
            { data: "nombrecourse", className: "text-center" },
            { data: "seccion", className: "text-center" },
            { data: "turno", className: "text-center"} ,
            { data: "creditos", className: "text-center"} ,
            { data: "horas", className: "text-center"} ,
        ],
    });

    // BOTON VER CURSOS
    $("#datatableGeneral tbody").on("click", ".btnVerCursos", function (e) {
        dt_idstudent = $(this).data("idstudent");
        table2.ajax.reload();
        setTimeout(function () { $("#modalDetalleCursos").modal("show"); }, 500); // mostrar despues de x sec
    });


    // LISTAR DATATABLE 3
    var table3 = $('#datatableGeneral3').DataTable({
        createdRow: function (row, data, index) {
            $(row).addClass("selected");
        },
        order: [],
        ajax: {
            headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
            type: 'POST',
            url: '/admin/matricula/alumnos_cursos/list_not_enrollment_subjects',
            data: function (d) {
                d.idstudent = dt_idstudent;
            },
        },
        searching: false,
        pageLength: 10, 
        dom: "Bfrtip",
        select: false,
        lengthChange: false,
        responsive: true,
        language: languageSchema,
        buttons: [],
        columns: [
            { data: "periodo", className: "text-center",
                render: function (data, type, all, meta) {
                    return integer_to_roman(all.periodo);
                }
            },
            { data: "codcurso", className: "text-center" },
            { data: "nombrecourse", className: "text-center" },
            { data: "seccion", className: "text-center" },
            { data: "creditos", className: "text-center"} ,
            { data: "accion", sortable: false, className: "text-center",
                render: function (data, type, all, meta) {
                    if (all.estado_subjectenrolment == "2") {
                        return `
                        <div class="d-flex justify-content-center">
                            <a href="javascript:void(0);" class="btnEstadoMatricula btn btn-success shadow btn-xs sharp me-2"
                            data-idsubjectenrollment="${all.idsubjectenrollment}"
                            data-bs-placement="top"
                            title="Enlazar">
                            <i class="fa-solid fa-check fa-lg"></i>
                            </a>

                            <a href="javascript:void(0);" class="btnDesmatricular btn btn-danger shadow btn-xs sharp"
                            data-idsubjectenrollment="${all.idsubjectenrollment}"
                            data-bs-placement="top"
                            title="Desenlazar">
                            <i class="fas fa-user-xmark fa-lg"></i>
                            </a>
                        </div>
                        `;
                    } else if (all.relacion_estado == "1") {
                        return `
                        <div class="d-flex justify-content-center">
                            <a href="javascript:void(0);" class="btnDesmatricular btn btn-danger shadow btn-xs sharp"
                            data-idsubjectenrollment="${all.idsubjectenrollment}"
                            data-bs-placement="top"
                            title="Desenlazar">
                            <i class="fas fa-user-xmark fa-lg"></i>
                            </a>
                        </div>
                        `;
                    } else if (all.relacion_estado == "0") {
                        return `
                        <div class="d-flex justify-content-center">
                            <a href="javascript:void(0);" class="btnMatricular btn btn-success shadow btn-xs sharp"
                            data-idstudent="${all.idstudent}"
                            data-idsubject="${all.idsubject}"
                            data-bs-placement="top"
                            title="Enlazar">
                            <i class="fas fa-user-plus fa-lg"></i>
                            </a>
                        </div>
                        `;
                    } 
                },
            },
        ],
    });

    // BOTON VER CURSOS
    $("#datatableGeneral tbody").on("click", ".btnMatricularCursos", function (e) {
        dt_idstudent = $(this).data("idstudent");
        table3.ajax.reload();
        $('#modalDetalleCursosLabel').empty();
        $('#modalDetalleCursosLabel').append('Cursos para matricular al estudiante: ' + $(this).data('estudiante'));
        setTimeout(function () { $("#modalDetalleCursos").modal("show"); }, 500); 
    });
});


