import { notificaciontoast } from "../../common/method_toast.js";
import { confirmation_sweetAlert } from "../../common/method_sweetAlert.js";
import { getButtonsSchema, languageSchema } from "../../common/schemas.js";
//import { tl_plans} from "../../common/timeline/programs.js";

$(document).ready(function () {

    const tableName = "Matricula Alumno y cursos";

    var dt_idsemester = "0", dt_idstudent = "0", dt_idcourse = "0", dt_idplan ="0";
    var formModal, formData;

    // LISTAR DATATABLE
    var table = $('#datatableGeneral').DataTable({
        createdRow: function (row, data, index) {
            $(row).addClass("selected");
        },
        order: [],
        ajax: {
            headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
            type: 'POST',
            url: '/admin/matricula/alumnos_cursos/list',
            data: function (d) {
                d.idsemester = dt_idsemester;
                d.idstudent = dt_idstudent;
            },
        },
        searching: true,
        pageLength: 12, // 12 filas
        dom: "Bfrtip",
        select: false,
        lengthChange: false,
        responsive: true,
        language: languageSchema,
        buttons: getButtonsSchema(tableName),
        columns: [
            { data: 'idsubject', className: 'text-center', },
            { data: "periodo", className: "text-center",
                render: function (data, type, all, meta) {
                            return integer_to_roman(all.periodo);
                    }
            },
            { data: "nombrecourse", className: "text-center", },
            { data: "seccion", className: "text-center", },
            { data: "turno", className: "text-center", },
            { data: "tiposubject", className: "text-center", },
            { data: "estado_matricula1", sortable: false, className: "text-center",
                render: function (data, type, all, meta) {
                    if (all.estado_subjectenrolment == "1") {
                        return `<span class="badge light badge-success">Matriculado</span>`;
                    } else if (all.relacion_estado == "0") {
                        return `<span  class="badge light badge-danger">No Matriculado</span>`;
                    } else if (all.estado_subjectenrolment == "2") {
                        return `<span  class="badge light badge-warning">Pendiente</span>`;
                    }   
                },
            },
            { data: "estado_matricula2", sortable: false, className: "text-center",
                render: function (data, type, all, meta) {
                    if (all.estado_subjectenrolment == "2") {
                        return `
                        <div class="d-flex justify-content-center">
                            <a href="javascript:void(0);" class="btnEstadoMatricula btn btn-success shadow btn-xs sharp me-2"
                            data-idsubjectenrollment="${all.idsubjectenrollment}"
                            data-bs-placement="top"
                            title="Enlazar">
                            <i class="fa-solid fa-check fa-lg"></i>
                            </a>

                            <a href="javascript:void(0);" class="btnDesmatricular btn btn-danger shadow btn-xs sharp"
                            data-idsubjectenrollment="${all.idsubjectenrollment}"
                            data-bs-placement="top"
                            title="Desenlazar">
                            <i class="fas fa-user-xmark fa-lg"></i>
                            </a>
                        </div>
                        `;
                    } else if (all.relacion_estado == "1") {
                        return `
                        <div class="d-flex justify-content-center">
                            <a href="javascript:void(0);" class="btnDesmatricular btn btn-danger shadow btn-xs sharp"
                            data-idsubjectenrollment="${all.idsubjectenrollment}"
                            data-bs-placement="top"
                            title="Desenlazar">
                            <i class="fas fa-user-xmark fa-lg"></i>
                            </a>
                        </div>
                        `;
                    } else if (all.relacion_estado == "0") {
                        return `
                        <div class="d-flex justify-content-center">
                            <a href="javascript:void(0);" class="btnMatricular btn btn-success shadow btn-xs sharp"
                            data-idstudent="${all.idstudent}"
                            data-idsubject="${all.idsubject}"
                            data-bs-placement="top"
                            title="Enlazar">
                            <i class="fas fa-user-plus fa-lg"></i>
                            </a>
                        </div>
                        `;
                    } 
                },
            },
        ],
    });

    const integer_to_roman = (num) => {
        if (typeof num !== 'number')
            return false;
        
        var digits = String(+num).split(""),
            key = ["", "C", "CC", "CCC", "CD", "D", "DC", "DCC", "DCCC", "CM",
                "", "X", "XX", "XXX", "XL", "L", "LX", "LXX", "LXXX", "XC",
                "", "I", "II", "III", "IV", "V", "VI", "VII", "VIII", "IX"],
            roman_num = "",
            i = 3;
        while (i--)
            roman_num = (key[+digits.pop() + (i * 10)] || "") + roman_num;
        return Array(+digits.join("") + 1).join("M") + roman_num;
    };


    // Agregar una columna de números automáticos
    table.on('order.dt search.dt', function () {
        table.column(0, { search: 'applied', order: 'applied' }).nodes().each(function (cell, i) {
            cell.innerHTML = i + 1;
        });
    }).draw();


    // INICIO - SELECCIONAR PERIODO
    $("#tlsemester").on("click", ".btnSemester", function (e) {
        dt_idsemester = $(this).data("idsemester");
        $("#txt-idsemester").val(dt_idsemester);
        //Colorear la opcion seleccionada
        $('.divsemester').removeClass("dark").addClass("primary");
        $(this).prev('div').removeClass("primary").addClass("dark");
        //Quitar atributo
        document.getElementById("btnReportSemester").removeAttribute('style','display:none');
        document.getElementById("btnReportGeneral").removeAttribute('style','display:none');
        //info Toast
        notificaciontoast("info", "Consultando a la  base de datos!", "Mensaje!");
        // CARGAR TABLA
        table.ajax.reload();
        cb_students(dt_idplan);
    });
    // FIN - SELECCIONAR PERIODO


    // // INICIO - SELECCIONAR PROGRAMA
    $("#tlprogram").on("click", ".btnProgram", function (e) {
        dt_idstudent = "0";
        cleanInfoAlumno();
        //Colorear la opcion seleccionada
        $('.divprogram').removeClass("dark").addClass("primary");
        $(this).prev('div').removeClass("primary").addClass("dark");
        // listar planes
        tl_plans($(this).data("idprogram"));
        // limpiar alumnos
        $("#txt-students").find("option").remove().end() // delete options
        $("#txt-students").append('<option selected disabled value="">Buscar alumno</option>');
        $("#txt-students").selectpicker("refresh");
        //Quitar atributo
        document.getElementById("btnReportSemester").setAttribute('style','display:none');
        document.getElementById("btnReportGeneral").setAttribute('style','display:none');
        // CARGAR TABLA
        table.ajax.reload();
    });
    // FIN - SELECCIONAR PROGRAMA


    // // INICIO - SELECCIONAR PLAN
    $("#tlplan").on("click", ".btnPlan", function (e) {
        dt_idstudent = "0";
        cleanInfoAlumno();
        //Colorear la opcion seleccionada
        $('.divplan').removeClass("dark").addClass("primary");
        $(this).prev('div').removeClass("primary").addClass("dark");
        // listar alumnos
        dt_idplan=$(this).data("idplan");
        cb_students(dt_idplan);
        //info Toast
        notificaciontoast("info", "Consultando a la  base de datos!", "Mensaje!");
        // CARGAR TABLA
        table.ajax.reload();
    });
    // // FIN - SELECCIONAR PLAN


    function cb_students(idplan) {
        let apenom;
        $("#txt-students").find("option").remove().end() // delete options
        $.ajax({
            type: "GET",
            url: '/ajax_all/students/' + idplan,
            data:{
                idsemester: dt_idsemester,
            },
            dataType: 'json',
            beforeSend: function () { },
            success: function (response) {
                $("#txt-students").append('<option selected disabled value="">Buscar alumno</option>');
                response.forEach((elemento) => {
                    apenom = elemento.apellido_pa + " " + elemento.apellido_ma + ", " + elemento.nombres;
                    $("#txt-students").append('<option' +
                        ' value="' + elemento.idstudent + '" ' +
                        ' data-subtext="' + elemento.nroidenti + '" ' +
                        ' data-idstudent="' + elemento.idstudent + '" ' +
                        ' data-apellido_pa="' + elemento.apellido_pa + '" ' +
                        ' data-apellido_ma="' + elemento.apellido_ma + '" ' +
                        ' data-nombres="' + elemento.nombres + '" ' +
                        ' data-tipoidenti="' + elemento.tipoidenti + '" ' +
                        ' data-nroidenti="' + elemento.nroidenti + '" ' +
                        ' data-celular="' + elemento.celular + '" ' +
                        ' data-anho_ingreso="' + elemento.anho_ingreso + '" ' +
                        ' data-estado="' + elemento.estado + '" ' +
                        '>' + apenom + '</option>');
                })
                $("#txt-students").selectpicker("refresh");
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    var selectedOption;

    // on change students
    $("#txt-students").on('change', function () {
        // setear idstudent
        dt_idstudent = $(this).val();
        // insertar info en card
        selectedOption = $(this).find('option:selected');
        let apenom = selectedOption.data('apellido_pa') + " " + selectedOption.data('apellido_ma') + ", " + selectedOption.data('nombres');
        $('#txt-info-nombres').html(apenom);
        $('#txt-info-id').html(selectedOption.data('tipoidenti')+': '+selectedOption.data('nroidenti'));
        $('#txt-info-anho_ingreso').html(selectedOption.data('anho_ingreso'));

        //Quitar atributo
        // document.getElementById("btnFactura").setAttribute('style','display:none');
        document.getElementById("btnReportSemester").removeAttribute('style','display:none');
        document.getElementById("btnReportGeneral").removeAttribute('style','display:none');
        // CARGAR TABLA
        table.ajax.reload();
    });

    // INICIO - MODAL MATRICULAR
    $("#datatableGeneral tbody").on("click", ".btnMatricular", function (e) {
        let idstudent = $(this).data("idstudent");
        let idsubject = $(this).data("idsubject");
        // confirmacion
        confirmation_sweetAlert("Deseas continuar?", "Se procederá a matricular al alumno al curso", "warning")
            .then(function (isConfirm) {
                if (isConfirm.value) {
                    // setear datos
                    $("#txt-idstudent").val(idstudent);
                    $("#txt-idsubject").val(idsubject);
                    store();
                } else {
                    console.log("Cancelado");
                }
            });
    });
    // FIN - MODAL MATRICULAR


    // INICIO - MODAL CAMBIAR ESTADO MATRICULA
    $("#datatableGeneral tbody").on("click", ".btnEstadoMatricula", function (e) {
        let idsubjectenrollment = $(this).data("idsubjectenrollment");
        // confirmacion
        confirmation_sweetAlert("Deseas continuar?", "Se procederá a matricular al alumno al curso", "warning")
            .then(function (isConfirm) {
                if (isConfirm.value) {
                    // setear datos
                    update_estado(idsubjectenrollment);
                } else {
                    console.log("Cancelado");
                }
            });
    });
    // FIN - MODAL CAMBIAR ESTADO MATRICULA


    // INICIO - MODAL DESMATRICULAR
    $("#datatableGeneral tbody").on("click", ".btnDesmatricular", function (e) {
        let idsubjectenrollment = $(this).data("idsubjectenrollment");
        // confirmacion
        confirmation_sweetAlert("Deseas continuar?", "Se procederá a desmatricular al alumno del curso", "warning")
            .then(function (isConfirm) {
                if (isConfirm.value) {
                    // setear datos
                    destroy(idsubjectenrollment);
                } else {
                    console.log("Cancelado");
                }
            });
    });
    // FIN - MODAL DESMATRICULAR


    function store() {
        formData = new FormData(document.getElementById('formModal'));
        $.ajax({
            headers: { "X-CSRF-TOKEN": $('input[name="_token"]').val() },
            type: "POST",
            url: '/admin/matricula/alumnos_cursos/store',
            data: formData,
            processData: false,
            contentType: false,
            beforeSend: function () { },
            success: function (data) {
                if (data.status == true) {
                    table.ajax.reload();
                    setTimeout(function () {
                        notificaciontoast("info", data.mensaje, "Éxito!");
                        $("#modalCreateUpdate").modal("hide");
                    }, 1000); // ocultar despues de 1 sec
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    function update_estado(idsubjectenrollment) {
        formData = new FormData(document.getElementById('formModal'));
        $.ajax({
            headers: { "X-CSRF-TOKEN": $('input[name="_token"]').val() },
            type: "GET",
            url: '/admin/matricula/alumnos_cursos/update_estado/' + idsubjectenrollment,
            data: formData,
            processData: false,
            contentType: false,
            beforeSend: function () { },
            success: function (data) {
                if (data.status == true) {
                    table.ajax.reload();
                    setTimeout(function () {
                        notificaciontoast("info", data.mensaje, "Éxito!");
                        $("#modalCreateUpdate").modal("hide");
                    }, 1000); 
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    function destroy(idsubjectenrollment) {
        $.ajax({
            headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
            type: "DELETE",
            url: '/admin/matricula/alumnos_cursos/destroy/' + idsubjectenrollment,
            beforeSend: function () { },
            success: function (data) {
                if (data.status == true) {
                    table.ajax.reload();
                    notificaciontoast("info", data.mensaje, "Éxito!");
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }


    // LISTAR DATATABLE
    var table2 = $('#datatableGeneral2').DataTable({
        createdRow: function (row, data, index) {
            $(row).addClass("selected");
        },
        order: [],
        ajax: {
            headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
            type: 'POST',
            url: '/admin/matricula/alumnos_cursos/list_historial',
            data: function (d) {
                d.idstudent = dt_idstudent;
                d.idcourse = dt_idcourse;
            },
        },
        searching: false,
        paging: false, // Deshabilita la paginación
        info: false, // Oculta la información de entradas
        pageLength: 12, // 12 filas
        select: false,
        lengthChange: false,
        responsive: true,
        language: languageSchema,
        columns: [
            {
                data: "idsemester",
                className: "text-center",
                render: function (data, type, all, meta) {
                    return all.anho + " - " + all.numero;
                }
            },
            { data: 'fecinicio', className: 'text-center' },
            { data: 'fecfin', className: 'text-center' },
            { data: 'seccion', className: 'text-center' },
            { data: 'turno', className: 'text-center' },
            { data: 'tiposubject', className: 'text-center' },
            { data: 'idteacher', className: 'text-center' },
            { data: 'nota', className: 'text-center' },
            {
                data: "estado",
                className: "text-center",
                render: function (data, type, all, meta) {
                    if (all.estado == "0") {
                        return `<span class="badge light badge-danger">Desaprobado</span>`;
                    }
                    else if (all.estado == "1") {
                        return `<span class="badge light badge-success">Aprobado</span>`;
                    }
                    else {
                        return `<span class="badge light badge-warning">Sin evaluar</span>`;
                    }
                }
            },
        ],
    });


    // INICIO - MODAL VER HISTORIAL ALUMNO CURSO
    $("#datatableGeneral tbody").on("click", ".btnVerHistorialCurso", function (e) {
        dt_idstudent = $(this).data("idstudent");
        dt_idcourse = $(this).data("idcourse");
        // cargar tabla
        table2.ajax.reload();
        setTimeout(function () { $("#modalHistorialAlumnoCurso").modal("show"); }, 500); // mostrar despues de x sec
        // mostrar modal
    });
    // FIN - MODAL VER HISTORIAL ALUMNO CURSO


    function cleanInfoAlumno(){
        $('#txt-info-nombres').html('--');
        $('#txt-info-id').html('--');
        $('#txt-info-anho_ingreso').html('--');
    }


    //REPORTE DE LAS Curso LLEVADOS DEL ALUMNO POR PERIODO
    $(document).on("click", "#btnReportSemester", function () {
        var idsubject = $(this).attr("data-idsubject");
        $("#modalpreload").modal("show");
        document.getElementById('div_progressbar_modal_preload').innerHTML =
        ` <div class="drive-content mt-2 mx-2 p-1">
            <div class="progress default-progress">
                <div class="progress-bar bg-vigit progress-animated bg-info" style="width: 100%; height:100%;" role="progressbar">
                    <span id="txt_title_progressbar">CARGANDO</span>
                </div>
            </div>
        </div>`
        setTimeout(function () {
            $("#modalpreload").modal("hide");
        }, 2000);
        setTimeout(function () {
            window.open('/reportes/curso_semestre_alumno/'+dt_idsemester+'/'+dt_idstudent, '_blank');
        }, 2000);
    });

    //REPORTE DE LAS Curso LLEVADOS DEL ALUMNO EN GENERAL
    $(document).on("click", "#btnReportGeneral", function () {
        $("#modalpreload").modal("show");
        document.getElementById('div_progressbar_modal_preload').innerHTML =
        ` <div class="drive-content mt-2 mx-2 p-1">
            <div class="progress default-progress">
                <div class="progress-bar bg-vigit progress-animated bg-info" style="width: 100%; height:100%;" role="progressbar">
                    <span id="txt_title_progressbar">CARGANDO</span>
                </div>
            </div>
        </div>`
        setTimeout(function () {
            $("#modalpreload").modal("hide");
        }, 2000);
        setTimeout(function () {
            window.open('/reportes/curso_total_alumno/'+dt_idsemester+'/'+dt_idstudent, '_blank');
        }, 2000);
    });

});


