// resources/js/admin/semestres.js
"use strict";
import { notificaciontoast } from "../../common/method_toast.js";
import { confirmation_sweetAlert } from "../../common/method_sweetAlert.js";
import { getButtonsSchema, languageSchema } from "../../common/schemas.js";

$(document).ready(function () {
    const tableName = "Semestres ";
    let formCheck;
    
    // LISTAR DATATABLE
    const table = $("#datatableGeneral").DataTable({
        createdRow: function (row) {
            $(row).addClass("selected");
        },
        order: [],
        ajax: "/admin/institucion/semestres/list",
        searching: true,
        dom: "Bfrtip",
        select: false,
        lengthChange: false,
        responsive: true,
        language: languageSchema,
        buttons: getButtonsSchema(tableName),
        columns: [
            {
                data: "nombre",
                className: "text-center",
                render: function (_d, _t, all) {
                    return all.anho + "-" + all.numero;
                },
                title: "Semestre",
            },
            {
                data: "tipo",
                className: "text-center",
                render: function (_d, _t, all) {
                    if (all.tipo == 1) return "Regular";
                    if (all.tipo == 2) return "Vacacional";
                    if (all.tipo == 3) return "Reforzamiento";
                    return "--";
                },
                title: "Tipo",
            },
            { data: "creditaje", className: "text-center", title: "Créditos Máx" },
            { data: "porcentaje_inasistencias", className: "text-center", title: "% Inasistencias" },
            { data: "nota_minima", className: "text-center", title: "Nota Mínima" },
            { data: "fechas_matricula", className: "text-center", title: "Matrícula" },
            { data: "fechas_notas", className: "text-center", title: "Notas" },
            { data: "fechas_actas", className: "text-center", title: "Actas" },
            { data: "nota", className: "text-center", sortable: false, title: "Estado",
                render: function (_d, _t, all) {
                    const checked = all.estado == 1 ? "checked" : "";
                    const badge =
                        all.estado == 1
                            ? `<span class="badge light badge-success">Habilitado</span>`
                            : `<span class="badge light badge-danger">Deshabilitado</span>`;
                    return `
                        <div class="d-flex justify-content-center form-check form-switch checkbox-info align-items-center gap-2">
                            <label class="form-check d-inline-block mb-0">
                                <input class="form-check-input checkbox-info switchEstado"
                                    type="checkbox"
                                    data-id="${all.id}"
                                    ${checked}>
                            </label>
                            ${badge}
                        </div>
                    `;
                },
            },
            {
                data: "accion",
                className: "text-center",
                sortable: false,
                title: "Acción",
                render: function (_d, _t, all) {
                    return `
                        <div class="d-flex justify-content-center">
                            <a href="javascript:void(0);" class="editBtn btn btn-warning shadow btn-xs sharp me-1"
                                data-id="${all.id}"
                                data-anho="${all.anho}"
                                data-numero="${all.numero}"
                                data-tipo="${all.tipo}"
                                data-creditaje="${all.creditaje}"
                                data-porcentaje_inasistencias="${all.porcentaje_inasistencias}"
                                data-nota_minima="${all.nota_minima}"
                                data-fecinicio="${all.fecinicio ?? ""}"
                                data-fecfin="${all.fecfin ?? ""}"
                                data-informacion='${(all.informacion ?? "").replace(/'/g, "&#39;")}'
                                data-fecha_inicio_matricula="${all.fecha_inicio_matricula ?? ""}"
                                data-fecha_fin_matricula="${all.fecha_fin_matricula ?? ""}"
                                data-fecha_inicio_notas="${all.fecha_inicio_notas ?? ""}"
                                data-fecha_fin_notas="${all.fecha_fin_notas ?? ""}"
                                data-fecha_inicio_actas="${all.fecha_inicio_actas ?? ""}"
                                data-fecha_fin_actas="${all.fecha_fin_actas ?? ""}"
                                title="Editar registro">
                                <i class="fas fa-pencil-alt fa-sm"></i>
                            </a>
                            
                            <a href="javascript:void(0);" class="deleteBtn btn btn-danger shadow btn-xs sharp"
                                data-id="${all.id}"
                                title="Eliminar registro">
                                <i class="fas fa-trash fa-sm"></i>
                            </a>
                        </div>
                    `;
                },
            },
        ],
    });

    // Toggle estado (único activo)
    $("#datatableGeneral tbody").on("change", ".switchEstado", function () {
        const id = $(this).data("id");
        $("#txt-id").val(id);
        $("#txt-estado").val($(this).is(":checked") ? 1 : 0);
        update_estado();
    });

    // Crear: abrir modal limpio
    $("#btnCreateModal").click(function () {
        $("#btnCreateUpdate").val("Create").text("Guardar");
        $("#modalCreateUpdateLabel").text("Registrar datos del Periodo Lectivo");
        clearCheck();
        Clearform();
    });

    // Editar: setear datos y abrir modal
    $("#datatableGeneral tbody").on("click", ".editBtn", function () {
        clearCheck();
        $("#btnCreateUpdate").text("Actualizar").val("Update");
        $("#modalCreateUpdateLabel").text("Actualizar datos del Periodo Lectivo");
        $("#txt-id").val($(this).data("id"));
        $("#txt-anho").val($(this).data("anho"));
        $("#txt-numero").val($(this).data("numero"));
        $("#txt-creditaje").val($(this).data("creditaje"));
        $("#txt-porcentaje_inasistencias").val($(this).data("porcentaje_inasistencias"));
        $("#txt-nota_minima").val($(this).data("nota_minima"));
        $("#txt-tipo").selectpicker("val", $(this).attr("data-tipo"));
        $("#txt-fecha_inicio_matricula").val($(this).data("fecha_inicio_matricula"));
        $("#txt-fecha_fin_matricula").val($(this).data("fecha_fin_matricula"));
        $("#txt-fecha_inicio_notas").val($(this).data("fecha_inicio_notas"));
        $("#txt-fecha_fin_notas").val($(this).data("fecha_fin_notas"));
        $("#txt-fecha_inicio_actas").val($(this).data("fecha_inicio_actas"));
        $("#txt-fecha_fin_actas").val($(this).data("fecha_fin_actas"));

        if (window.tinymce && tinymce.get("txt-informacion")) {
            tinymce.get("txt-informacion").setContent($(this).data("informacion") || "");
        } else {
            $("#txt-informacion").val($(this).data("informacion") || "");
        }

        $("#modalCreateUpdate").modal("show");
    });

    // Guardar / Actualizar
    $("#btnCreateUpdate").on("click", function (event) {
        event.preventDefault();
        formCheck = $("#formModal")[0];
        if (!formCheck.checkValidity()) {
            event.stopPropagation();
            $(formCheck).addClass("was-validated");
            return;
        }
        const mode = $("#btnCreateUpdate").val();
        if (mode === "Create") store();
        if (mode === "Update") update();
    });

    // Eliminar
    $("#datatableGeneral tbody").on("click", ".deleteBtn", function () {
        const id = $(this).data("id");
        confirmation_sweetAlert(
            "Deseas continuar?",
            "Se procederá a eliminar el registro de la base de datos",
            "warning"
        ).then(function (isConfirm) {
            if (isConfirm.value) destroy(id);
        });
    });

    // -------- funciones --------
    function store() {
        const info = getInfo();
        const formData = $("#formModal").serializeArray();
        formData.push({ name: "informacion", value: info });
        const queryString = $.param(formData);

        $.ajax({
            type: "POST",
            url: "/admin/institucion/semestres/store",
            data: queryString,
            dataType: "json",
            success: function (data) {
                if (data.status) {
                    notificaciontoast("info", data.mensaje, "Éxito!");
                    table.ajax.reload();
                    $("#modalCreateUpdate").modal("hide");
                } else {
                    notificaciontoast("error", data.mensaje || "Error al registrar", "Error!");
                }
            },
            error: function (err) {
                console.log("Error", err);
                notificaciontoast("error", "Error al registrar", "Error!");
            },
        });
    }

    function update() {
        const id = $("#txt-id").val();
        const info = getInfo();
        const formData = $("#formModal").serializeArray();
        formData.push({ name: "txt-informacion", value: info });
        const queryString = $.param(formData);

        $.ajax({
            type: "PUT",
            url: "/admin/institucion/semestres/update/" + id,
            data: queryString,
            dataType: "json",
            success: function (data) {
                if (data.status) {
                    notificaciontoast("info", data.mensaje, "Éxito!");
                    table.ajax.reload();
                    $("#modalCreateUpdate").modal("hide");
                    setTimeout(resetForm, 500);
                } else {
                    notificaciontoast("error", data.mensaje || "Error al actualizar", "Error!");
                }
            },
            error: function (err) {
                console.log("Error", err);
                notificaciontoast("error", "Error al actualizar", "Error!");
            },
        });
    }

    function destroy(id) {
        $.ajax({
            headers: { "X-CSRF-TOKEN": $('input[name="_token"]').val() },
            type: "DELETE",
            url: "/admin/institucion/semestres/destroy/" + id,
            success: function (data) {
                if (data.status) {
                    notificaciontoast("info", data.mensaje, "Éxito!");
                    table.ajax.reload();
                } else {
                    notificaciontoast("error", data.mensaje || "No se pudo eliminar", "Error!");
                }
            },
            error: function (err) {
                console.log("Error", err);
                notificaciontoast("error", "Error al eliminar", "Error!");
            },
        });
    }

    function update_estado() {
        const id = $("#txt-id").val();
        const formData = $("#formModal").serialize();
        $.ajax({
            type: "PUT",
            url: "/admin/institucion/semestres/update_estado/" + id,
            data: formData,
            dataType: "json",
            success: function (data) {
                if (data.status) {
                    notificaciontoast("info", data.mensaje, "Éxito!");
                    table.ajax.reload();
                    $("#modalCreateUpdate").modal("hide");
                    setTimeout(resetForm, 500);
                } else {
                    table.ajax.reload();
                    notificaciontoast("error", data.mensaje || "No se pudo actualizar", "Error!");
                }
            },
            error: function (err) {
                console.log("Error", err);
                notificaciontoast("error", "Error al actualizar estado", "Error!");
            },
        });
    }

    function getInfo() {
        if (window.tinymce && tinymce.get("txt-informacion")) {
            const content = tinymce.get("txt-informacion").getContent();
            if (!content) tinymce.get("txt-informacion").setContent("No hay información");
            return tinymce.get("txt-informacion").getContent();
        }
        const val = $("#txt-informacion").val();
        return val && val.trim() ? val : "No hay información";
    }

    function clearCheck() {
        formCheck = $("#formModal")[0];
        $(formCheck).removeClass("was-validated");
    }

    function Clearform() {
        $("#txt-anho").val("");
        $("#txt-numero").val("");
        $("#txt-tipo").selectpicker("val", "1");
        $("#txt-informacion").val("");
        $("#txt-fecha_inicio_matricula").val("");
        $("#txt-fecha_fin_matricula").val("");
        $("#txt-fecha_inicio_notas").val("");
        $("#txt-fecha_fin_notas").val("");
        $("#txt-fecha_inicio_actas").val("");
        $("#txt-fecha_fin_actas").val("");
    }

    function resetForm() {
        document.getElementById("formModal").classList.remove("was-validated");
        document.getElementById("formModal").reset();
        $("#btnCreateUpdate").val("Create").text("Guardar");
    }
});
