"use strict";
import { notificaciontoast } from "../../common/method_toast.js";
import { confirmation_sweetAlert } from "../../common/method_sweetAlert.js";
import { getButtonsSchema, languageSchema } from '../../common/schemas.js';

$(document).ready(function () {
    const tableName = "Roles y Áreas";

    // LISTAR DATATABLE
    var table = $("#datatableGeneral").DataTable({
        createdRow: function (row, data, index) {
            $(row).addClass("selected");
        },
        order: [],
        ajax: {
            headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
            type: 'GET',
            url: '/admin/institucion/roles_areas/list',
        },
        pageLength: 13, // numero de filas
        searching: true,
        dom: "Bfrtip",
        select: false,
        lengthChange: false,
        responsive: true,
        language: languageSchema,
        buttons: getButtonsSchema(tableName),
        columns: [
            {
                data: "role_id",
                className: "text-center",

                render: function (data, type, all, meta) {
                    return `<h3> ${all.role_id}. ${all.role_nombre} </h3>
                        <br>
                        <b> ${all.role_descripcion} </b>`;
                },
                name: "primero",
            },
            {
                data: "area_id",
                sortable: false,
                className: "text-center",

                render: function (data, type, all, meta) {
                    return all.area_nombre;
                },
            },
            {
                data: "permiso",
                sortable: false,
                className: "text-center",

                render: function (data, type, all, meta) {
                    if (all.permiso == "1") {
                        return `
                        <i class="fa fa-check-circle text-success" aria-hidden="true"></i>
                        <select class="editBtn default-select"
                        data-role_id="${all.role_id}"
                        data-area_id="${all.area_id}"
                        >
                            <option selected value="1">Habilitado</option>
                            <option value="0">Inhabilitado</option>
                        </select>
                        `;
                    } else {
                        return `
                        <i class="fa fa-times-circle text-danger" aria-hidden="true"></i>
                        <select class="editBtn default-select"
                        data-role_id="${all.role_id}"
                        data-area_id="${all.area_id}"
                        >
                            <option value="1">Habilitado</option>
                            <option selected value="0">Inhabilitado</option>
                        </select>
                        `;
                    }
                },

            },
        ],
        rowsGroup: [
            'primero:name',
        ],
        orderFixed: [0, 'asc'], // Fija el orden por defecto de la primera columna
    });

    // - - - - - - - - - - F U N C I O N E S - - - - - - - - - -

    $("#datatableGeneral tbody").on("change", ".editBtn", async function (e) {
        const role_id = $(this).attr("data-role_id");
        const area_id = $(this).attr("data-area_id");

        const optSelected = $(this).val();

        const actions = {
            1: () => { store(role_id, area_id) },
            0: () => { destroy(role_id, area_id) },
            'default': () => { }
        };

        (actions[optSelected] || actions['default'])();

    });

    function store(role_id, area_id) {
        $.ajax({
            headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
            type: "POST",
            url: `/admin/institucion/roles_areas/store?role_id=${role_id}&area_id=${area_id}`,
            beforeSend: function () { },
            success: function (data) {
                if (data.status == true) {
                    table.ajax.reload();
                    notificaciontoast("info", data.mensaje, "Éxito!");
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    function destroy(role_id, area_id) {
        $.ajax({
            headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
            type: "DELETE",
            url: `/admin/institucion/roles_areas/destroy?role_id=${role_id}&area_id=${area_id}`,
            beforeSend: function () { },
            success: function (data) {
                if (data.status == true) {
                    table.ajax.reload();
                    notificaciontoast("info", data.mensaje, "Éxito!");
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

});
