'use strict'

import { notificaciontoast } from '../../common/method_toast.js'
import { confirmation_sweetAlert } from '../../common/method_sweetAlert.js'
import { getButtonsSchema, languageSchema } from '../../common/schemas.js'

$(document).ready(function () {
  const tableName = 'Requisitos de Docente'

  // LISTAR DATATABLE
  const table = $('#datatableGeneral').DataTable({
    createdRow: function (row, data, index) {
      $(row).addClass('selected')
    },
    order: [],
    ajax: {
      headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
      type: 'POST',
      url: '/admin/institucion/requisitosdocente/list'
    },
    searching: true,
    dom: 'Bfrtip',
    select: false,
    lengthChange: false,
    responsive: true,
    language: languageSchema,
    buttons: getButtonsSchema(tableName),
    columns: [
      { data: 'id', className: 'text-center' },
      { data: 'nombre', className: 'text-center' },
      {
        data: 'id',
        className: 'text-center',
        sortable: false,
        render: function (data, type, all, meta) {
          return `
            <div class="d-flex justify-content-center">
                <a href="#" class="editBtn btn btn-warning shadow btn-xs sharp me-1"
                data-id="${all.id}"
                data-nombre="${all.nombre}"
                data-bs-placement="top"
                title="Editar registro">
                <i class="fas fa-pencil-alt"></i>
                </a>

                <a href="#" class="deleteBtn btn btn-danger shadow btn-xs sharp"
                data-id="${all.id}"
                data-bs-placement="top"
                title="Eliminar registro">
                <i class="fas fa-trash"></i>
                </a>
            </div>
          `
        }
      }
    ]
  })

  // Agregar una columna de números automáticos
  table
    .on('order.dt search.dt', function () {
      table
        .column(0, { search: 'applied', order: 'applied' })
        .nodes()
        .each(function (cell, i) {
          cell.innerHTML = i + 1
        })
    })
    .draw()

  // - - - - - - - - - - M O D A L S - - - - - - - - - -
  const forms = $('.needs-validation')
  // INICIO - MODAL CREATE
  $('#btnCreateModal').click(function () {
    // change value
    document.getElementById('btnCreateUpdate').setAttribute('value', 'Create')
    document.getElementById('btnCreateUpdate').innerHTML = 'Guardar'
    document.getElementById('modalCreateUpdateLabel').innerHTML =
      'Registrar datos del requisito de docente'
    clearCheck()
    Clearform()
  })
  // FIN - MODAL CREATE

  // INICIO - MODAL UPDATE
  $('#datatableGeneral tbody').on('click', '.editBtn', function (e) {
    clearCheck()
    //cambiar el text del button
    document.getElementById('btnCreateUpdate').innerHTML = 'Actualizar'
    document.getElementById('modalCreateUpdateLabel').innerHTML =
      'Actualizar datos del requisito de docente'
    // setear data de cargo
    document.getElementById('txt-id').value = $(this).attr('data-id')
    document.getElementById('txt-nombre').value = $(this).attr('data-nombre')
    // show form
    $('#modalCreateUpdate').modal('show')
    // change value
    document.getElementById('btnCreateUpdate').setAttribute('value', 'Update')
  })
  // FIN - MODAL UPDATE

  let valbtn = ''
  // INICIO - FUNCION CREATE O UPDATE
  $('#btnCreateUpdate').on('click', function (e) {
    e.preventDefault()
    // Iterar sobre los formularios y evitar la acción predeterminada si no son válidos
    forms.each(function (index, form) {
      if (!form.checkValidity()) {
        e.preventDefault()
        e.stopPropagation()
        $(form).addClass('was-validated') // añadir validaciones
      } else {
        valbtn = $('#btnCreateUpdate').val()
        // FUNCION CREAR
        if (valbtn === 'Create') {
          // insertar
          store()
        }
        // FUNCION ACTUALIZAR
        if (valbtn === 'Update') {
          // actualizar
          update()
        }
      }
    })
  })
  // FIN - FUNCION CREATE O UPDATE

  // INICIO - MODAL DELETE
  $('#datatableGeneral tbody').on('click', '.deleteBtn', function (e) {
    const id = $(this).attr('data-id')
    // confirmacion
    confirmation_sweetAlert(
      'Deseas continuar?',
      'Se procederá a eliminar el registro de la base de datos',
      'warning'
    ).then(function (isConfirm) {
      if (isConfirm.value) {
        // enviando el parametro de la data que se procede a delete
        destroy(id)
      } else {
        console.log('Cancelado')
      }
    })
  })

  // - - - - - - - - - - F U N C I O N E S - - - - - - - - - -
  function store() {
    const formModal = $('#formModal')
    $.ajax({
      type: 'POST',
      url: '/admin/institucion/requisitosdocente/store',
      data: formModal.serialize(),
      dataType: 'json',
      beforeSend: function () {},
      success: function (data) {
        if (data.status == true) {
          formModal.addClass('was-validated')
          notificaciontoast('info', data.mensaje, 'Éxito!')
          table.ajax.reload()
          $('#modalCreateUpdate').modal('hide')
        } else {
          notificaciontoast('error', data.mensaje, 'Error!')
        }
      },
      error: function (error) {
        console.log('Error', error)
      }
    })
  }

  function update() {
    const id = document.getElementById('txt-id').value
    const formModal = $('#formModal')
    $.ajax({
      type: 'PUT',
      url: '/admin/institucion/requisitosdocente/update/' + id,
      data: formModal.serialize(),
      dataType: 'json',
      beforeSend: function () {},
      success: function (data) {
        if (data.status == true) {
          formModal.addClass('was-validated')
          notificaciontoast('info', data.mensaje, 'Éxito!')
          table.ajax.reload()
          $('#modalCreateUpdate').modal('hide')
          setTimeout(function () {
            document
              .getElementById('formModal')
              .classList.remove('was-validated')
            document.getElementById('formModal').reset()
            document
              .getElementById('btnCreateUpdate')
              .setAttribute('value', 'Registrar')
          }, 500)
        } else {
          notificaciontoast('error', data.mensaje, 'Error!')
        }
      },
      error: function (error) {
        console.log('Error', error)
      }
    })
  }

  function destroy(id) {
    $.ajax({
      headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
      type: 'DELETE',
      url: '/admin/institucion/requisitosdocente/destroy/' + id,
      beforeSend: function () {},
      success: function (data) {
        if (data.status == true) {
          notificaciontoast('info', data.mensaje, 'Éxito!')
          table.ajax.reload()
        } else {
          notificaciontoast('error', data.mensaje, 'Error!')
        }
      },
      error: function (error) {
        console.log('Error', error)
      }
    })
  }

  // LIMPIAR VALIDACIONES
  function clearCheck() {
    // recorrer todos los forms
    forms.each(function (index, form) {
      $(form).removeClass('was-validated') // remover validaciones
    })
  }

  // - - - - - - - - - - LIMPIAR CAMPOS - - - - - - - - - -
  function Clearform() {
    document.getElementById('txt-id').value = ''
    document.getElementById('txt-nombre').value = ''
  }
})
