"use strict";
import { notificaciontoast } from "../../common/method_toast.js";
import { confirmation_sweetAlert } from "../../common/method_sweetAlert.js";
import { getButtonsSchema, languageSchema } from "../../common/schemas.js";

$(document).ready(function () {
    const tableName = "Instituciones";
    var number = 0;
    // LISTAR DATATABLE
    var table = $("#datatableGeneral").DataTable({
        createdRow: function (row, data, index) {
            $(row).addClass("selected");
        },
        order: [],
        ajax: "/admin/institucion/instituciones/list",
        searching: true,
        dom: "Bfrtip",
        select: false,
        lengthChange: false,
        responsive: true,
        language: languageSchema,
        buttons: getButtonsSchema(tableName),
        columns: [
            { data: "id", className: "text-center" },
            { data: "name", className: "text-center" },
            { data: "direccion", className: "text-center" },
            { data: "contact_number", className: "text-center" },
            { data: "email", className: "text-center" },
            {
                data: "id",
                className: "text-center",
                sortable: false,
                render: function (data, type, all, meta) {
                    return `
                        <div class="d-flex justify-content-center">
                            <a href="javascript:void(0);" class="editBtn btn btn-warning shadow btn-xs sharp me-1"
                            data-id="${all.id}"
                            data-name="${all.name}"
                            data-direccion="${all.direccion}"
                            data-contact_number="${all.contact_number}"
                            data-email="${all.email}"
                            data-bs-placement="top"
                            title="Editar registro">
                            <i class="fas fa-pencil-alt"></i>
                            </a>

                            <a href="javascript:void(0);" class="deleteBtn btn btn-danger shadow btn-xs sharp"
                            data-id="${all.id}"
                            data-bs-placement="top"
                            title="Eliminar registro">
                            <i class="fas fa-trash"></i>
                            </a>
                        </div>
                    `;
                },
            },
        ],
    });

    // Agregar una columna de números automáticos
    table
        .on("order.dt search.dt", function () {
            table
                .column(0, { search: "applied", order: "applied" })
                .nodes()
                .each(function (cell, i) {
                    cell.innerHTML = i + 1;
                });
        })
        .draw();

    // - - - - - - - - - - M O D A L S - - - - - - - - - -
    // INICIO - MODAL CREATE
    $("#btnCreateModal").click(function () {
        document.getElementById("btnCreateUpdate").setAttribute("value", "Create");
        document.getElementById("btnCreateUpdate").innerHTML = "Guardar";
        document.getElementById("modalCreateUpdateLabel").innerHTML = "Registrar datos de la Insitución Externa";
        clearCheck();
        Clearform(); // <-- corregida abajo
    });
    // FIN - MODAL CREATE

    // INICIO - MODAL UPDATE
    $("#datatableGeneral tbody").on("click", ".editBtn", function (e) {
        clearCheck(); // borrar validaciones
        //cambiar el text del button
        document.getElementById("btnCreateUpdate").innerHTML = "Actualizar";
        document.getElementById("modalCreateUpdateLabel").innerHTML =
            "Actualizar datos de la Institución Externa";
        // setear data de cargo
        document.getElementById("txt-id").value = $(this).attr("data-id");
        document.getElementById("txt-name").value = $(this).attr("data-name");
        document.getElementById("txt-direccion").value = $(this).attr("data-direccion");   
        document.getElementById("txt-contact_number").value = $(this).attr("data-contact_number");
        document.getElementById("txt-email").value = $(this).attr("data-email");
        
        // show form
        $("#modalCreateUpdate").modal("show");
        // change value
        document
            .getElementById("btnCreateUpdate")
            .setAttribute("value", "Update");
    });
    // FIN - MODAL UPDATE

    var valbtn, formCheck;
    // INICIO - FUNCION CREATE O UPDATE
    $("#btnCreateUpdate").on("click", function (event) {
        event.preventDefault();
        formCheck = $("#formModal")[0];
        if (!formCheck.checkValidity()) {
            event.preventDefault();
            event.stopPropagation();
            $(formCheck).addClass("was-validated"); // añadir validaciones
        } else {
            // obtener valor del boton
            valbtn = $("#btnCreateUpdate").val();
            // FUNCION CREAR
            if (valbtn === "Create") {
                // insertar tabla cargo
                store();
            }
            // FUNCION ACTUALIZAR
            if (valbtn === "Update") {
                // actualizar tabla cargo
                update();
            }
        }
    });
    // FIN - FUNCION CREATE O UPDATE

    // INICIO - MODAL DELETE
    $("#datatableGeneral tbody").on("click", ".deleteBtn", function (e) {
        var id = $(this).attr("data-id");
        // confirmacion
        confirmation_sweetAlert(
            "Deseas continuar?",
            "Se procederá a eliminar el registro de la base de datos",
            "warning"
        ).then(function (isConfirm) {
            if (isConfirm.value) {
                // enviando el parametro de la data que se procede a delete
                destroy(id);
            } else {
                console.log("Cancelado");
            }
        });
    });

    var formModal;

    // - - - - - - - - - - F U N C I O N E S - - - - - - - - - -
    function store() {
        formModal = $("#formModal");
        $.ajax({
            type: "POST",
            url: "/admin/institucion/instituciones/store",
            data: formModal.serialize(),
            dataType: "json",
            beforeSend: function () { },
            success: function (data) {
                if (data.status == true) {
                    table.ajax.reload();
                    formModal.addClass("was-validated"); // añadir validaciones
                    notificaciontoast("info", data.mensaje, "Éxito!");
                    setTimeout(function () {
                        $("#modalCreateUpdate").modal("hide");
                    }, 1000); // ocultar despues de 1 sec
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    function update() {
        formModal = $("#formModal");
        var id = document.getElementById("txt-id").value;
        var formData = $("#formModal").serialize();
        $.ajax({
            type: "PUT",
            url: "/admin/institucion/instituciones/update/" + id,
            data: formData,
            dataType: "json",
            beforeSend: function () { },
            success: function (data) {
                if (data.status == true) {
                    table.ajax.reload();
                    formModal.addClass("was-validated"); // añadir validaciones
                    notificaciontoast("info", data.mensaje, "Éxito!");
                    setTimeout(function () {
                        $("#modalCreateUpdate").modal("hide");
                    }, 1000); // ocultar despues de 1 sec
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    function destroy(id) {
        $.ajax({
            headers: { "X-CSRF-TOKEN": $('input[name="_token"]').val() },
            type: "DELETE",
            url: "/admin/institucion/instituciones/destroy/" + id,
            beforeSend: function () { },
            success: function (data) {
                if (data.status == true) {
                    notificaciontoast("info", data.mensaje, "Éxito!");
                    table.ajax.reload();
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    // LIMPIAR VALIDACIONES
    function clearCheck() {
        formCheck = $("#formModal")[0];
        $(formCheck).removeClass("was-validated"); // remover validaciones
    }

    // - - - - - - - - - - LIMPIAR CAMPOS - - - - - - - - - -
    function Clearform() {
        document.getElementById("txt-id").value = "";
        $("#txt-name").val("");
        $("#txt-direccion").val("");
        $("#txt-contact_number").val("");
        $("#txt-email").val("");
    }
});
