/* =================================================================
 *  INSTITUCIÓN – INFO INSTITUCIONAL
 * =================================================================
 * 0.  IMPORTS
 * -------------------------------------------------------------- */
import { notificaciontoast } from "../../common/method_toast.js";
import { confirmation_sweetAlert } from "../../common/method_sweetAlert.js";
import { getButtonsSchema, languageSchema } from "../../common/schemas.js";

/* -------------------------------------------------------------- *
 * 1.  CONFIG / UTILS
 * -------------------------------------------------------------- */
const TOKEN = $('meta[name="csrf-token"]').attr('content');

/* -------------------------------------------------------------- *
 * 2.  API – LLAMADOS AL SERVIDOR
 * -------------------------------------------------------------- */
const InstitucionAPI = (() => {
    const ENDPOINTS = {
        list: '/admin/institucion/info_institucional/list',
        update: '/admin/institucion/info_institucional/update/1'
    };

    /* ---- GET ---- */
    const obtener = () =>
        $.ajax({
            url: ENDPOINTS.list,
            method: 'GET',
            dataType: 'json'
        });

    /* ---- PUT (vía POST + _method) ---- */
    const actualizar = (payload) =>
        $.ajax({
            url: ENDPOINTS.update,
            method: 'POST',
            data: payload,
            headers: { 'X-CSRF-TOKEN': TOKEN },
            processData: false,
            contentType: false,
            dataType: 'json'
        });

    return { obtener, actualizar };
})();

/* -------------------------------------------------------------- *
 * 3.  UI – INTERACCIÓN CON EL DOM
 * -------------------------------------------------------------- */
const UI = (() => {
    /* ---- Selectores re-utilizables ---- */
    const $nombre = $('#nombre');
    const $direccion = $('#direccion');
    const $contacto = $('#contacto');
    const $logoFile = $('#logoFile');
    const $logoPreview = $('#logoPreview');
    const $btnGuardar = $('#btnGuardarInfo');

    /* ---- Rellenar formulario ---- */
    const rellenar = (data) => {
        $nombre.val(data.nombre ?? '');
        $direccion.val(data.direccion ?? '');
        $contacto.val(data.contacto ?? '');

        if (data.logo_url) {
            $logoPreview.attr('src', data.logo_url).removeClass('d-none');
        } else {
            $logoPreview.addClass('d-none');
        }
    };

    /* ---- Leer formulario ---- */
    const leer = () => {
        const fd = new FormData();
        fd.append('_method', 'PUT');
        fd.append('nombre', $nombre.val().trim());
        fd.append('direccion', $direccion.val().trim());
        fd.append('contacto', $contacto.val().trim());

        const archivo = $logoFile[0].files[0];
        if (archivo) fd.append('logoFile', archivo);

        return fd;
    };

    /* ---- Actualizar preview del logo ---- */
    const actualizarPreview = (url) => {
        $logoPreview.attr('src', url + '?t=' + Date.now()).removeClass('d-none');
    };

    return { rellenar, leer, actualizarPreview, $btnGuardar };
})();

/* -------------------------------------------------------------- *
 * 4.  HANDLERS – LÓGICA DE LA PANTALLA
 * -------------------------------------------------------------- */
function cargarInfo() {
    InstitucionAPI.obtener()
        .done(UI.rellenar)
        .fail(() => toastr.error('No se pudieron cargar los datos institucionales'));
}

function guardarInfo() {
    const payload = UI.leer();

    InstitucionAPI.actualizar(payload)
        .done((res) => {
            toastr.success(res.message);
            if (res.logo_url) UI.actualizarPreview(res.logo_url);
        })
        .fail((xhr) => {
            if (xhr.status === 422) {
                const msg = Object.values(xhr.responseJSON.errors).join('<br>');
                toastr.error(msg);
            } else {
                toastr.error('Error al guardar');
            }
        });
}

/* -------------------------------------------------------------- *
 * 5.  INICIALIZACIÓN
 * -------------------------------------------------------------- */
$(() => {
    cargarInfo();
    UI.$btnGuardar.on('click', (e) => {
        e.preventDefault();
        guardarInfo();
    });
});
