"use strict";
import { notificaciontoast } from "../../common/method_toast.js";
import { confirmation_sweetAlert } from "../../common/method_sweetAlert.js";
import { getButtonsSchema, languageSchema } from "../../common/schemas.js";

$(document).ready(function () {
    const tableName = "convenios ";
    var number = 0;
    // LISTAR DATATABLE
    var table = $("#datatableGeneral").DataTable({
        createdRow: function (row, data, index) {
            $(row).addClass("selected");
        },
        order: [],
        ajax: "/admin/institucion/convenios/list",
        searching: true,
        dom: "Bfrtip",
        select: false,
        lengthChange: false,
        responsive: true,
        language: languageSchema,
        buttons: getButtonsSchema(tableName),
        columns: [
            { data: "idagreement", className: "text-center" },
            { data: "empresa", className: "text-center" },
            { data: "vigencia", className: "text-center" },
            // { data: "idagreement", sortable: false, className: "text-center",
            //     render: function (data, type, all, meta) {
            //         if (all.documento == null || all.documento == "--") {
            //             return `<div class="d-flex justify-content-center"> -- </div>`;
            //         } else {
            //             return `
            //             <div class="d-flex justify-content-center">
            //                 <a href="/verSilabo/${all.idagreement}" class="btn btn-info shadow btn-xs sharp me-1"
            //                 target="_blank"
            //                 data-bs-placement="top"
            //                 title="Ver Documento">
            //                 <i class="fas fa-file-lines fa-lg"></i>
            //                 </a>
            //             </div>
            //             `;
            //         }
            //     },
            // },
            { data: "descripcion", className: "text-center" },
            { data: "idagreement",
                className: "text-center",
                sortable: false,
                render: function (data, type, all, meta) {
                    return `
                        <div class="d-flex justify-content-center">
                            <a href="javascript:void(0);" class="editBtn btn btn-warning shadow btn-xs sharp me-1"
                            data-idagreement="${all.idagreement}"
                            data-idcompany="${all.idcompany}"
                            data-fecha_inicio="${all.fecha_inicio}"
                            data-fecha_fin="${all.fecha_fin}"
                            data-documento="${all.documento}"
                            data-descripcion="${all.descripcion}"
                            data-bs-placement="top"
                            title="Editar registro">
                            <i class="fas fa-pencil-alt"></i>
                            </a>
                            
                            <a href="javascript:void(0);" class="deleteBtn btn btn-danger shadow btn-xs sharp"
                            data-id="${all.id}"
                            data-bs-placement="top"
                            title="Eliminar registro">
                            <i class="fas fa-trash"></i>
                            </a>
                        </div>
                    `;
                },
            },
        ],
    });

    // Agregar una columna de números automáticos
    table.on("order.dt search.dt", function () {
            table.column(0, { search: "applied", order: "applied" }).nodes().each(function (cell, i) {cell.innerHTML = i + 1;});
    }).draw();


    cb_companies();
    function cb_companies() {
        let apenom;
        $("#txt-companies").find("option").remove().end() // delete options
        $.ajax({
            type: "GET",
            url: '/ajax_all/companies',
            dataType: 'json',
            beforeSend: function () { },
            success: function (response) {
                $("#txt-companies").append('<option selected disabled value="">Buscar empresa</option>+');
                response.forEach((elemento) => {
                    $("#txt-companies").append('<option' +
                        ' value="' + elemento.idcompany + '" ' +
                        ' data-subtext="' + elemento.ruc + '" ' +
                        ' data-idcompany="' + elemento.idcompany + '" ' +
                        ' data-nombre="' + elemento.nombre + '" ' +
                        ' data-direccion="' + elemento.direccion + '" ' +
                        ' data-nrocontacto="' + elemento.nrocontacto + '" ' +
                        ' data-ishabilitado="' + elemento.ishabilitado + '" ' +
                        ' data-user="' + elemento.user + '" ' +
                        ' data-logo="' + elemento.logo + '" ' +
                        '>' + elemento.nombre + '</option>');
                })
                $("#txt-companies").selectpicker("refresh");
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }


    // - - - - - - - - - - M O D A L S - - - - - - - - - -
    // INICIO - MODAL CREATE
    $("#btnCreateModal").click(function () {
        // change value
        document.getElementById("btnCreateUpdate").setAttribute("value", "Create");
        document.getElementById("btnCreateUpdate").innerHTML = "Guardar";
        document.getElementById("modalCreateUpdateLabel").innerHTML = "Registrar datos del convenio";
        clearCheck(); // borrar validaciones
        Clearform();
    });
    // FIN - MODAL CREATE

    // INICIO - MODAL UPDATE
    $("#datatableGeneral tbody").on("click", ".editBtn", function (e) {
        clearCheck(); // borrar validaciones
        //cambiar el text del button
        document.getElementById("btnCreateUpdate").innerHTML = "Actualizar";
        document.getElementById("modalCreateUpdateLabel").innerHTML ="Actualizar datos del convenio";
        // setear data de cargo
        $("#txt-idagreement").val($(this).attr("data-idagreement"));
        $("#txt-fecha_inicio").val($(this).attr("data-fecha_inicio"));
        $("#txt-fecha_fin").val($(this).attr("data-fecha_fin"));
        $("#txt-descripcion").val($(this).attr("data-descripcion"));
        $("#txt-companies").selectpicker("val", $(this).attr("data-idcompany"));
        // show form
        $("#modalCreateUpdate").modal("show");
        // change value
        document.getElementById("btnCreateUpdate").setAttribute("value", "Update");
    });
    // FIN - MODAL UPDATE

    var valbtn, formCheck;
    // INICIO - FUNCION CREATE O UPDATE
    $("#btnCreateUpdate").on("click", function (event) {
        event.preventDefault();
        formCheck = $("#formModal")[0];
        if (!formCheck.checkValidity()) {
            event.preventDefault();
            event.stopPropagation();
            $(formCheck).addClass("was-validated"); // añadir validaciones
        } else {
            // obtener valor del boton
            valbtn = $("#btnCreateUpdate").val();
            // FUNCION CREAR
            if (valbtn === "Create") {
                // insertar tabla cargo
                store();
            }
            // FUNCION ACTUALIZAR
            if (valbtn === "Update") {
                // actualizar tabla cargo
                update();
            }
        }
    });
    // FIN - FUNCION CREATE O UPDATE

    // INICIO - MODAL DELETE
    $("#datatableGeneral tbody").on("click", ".deleteBtn", function (e) {
        var id = $(this).attr("data-id");
        // confirmacion
        confirmation_sweetAlert(
            "Deseas continuar?",
            "Se procederá a eliminar el registro de la base de datos",
            "warning"
        ).then(function (isConfirm) {
            if (isConfirm.value) {
                // enviando el parametro de la data que se procede a delete
                destroy(id);
            } else {
                console.log("Cancelado");
            }
        });
    });

    var formModal;

    // - - - - - - - - - - F U N C I O N E S - - - - - - - - - -
    function store() {
        formModal = $("#formModal");
        $.ajax({
            type: "POST",
            url: "/admin/institucion/convenios/store",
            data: formModal.serialize(),
            dataType: "json",
            beforeSend: function () {},
            success: function (data) {
                if (data.status == true) {
                    table.ajax.reload();
                    formModal.addClass("was-validated"); // añadir validaciones
                    notificaciontoast("info", data.mensaje, "Éxito!");
                    setTimeout(function () {
                        $("#modalCreateUpdate").modal("hide");
                    }, 1000); // ocultar despues de 1 sec
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    function update() {
        formModal = $("#formModal");
        var id = document.getElementById("txt-idagreement").value;
        var formData = $("#formModal").serialize();
        $.ajax({
            type: "POST",
            url: "/admin/institucion/convenios/update/" + id,
            data: formData,
            dataType: "json",
            beforeSend: function () {},
            success: function (data) {
                if (data.status == true) {
                    table.ajax.reload();
                    formModal.addClass("was-validated"); // añadir validaciones
                    notificaciontoast("info", data.mensaje, "Éxito!");
                    setTimeout(function () {
                        $("#modalCreateUpdate").modal("hide");
                    }, 1000); // ocultar despues de 1 sec
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    function destroy(id) {
        $.ajax({
            headers: { "X-CSRF-TOKEN": $('input[name="_token"]').val() },
            type: "DELETE",
            url: "/admin/institucion/convenios/destroy/" + id,
            beforeSend: function () {},
            success: function (data) {
                if (data.status == true) {
                    notificaciontoast("info", data.mensaje, "Éxito!");
                    table.ajax.reload();
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    // LIMPIAR VALIDACIONES
    function clearCheck() {
        formCheck = $("#formModal")[0];
        $(formCheck).removeClass("was-validated"); // remover validaciones
    }

    // - - - - - - - - - - LIMPIAR CAMPOS - - - - - - - - - -
    function Clearform() {
        $("#txt-companies").selectpicker("val", "");
        document.getElementById("txt-idagreement").value = "";
        document.getElementById("txt-fecha_inicio").value = "";
        document.getElementById("txt-fecha_fin").value = "";
        document.getElementById("txt-descripcion").value = "";
    }
});
