import { notificaciontoast } from "../../common/method_toast.js";
import { confirmation_sweetAlert } from "../../common/method_sweetAlert.js";
import { getButtonsSchema, languageSchema } from "../../common/schemas.js";
import { tl_semesters } from "../../common/timeline/semesters.js";

$(document).ready(function () {
    const tableName = "Horarios ";

    var dt_idsemester = "null",
        dt_idplan = "null",
        dt_idperiod = "null",
        url = "/admin/horarios/asignar_horario/list";

    // LISTAR DATATABLE
    var table = $("#datatableGeneral").DataTable({
        createdRow: function (row, data, index) {
            $(row).addClass("selected");
        },
        order: [],
        ajax: {
            headers: { "X-CSRF-TOKEN": $('input[name="_token"]').val() },
            type: "POST",
            url: url,
            data: function (d) {
                d.idsemester = dt_idsemester;
                d.idperiod = dt_idperiod;
            },
        },
        searching: true,
        dom: "Bfrtip",
        select: false,
        lengthChange: false,
        responsive: true,
        language: languageSchema,
        buttons: getButtonsSchema(tableName),
        columns: [
            {   data: "periodo", className: "text-center", name: "primero",
                render: function (data, type, all, meta) {
                    return "<h6>" + all.programa + "</h6>" +
                        "" +
                        "<text>Plan: " + all.plan + "<br> Periodo: " + all.periodo + "</text>"
                },
            },
            {   data: "nombre", className: "text-center", name: "segundo",
                render: function (data, type, all, meta) {
                    return "<h6>" + all.nombre + "</h6>" +
                        "" +
                        "<text>Crd: " + all.creditos + ", Hrs: " + all.horas + ", Seccion: " + all.seccion + ", Turno: " + all.turno +"</text>"
                },
            },
            { data: "idasignatura", className: "text-center", name: "tercero",
                sortable: false,
                render: function (data, type, all, meta) {
                    return `
                    <div class="d-flex justify-content-center">
                        <a href="javascript:void(0);" class="createBtn btn btn-success shadow btn-xs sharp me-1"
                        data-idasignatura="${all.idasignatura}"
                        data-bs-placement="top"
                        title="Crear Horario">
                            <i class="fa-regular fa-clock fa-spin fa-xl"></i>
                        </a>
                    </div>
                    `;
                },
            },
            { data: "dia", className: "text-center" },
            { data: "horaini2", className: "text-center" },
            { data: "horafin2", className: "text-center" },
            { data: "duracion", className: "text-center" },
            { data: "numero", className: "text-center" },
            { data: "tipo", className: "text-center" },
            { data: "idhorario", className: "text-center",
                sortable: false,
                render: function (data, type, all, meta) {
                    if (all.idhorario != null) {
                        // <a href="javascript:void(0);" class="editBtn btn btn-warning shadow btn-xs sharp me-1"
                        //     data-idasignatura="${all.idasignatura}"
                        //     data-idhorario="${all.idhorario}"
                        //     data-dia="${all.dia}"
                        //     data-horaini="${all.horaini}"
                        //     data-horafin="${all.horafin}"
                        //     data-idaula="${all.idaula}"
                        //     data-bs-placement="top"
                        //     title="Editar registro">
                        //     <i class="fas fa-pencil-alt"></i>
                        // </a>
                        return `
                        <div class="d-flex justify-content-center">

                            <a href="#" class="deleteHorarioBtn btn btn-danger shadow btn-xs sharp"
                                data-idasignatura="${all.idasignatura}"
                                data-idhorario="${all.idhorario}"
                                data-bs-placement="top"
                                title="Eliminar registro">
                                <i class="fa-solid fa-x fa-fade fa-xl"></i>
                            </a>
                        </div>
                        `;
                    } else {
                        return `
                        <div class="d-flex justify-content-center">
                        </div>
                        `;
                    }
                },
            },
        ],
        rowsGroup: [
            "primero:name",
            "segundo:name",
            "tercero:name",
        ],
    });

    //--------- T I M E L I N E S   Y   F U N C I O N E S --------------//
    tl_programs();
    function tl_programs() {
        $.ajax({
            type: "GET",
            url: "/ajax_all/programs",
            dataType: "json",
            beforeSend: function () { },
            success: function (response) {
                response.forEach((elemento) => {
                    document.getElementById("tlprogram").innerHTML +=
                        "<li class=''>" +
                        "<div class='divprogram timeline-badge primary'></div>" +
                        "<a class='btnProgram timeline-panel text-muted px-2 py-1 mr-4 ml-2' href='javascript:void(0);' " +
                        "data-idprogram='" + elemento.id + "'" +
                        "data-codprograma='" + elemento.codprograma + "'" +
                        "data-nombre='" + elemento.nombre + "'" +
                        "data-nivel_formativo='" + elemento.nivel_formativo + "'" +
                        ">" +
                        "<h6 class='mb-0 fs-14'>" +
                        "<strong class='text-dark'>" + elemento.codprograma + "</strong>" + " <br> " + elemento.nombre +
                        "</h6>" +
                        "</a>" +
                        "</li>";
                });
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    // on change programas
    $(document).on("click", ".btnProgram", function () {
        let idprogram = $(this).attr("data-idprogram");
        $(".divprogram").removeClass("dark").addClass("primary");
        $(this).prev("div").removeClass("primary").addClass("dark");
        document.getElementById("tlplan").innerHTML = "";
        document.getElementById("tlperiod").innerHTML = "";
        tl_plans(idprogram);
    });

    // listar planes
    function tl_plans(idprogram) {
        document.getElementById("tlplan").innerHTML = "";
        $.ajax({
            type: "GET",
            url: "/ajax_all/plans/" + idprogram,
            dataType: "json",
            beforeSend: function () { },
            success: function (response) {
                response.forEach((elemento) => {
                    document.getElementById("tlplan").innerHTML +=
                        "<li class=''>" +
                        "<div class='divplan timeline-badge primary'></div>" +
                        "<a class='btnPlan timeline-panel text-muted px-2 py-1 mr-4 ml-2' href='javascript:void(0);' " +
                        "data-idplan='" + elemento.id + "'" +
                        "data-nombre='" + elemento.nombre + "'" +
                        "data-tipo='" + elemento.tipo + "'" +
                        "data-modalidad='" + elemento.modalidad + "'" +
                        "data-enfoque='" + elemento.enfoque + "'" +
                        ">" +
                        "<h6 class='mb-0 fs-14'>" + "<strong class='text-dark'>" + elemento.nombre + "</strong>" + " <br> " + elemento.tipo + "</h6>" +
                        "</a>" +
                        "</li>";
                });
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    // on change planes
    $(document).on("click", ".btnPlan", function () {
        dt_idplan = $(this).attr("data-idplan");
        $(".divplan").removeClass("dark").addClass("primary");
        $(this).prev("div").removeClass("primary").addClass("dark");
        tl_periods(dt_idsemester, dt_idplan);
    });

    // listar periodos por plan
    function tl_periods(idsemester, idplan) {
        document.getElementById("tlperiod").innerHTML = "";
        $.ajax({
            type: "GET",
            url: "/ajax_all/periods/" + idsemester + "/" + idplan,
            dataType: "json",
            beforeSend: function () { },
            success: function (response) {
                response.forEach((elemento) => {
                    document.getElementById("tlperiod").innerHTML +=
                        "<li class=''>" +
                        "<div class='divperiod timeline-badge primary'></div>" +
                        "<a class='btnPeriod timeline-panel text-muted px-2 py-1 mr-4 ml-2' href='javascript:void(0);' " +
                        "data-idperiod='" + elemento.id + "'" +
                        "data-numero='" + elemento.numero + "'" +
                        ">" +
                        "<h6 class='mb-0 fs-14'>" + "<strong class='text-dark'>" + elemento.numero + "</strong></h6>" +
                        "</a>" +
                        "</li>";
                });
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    // on change periodos
    $(document).on("click", ".btnPeriod", function () {
        dt_idperiod = $(this).attr("data-idperiod");
        $(".divperiod").removeClass("dark").addClass("primary");
        $(this).prev("div").removeClass("primary").addClass("dark");
        //info Toast
        notificaciontoast("info", "Consultando a la  base de datos!", "Mensaje!");
        table.ajax.reload();
    });


    // on change semester
    $(document).on("click", ".btnSemester", function () {
        dt_idsemester = $(this).attr("data-idsemester");
        $("#txt-idsemester").val(dt_idsemester);
        $(".divsemester").removeClass("dark").addClass("primary");
        $(this).prev("div").removeClass("primary").addClass("dark");

        //info Toast
        notificaciontoast("info", "Consultando a la  base de datos!", "Mensaje!");
        table.ajax.reload();
    });


    cb_classrooms()
    function cb_classrooms() {
        $.ajax({
            type: "GET",
            url: "/ajax_all/classrooms",
            dataType: "json",
            beforeSend: function () {},
            success: function (response) {
                    response.forEach((elemento) => {
                        $("#txt_idaula").append('<option ' +
                            'value="' + elemento.id + '"' +
                            'data-tipo="' + elemento.tipo + '"' +
                            ' >' + elemento.numero + ' - ' + elemento.tipo + '</option>');
                    })
                    $("#txt_idaula").selectpicker("refresh");
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

  $(document).on('click', '#btnGenerarClases', function () {
    const fecha = $('#data-fecha').val()
    const semanas = $('#data-semanas').val()

    // VALIDACIONES
    if (!fecha) {
      notificaciontoast('error', 'Seleccione una fecha válida.', 'Error!')
      return
    }

    if (!semanas || semanas <= 0 || !Number.isInteger(Number(semanas))) {
      notificaciontoast('error', 'Ingrese un número de semanas.', 'Error!')
      return
    }

    generar_clases(dt_idsemester, fecha, semanas)

    notificaciontoast('info', 'Generando clases...', 'Mensaje!')
  })

  $(document).on('click', '#btnEliminarClases', function () {
    if (!dt_idsemester || dt_idsemester === 'null') {
      notificaciontoast('error', 'Seleccione un semestre académico antes de eliminar las semanas.', 'Error!')
      return
    }

    // Confirmación con SweetAlert antes de eliminar
    confirmation_sweetAlert(
      '¿Deseas continuar?',
      'Se eliminarán todas las semanas generadas para el semestre seleccionado.',
      'warning'
    ).then(function (isConfirm) {
      if (isConfirm.value) {
        eliminar_clases(dt_idsemester)
        notificaciontoast('info', 'Eliminando semanas generadas...', 'Procesando')
      } else {
        console.log('Cancelado')
      }
    })
  })


    //----------A B R I R   M O D A L S   Y   F U N C I O N E S----------

    // INICIO - FUNCION CREATE HORARIO
        // $("#datatableGeneral tbody").on("click", ".createHorarioBtn", function (e) {
        //     // data
        //     document.getElementById("txt_idasignatura").value = $(this).attr("data-idasignatura");
        //     $("#modalCreateHorario").modal("show");
        // });
        // $("#btnCreateHorario").on("click", function (e) {
        //     store();
        // });
    // FIN - FUNCION CREATE HORARIO


    // INICIO - MODAL CREATE
    $("#datatableGeneral tbody").on("click", ".createBtn", function (e) {
        // change value
        document.getElementById("txt_idasignatura").value = $(this).attr("data-idasignatura");
        document.getElementById("btnCreateUpdate").setAttribute("value", "Create");
        document.getElementById("btnCreateUpdate").innerHTML = "Guardar";
        $("#modalCreateUpdate").modal("show");
        document.getElementById("modalCreateUpdateLabel").innerHTML = "Registrar datos del Horario";
        Clearform();
    });
    // FIN - MODAL CREATE

    $("#datatableGeneral tbody").on("click", ".editBtn", function (e) {
        //cambiar el text del button
        document.getElementById("btnCreateUpdate").innerHTML = "Actualizar";
        document.getElementById("modalCreateUpdateLabel").innerHTML = "Actualizar datos del Horario";
        // setear data de cargo
        document.getElementById("txt_idasignatura").value = $(this).attr("data-idasignatura");
        document.getElementById("txt_idhorario").value = $(this).attr("data-idhorario");
        $("#txt_dia").selectpicker("val", $(this).data("dia"));
        $("#txt_horaini").selectpicker("val", $(this).data("horaini"));
        $("#txt_horafin").selectpicker("val", $(this).data("horafin"));
        $("#txt_idaula").selectpicker("val", String($(this).data("idaula")));
        // show form
        $("#modalCreateUpdate").modal("show");
        // change value
        document.getElementById("btnCreateUpdate").setAttribute("value", "Update");
    });
    // FIN - MODAL UPDATE


    var valbtn, formCheck;
    // INICIO - FUNCION CREATE O UPDATE HORARIO
    $("#btnCreateUpdate").on("click", function (event) {
        event.preventDefault();
        formCheck = $("#formModal")[0];
        if (!formCheck.checkValidity()) {
            event.preventDefault();
            event.stopPropagation();
            $(formCheck).addClass('was-validated'); // añadir validaciones
        } else {
            // obtener valor del boton
            valbtn = $("#btnCreateUpdate").val()
            // FUNCION CREAR
            if (valbtn === "Create") {
                // insertar tabla cargo
                store();
            }
            // FUNCION ACTUALIZAR
            if (valbtn === "Update") {
                // actualizar tabla cargo
                update();
            }
        }
    });
    // FIN - FUNCION CREATE O UPDATE


    // INICIO - MODAL DELETE HORARIO
    $("#datatableGeneral tbody").on("click", ".deleteHorarioBtn", function (e) {
        // data
        var id = $(this).attr("data-idhorario");
        // confirmacion
        confirmation_sweetAlert("Deseas continuar?", "Se procederá a eliminar el registro de la base de datos", "warning"
        ).then(function (isConfirm) {
            if (isConfirm.value) {
                destroy(id);
            } else {
                console.log("Cancelado");
            }
        });
    });
    // FIN - MODAL DELETE HORARIO


    //----------E J E C U T A R   F U N C I O N E S----------
    function Clearform() {
        // document.getElementById("txt_idasignatura").value = "";
        // document.getElementById("txt_idhorario").value = "";
        $("#txt_dia").selectpicker("val", "0");
        $("#txt_horaini").selectpicker("val", "0");
        $("#txt_horafin").selectpicker("val", "0");
        $("#txt_idaula").selectpicker("val", "0");
    }

    // CREATE HORARIO
    function store() {
        var formData = $('#formModal').serialize();
        $.ajax({
            type: "POST",
            url: '/admin/horarios/asignar_horario/store',
            data: formData,
            dataType: 'json',
            beforeSend: function () { },
            success: function (data) {
                if (data.status == true) {
                    notificaciontoast("info", data.mensaje, "Éxito!");
                    table.ajax.reload();
                    $("#modalCreateUpdate").modal("hide");
                } else {
                    // notificaciontoast("error", data.mensaje.txt_id_name[0], "Error!");
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    var formModal;
    function update() {
        formModal = $('#formModal');
        var id = document.getElementById("txt_idhorario").value;
        var formData = $('#formModal').serialize();
        $.ajax({
            type: "PUT",
            url: '/admin/horarios/asignar_horario/update/' + id,
            data: formData,
            dataType: 'json',
            beforeSend: function () { },
            success: function (data) {
                if (data.status == true) {
                    table.ajax.reload();
                    formModal.addClass("was-validated");    // añadir validaciones
                    notificaciontoast("info", data.mensaje, "Éxito!");
                    setTimeout(function () { $("#modalCreateUpdate").modal("hide"); }, 1000);   // ocultar despues de 1 sec
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    // DELETE HORARIO
    function destroy(id) {
        $.ajax({
            headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
            type: "DELETE",
            url: '/admin/horarios/asignar_horario/destroy/' + id,
            beforeSend: function () { },
            success: function (data) {
                if (data.status == true) {
                    notificaciontoast("info", data.mensaje, "Éxito!");
                    table.ajax.reload();
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    // GENERAR HORARIO
    function generar_clases(idsemester, fecha, semanas) {
      $.ajax({
        type: 'POST',
        url: '/admin/horarios/horario_general/generar_clases/' + idsemester + '/' + fecha,
        data: {
            semanas: semanas,
            _token: $('meta[name="csrf-token"]').attr('content')
        },
        dataType: 'json',
        beforeSend: function () {},
        success: function (data) {
          if (data.status == true) {
            notificaciontoast('info', data.mensaje, 'Éxito!')
          } else {
            notificaciontoast('error', data.mensaje, 'Error!')
          }
        },
        error: function (error) {
          console.log('Error', error)
        }
      })
    }

  // ELIMINAR HORARIO (todas las semanas generadas)
  function eliminar_clases(idsemester) {
    $.ajax({
      type: 'POST',
      url: '/admin/horarios/horario_general/eliminar_clases/' + idsemester,
      data: {
        _token: $('meta[name="csrf-token"]').attr('content')
      },
      dataType: 'json',
      beforeSend: function () {},
      success: function (data) {
        if (data.status == true) {
          notificaciontoast('info', data.mensaje, 'Éxito!')
        } else {
          notificaciontoast('error', data.mensaje, 'Error!')
        }
      },
      error: function (error) {
        console.log('Error', error)
      }
    })
  }
});
