//"use strict";
import { notificaciontoast } from "../../common/method_toast.js";
import { confirmation_sweetAlert } from "../../common/method_sweetAlert.js";
import { getButtonsSchema, languageSchema } from "../../common/schemas.js";
import { tl_semesters } from "../../common/timeline/semesters.js";

$(document).ready(function () {
    const tableName = "General de Horarios ";
    var programa = "null";
    var plan = "null";
    var semester = "null";
    var estudiante = "null";
    var dt_idsemester = "null",
        dt_idstudent = "null", dt_idplan = "0";

    // LISTAR DATATABLE
    var table = $("#datatableGeneral").DataTable({
        createdRow: function (row, data, index) {
            $(row).addClass("selected");
        },
        order: [],
        ajax: {
            headers: { "X-CSRF-TOKEN": $('input[name="_token"]').val() },
            type: "POST",
            url: "/admin/horarios/horario_estudiante/list",
            beforeSend: function () {
                notificaciontoast("info", "Consultando a la  base de datos!", "Mensaje!");
            },
            data: function (d) {
                d.idsemester = dt_idsemester;
                d.idstudent = dt_idstudent;
            },
        },
        searching: true,
        dom: "Bfrtip",
        select: false,
        lengthChange: false,
        responsive: true,
        language: languageSchema,
        buttons: getButtonsSchema(tableName),
        columns: [
            { data: "codcurso", className: "text-center bg-primary" },
            { data: "curso", className: "text-center bg-primary" },
            { data: "turno", className: "text-center bg-primary" },
            { data: "seccion", className: "text-center bg-primary" },
            { data: "periodo", className: "text-center bg-primary" },
            { data: "Lunes", className: "text-center bg-success" },
            { data: "Martes", className: "text-center bg-success" },
            { data: "Miercoles", className: "text-center bg-success" },
            { data: "Jueves", className: "text-center bg-success" },
            { data: "Viernes", className: "text-center bg-success" },
            { data: "Sabado", className: "text-center bg-success" },
            { data: "docente", className: "text-center bg-primary" },
            { data: "aula", className: "text-center bg-primary" },
        ],
    });

    //---------T I M E L I N E S   Y   F U N C I O N E S--------------//
    tl_programs();
    function tl_programs() {
        $.ajax({
            type: "GET",
            url: "/ajax_all/programs",
            dataType: "json",
            beforeSend: function () { },
            success: function (response) {
                response.forEach((elemento) => {
                    document.getElementById("tlprogram").innerHTML +=
                        "<li class=''>" +
                        "<div class='divprogram timeline-badge primary'></div>" +
                        "<a class='btnProgram timeline-panel text-muted px-2 py-1 mr-4 ml-2' href='javascript:void(0);' " +
                        "data-idprogram='" +
                        elemento.id +
                        "'" +
                        "data-codprograma='" +
                        elemento.codprograma +
                        "'" +
                        "data-nombre='" +
                        elemento.nombre +
                        "'" +
                        "data-nivel_formativo='" +
                        elemento.nivel_formativo +
                        "'" +
                        ">" +
                        "<h6 class='mb-0 fs-14'>" +
                        "<strong class='text-dark'>" +
                        elemento.codprograma +
                        "</strong>" +
                        " <br> " +
                        elemento.nombre +
                        "</h6>" +
                        "   </a>" +
                        "</li>";
                });
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    // on change programas
    $(document).on("click", ".btnProgram", function () {
        let idprogram = $(this).attr("data-idprogram");
        programa = $(this).attr("data-nombre");
        $(".divprogram").removeClass("dark").addClass("primary");
        $(this).prev("div").removeClass("primary").addClass("dark");
        tl_plans(idprogram);
    });

    // listar planes
    function tl_plans(idprogram) {
        document.getElementById("tlplan").innerHTML = "";
        $.ajax({
            type: "GET",
            url: "/ajax_all/plans/" + idprogram,
            dataType: "json",
            beforeSend: function () { },
            success: function (response) {
                response.forEach((elemento) => {
                    document.getElementById("tlplan").innerHTML +=
                        "<li class=''>" +
                        "<div class='divplan timeline-badge primary'></div>" +
                        "<a class='btnPlan timeline-panel text-muted px-2 py-1 mr-4 ml-2' href='javascript:void(0);' " +
                        "data-idplan='" +
                        elemento.id +
                        "'" +
                        "data-nombre='" +
                        elemento.nombre +
                        "'" +
                        "data-tipo='" +
                        elemento.tipo +
                        "'" +
                        "data-modalidad='" +
                        elemento.modalidad +
                        "'" +
                        "data-enfoque='" +
                        elemento.enfoque +
                        "'" +
                        ">" +
                        "<h6 class='mb-0 fs-14'>" +
                        "<strong class='text-dark'>" +
                        elemento.nombre +
                        "</strong><br> " +
                        elemento.tipo +
                        "</h6>" +
                        "</a>" +
                        "</li>";
                });
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    // on change planes
    $(document).on("click", ".btnPlan", function () {
        dt_idplan = $(this).attr("data-idplan");
        plan = $(this).attr("data-nombre");
        $(".divplan").removeClass("dark").addClass("primary");
        $(this).prev("div").removeClass("primary").addClass("dark");
        cb_students(dt_idplan);
    });

    function cb_students(idplan) {
        let apenom;
        $("#txt-students").find("option").remove().end() // delete options
        $.ajax({
            type: "GET",
            url: '/ajax_all/students/' + idplan,
            data: {
                idsemester: dt_idsemester,
            },
            dataType: 'json',
            beforeSend: function () { },
            success: function (response) {
                $("#txt-students").append('<option selected disabled value="">Buscar estudiante</option>');
                response.forEach((elemento) => {
                    apenom = elemento.apellido_pa + " " + elemento.apellido_ma + ", " + elemento.nombres;
                    $("#txt-students").append('<option' +
                        ' value="' + elemento.idstudent + '" ' +
                        ' data-idstudent="' + elemento.idstudent + '" ' +
                        ' data-apellido_pa="' + elemento.apellido_pa + '" ' +
                        ' data-apellido_ma="' + elemento.apellido_ma + '" ' +
                        ' data-nombres="' + elemento.nombres + '" ' +
                        ' data-nroidenti="' + elemento.nroidenti + '" ' +
                        ' data-celular="' + elemento.celular + '" ' +
                        ' data-anho_ingreso="' + elemento.anho_ingreso + '" ' +
                        ' data-estado="' + elemento.estado + '" ' +
                        '>' + apenom + '</option>');
                })
                $("#txt-students").selectpicker("refresh");
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    // on change programas
    $("#txt-students").on('change', function () {
        // insertar info en card
        dt_idstudent = $(this).val();
        //info Toast
        notificaciontoast("info", "Consultando a la  base de datos!", "Mensaje!");
        table.ajax.reload();
    });

    // on change semester
    $(document).on("click", ".btnSemester", function () {
        dt_idsemester = $(this).attr("data-idsemester");
        semester = $(this).attr("data-anho");
        console.log(semester);
        $(".divsemester").removeClass("dark").addClass("primary");
        $(this).prev("div").removeClass("primary").addClass("dark");
        //info Toast
        notificaciontoast("info", "Consultando a la  base de datos!", "Mensaje!");
        table.ajax.reload();
        cb_students(dt_idplan);
    });
});
