//"use strict";
import { notificaciontoast } from "../../common/method_toast.js";
import { confirmation_sweetAlert } from "../../common/method_sweetAlert.js";
import { getButtonsSchema, languageSchema } from "../../common/schemas.js";
import { tl_semesters } from "../../common/timeline/semesters.js";

$(document).ready(function () {
    const tableName = "Reporte de Horarios ";
    var teacher = "null";
    var semester = "null";
    var dt_idsemester = "null", dt_idteacher = "null";
    
    // LISTAR DATATABLE
    var table = $("#datatableGeneral").DataTable({
        createdRow: function (row, data, index) {
            $(row).addClass("selected");
        },
        order: [],
        ajax: {
            headers: { "X-CSRF-TOKEN": $('input[name="_token"]').val() },
            type: "POST",
            url: "/admin/horarios/horario_docente/list",
            data: function (d) {
                d.idsemester = dt_idsemester;
                d.idteacher = dt_idteacher;
            },
        },
        searching: true,
        dom: "Bfrtip",
        select: false,
        lengthChange: false,
        responsive: true,
        language: languageSchema,
        buttons: getButtonsSchema(tableName),
        columns: [
            { data: "programa", className: "text-center" },
            { data: "plan", className: "text-center" },
            // { data: "codcurso", className: "text-center" },
            // { data: "curso", className: "text-center" },
            {
                data: "curso", className: "text-center",
                render: function (data, type, all, meta) {
                    return all.codcurso + " - " + all.curso
                },
            },
            // { data: "turno", className: "text-center" },
            { data: "seccion", className: "text-center" },
            // { data: "creditos", className: "text-center" },
            // { data: "horas", className: "text-center" },
            { data: "periodo", className: "text-center" },
            { data: "Lunes", className: "text-center" },
            { data: "Martes", className: "text-center" },
            { data: "Miercoles", className: "text-center" },
            { data: "Jueves", className: "text-center" },
            { data: "Viernes", className: "text-center" },
            { data: "Sabado", className: "text-center" },
            { data: "aula", className: "text-center" },
        ],
    });

    // on change semester
    $(document).on("click", ".btnSemester", function () {
        dt_idsemester = $(this).attr("data-idsemester");
        semester = $(this).attr("data-anho");
        $(".divsemester").removeClass("dark").addClass("primary");
        $(this).prev("div").removeClass("primary").addClass("dark");
        //info Toast
        notificaciontoast("info", "Consultando a la  base de datos!", "Mensaje!");
        table.ajax.reload();
    });

    tl_teachers();
    function tl_teachers() {
        $.ajax({
            type: "GET",
            url: '/ajax_all/teachers',
            dataType: 'json',
            beforeSend: function () { },
            success: function (response) {
                document.getElementById("tlteacher").innerHTML = "";
                response.forEach((elemento) => {
                    let apenom = elemento.apellido_pa + " " + elemento.apellido_ma + ", " + elemento.nombres;
                    document.getElementById("tlteacher").innerHTML +=
                        "<li class=''>" +
                        "<div class='divteacher timeline-badge primary'></div>" +
                        "<a class='btnTeacher timeline-panel text-muted px-2 py-1 mr-4 ml-2' href='javascript:void(0);' " +
                        "data-idteacher='" + elemento.idteacher + "'" +
                        "data-nroidenti='" + elemento.nroidenti + "'" +
                        "data-nombre='" + elemento.apellido_pa + " " + elemento.apellido_ma + ", " + elemento.nombres + "'" +
                        "data-tipocontrato='" + elemento.tipocontrato + "'" +
                        "data-horas_lectivas='" + elemento.horas_lectivas + "'" +
                        ">" +
                        "<h6 class='mb-0 fs-14'>" + "<strong class='text-dark'>" + apenom + "</strong> <br>" + elemento.nroidenti +
                        "</h6>" +
                        "</a>" +
                        "</li>";
                });
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    // on change teacher
    $(document).on("click", ".btnTeacher", function () {
        dt_idteacher = $(this).attr("data-idteacher");
        teacher = $(this).attr("data-nombre");
        $(".divteacher").removeClass("dark").addClass("primary");
        $(this).prev("div").removeClass("primary").addClass("dark");
        //info Toast
        notificaciontoast("info", "Consultando a la  base de datos!", "Mensaje!");
        table.ajax.reload();
    });

    var formCheck, formModal;

    // on change teachers
    $("#txt-teachers").on('change', function () {
        // setear idteacher
        dt_idteacher = $(this).val();
        $('#txt-idteacher').val(dt_idteacher);
        table.ajax.reload();
    });

    // on change teachers
    $("#txt-semesters").on('change', function () {
        // setear idteacher
        dt_idsemester = $(this).val();
        $('#txt-idsemester').val(dt_idsemester);
        table.ajax.reload();
    });

});
