import { notificaciontoast } from "../../common/method_toast.js";
import { confirmation_sweetAlert } from "../../common/method_sweetAlert.js";
import { getButtonsSchema, languageSchema } from "../../common/schemas.js";

$(document).ready(function () {
    
    const tableName = "Estudiantes";
    var dt_idplan = "0";
    
    // LISTAR DATATABLE estudiantes
    var table_estudiantes = $('#datatableGeneral_estudiantes').DataTable({
        createdRow: function (row, data, index) {
            $(row).addClass("selected");
        },
        order: [],
        ajax: {
            headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
            type: 'POST',
            url: '/admin/bolsa_laboral/situacion_estudiante/list_estudiantes',
            data: function (d) {
                d.idplan = dt_idplan;
            },
        },
        searching: true,
        dom: "Bfrtip",
        select: false,
        pageLength: 10,
        lengthChange: false,
        responsive: true,
        language: languageSchema,
        buttons: getButtonsSchema(tableName),
        columns: [
            { data: 'n', className: 'text-center', },
            { data: "identificacion", className: "text-center",
                render: function (data, type, all, meta) {
                    return all.nroidenti;
                },
            },
            { data: "estudiante", className: "text-center", },
            { data: "plan", className: "text-center", },
            { data: "accion", className: "text-center", sortable: false,
                render: function (data, type, all, meta) {
                    return `
                            <div class="d-flex justify-content-center">
                                <a href="javascript:void(0);" class="btnVerRecordAcademico btn btn-info shadow btn-xs sharp me-2"
                                    data-idstudent="${all.idstudent}"
                                    data-bs-placement="top"
                                    title="Ver Record Académico">
                                    <i class="fas fa-eye fa-lg"></i>
                                </a>
                                
                                <a href="javascript:void(0);" class="btnCambiarEstado btn btn-info shadow btn-xs sharp"
                                    data-idstudent="${all.idstudent}"
                                    data-estudiante="${all.estudiante}"
                                    data-ididentificationtype="${all.ididentificationtype}"
                                    data-tipoidenti="${all.tipoidenti}"
                                    data-nroidenti="${all.nroidenti}"
                                    data-bs-placement="top"
                                    title="Cambiar estado">
                                    <i class="fa-solid fa-user-graduate fa-xl"></i>
                                </a>
                            </div>
                            `;
                },
            },
        ],
    });

    // Agregar una columna de números automáticos
    table_estudiantes.on('order.dt search.dt', function () {
        table_estudiantes.column(0, { search: 'applied', order: 'applied' }).nodes().each(function (cell, i) {
            cell.innerHTML = i + 1;
        });
    }).draw();

    const tableName_egresados = "Egresados";

    // LISTAR DATATABLE estudiantes
    var table_egresados = $('#datatableGeneral_egresados').DataTable({
        createdRow: function (row, data, index) {
            $(row).addClass("selected");
        },
        order: [],
        ajax: {
            headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
            type: 'POST',
            url: '/admin/bolsa_laboral/situacion_estudiante/list_egresados',
            data: function (d) {
                d.idplan = dt_idplan;
            },
        },
        searching: true,
        dom: "Bfrtip",
        select: false,
        lengthChange: false,
        pageLength: 10,
        responsive: true,
        language: languageSchema,
        buttons: getButtonsSchema(tableName_egresados),
        columns: [
            { data: 'n', className: 'text-center', },
            { data: "identificacion", className: "text-center",
                render: function (data, type, all, meta) {
                    return all.nroidenti;
                },
            },
            { data: "estudiante", className: "text-center", },
            { data: "plan", className: "text-center", },
            { data: "accion", className: "text-center", sortable: false,
                render: function (data, type, all, meta) {
                    return `
                        <div class="d-flex justify-content-center">
                            <a href="javascript:void(0);" class="btnVerRecordAcademico btn btn-info shadow btn-xs sharp me-2"
                                data-idstudent="${all.idstudent}"
                                data-bs-placement="top"
                                title="Ver Record Académico">
                                <i class="fas fa-eye fa-lg"></i>
                            </a>
                            
                            <a href="/ficha_socioeconomica" target="_blank" class="btn btn-warning shadow btn-xs sharp me-2"
                                data-idstudent="${all.idstudent}"
                                data-bs-placement="top"
                                title="Registrar ficha socioeconómica">
                                <i class="fas fa-sign-in-alt fa-fade fa-xl"></i>
                            </a>
                            
                            <a href="javascript:void(0);" class="btnInfoFicha btn btn-info shadow btn-xs sharp"
                                data-idstudent="${all.idstudent}"
                                data-bs-placement="top"
                                title="Ver Ficha Socioeconómica">
                                <i class="fas fa-id-card fa-lg"></i>
                            </a>
                        </div>
                    `;
                },
            },
        ],
    });

    // RECORD ACADEMICO - INICIO

    var dt_idStudent = 0;

    let tableRecordAcademico=$("#datatableGeneralRecordAcademico").DataTable({
        createdRow: function (row, data, index) {
            $(row).addClass("selected");
        },
        order: [],
        ajax: {
            headers: { "X-CSRF-TOKEN": $('input[name="_token"]').val() },
            type: "POST",
            url: "/admin/seguimiento_egresado/record_academico/list",
            data: function (d) {
                d.idStudent = dt_idStudent;
            },
        },
        searching: false,
        paging: true, // Deshabilita la paginación
        info: false, // Oculta la información de entradas
        pageLength: 80, // 12 filas
        select: false,
        lengthChange: false,
        responsive: true,
        language: languageSchema,
        columns: [
            { data: "numero_modulo", className: "text-center", name: "primero",
                render: function (data, type, all, meta) {
                    return `<div style='white-space: pre-wrap; word-wrap: break-word; word-break: break-word; width: 150px;'>
                                <h5>Modulo Formativo ${all.numero_modulo}</h5>
                                <!-- <b>Codigo Modular:</b> ${all.codigo_modulo}<br> -->
                                <b>Descripcion:</b> ${all.descripcion_modulo}
                            </div>
                            `;
                },
            },
            { data: "periodo", className: "text-center", name: "segundo",
                render: function (data, type, all, meta) {
                    return "<div>" +
                    "<h4>" + all.periodo + "</h4>" +
                    "</div>";
                },
            },
            { data: "codcurso", className: "text-center" },
            { data: "nombre_curso", className: "text-center" },
            { data: "creditos", className: "text-center" },
            { data: "horas", className: "text-center" },
            // { data: "seccion", className: "text-center" },
            // { data: "turno", className: "text-center" },
            { data: "semestre", className: "text-center" },
            { data: "promedio_final", className: "text-center",
                render: function (data, type, all, meta) {
                    return all.promedio_final ?? '--';
                },
            },
            { data: "estado", className: "text-center" },
        ],
        rowsGroup: [
            'primero:name',
            'segundo:name',
        ],
    });

    // INICIO - MODAL
    $("tbody").on("click", ".btnVerRecordAcademico", function (e) {
        // setear data de idstudent
        const idStudent = $(this).data("idstudent")
        dt_idStudent = idStudent
        // cargar tabla
        tableRecordAcademico.ajax.reload();
        
        // show form
        setTimeout(function () { $("#modalRecordAcademico").modal("show"); }, 500); // mostrar despues de x sec
    });
    // FIN - MODAL

    // RECORD ACADEMICO - FIN


    // FICHA SOCIOECONOMICA - INICIO
    $("tbody").on("click", ".btnInfoFicha", function (e) {
        // setear data de idstudent
        const idStudent = $(this).data("idstudent")
        dt_idStudent = idStudent
        // cargar tabla
        // tableRecordAcademico.ajax.reload();
        
        // show form
        setTimeout(function () { $("#modalFichaSocioeconomica").modal("show"); }, 500); // mostrar despues de x sec
    });
    // FICHA SOCIOECONOMICA - FIN


    cb_programs();
    function cb_programs() {
        $("#txt-programs").find("option").remove().end() // delete options
        $.ajax({
            type: "GET",
            url: '/ajax_all/programs',
            dataType: 'json',
            beforeSend: function () { },
            success: function (response) {
                $("#txt-programs").append('<option selected disabled value="">Seleccione programa</option>');
                response.forEach((elemento) => {
                    $("#txt-programs").append('<option ' +
                        'value="' + elemento.id + '"' +
                        'data-codprograma="' + elemento.codprograma + '"' +
                        'data-nombre="' + elemento.nombre + '"' +
                        'data-nivel_formativo="' + elemento.nivel_formativo + '"' +
                        ' >' + elemento.nombre + '</option>');
                })
                $("#txt-programs").selectpicker("refresh");
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    // INICIO - SELECCIONAR PROGRAMA
    $(document).on("change", "#txt-programs", function (e) {
        cb_plans($(this).val());
    });
    // FIN - SELECCIONAR PROGRAMA

    function cb_plans(idprogram) {
        $("#txt-plans").find("option").remove().end() // delete options
        $.ajax({
            type: "GET",
            url: '/ajax_all/plans/' + idprogram,
            dataType: 'json',
            beforeSend: function () { },
            success: function (response) {
                $("#txt-plans").append('<option selected disabled value="">Seleccione plan</option>');
                response.forEach((elemento) => {
                    $("#txt-plans").append('<option ' +
                        ' value="' + elemento.id + '"' +
                        ' data-nombre="' + elemento.nombre + '"' +
                        ' data-tipo="' + elemento.tipo + '"' +
                        ' data-modalidad="' + elemento.modalidad + '"' +
                        ' data-enfoque="' + elemento.enfoque + '"' +
                        ' >' + elemento.nombre + " - " + elemento.tipo + '</option>');
                })
                $("#txt-plans").selectpicker("refresh");
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    // INICIO - SELECCIONAR PLAN
    $(document).on("change", "#txt-plans", function (e) {
        dt_idplan = ($(this).val());
        //Info toast
        notificaciontoast("info", "Consultando a la  base de datos!", "Mensaje!");
        // CARGAR TABLA
        table_estudiantes.ajax.reload();
        table_egresados.ajax.reload();
    });
    // FIN - SELECCIONAR PLAN


    var valbtn, formCheck, formModal;

    // INICIO - MODAL DESMATRICULAR
    $("#datatableGeneral_estudiantes tbody").on("click", ".btnCambiarEstado", function (e) {
        let idstudent = $(this).data("idstudent");
        let mensaje = 'Se procederá a cambiar el estado del estudiante"' + $(this).data('estudiante')
            + '" identificado con "' + $(this).data('tipoidenti') + ' ' + $(this).data('nroidenti') + '" a EGRESADO';
        // confirmacion
        confirmation_sweetAlert("Deseas continuar?", mensaje, "success")
            .then(function (isConfirm) {
                if (isConfirm.value) {
                    update_student(idstudent);
                } else {
                    console.log("Cancelado");
                }
            });
    });

    $(document).on("click", "#btnReporteEgresados", function () {
        $("#modalpreload").modal("show");
        document.getElementById('div_progressbar_modal_preload').innerHTML =
        ` <div class="drive-content mt-2 mx-2 p-1">
            <div class="progress default-progress">
                <div class="progress-bar bg-vigit progress-animated bg-info" style="width: 100%; height:100%;" role="progressbar">
                    <span id="txt_title_progressbar">CARGANDO</span>
                </div>
            </div>
        </div>`
        setTimeout(function () {
            $("#modalpreload").modal("hide");
        }, 2000);
        setTimeout(function () {
            window.open('/reportes/list_egresados/'+dt_idplan, '_blank');
        }, 2000);
    });


    let idstudent
    $("#datatableGeneral_egresados").on("click",".btnegresado", function (event) {
        // change value
        idstudent = $(this).data("idstudent");
        console.log(idstudent);
        $("#btnCreateUpdate").attr("value", "Create");
        $("#btnCreateUpdate").html("Registrar");
        // mostrar contraseña
        $("#div_txt_password").removeAttr("style");
        clearCheck();
        clearForm();
        $("#modalCreateUpdate").modal("show");
    });

    // LIMPIAR VALIDACIONES  ************************* LISTO
    function clearCheck() {
        formCheck = $("#formModal")[0];
        $(formCheck).removeClass("was-validated"); // remover validaciones
    }


    // INICIO - FUNCION CREATE EGRESADO
    $("#btnCreateUpdate").on("click", function (event) {
        event.preventDefault();
        // Iterar sobre los formularios y evitar la acción predeterminada si no son válidos

        $("#txt_idstudent").val(idstudent);
        console.log(idstudent);
        formCheck = $("#formModal")[0];
        if (!formCheck.checkValidity()) {
            event.preventDefault();
            event.stopPropagation();
        } else {
            valbtn = $("#btnCreateUpdate").val();
            // FUNCION CREAR
            if (valbtn === "Create") {
                // insertar
                store_egresado();
            }
        }
        $(formCheck).addClass('was-validated'); // añadir validaciones
    });
    // FIN - FUNCION CREATE EGRESADO

    // INICIO - FUNCION CREATE TITULADO
    $("#datatableGeneral_estudiantes tbody").on("click", ".btnCambiarEstado2", function (e) {
        let idstudent = $(this).data("idstudent");
        let mensaje = 'Se procederá a cambiar el estado del egresado "' + $(this).data('estudiante')
            + '" identificado con "' + $(this).data('tipoidenti') + ' ' + $(this).data('nroidenti') + '" a TITULADO';
        // confirmacion
        confirmation_sweetAlert("Deseas continuar?", mensaje, "success")
            .then(function (isConfirm) {
                if (isConfirm.value) {
                    update_student(idstudent);
                } else {
                    console.log("Cancelado");
                }
            });
    });
    // FIN - FUNCION CREATE TITULADO

    $(document).on("click", "#btnRecordNotas", function () {
        setTimeout(function () {
            window.open('/reportes/record_notas/'+ dt_idStudent, '_blank');
        }, 2000);
    });

    // LIMPIAR FORMULARIO ************************* LISTO
    function clearForm() {
        $("#txt_estadocivil").selectpicker("");
        $("#txt_nrohijos").val("");
        $("#txt_ingresomensual").val("");
        $("#txt_ocupacion").val("");
        $("#txt_emopresas").selectpicker("");
        $("#txt_tipovivienda").val("");
        $("#txt_gastosmensuales").val("");
    }

    function update_student(idstudent) {
        formModal = $('#formModal');
        $.ajax({
            headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
            type: 'PUT',
            url: '/admin/bolsa_laboral/situacion_estudiante/update_estudiante/' + idstudent,
            data: formModal.serialize(),
            dataType: 'json',
            beforeSend: function () { },
            success: function (data) {
                if (data.status == true) {
                    table_estudiantes.ajax.reload();
                    table_egresados.ajax.reload();
                    setTimeout(function () {
                        notificaciontoast("info", data.mensaje, "Éxito!");
                        $("#modalCreateUpdate").modal("hide");
                    }, 1000);   // ocultar despues de 1 sec
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                    $("#modalCreateUpdate").modal("hide");
                }
            },
            error: function (error) {
                console.log('Error', error);
                $("#modalCreateUpdate").modal("hide");
            }
        })
    }

    function update_egresado(idstudent) {
        formModal = $('#formModal');
        $.ajax({
            headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
            type: 'PUT',
            url: '/admin/bolsa_laboral/situacion_estudiante/update_egresado/' + idstudent,
            data: formModal.serialize(),
            dataType: 'json',
            beforeSend: function () { },
            success: function (data) {
                if (data.status == true) {
                    table_egresados.ajax.reload();
                    setTimeout(function () {
                        notificaciontoast("info", data.mensaje, "Éxito!");
                        $("#modalCreateUpdate").modal("hide");
                    }, 1000);   // ocultar despues de 1 sec
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
            error: function (error) {
                console.log('Error', error)
            }
        })
    }

    function store_egresado() {
        formModal = $('#formModal');
        $.ajax({
            type: "POST",
            url: '/admin/bolsa_laboral/situacion_estudiante/store_egresado',
            data: formModal.serialize(),
            dataType: 'json',
            beforeSend: function () { },
            success: function (data) {
                if (data.status == true) {
                    setTimeout(function () {
                        notificaciontoast("info", data.mensaje, "Éxito!");
                        $("#modalCreateUpdate").modal("hide");
                    }, 1000); // ocultar despues de 1 sec
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

});
