import { notificaciontoast } from "../../common/method_toast.js";
import { confirmation_sweetAlert } from "../../common/method_sweetAlert.js";
import { getButtonsSchema, languageSchema } from "../../common/schemas.js";
import { cb_provincias, cb_distritos, ubigeo_for_update, vaciar_distritos, vaciar_provincias } from "../../common/combobox/ubigeo.js";

$(document).ready(function () {

    var dt_idplan;
    const tableName = "Estudiantes";

    // LISTAR DATATABLE ************************* LISTO
    var table = $("#datatableGeneral").DataTable({
        createdRow: function (row, data, index) {
            $(row).addClass("selected");
        },
        order: [],
        ajax: {
            headers: { "X-CSRF-TOKEN": $('input[name="_token"]').val() },
            type: "GET",
            url: "/admin/inscripciones/students/list",
            data: function (d) {
                d.idplan = dt_idplan;
            },
        },
        searching: true,
        dom: "Bfrtip",
        select: false,
        lengthChange: false,
        responsive: true,
        language: languageSchema,
        buttons: getButtonsSchema(tableName),
        columns: [
            { data: "semestre", className: "text-center" },
            { data: "tipoidenti", className: "text-center" },
            { data: "nroidenti", className: "text-center" },
            { data: "apellidos", className: "text-center" },
            { data: "nombres", className: "text-center" },
            { data: "correo", className: "text-center" },
            { data: "celular", className: "text-center" },
            { data: "anioingreso", className: "text-center" },
            { data: "modingreso", sortable: false, className: "text-center",
                render: function (data, type, all, meta) {
                    if (all.modingreso == "0") {
                        return `Egresado`;
                    } else if (all.modingreso == "1") {
                        return `Regular`;
                    } else if (all.modingreso == "2") {
                        return `Matricula reservada`;
                    } else if (all.modingreso == "3") {
                        return `Licencia regular`;
                    } else if (all.modingreso == "4") {
                        return `Licencia Discapacitado`;
                    } else if (all.modingreso == "5") {
                        return `Retirado`;
                    }
                },
            },
            { data: "estadoacin", sortable: false, className: "text-center",
                render: function (data, type, all, meta) {
                    if (all.estadoacin == "1") {
                        return `<span class="badge light badge-success">Activo</span>`;
                    } else {
                        return `<span class="badge light badge-danger">Inactivo</span>`;
                    }
                },
            },
            { data: "idstudents", className: "text-center noExport", sortable: false, searchable: false,
                render: function (data, type, all, meta) {
                    return `
                            <div class="d-flex justify-content-center">

                                <a href="javascript:void(0);" class="passwordBtn btn btn-dark shadow btn-xs sharp  me-1"
                                data-iduser="${all.iduser}"
                                data-nroidenti="${all.nroidenti}"
                                data-nombres="${all.nombres}"
                                data-apellido_pa="${all.apellido_pa}"
                                data-apellido_ma="${all.apellido_ma}"
                                data-bs-placement="top"
                                title="Actualizar contraseña">
                                <i class="fas fa-key"></i>
                                </a>

                                <a href="javascript:void(0);" class="editBtn btn btn-warning shadow btn-xs sharp me-1"
                                data-iduser="${all.iduser}"
                                data-ididentificationtype="${all.ididentificationtype}"
                                data-tipoidenti="${all.tipoidenti}"
                                data-nroidenti="${all.nroidenti}"
                                data-estadoacin="${all.estadoacin}"
                                data-nombres="${all.nombres}"
                                data-apellido_pa="${all.apellido_pa}"
                                data-apellido_ma="${all.apellido_ma}"
                                data-fecnac="${all.fecnac}"
                                data-correo="${all.correo}"
                                data-telefono="${all.telefono}"
                                data-celular="${all.celular}"
                                data-genre_id="${all.idgenre}"
                                data-ubigeo_id="${all.idubigeo}"
                                data-iddepartamento="${all.iddepartamento}"
                                data-departamento="${all.departamento}"
                                data-idprovincia="${all.idprovincia}"
                                data-provincia="${all.provincia}"
                                data-iddistrito="${all.iddistrito}"
                                data-distrito="${all.distrito}"
                                data-direccion="${all.direccion}"
                                data-idstudents="${all.idstudents}"
                                data-modingreso="${all.modingreso}"
                                data-anioingreso="${all.anioingreso}"
                                data-apoderado="${all.apoderado}"
                                data-bs-placement="top"
                                title="Editar registro">
                                <i class="fas fa-pencil-alt"></i>
                                </a>

                                <a href="javascript:void(0);" class="programsplanBtn btn btn-dark shadow btn-xs sharp  me-1"
                                data-idstudents="${all.idstudents}"
                                data-programa ="${all.programa}"
                                data-plan ="${all.plan}"
                                data-idplan ="${all.idplan}"
                                data-bs-placement="top"
                                title="Actualizar plan"
                                style="display:none;">
                                <i class="fa-solid fa-folder-open"></i>
                                </a>

                                <a href="javascript:void(0);" class="deleteBtn btn btn-danger shadow btn-xs sharp"
                                data-idstudents="${all.idstudents}"
                                data-iduser="${all.iduser}"
                                data-bs-placement="top"
                                title="Eliminar registro">
                                <i class="fas fa-trash"></i>
                                </a>

                            </div>

                            `;
                },
            },
        ],
    });

    var valbtn, formCheck;

    // INICIO - MODAL CREATE ************************* LISTO
    $("#btnCreateModal").click(function () {
        // change value
        $("#btnCreateUpdate").attr("value", "Create");
        $("#btnCreateUpdate").html("Registrar");
        $("#modalCreateUpdateLabel").html("Registrar datos del Estudiante");
        // mostrar contraseña
        $("#div_txt_password").removeAttr("style");
        clearCheck();
        clearForm();

        if ($('#txt-idplan').val() != "") {
            $("#modalCreateUpdate").modal("show");
        } else {
            notificaciontoast("error", "Seleccione un Programa / Plan de estudio", "Error", "bottom-right", "2500");
        }
    });
    // FIN - MODAL CREATE

    // INICIO - MODAL UPDATE
    $("#datatableGeneral tbody").on("click", ".editBtn", function (e) {
        clearCheck(); // borrar validaciones
        //cambiar el text del button
        $("#btnCreateUpdate").html("Actualizar");
        $("#modalCreateUpdateLabel").html("Actualizar datos del Estudiante");
        // ocultar txt_password
        $("#div_txt_password").css("display", "none");
        $("#txt_password").val("****"); // para poder pasar el check validity
        // setear data de usuario
        $("#txt_iduser").val($(this).data("iduser"));
        $("#txt_tipoidenti").selectpicker("val", $(this).attr("data-ididentificationtype"));
        $("#txt_nroidenti").val($(this).data("nroidenti"));
        $("#txt_estado").selectpicker("val", $(this).attr("data-estadoacin"));
        $("#txt_nombres").val($(this).data("nombres"));
        $("#txt_anho_ingreso").val($(this).data("anioingreso"));
        $("#txt_apellido_pa").val($(this).data("apellido_pa"));
        $("#txt_apellido_ma").val($(this).data("apellido_ma"));
        $("#txt_fecnac").val($(this).data("fecnac"));
        $("#txt_correo").val($(this).data("correo"));
        $("#txt_telefono").val($(this).data("telefono"));
        $("#txt_celular").val($(this).data("celular"));
        $("#txt_genre_id").selectpicker("val", $(this).attr("data-genre_id"));
        $("#txt_estadoestudiante").selectpicker("val", $(this).attr("data-modingreso") + "");
        $("#txt_direccion").val($(this).data("direccion"));
        $("#txt-apoderado").val($(this).data("apoderado"));
        // ubigeo
        $("#txt_departamento").selectpicker(
            "val",
            $(this).attr("data-iddepartamento")
        );
        let sl_departamento = $(this).data("departamento");
        let sl_provincia = $(this).data("provincia");
        let sl_distrito = $(this).data("distrito");
        ubigeo_for_update(sl_departamento, sl_provincia, sl_distrito);
        // obtener datos del administrador
        $("#txt_idadministrador").val($(this).data("idadministrador"));
        // show form
        $("#modalCreateUpdate").modal("show");
        // change value
        $("#btnCreateUpdate").attr("value", "Update");
    });
    // FIN - MODAL UPDATE

    // INICIO - MODAL UPDATE PASSWORD ************************* LISTO
    $("#datatableGeneral tbody").on("click", ".passwordBtn", function (e) {
        // borrar validaciones
        formCheck = $("#formModal2")[0];
        $(formCheck).removeClass("was-validated"); // remover validaciones
        // setear data de usuario
        $("#txt_iduser2").val($(this).data("iduser"));
        $("#txt_nroidenti2").val($(this).data("nroidenti"));
        let apenom =
            $(this).data("apellido_pa") +
            " " +
            $(this).data("apellido_ma") +
            ", " +
            $(this).data("nombres");
        $("#txt_apenom").val(apenom);
        $("#txt_password2").val("");
        // show form
        $("#modalUpdatePassword").modal("show");
    });
    // FIN - MODAL UPDATE PASSWORD

    // INICIO - MODAL DELETE ************************* LISTO
    $("#datatableGeneral tbody").on("click", ".deleteBtn", function (e) {
        let iduser = $(this).data("iduser");
        // confirmacion
        confirmation_sweetAlert(
            "Deseas continuar?",
            "Se procederá a eliminar el registro de la base de datos",
            "warning"
        ).then(function (isConfirm) {
            if (isConfirm.value) {
                // enviando el parametro de la data que se procede a delete
                destroy(iduser);
            } else {
            }
        });
    });
    // FIN - MODAL DELETE

    // INICIO - FUNCION CREATE O UPDATE
    $("#btnCreateUpdate").on("click", function (event) {
        event.preventDefault();
        // Iterar sobre los formularios y evitar la acción predeterminada si no son válidos
        formCheck = $("#formModal")[0];
        if (!formCheck.checkValidity()) {
            event.preventDefault();
            event.stopPropagation();
        } else {
            valbtn = $("#btnCreateUpdate").val();
            // FUNCION CREAR
            if (valbtn === "Create") {
                // insertar
                store();
                document.getElementById('title_programa').innerHTML = "";
                document.getElementById('name_programa_title').value = "";
                document.getElementById('title_plan').innerHTML = "";
                document.getElementById('txt-idplan').value = "";
            }
            // FUNCION ACTUALIZAR
            if (valbtn === "Update") {
                // actualizar
                update($("#txt_iduser").val());

            }
        }
        $(formCheck).addClass("was-validated"); // añadir validaciones
    });
    // FIN - FUNCION CREATE O UPDATE

    // INICIO - FUNCION UPDATE PASSWORD  ************************* LISTO
    $("#btnUpdatePassword").on("click", function (event) {
        event.preventDefault();
        // Iterar sobre los formularios y evitar la acción predeterminada si no son válidos
        formCheck = $("#formModal2")[0];
        if (!formCheck.checkValidity()) {
            event.preventDefault();
            event.stopPropagation();
            // añadir validaciones
        } else {
            update_password($("#txt_iduser2").val());
        }
        $(formCheck).addClass("was-validated");
    });
    // FIN - FUNCION UPDATE PASSWORD

    // INICIO - ACTUALIZAR PLAN ************************* LISTO
    $("#datatableGeneral tbody").on("click", ".programsplanBtn", function (e) {
        //
        if ($('#txt-idplan').val() != "") {
            let idstudents = $(this).data("idstudents");
            // confirmacion
            confirmation_sweetAlert(
                "Deseas continuar?",
                "Se procederá a actualizar el plan según el programa selecionado",
                "warning"
            ).then(function (isConfirm) {
                if (isConfirm.value) {
                    // enviando el parametro de la data que se procede a actualizar plan
                    updateplan(idstudents);
                } else {
                }
            });
        } else {
            notificaciontoast("error", "Seleccione un programa y Plan de estudio para actualizar", "Error", "bottom-right", "2500");
        }

    });
    // FIN - ACTUALIZAR PLAN


    // INICIO - FUNCION INSERTAR PLANTILLA ************************* LISTO
    $("#btn_insert_plantilla").click(function () {
        if ($('#txt-idplan').val() != "") {
            if (datajsondos.length > 0) {
                // confirmacion
                confirmation_sweetAlert(
                    "Deseas continuar?",
                    "Se procederá a insertar la plantilla a la base de datos, consideras que los datos enviados son los correctos",
                    "warning"
                ).then(function (isConfirm) {
                    if (isConfirm.value) {
                        store_plantilla();
                    } else {
                    }
                });
            } else {
                notificaciontoast("error", "Seleccione una plantilla y previsualice", "Error", "bottom-right", "2500");
            }

        } else {
            notificaciontoast("error", "Seleccione un programa / Plan de estudio", "Error", "bottom-right", "2500");
        }
    });
    // FIN

    list_programs();
    function list_programs() {
        $.ajax({
            type: "GET",
            url: admissionlistprograms,
            dataType: "json",
            beforeSend: function () { },
            success: function (response) {
                response.forEach((elemento) => {
                    //
                    document.getElementById("div_porgrams").innerHTML +=
                        `<li class="btn-programa" data-idprograma="${elemento.id}" data-programa="${elemento.cod} - ${elemento.programa}">
                        <div class="timeline-badge primary"></div>
                        <div class="drive mx-4 py-1 rounded border border-primary">
                            <div class="dz-folder">
                                <i class="fa-solid fa-graduation-cap fa-2xl text-primary"></i>
                            </div>
                            <div class="drive-content">
                                <h4 class="title mb-1">${elemento.programa}</h4>
                                <span class="title fs-14">Código: ${elemento.cod}</span>
                            </div>
                        </div>
                    </li>`;
                });
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    $(document).on("click", ".btn-programa", function () {
        let idprogram = $(this).attr("data-idprograma");
        list_plans(idprogram);
        document.getElementById('title_programa').innerHTML = $(this).attr("data-programa");
        document.getElementById('name_programa_title').value = $(this).attr("data-programa");
        document.getElementById('title_plan').innerHTML = "";
        document.getElementById('txt-idplan').value = "";
        dt_idplan = "";
        table.ajax.reload();
    });

    function list_plans(idprogram) {
        document.getElementById("div_plans").innerHTML = "";
        $.ajax({
            headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
            type: "GET",
            url: "/admin/inscripciones/programs/list_plans/" + idprogram,
            dataType: "json",
            beforeSend: function () { },
            success: function (response) {
                response.forEach((elemento) => {
                    document.getElementById("div_plans").innerHTML +=
                        `<li class="btn-plan" data-idplan="${elemento.id}" data-plan="${elemento.plan}">
                            <div class="timeline-badge primary"></div>
                            <div class="drive mx-4 py-1 rounded border border-primary">
                                <div class="dz-folder">
                                    <i class="fa-solid fa-map fa-2xl text-primary"></i>
                                </div>
                                <div class="drive-content">
                                    <a href="javascript:void(0);">
                                        <h4 class="title mb-1">Plan: ${elemento.plan}</h4>
                                        <span class="fs-14">Tipo: ${elemento.tipo}</span>
                                    </a>
                                </div>
                            </div>
                        </li>`;
                });
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    $(document).on("click", ".btn-plan", function () {
        document.getElementById('title_plan').innerHTML = $(this).attr("data-plan");
        document.getElementById('txt-idplan').value = $(this).attr("data-idplan");
        dt_idplan = $(this).attr("data-idplan");
        table.ajax.reload();
    });


    var formModal;
    //FUNCION CREAR UN REGISRO   ************************* LISTO
    function store() {
        formModal = $("#formModal");
        $.ajax({
            type: "POST",
            url: "/admin/inscripciones/students/store",
            data: formModal.serialize(),
            dataType: "json",
            beforeSend: function () { },
            success: function (data) {
                if (data.status == true) {
                    table.ajax.reload(); // añadir validaciones
                    notificaciontoast("info", data.mensaje, "Éxito!");
                    setTimeout(function () {
                        $("#modalCreateUpdate").modal("hide");
                    }, 1750); // ocultar despues de 1 sec
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    function update(iduser) {
        formModal = $("#formModal");
        $.ajax({
            headers: { "X-CSRF-TOKEN": $('input[name="_token"]').val() },
            type: "PUT",
            url: "/admin/inscripciones/students/update/" + iduser,
            data: formModal.serialize(),
            dataType: "json",
            beforeSend: function () { },
            success: function (data) {
                if (data.status == true) {
                    table.ajax.reload();
                    formModal.addClass("was-validated"); // añadir validaciones
                    notificaciontoast("info", data.mensaje, "Éxito!");
                    setTimeout(function () {
                        $("#modalCreateUpdate").modal("hide");
                    }, 1000); // ocultar despues de 1 sec
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    //FUNCION ACTUALIZAR PASSWORD   ************************* LISTO
    function update_password(iduser) {
        $.ajax({
            headers: { "X-CSRF-TOKEN": $('input[name="_token"]').val() },
            type: "PUT",
            url: "/admin/inscripciones/students/update_password/" + iduser,
            data: $("#formModal2").serialize(),
            dataType: "json",
            beforeSend: function () { },
            success: function (data) {
                if (data.status == true) {
                    table.ajax.reload();
                    notificaciontoast("info", data.mensaje, "Éxito!");
                    setTimeout(function () {
                        $("#modalUpdatePassword").modal("hide");
                    }, 1000); // ocultar despues de 1 sec
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    //FUNCION ACTUALIZAR plan   ************************* LISTO
    function updateplan(iduser) {
        $.ajax({
            headers: { "X-CSRF-TOKEN": $('input[name="_token"]').val() },
            type: "PUT",
            url: "/admin/inscripciones/students/update_plan/" + iduser,
            data: $("#formModal").serialize(),
            dataType: "json",
            beforeSend: function () { },
            success: function (data) {
                if (data.status == true) {
                    table.ajax.reload();
                    notificaciontoast("info", data.mensaje, "Éxito!");
                    document.getElementById('title_programa').innerHTML = "";
                    document.getElementById('name_programa_title').value = "";
                    document.getElementById('title_plan').innerHTML = "";
                    document.getElementById('txt-idplan').value = "";
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    //FUNCION ELIMINAR UN REGISRO   ************************* LISTO
    function destroy(iduser) {
        $.ajax({
            headers: { "X-CSRF-TOKEN": $('input[name="_token"]').val() },
            type: "DELETE",
            url: "/admin/inscripciones/students/destroy/" + iduser,
            beforeSend: function () { },
            success: function (data) {
                if (data.status == true) {
                    table.ajax.reload();
                    notificaciontoast("info", data.mensaje, "Éxito!");
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    // LIMPIAR VALIDACIONES  ************************* LISTO
    function clearCheck() {
        formCheck = $("#formModal")[0];
        $(formCheck).removeClass("was-validated"); // remover validaciones

    }

    // LIMPIAR FORMULARIO ************************* LISTO
    function clearForm() {
        $("#txt_iduser").val("");
        $("#txt_tipoidenti").selectpicker("val", "");
        $("#txt_nroidenti").val("");
        $("#txt_password").val("");
        $("#txt_role_id").selectpicker("val", "");
        $("#txt_estado").selectpicker("val", "1");
        $("#txt_nombres").val("");
        $("#txt_apellido_pa").val("");
        $("#txt_apellido_ma").val("");
        $("#txt_fecnac").val("");
        $("#txt_correo").val("");
        $("#txt_telefono").val("");
        $("#txt_celular").val("");
        $("#txt_genre_id").selectpicker("val", "");
        $("#txt_direccion").val("");
        $("#txt_departamento").selectpicker("val", "");
        $("#txt_estadomodalidad").selectpicker("val", "");
        $("#txt_anho_ingreso").val("");
        $("#txt-apoderado").val("");
        vaciar_provincias();
        vaciar_distritos();
        $("#txt_idadministrador").val("");
    }

    function clearClasses() {
        // limpiar clases
        $("#txt_nombres").removeClass("border border-info shadow");
        $("#txt_apellido_pa").removeClass("border border-info shadow");
        $("#txt_apellido_ma").removeClass("border border-info shadow");
        $("#txt_fecnac").removeClass("border border-info shadow");
        $("#txt_correo").removeClass("border border-info shadow");
        $("#txt_telefono").removeClass("border border-info shadow");
        $("#txt_celular").removeClass("border border-info shadow");
        $("#txt_direccion").removeClass("border border-info shadow");
        $("#txt_estado").siblings('button[type="button"]').removeClass("border border-info shadow");
        $("#txt_genre_id").siblings('button[type="button"]').removeClass("border border-info shadow");
        $("#txt_departamento").siblings('button[type="button"]').removeClass("border border-info shadow");
        $("#txt_provincia").removeClass("border border-info shadow");
        $("#txt_provincia").closest('.bootstrap-select').removeClass("border border-info shadow");
        // $("#txt_provincia").siblings('button[type="button"]').removeClass("border border-info shadow");
        $("#txt_distrito").removeClass("border border-info shadow");
        $("#txt_distrito").closest('.bootstrap-select').removeClass("border border-info shadow");
        // $("#txt_distrito").siblings('button[type="button"]').removeClass("border border-info shadow");
    }


    //INSERTAR STUDENTS DE PLANTILLA EXCEL
    function store_plantilla() {
        //
        $.ajax({
            headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
            type: "POST",
            url: "/admin/inscripciones/students/storePlantilla",
            data: { datajsondos: datajsondos, idplan: $("#txt-idplan").val() },
            dataType: "json",
            beforeSend: function () {
                // mostrar preloader
                $("#modalCargandoExcel").modal("show");
                document.getElementById('div_progressbar_modal_preload').innerHTML =
                    ` <div class="drive-content mt-2 mx-2 p-1">
                        <div class="progress default-progress">
                            <div class="progress-bar bg-vigit progress-animated bg-info" style="width: 100%; height:100%;" role="progressbar">
                                <span id="txt_title_progressbar">... Cargando!</span>
                            </div>
                        </div>
                    </div>`
                document.getElementById("id_preload_excel").innerHTML = " Registrando";
            },
            success: function (data) {
                if (data.status == true) {
                    notificaciontoast("info", data.mensaje, "Éxito!");
                    document.getElementById("id_preload_excel").innerHTML = " " + data.mensaje;
                    table.ajax.reload();
                    // preloader
                    document.getElementById("hiddenswitch").value = "1";
                    if (document.getElementById("hiddenswitch").value == "1") {
                        document.getElementById("hiddenswitch").value = "0";
                        setTimeout(function () {
                            // limpiar preloader
                            document.getElementById('div_progressbar_modal_preload').innerHTML = ""
                            document.getElementById("id_preload_excel").innerHTML = "";
                            $("#modalCargandoExcel").modal("hide");
                            $("#file_select_plantilla").val("");
                            $("#btn_previsualizar_plantilla").prop("disabled", true);
                            datajsondos.splice(0, datajsondos.length);
                            // limpiart tabla
                            $("#datatableGeneral_preview_Excel").DataTable().clear().draw();
                        }, 3500);
                    }

                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                    document.getElementById("id_preload_excel").innerHTML = " " + data.mensaje;
                    // preloader
                    document.getElementById("hiddenswitch").value = "1";
                    if (document.getElementById("hiddenswitch").value == "1") {
                        document.getElementById("hiddenswitch").value = "0";
                        setTimeout(function () {
                            // limpiar preloader
                            document.getElementById('div_progressbar_modal_preload').innerHTML = ""
                            document.getElementById("id_preload_excel").innerHTML = "";
                            $("#modalCargandoExcel").modal("hide");
                            $("#file_select_plantilla").val("");
                            $("#btn_previsualizar_plantilla").prop("disabled", true);
                            datajsondos.splice(0, datajsondos.length);
                            // limpiart tabla
                            $("#datatableGeneral_preview_Excel").DataTable().clear().draw();
                        }, 3500);
                    }
                }

            },
            error: function (error) {
                document.getElementById('div_progressbar_modal_preload').innerHTML = ""
                document.getElementById("id_preload_excel").innerHTML = "";
                $("#modalCargandoExcel").modal("hide");
                console.log("Error", error);
            },
        });
    }

    //Traer datos con el DNI desde la base de datos
    $("#btn-querybd").on("click", function (event) {
        var nroidenti = $("#txt_nroidenti").val();
        $.ajax({
            type: "GET",
            url: '/admin/query_bd/' + nroidenti,
            dataType: 'json',
            beforeSend: function () { },
            success: function (response) {
                if (response.data.length == 0) {
                    notificaciontoast("error", "El usuario no existe en la base de datos", "Error!", "top-center");
                } else {
                    const dataObj = response.data;
                    for (const key in dataObj) {
                        if (dataObj.hasOwnProperty(key)) {
                            const user = dataObj[key];

                            // setear data de programa
                            $("#txt_nombres").val(convertirTexto(user.nombres));
                            $("#txt_apellido_pa").val(convertirTexto(user.apellido_pa));
                            $("#txt_apellido_ma").val(convertirTexto(user.apellido_ma));
                            $("#txt_fecnac").val(user.fecnac);
                            $("#txt_correo").val(user.correo);
                            $("#txt_telefono").val(user.telefono);
                            $("#txt_celular").val(user.celular);
                            $("#txt_direccion").val(user.direccion);
                            $("#txt_estado").selectpicker("val", String(user.estado));
                            $("#txt_genre_id").selectpicker("val", String(user.idgenre));
                            $("#txt_departamento").selectpicker("val", user.iddepartamento);
                            let sl_departamento = user.departamento;
                            let sl_provincia = user.provincia;
                            let sl_distrito = user.distrito;
                            ubigeo_for_update(sl_departamento, sl_provincia, sl_distrito);

                            // añadir clases
                            $("#txt_nombres").addClass("border border-info shadow");
                            $("#txt_apellido_pa").addClass("border border-info shadow");
                            $("#txt_apellido_ma").addClass("border border-info shadow");
                            $("#txt_fecnac").addClass("border border-info shadow");
                            $("#txt_correo").addClass("border border-info shadow");
                            $("#txt_telefono").addClass("border border-info shadow");
                            $("#txt_celular").addClass("border border-info shadow");
                            $("#txt_direccion").addClass("border border-info shadow");
                            $("#txt_estado").siblings('button[type="button"]').addClass("border border-info shadow");
                            $("#txt_genre_id").siblings('button[type="button"]').addClass("border border-info shadow");
                            $("#txt_departamento").siblings('button[type="button"]').addClass("border border-info shadow");
                            $("#txt_provincia").addClass("border border-info shadow");
                            $("#txt_distrito").addClass("border border-info shadow");

                            // remover clases después de un tiempo
                            setTimeout(function () {
                                clearClasses();
                            }, 1000);
                        }
                    }

                }
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    });

    //Traer datos con el DNI desde la RENIEC
    $("#btn-querydata").on("click", function (event) {
        var nroidenti = $("#txt_nroidenti").val();
        $.ajax({
            type: "GET",
            url: '/admin/query_data/' + nroidenti,
            dataType: 'json',
            beforeSend: function () { },
            success: function (response) {
                const dataObj = JSON.parse(response.data);
                if (dataObj.hasOwnProperty('message')) {
                    console.log(dataObj.message);
                    notificaciontoast("error", "Datos del DNI no encontrado", "Error!", "top-center");
                } else {
                    $("#txt_nombres").val(convertirTexto(dataObj.nombres));
                    $("#txt_apellido_pa").val(convertirTexto(dataObj.apellidoPaterno));
                    $("#txt_apellido_ma").val(convertirTexto(dataObj.apellidoMaterno));

                    // setear data de programa
                    $("#txt_nombres").addClass("border border-info shadow");
                    $("#txt_apellido_pa").addClass("border border-info shadow");
                    $("#txt_apellido_ma").addClass("border border-info shadow");

                    setTimeout(function () {
                        $("#txt_nombres").removeClass("border border-info shadow");
                        $("#txt_apellido_pa").removeClass("border border-info shadow");
                        $("#txt_apellido_ma").removeClass("border border-info shadow");
                    }, 300);
                }
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    });

    function convertirTexto(texto) {
        // Convierte todo el texto a minúsculas
        texto = texto.toLowerCase();

        // Divide el texto en palabras
        var palabras = texto.split(' ');

        // Itera sobre cada palabra y capitaliza la primera letra
        for (var i = 0; i < palabras.length; i++) {
            palabras[i] = palabras[i].charAt(0).toUpperCase() + palabras[i].substring(1);
        }

        // Une las palabras de nuevo en un solo texto
        var resultado = palabras.join(' ');

        return resultado;
    }


    /* ---------------------------------  METODO CARGAR PLANTILLA DE EXCEL ------------------------------------------------- */
    var datajsondos = [];
    var clickdato = true;

    //activar boton cargar excel una ves que se haya selecionado el archivo excel en el input type "file"
    $("#file_select_plantilla").change(function () {
        $("#btn_previsualizar_plantilla").prop(
            "disabled",
            this.files.length == 0
        );
    });

    function CargardatosdelExcel() {
        // Obtener el archivo seleccionado
        var archivo = document.getElementById("file_select_plantilla").files[0];
        // Crear un objeto FileReader para leer el archivo
        var reader = new FileReader();
        reader.onload = function (e) {
            // Obtener los datos del archivo
            var data = e.target.result;
            var workbook = XLSX.read(data, {
                type: "binary",
            });

            // Obtener los datos de la primera hoja del archivo
            var sheetName = workbook.SheetNames[0];
            var sheet = workbook.Sheets[sheetName];

            var rangoInicio = "A4"; // Cambia la celda de inicio según sea necesario (columna B, fila 2)

            var rangoCompleto = sheet["!ref"]; // Obtiene el rango completo de la hoja
            var rangoFinal = rangoCompleto.split(":")[1]; // Obtiene la celda final del rango completo

            var rango = rangoInicio + ":" + rangoFinal;

            var datajson = XLSX.utils.sheet_to_json(sheet, {
                header: 1, // Indica que la primera fila es el encabezado
                range: rango, // Empieza desde la fila 2 (cero-indexed)
            });

            //recorremos el datajson del excel este contiene dato con filas nulas o no definidas
            datajson.forEach((row) => {
                // Si la fila tiene al menos un valor distinto de null o undefined
                if (row.some((cell) => cell !== null && cell !== undefined)) {
                    //llenamos el array de javaScript
                    datajsondos.push(row);
                }
            });

            $("#datatableGeneral_preview_Excel").DataTable({
                data: datajsondos,
                order: [],
                searching: true,
                dom: "Bfrtip",
                select: false,
                lengthChange: false,
                responsive: true,
                buttons: [
                    {
                        extend: "excel",
                        title: "Reporte de Busqueda de Partidas",
                        type: "button",
                        className: "btn btn-sm btn-arounded",
                        exportOptions: {
                            columns: ":visible",
                            orthogonal: "print",
                        },
                    },
                    {
                        extend: "pdf",
                        title: "Reporte de Busqueda de Partidas",
                        type: "button",
                        className: "btn btn-sm btn-arounded",
                        exportOptions: {
                            columns: ":visible",
                            orthogonal: "print",
                        },
                    },
                    {
                        extend: "print",
                        title: "Reporte de Busqueda de Partidas",
                        type: "button",
                        className: "btn  btn-sm btn-arounded",
                        exportOptions: {
                            columns: ":visible",
                            orthogonal: "print",
                        },
                    },
                    {
                        extend: "colvis",
                        text: "Seleccionar celdas",
                        title: "Reporte de Busqueda de Partidas",
                        type: "button",
                        className: "btn btn-sm btn-arounded",
                        exportOptions: {
                            columns: ":visible",
                            orthogonal: "print",
                        },
                    },
                ],
                language: {
                    search: 'Buscar',
                    info: 'Mostrando _START_ a _END_ de _TOTAL_ Registros',
                    zeroRecords: 'No hay registros para mostrar.',
                    infoFiltered: '(Filtrados de _MAX_ Registros)',
                    emptyTable: 'La tabla está vacia.',
                    infoEmpty: 'No hay registros',
                    paginate: {
                        next: '<i class="fa-solid fa-angle-right"></i>',
                        previous: '<i class="fa-solid fa-angle-left"></i>'
                    }
                },
                fnCreatedRow: function (row, data, dataIndex) {
                    $(row).attr("id", "fila-" + dataIndex);
                    $(row)
                        .find("td")
                        .each(function (i) {
                            $(this).attr(
                                "id",
                                "fila-" + dataIndex + "-col-" + i
                            );
                        });
                },
                columns: [
                    {
                        data: `${[0]}`,
                        render: function (data, type, row, meta) {
                            return `${row[0]}`;
                        },
                    },
                    {
                        data: `${[1]}`,
                        render: function (data, type, row, meta) {
                            return `${row[1]}`;
                        },
                    },
                    {
                        data: [2],
                        className: "text-start",
                        render: function (data, type, row, meta) {
                            return `${row[2]}`;
                        },
                    },
                    {
                        data: [3],
                        className: "text-start",
                        render: function (data, type, row, meta) {
                            return `${row[3]}`;
                        },
                    },
                    {
                        data: [4],
                        className: "text-start",
                        render: function (data, type, row, meta) {
                            return `${row[4]}`;
                        },
                    },
                    {
                        data: [5],
                        className: "text-start",
                        render: function (data, type, row, meta) {
                            return `${row[5]}`;
                        },
                    },
                    {
                        data: [6],
                        className: "text-start",
                        render: function (data, type, row, meta) {
                            return `${row[6]}`;
                        },
                    },
                    {
                        data: [7],
                        className: "text-start",
                        render: function (data, type, row, meta) {
                            return `${row[7]}`;
                        },
                    },
                    // {
                    //     data: [8],
                    //     className: "text-start",
                    //     render: function (data, type, row, meta) {
                    //         return `${row[8]}`;
                    //     },
                    // },
                    {
                        data: [8],
                        className: "text-start",
                            render: function (data, type, row, meta) {
                                var dateValue = row[8];
                                if (type === 'display' && dateValue) {
                                    // Convertir el valor de la celda a un objeto de fecha
                                    var excelDate = new Date((dateValue - (25567 + 1)) * 86400 * 1000);
                                    // Formatear la fecha en el formato deseado (por ejemplo, DD/MM/YYYY)
                                    var formattedDate = excelDate.toLocaleDateString('es-ES');
                                    // Devolver la fecha formateada
                                    return formattedDate;
                                } else {
                                    return data;
                                }
                            },
                    },
                    {
                        data: [9],
                        className: "text-start",
                        render: function (data, type, row, meta) {
                            return `${row[9]}`;
                        },
                    },
                    {
                        data: [10],
                        className: "text-start",
                        render: function (data, type, row, meta) {
                            return `${row[10]}`;
                        },
                    },
                    {
                        data: [11],
                        className: "text-start",
                        render: function (data, type, row, meta) {
                            return `${row[11]}`;
                        },
                    },
                    {
                        data: [12],
                        className: "text-start",
                        render: function (data, type, row, meta) {
                            return `${row[12]}`;
                        },
                    },
                    {
                        data: [13],
                        className: "text-start",
                        render: function (data, type, row, meta) {
                            return `${row[13]}`;
                        },
                    },
                ],
            });
        };
        reader.readAsBinaryString(archivo);
    }

    let btnjs_btn_previsualizar_plantilla = document.querySelector(
        "#btn_previsualizar_plantilla"
    );
    btnjs_btn_previsualizar_plantilla.addEventListener("click", function (e) {
        e.preventDefault();

        if (clickdato == true) {
            CargardatosdelExcel();
            clickdato = false;
            datajsondos.splice(0, datajsondos.length);
        } else {
            datajsondos.splice(0, datajsondos.length);
            $("#datatableGeneral_preview_Excel").DataTable().destroy();
            CargardatosdelExcel();
        }
    });
});
