"use strict";
import { notificaciontoast } from "../../common/method_toast.js";
import { confirmation_sweetAlert } from "../../common/method_sweetAlert.js";
import { getButtonsSchema, languageSchema } from "../../common/schemas.js";
import { cb_convenios } from "../../common/combobox/convenios.js";

$(document).ready(function () {
    cb_convenios();

    const tableName = "EFSRT";
    var dt_planId = 0,
        dt_studentId = 0,
        dt_EfsrtId = 0;

    // LISTAR DATATABLE
    var table = $("#datatableGeneral").DataTable({
        createdRow: function (row, data, index) {
            $(row).addClass("selected");
        },
        order: [],
        ajax: {
            headers: { "X-CSRF-TOKEN": $('input[name="_token"]').val() },
            type: "POST",
            url: "/api/efsrt/list",
            data: function (d) {
                d.plan_id = dt_planId;
                d.student_id = dt_studentId;
            },
        },
        searching: true,
        dom: "Bfrtip",
        select: false,
        lengthChange: false,
        responsive: true,
        language: languageSchema,
        buttons: getButtonsSchema(tableName),
        columns: [
            { data: "mf_id", className: "text-center" },
            { data: "mf_descripcion", className: "text-center" },
            {
                data: "ef_estado",
                sortable: false,
                className: "text-center",
                render: function (data, type, all, meta) {
                    // return all.ef_estado;
                    if (all.ef_existe == "1") {
                        return `<span class="badge light badge-success">Activo</span>`;
                    }
                    //  else if (all.efx == "1") {
                    //     return `<span class="badge light badge-info">En curso</span>`;
                    // }
                    else {
                        return `<span class="badge light badge-danger">Inactivo</span>`;
                    }
                },
            },
            {
                data: "ef_existe",
                sortable: false,
                className: "text-center",
                render: function (data, type, all, meta) {
                    if (all.ef_existe == 1) {
                        return `
                        <div class="d-flex justify-content-center">
                            <a href="javascript:void(0);" class="btnDeleteEfsrt btn btn-danger shadow btn-xs sharp me-2"
                            data-efsrt_id="${all.ef_id}"
                            data-bs-placement="top"
                            title="Eliminar Efsrt">
                            <i class="fas fa-xmark"></i>
                            </a>

                            <a href="javascript:void(0);" class="btnViewEfsrtDetails btn btn-info shadow btn-xs sharp"
                            data-efsrt_id="${all.ef_id}"
                            data-bs-placement="top"
                            title="Ver detalles Efsrt">
                            <i class="fas fa-eye fa-lg"></i>
                            </a>
                        </div>
                        `;
                    } else {
                        return `
                        <div class="d-flex justify-content-center">
                            <a href="javascript:void(0);" class="btnModalCreateEfsrt btn btn-success shadow btn-xs sharp me-2"
                            data-modulo_formativo_id="${all.mf_id}"
                            data-bs-placement="top"
                            title="Iniciar Efsrt">
                            <i class="fas fa-solid fa-plus"></i>
                            </a>

                            <a href="javascript:void(0);" class="btnViewEfsrtDetails disabled btn btn-info shadow btn-xs sharp"
                            data-efsrt_id="${all.ef_id}"
                            data-bs-placement="top"
                            title="Ver detalles Efsrt">
                            <i class="fas fa-eye fa-lg"></i>
                            </a>
                        </div>
                        `;
                    }
                },
            },
        ],
    });

    // Agregar una columna de números automáticos
    table
        .on("order.dt search.dt", function () {
            table
                .column(0, { search: "applied", order: "applied" })
                .nodes()
                .each(function (cell, i) {
                    cell.innerHTML = i + 1;
                });
        })
        .draw();

    // LISTAR DATATABLE 2
    const tableNameEfsrtDetails = "Efrst Detalle";
    var dt_EfsrtId = 0;
    var table_efsrt_details = $("#datatableEfsrtDetalle").DataTable({
        createdRow: function (row, data, index) {
            $(row).addClass("selected");
        },
        order: [],
        ajax: {
            headers: { "X-CSRF-TOKEN": $('input[name="_token"]').val() },
            type: "POST",
            url: `/api/efsrt/list/details`,
            data: function (d) {
                d.efsrt_id = dt_EfsrtId;
            },
        },
        searching: true,
        dom: "Bfrtip",
        select: false,
        lengthChange: false,
        responsive: true,
        language: languageSchema,
        buttons: getButtonsSchema(tableNameEfsrtDetails),
        columns: [
            { data: "efdet_id", className: "text-center" },
            { data: "con_nombre", className: "text-center" },
            { data: "efdet_horas", className: "text-center" },
            { data: "efdet_fecha", className: "text-center" },
            {
                data: "efdet_estado",
                sortable: false,
                className: "text-center",
                render: function (data, type, all, meta) {
                    // return all.ef_estado;
                    if (all.efdet_estado == "1") {
                        return `<span class="badge light badge-success">Habilitado</span>`;
                    } else {
                        return `<span class="badge light badge-danger">Deshabilitado</span>`;
                    }
                },
            },
            {
                data: "efdet_id",
                sortable: false,
                className: "text-center",
                render: function (data, type, all, meta) {
                    if (all.efdet_estado == 1) {
                        return `
                        <div class="d-flex justify-content-center">
                            <a href="javascript:void(0);" class="btnDisableEfsrtDetalle btn btn-warning shadow btn-xs sharp me-2"
                            data-efdet_id="${all.efdet_id}"
                            data-bs-placement="top"
                            title="Deshabilitar Convenio">
                            <i class="fas fa-xmark"></i>
                            </a>

                            <a href="javascript:void(0);" class="btnDeleteEfsrtDetalle disabled btn btn-danger shadow btn-xs sharp"
                            data-efdet_id="${all.efdet_id}"
                            data-bs-placement="top"
                            title="Eliminar Convenio">
                            <i class="fas fa-trash fa-lg"></i>
                            </a>
                        </div>
                        `;
                    } else {
                        return `
                        <div class="d-flex justify-content-center">
                            <a href="javascript:void(0);" class="btnEnableEfsrtDetalle btn btn-info shadow btn-xs sharp me-2"
                            data-efdet_id="${all.efdet_id}"
                            data-bs-placement="top"
                            title="Habilitar Convenio">
                            <i class="fas fa-check"></i>
                            </a>

                            <a href="javascript:void(0);" class="btnDeleteEfsrtDetalle btn btn-danger shadow btn-xs sharp"
                            data-efdet_id="${all.efdet_id}"
                            data-bs-placement="top"
                            title="Eliminar Convenio">
                            <i class="fas fa-trash fa-lg"></i>
                            </a>
                        </div>
                        `;
                    }
                },
            },
        ],
    });

    // Agregar una columna de números automáticos
    table_efsrt_details
        .on("order.dt search.dt", function () {
            table_efsrt_details
                .column(0, { search: "applied", order: "applied" })
                .nodes()
                .each(function (cell, i) {
                    cell.innerHTML = i + 1;
                });
        })
        .draw();

    // INICIO - SELECCIONAR PROGRAMA
    $("#tlprogram").on("click", ".btnProgram", function (e) {
        dt_studentId = "0";
        cleanInfoAlumno();
        //Colorear la opcion seleccionada
        $(".divprogram").removeClass("dark").addClass("primary");
        $(this).prev("div").removeClass("primary").addClass("dark");
        // listar planes
        tl_plans($(this).data("idprogram"));
        // limpiar alumnos
        $("#txt-students").find("option").remove().end(); // delete options
        $("#txt-students").append(
            '<option selected disabled value="">Buscar alumno</option>'
        );
        $("#txt-students").selectpicker("refresh");
        // // CARGAR TABLA
        table.ajax.reload();
    });
    // FIN - SELECCIONAR PROGRAMA

    // // INICIO - SELECCIONAR PLAN
    $("#tlplan").on("click", ".btnPlan", function (e) {
        dt_studentId = "0";
        cleanInfoAlumno();
        //Colorear la opcion seleccionada
        $(".divplan").removeClass("dark").addClass("primary");
        $(this).prev("div").removeClass("primary").addClass("dark");
        // listar alumnos
        dt_planId = $(this).data("idplan");
        cb_students(dt_planId);
        //info Toast
        notificaciontoast(
            "info",
            "Consultando a la  base de datos!",
            "Mensaje!"
        );
        // CARGAR TABLA
        table.ajax.reload();
    });
    // // FIN - SELECCIONAR PLAN

    // INICIO - SELECCIONAR ESTUDIANTE
    $(document).on("change", "#txt-students", function (e) {
        dt_studentId = $(this).val();
        $("#add_student_id").val(dt_studentId);

        table.ajax.reload();
    });
    // FIN - SELECCIONAR ESTUDIANTE

    // INICIO - MODAL
    $("#datatableGeneral tbody").on(
        "click",
        ".btnViewEfsrtDetails",
        async function (e) {
            dt_EfsrtId = $(this).attr("data-efsrt_id");

            $("#add_det_efsrt_id").val(dt_EfsrtId);
            table_efsrt_details.ajax.reload();

            const efsrtDetalleData = await getDataByEfsrt(dt_EfsrtId);

            setEfsrtDataOnDetailsModal(efsrtDetalleData.data);

            // show form
            $("#modalEfsrtDetalle").modal("show");
        }
    );
    // FIN - MODAL

    function cleanInfoAlumno() {
        $("#txt-info-nombres").html("--");
        $("#txt-info-id").html("--");
        $("#txt-info-anho_ingreso").html("--");
    }

    // listar planes
    function tl_plans(idprogram) {
        $.ajax({
            type: "GET",
            url: "/ajax_all/plans/" + idprogram,
            dataType: "json",
            beforeSend: function () {},
            success: function (response) {
                $("#tlplan").html("");
                response.forEach((elemento) => {
                    document.getElementById("tlplan").innerHTML += `
                    <li class=''>
                        <div class='divplan timeline-badge primary'></div>
                        <a class='btnPlan timeline-panel text-muted px-2 py-1 mr-4 ml-2'
                            href='javascript:void(0);'
                            data-idplan='${elemento.id}'
                        >
                            <h6 class='mb-0 fs-14'>
                            <strong class='text-dark'>${elemento.nombre}</strong>
                            <br>
                            ${elemento.tipo}
                            </h6>
                        </a>
                    </li>
                    `;
                });
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }
    function cb_students(idplan) {
        $("#txt-students").find("option").remove().end(); // delete options
        $.ajax({
            type: "GET",
            url:
                "/admin/consulta/constancias_certificados/list_estudiantes/" +
                idplan,
            dataType: "json",
            beforeSend: function () {},
            success: function (response) {
                $("#txt-students").append(
                    '<option selected disabled value="">Seleccione una opción</option>'
                );
                response.forEach((elemento) => {
                    $("#txt-students").append(
                        `<option
                            value="${elemento.idstudent}"
                            data-idstudent="${elemento.idstudent}"
                            data-nroidenti="${elemento.nroidenti}"
                            data-estudiante="${elemento.estudiante}"
                        > ${elemento.nroidenti} - ${elemento.estudiante}
                        </option>
                        `
                    );
                });
                $("#txt-students").selectpicker("refresh");
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    const getDataByEfsrt = async (efsrtId) => {
        const response = await fetch(`/api/efsrt/${efsrtId}/details`);
        const data = await response.json();
        return data;
    };

    const setEfsrtDataOnDetailsModal = (efsrtData) => {
        // const efsrtData = efsrtDetalleData.efsrt;
        const moduloFormativoData = efsrtData.modulo_formativo;
        const planData = moduloFormativoData.plan;
        const programData = planData.program;
        const userData = efsrtData.estudiante.user;

        $("#det_estudiante").val(userData.nombres);
        $("#det_modulo_formativo").val(moduloFormativoData.descripcion);
        $("#det_programa").val(programData.nombre);
        $("#det_total_horas").val(efsrtData.total_horas);
        $("#det_plan").val(planData.nombre);
        $("#det_porcentaje_efsrt").val(`${efsrtData.porcentaje_total}%`);
    };

    // FUNCIONES PARA AÑADIR Y ELIMINAR REGISTROS

    // INICIO - ADD EFSRT DETALLE
    $("#btnModalCreateEfsrtDetalle").on("click", function (e) {
        e.preventDefault();
        // show form
        $("#modalCreateEfsrtDetalle").modal("show");
    });
    // FIN - ADD EFSRT DETALLE

    // INICIO - ADD EFSRT DETALLE
    $(".btnModalCloseEfsrtDetalle").on("click", function (e) {
        e.preventDefault();
        // show form
        $("#modalCreateEfsrtDetalle").modal("hide");
    });
    // FIN - ADD EFSRT DETALLE

    // INICIO - ADD EFSRT DETALLE
    $("#btnCreateEfsrtDetalle").on("click", function (event) {
        event.preventDefault();
        const formCheck = $("#formEfsrtDetalle")[0];
        if (!formCheck.checkValidity()) {
            event.preventDefault();
            event.stopPropagation();
            $(formCheck).addClass("was-validated"); // añadir validaciones
            return;
        }
        createEfsrtDetalle();
    });
    // FIN - ADD EFSRT DETALLE

    function createEfsrtDetalle() {
        const btnTrigger = $("#btnCreateEfsrtDetalle");
        const formData = new FormData(
            document.getElementById("formEfsrtDetalle")
        );

        $.ajax({
            headers: { "X-CSRF-TOKEN": $('input[name="_token"]').val() },
            type: "POST",
            url: "/api/efsrt/detail",
            data: formData,
            processData: false,
            contentType: false,
            beforeSend: function () {
                btnTrigger.addClass("disabled");
            },
            success: async function (data) {
                if (data.status == true) {
                    table_efsrt_details.ajax.reload();
                    const efsrtData = await getDataByEfsrt(dt_EfsrtId);
                    setEfsrtDataOnDetailsModal(efsrtData.data);

                    notificaciontoast("info", data.mensaje, "Éxito!");
                    $("#modalCreateEfsrtDetalle").modal("hide");
                    btnTrigger.removeClass("disabled");
                    clearEfsrtDetalleForm();
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                    btnTrigger.removeClass("disabled");
                }
            },
            error: function (error) {
                clearEfsrtDetalleForm();
                console.log("Error", error);
                btnTrigger.removeClass("disabled");
            },
        });
    }

    // - - - - - - - - - - LIMPIAR CAMPOS - - - - - - - - - -
    const clearEfsrtDetalleForm = () => {
        $("#txt-convenios").selectpicker("val", "");
        $("#add_det_horas").val("");
    };

    // HABILITAR INHABILITAR CONVENIOS
    $("#datatableEfsrtDetalle tbody").on(
        "click",
        ".btnDisableEfsrtDetalle",
        function (e) {
            const efdet_id = $(this).data("efdet_id");
            let mensaje = `Se procederá a deshabilitar el convenio EFSRT. Esta acción hará que el porcentaje de horas baje.`;
            // confirmacion
            confirmation_sweetAlert(
                "Deseas continuar?",
                mensaje,
                "warning"
            ).then(function (isConfirm) {
                if (isConfirm.value) {
                    disableEfsrtDetalle(efdet_id);
                } else {
                    console.log("Cancelado");
                }
            });
        }
    );
    $("#datatableEfsrtDetalle tbody").on(
        "click",
        ".btnEnableEfsrtDetalle",
        function (e) {
            const efdet_id = $(this).data("efdet_id");
            let mensaje = `Se procederá a habilitar el convenio EFSRT. Esta acción hará que el porcentaje de horas suba.`;
            // confirmacion
            confirmation_sweetAlert(
                "Deseas continuar?",
                mensaje,
                "warning"
            ).then(function (isConfirm) {
                if (isConfirm.value) {
                    enableEfsrtDetalle(efdet_id);
                } else {
                    console.log("Cancelado");
                }
            });
        }
    );
    $("#datatableEfsrtDetalle tbody").on(
        "click",
        ".btnDeleteEfsrtDetalle",
        function (e) {
            const efdet_id = $(this).data("efdet_id");
            let mensaje = `Se procederá a eliminar el convenio EFSRT.`;
            // confirmacion
            confirmation_sweetAlert(
                "Deseas continuar?",
                mensaje,
                "warning"
            ).then(function (isConfirm) {
                if (isConfirm.value) {
                    destroyEfsrtDetalle(efdet_id);
                } else {
                    console.log("Cancelado");
                }
            });
        }
    );

    function disableEfsrtDetalle(efdet_id) {
        $.ajax({
            headers: { "X-CSRF-TOKEN": $('input[name="_token"]').val() },
            type: "PUT",
            url: `/api/efsrt/${efdet_id}/disable`,
            beforeSend: function () {},
            success: async function (data) {
                if (data.status == true) {
                    table_efsrt_details.ajax.reload();
                    const efsrtData = await getDataByEfsrt(dt_EfsrtId);
                    setEfsrtDataOnDetailsModal(efsrtData.data);
                    notificaciontoast("info", data.mensaje, "Éxito!");
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    function enableEfsrtDetalle(efdet_id) {
        $.ajax({
            headers: { "X-CSRF-TOKEN": $('input[name="_token"]').val() },
            type: "PUT",
            url: `/api/efsrt/${efdet_id}/enable`,
            beforeSend: function () {},
            success: async function (data) {
                if (data.status == true) {
                    table_efsrt_details.ajax.reload();
                    const efsrtData = await getDataByEfsrt(dt_EfsrtId);
                    setEfsrtDataOnDetailsModal(efsrtData.data);
                    notificaciontoast("info", data.mensaje, "Éxito!");
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }
    function destroyEfsrtDetalle(efdet_id) {
        $.ajax({
            headers: { "X-CSRF-TOKEN": $('input[name="_token"]').val() },
            type: "DELETE",
            url: `/api/efsrt/${efdet_id}/detail`,
            beforeSend: function () {},
            success: async function (data) {
                if (data.status == true) {
                    table_efsrt_details.ajax.reload();
                    const efsrtData = await getDataByEfsrt(dt_EfsrtId);
                    setEfsrtDataOnDetailsModal(efsrtData.data);
                    notificaciontoast("info", data.mensaje, "Éxito!");
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    // INICIO - ADD EFSRT
    // HABILITAR INHABILITAR CONVENIOS
    $("#datatableGeneral tbody").on(
        "click",
        ".btnModalCreateEfsrt",
        function (e) {
            e.preventDefault();
            $("#add_modulo_formativo_id").val(
                $(this).data("modulo_formativo_id")
            );
            // show form
            $("#modalCreateEfsrt").modal("show");
        }
    );

    // INICIO - ADD EFSRT
    $(".btnModalCloseEfsrt").on("click", function (e) {
        e.preventDefault();
        // show form
        $("#modalCreateEfsrt").modal("hide");
    });
    // FIN - ADD EFSRT

    // INICIO - ADD EFSRT
    $("#btnCreateEfsrt").on("click", function (event) {
        event.preventDefault();
        const formCheck = $("#formEfsrt")[0];
        if (!formCheck.checkValidity()) {
            event.preventDefault();
            event.stopPropagation();
            $(formCheck).addClass("was-validated"); // añadir validaciones
            return;
        }
        createEfsrt();
    });
    // FIN - ADD EFSRT

    function createEfsrt() {
        const btnTrigger = $("#btnCreateEfsrt");
        const formData = new FormData(document.getElementById("formEfsrt"));

        $.ajax({
            headers: { "X-CSRF-TOKEN": $('input[name="_token"]').val() },
            type: "POST",
            url: "/api/efsrt",
            data: formData,
            processData: false,
            contentType: false,
            beforeSend: function () {
                btnTrigger.addClass("disabled");
            },
            success: async function (data) {
                if (data.status == true) {
                    table.ajax.reload();

                    notificaciontoast("info", data.mensaje, "Éxito!");
                    $("#modalCreateEfsrt").modal("hide");
                    btnTrigger.removeClass("disabled");
                    clearEfsrtForm();
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                    btnTrigger.removeClass("disabled");
                }
            },
            error: function (error) {
                clearEfsrtForm();
                console.log("Error", error);
                btnTrigger.removeClass("disabled");
            },
        });
    }

    // - - - - - - - - - - LIMPIAR CAMPOS - - - - - - - - - -
    const clearEfsrtForm = () => {
        $("#add_total_horas").val("");
    };

    $("#datatableGeneral tbody").on("click", ".btnDeleteEfsrt", function (e) {
        const efsrtId = $(this).data("efsrt_id");
        let mensaje = `Se procederá a eliminar el convenio EFSRT.`;
        // confirmacion
        confirmation_sweetAlert("Deseas continuar?", mensaje, "warning").then(
            function (isConfirm) {
                if (isConfirm.value) {
                    destroyEfsrt(efsrtId);
                } else {
                    console.log("Cancelado");
                }
            }
        );
    });

    function destroyEfsrt(efsrtId) {
        $.ajax({
            headers: { "X-CSRF-TOKEN": $('input[name="_token"]').val() },
            type: "DELETE",
            url: `/api/efsrt/${efsrtId}`,
            beforeSend: function () {},
            success: function (data) {
                if (data.status == true) {
                    table.ajax.reload();
                    notificaciontoast("info", data.mensaje, "Éxito!");
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }
});
