    // MODULO DE GESTIONAR  ACTIVIDADES NO LECTIVAS

    let count1 = 1;

    $("#btn_addHorario").on("click", function (e) {
        var cantidadHijos = $("#section_Horario").children().length;
        if (cantidadHijos > 0) {
            count1 = cantidadHijos + 1;
        }
        let html;
        html = `
            <div class="row m-0 justify-content-between" id="descripcion_actividad_nl${count1}">
                <div class="col-sm-5  mb-2">
                    <label for="txt_dia_nl${count1}" class="form-label text-primary"><h5>Día</h5></label>
                    <input id="txt_dia_nl${count1}" name="txt_dia_nl[]" type="text" autocomplete="off" class="form-control form-control-sm" required>

                </div>
                <div class="col-sm-2  mb-2">
                    <label for="txt_horainicio_nl${count1}" class="form-label text-primary"><h5>Hora Inicio</h5></label>
                    <input id="txt_horainicio_nl${count1}" name="txt_horainicio_nl[]" type="time" autocomplete="off" class="form-control form-control-sm hora-inicio px-2" required>

                </div>
                <div class="col-sm-2  mb-2">
                    <label for="txt_horafin_nl${count1}" class="form-label text-primary"><h5>Hora fin</h5></label>
                    <input id="txt_horafin_nl${count1}" name="txt_horafin_nl[]" type="time" autocomplete="off" class="form-control form-control-sm hora-fin px-2" required>

                </div>
                <div class="col-sm-2  mb-2">
                    <label for="txt_duracion_nl${count1}" class="form-label text-primary"><h5>Duración</h5></label>
                    <input id="txt_duracion_nl${count1}" name="duraciones[]" type="text" class="form-control form-control-sm duracion" required>
                </div>
                <div class="col-sm-1 d-flex align-items-center pt-3">
                    <a href="javascript:void(0);" class="dleteBtn-horario btn btn-danger shadow btn-xs sharp"
                        data-idhorario="descripcion_actividad_nl${count1}"
                        data-bs-placement="top"
                        title="Eliminar registro">
                        <i class="fas fa-trash"></i>
                    </a>
                </div>
            </div>
        `;
        count1 = count1 + 1;
        $("#section_Horario").append(html);
    });

    $("#section_Horario").on("click", ".dleteBtn-horario", function (e) {
        // Puedes obtener atributos del elemento directamente
        let idhorario = $(e.currentTarget).attr("data-idhorario");
        $("#" + idhorario).remove();
    });

    // Crear o actualizar publicación
    var btnCreateUpdateActividad_nl = document.querySelector(
        "#btnCreateUpdateActividad_nl"
    );

    btnCreateUpdateActividad_nl.addEventListener(
        "click",
        function (event) {
            event.preventDefault(); // Evitar el envío por defecto

            const formCheck = $("#formModal4")[0];
            $(formCheck).addClass("was-validated"); // añadir validaciones
            if (!formCheck.checkValidity()) {
                event.preventDefault();
                event.stopPropagation();
            } else {
                const valbtn = $("#btnCreateUpdateActividad_nl").val();

                // Obtener horas totales asignadas desde el input
                const horasTotalesAsignadasInput = $("#txt_timepo_nl")
                    .val()
                    .trim();
                if (!horasTotalesAsignadasInput) {
                    notificaciontoast(
                        "warning",
                        "Ingresar total de horas no lectivas de la Actividad",
                        "Alerta!"
                    );
                    return;
                }

                // Convertir el valor ingresado a minutos (acepta horas, minutos o combinación)
                let horasTotalesAsignadas = 0;
                if (horasTotalesAsignadasInput.includes(":")) {
                    const [horas, minutos] = horasTotalesAsignadasInput
                        .split(":")
                        .map(Number);
                    horasTotalesAsignadas = (horas || 0) * 60 + (minutos || 0);
                } else {
                    horasTotalesAsignadas = parseInt(
                        horasTotalesAsignadasInput,
                        10
                    ); // Solo minutos
                }

                // Sumar todas las duraciones
                let sumaTotalMinutos = 0;

                $(".duracion").each(function () {
                    let duracion = $(this).val().trim(); // Obtener el valor del campo
                    if (duracion) {
                        if (duracion.includes(":")) {
                            const [horas, minutos] = duracion
                                .split(":")
                                .map(Number);
                            sumaTotalMinutos +=
                                (horas || 0) * 60 + (minutos || 0);
                        } else {
                            sumaTotalMinutos += parseInt(duracion, 10); // Solo minutos
                        }
                    }
                });

                // Comparar con las horas totales asignadas
                if (sumaTotalMinutos === horasTotalesAsignadas) {
                    notificaciontoast(
                        "info",
                        "Las duraciones coinciden. Guardando...",
                        "info!"
                    );

                    // Llamar funciones según la acción (crear o actualizar)
                    if (valbtn === "Create") {
                        crearActividades_nl();
                    } else {
                        updateActividades_nl(
                            $("#text_hidden_idactividad_cnl").val(),
                            $("#text_hidden_iddocente").val()
                        );
                    }
                } else {
                    const horasTotalSuma = Math.floor(sumaTotalMinutos / 60);
                    const minutosTotalSuma = sumaTotalMinutos % 60;

                    notificaciontoast(
                        "error",
                        `La suma total (${horasTotalSuma}h ${minutosTotalSuma}m) no coincide con las horas asignadas (${Math.floor(
                            horasTotalesAsignadas / 60
                        )}h ${horasTotalesAsignadas % 60}m).`,
                        "Error!"
                    );
                }
            }
        },
        false
    );

    const crearActividades_nl = () => {
        $.ajax({
            headers: { "X-CSRF-TOKEN": $('input[name="_token"]').val() },
            type: "POST",
            url: "/admin/carga_nl/docente/store",
            data: $("#formModal4").serialize(),
            dataType: "json",
            beforeSend: () => console.log("Enviando datos..."),
            success: (data) => {
                if (data.status) {
                    $("#formModal4").addClass("was-validated");
                    notificaciontoast("info", data.mensaje, "Éxito!");
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
                clear_modal_cnl();
                $("#modalGestion_cnl").modal("hide");
            },
            error: (jqXHR) => {
                console.log(jqXHR);
                if (jqXHR.status === 422) {
                    // Manejo de errores de validación
                    const errors = jqXHR.responseJSON.errors;
                    for (const key in errors) {
                        notificaciontoast(
                            "error",
                            errors[key][0],
                            "Error de Validación"
                        );
                    }
                } else {
                    // Manejo de errores generales
                    console.error("Error inesperado:", jqXHR);
                    notificaciontoast(
                        "error",
                        "Ocurrió un error inesperado. Inténtalo nuevamente.",
                        "Error!"
                    );
                }
            },
        });
    };

    function updateActividades_nl(idregistro, iddocente) {
        $.ajax({
            headers: { "X-CSRF-TOKEN": $('input[name="_token"]').val() },
            type: "PUT",
            url:
                "/admin/portafolio/docentes/update/actividades_ncl/" +
                idregistro,
            data: $("#formModal4").serialize(),
            dataType: "json",
            beforeSend: function () {},
            success: function (data) {
                if (data.status == true) {
                    $("#formModal4").addClass("was-validated");
                    list_DetalleCnl(iddocente);
                    notificaciontoast("info", data.mensaje, "Éxito!");
                    setTimeout(function () {
                        $("#modalGestion_cnl").modal("hide");
                    }, 1000); // ocultar despues de 1 sec
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    function clearCheck_modal_cnl() {
        formCheck = $("#formModal4")[0];
        $(formCheck).removeClass("was-validated"); // remover validaciones
    }

    // FIN FUNCION
    function clear_modal_cnl() {
        clearCheck_modal_cnl();
        $("#text_hidden_iddocente").val("");
        $("#formModal4")[0].reset(); // Resetear el formulario
        const container = $("#section_Horario");
        container.empty();
        $("#btnCreateUpdateActividad_nl").val("Create"); // Cambiar el texto del botón
    }

    function list_DetalleCnl(iduser) {
        $("#tabla-actividades").empty(); // Esta línea vacía el contenido del tbody
        $.ajax({
            type: "GET",
            url: "/admin/detalle/carga_nl/docente/" + iduser,
            dataType: "json",
            beforeSend: function () {},
            success: function (response) {
                if (response.status) {
                    renderTable(response.data);
                } else {
                }
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    function renderTable(data) {
        let tableHtml = "";

        // Agrupar por actividad (nombre, horas, descripción)
        const actividades = {};

        data.forEach((row) => {
            const key = row.nombreactividad; // Usa el nombreactividad de la actividad como clave
            if (!actividades[key]) {
                actividades[key] = {
                    idactividad_cnl: row.idactividad_cnl,
                    nombreactividad: row.nombreactividad,
                    horas: row.thoras_actividad,
                    descripcion: row.descripcion,
                    horarios: [],
                };
            }
            // Agregar cada horario a la actividad correspondiente
            actividades[key].horarios.push({
                iddetalle_actividad_cnl: row.iddetalle_actividad_cnl,
                dia: row.dia,
                horaini: row.horaini,
                horafin: row.horafin,
                duracion: row.duracion,
            });
        });


        // Iterar sobre las actividades agrupadas
        for (const actividad of Object.values(actividades)) {
            const numHorarios = actividad.horarios.length;

            // Fila principal con rowspan para actividad, horas y descripción
            tableHtml += `
                <tr>
                    <td rowspan="${numHorarios}" class="text-center">
                        <div class="d-flex justify-content-center">
                            <a href="javascript:void(0);" class="deleteBtn_anl btn btn-danger shadow btn-xs sharp me-1"
                                data-idactividad_cnl="${actividad.idactividad_cnl}"
                                data-bs-placement="top"
                                title="Eliminar Actvidad no Lectiva">
                                <i class="fas fa-trash"></i>
                            </a>
                            <a href="javascript:void(0);" class="edithBtn_anl btn btn-warning shadow btn-xs sharp me-1"
                                data-bs-placement="top"
                                data-idactividad_cnl="${actividad.idactividad_cnl}"
                                title="Editar registro">
                                <i class="fas fa-pencil-alt"></i>
                            </a>
                        <div>
                    </td>
                    <td rowspan="${numHorarios}" class="text-center">${actividad.nombreactividad}</td>
                    <td rowspan="${numHorarios}" class="text-center">${actividad.horas}</td>
                    <td rowspan="${numHorarios}" class="text-start"><pre>${actividad.descripcion}</pre></td>
            `;

            // Primera fila de horario
            tableHtml += `
                    <td class="text-center">
                            <a href="javascript:void(0);" class="deleteBtn_hnl btn btn-danger shadow btn-xs sharp"
                                data-iddetalle_actividad_cnl="${actividad.horarios[0].iddetalle_actividad_cnl}"
                                data-bs-placement="top"
                                title="Eliminar Horario1">
                                <i class="fas fa-trash"></i>
                                </a>
                    </td>
                    <td class="text-center">${actividad.horarios[0].dia}</td>
                    <td class="text-center">${actividad.horarios[0].horaini} - ${actividad.horarios[0].horafin}</td>
                    <td class="text-center">${actividad.horarios[0].duracion}</td>
                </tr>
            `;

            // Filas adicionales para otros horarios (si hay más de uno)
            for (let i = 1; i < actividad.horarios.length; i++) {
                tableHtml += `
                    <tr>
                        <td class="text-center">
                            <a href="javascript:void(0);" class="deleteBtn_hnl btn btn-danger shadow btn-xs sharp"
                                data-iddetalle_actividad_cnl="${actividad.horarios[0].iddetalle_actividad_cnl}"
                                data-bs-placement="top"
                                title="Eliminar Horario2">
                                <i class="fas fa-trash"></i>
                            </a>
                        </td>
                        <td class="text-center">${actividad.horarios[i].dia}</td>
                        <td class="text-center">${actividad.horarios[i].horaini} - ${actividad.horarios[i].horafin}</td>
                        <td class="text-center">${actividad.horarios[i].duracion}</td>
                    </tr>
                `;
            }
        }

        // Insertar el HTML generado en el tbody
        $("#tabla-actividades").html(tableHtml);
    }

    $("#tabla_detalleActividadesNl tbody").on(
        "click",
        ".edithBtn_anl",
        function (e) {
            // borrar validaciones
            let idregistro = $(this).data("idactividad_cnl");
            clear_modal_cnl();
            $("#btnCreateUpdateActividad_nl").val("Update");

            $.ajax({
                type: "GET",
                url: "/admin/detalle/carga_nl/docente/update/" + idregistro,
                dataType: "json",
                beforeSend: function () {},
                success: function (response) {
                    if (response.status) {
                        $("#text_hidden_iddocente").val(
                            response.actividad.docente_id
                        );
                        $("#text_hidden_idactividad_cnl").val(
                            response.actividad.idactividad_cnl
                        );
                        $("#txt_actividad_nl").val(
                            response.actividad.nombreactividad
                        );
                        $("#txt_timepo_nl").val(
                            response.actividad.thoras_actividad
                        );
                        $("#text_descripcion").val(
                            response.actividad.descripcion
                        );

                        let count_1 = 1;
                        let detallesHtml = "";
                        response.detalles.forEach(function (detalle) {
                            detallesHtml += `
                                <div class="row m-0 justify-content-between" id="descripcion_actividad_nl${count_1}">
                                    <input id="id_detalle_a_nl${count_1}" name="id_detalle_a_nl[]" type="hidden"  value="${detalle.iddetalle_actividad_cnl}">

                                    <div class="col-sm-5  mb-2">
                                        <label for="txt_dia_nl${count_1}" class="form-label text-primary"><h5>Día</h5></label>
                                        <input id="txt_dia_nl${count_1}" name="txt_dia_nl[]" type="text" autocomplete="off" class="form-control form-control-sm" value="${detalle.dia}" required>

                                    </div>
                                    <div class="col-sm-2  mb-2">
                                        <label for="txt_horainicio_nl${count_1}" class="form-label text-primary"><h5>Hora Inicio</h5></label>
                                        <input id="txt_horainicio_nl${count_1}" name="txt_horainicio_nl[]" type="time" autocomplete="off" class="form-control form-control-sm hora-inicio" value="${detalle.horaini}" required>

                                    </div>
                                    <div class="col-sm-2  mb-2">
                                        <label for="txt_horafin_nl${count_1}" class="form-label text-primary"><h5>Hora fin</h5></label>
                                        <input id="txt_horafin_nl${count_1}" name="txt_horafin_nl[]" type="time" autocomplete="off" class="form-control form-control-sm hora-fin" value="${detalle.horafin}" required>
                                    </div>
                                    <div class="col-sm-2  mb-2">
                                        <label for="txt_duracion_nl${count_1}" class="form-label text-primary"><h5>Duración</h5></label>
                                        <input id="txt_duracion_nl${count_1}" name="duraciones[]" type="text" class="form-control form-control-sm duracion" value="${detalle.duracion}" required>
                                    </div>
                                    <div class="col-sm-1 d-flex align-items-center pt-3">--
                                    </div>
                                </div>
                            `;
                            count_1 = count_1 + 1;
                        });

                        $("#section_Horario").html(detallesHtml);
                        $("#tabla_primera").hide();
                        $("#modalGestion_cnl").modal("show");
                    } else {
                    }
                },
                error: function (error) {
                    console.log("Error", error);
                },
            });
        }
    );

    $("#tabla_detalleActividadesNl tbody").on(
        "click",
        ".deleteBtn_anl",
        function (e) {
            // borrar validaciones
            let idregistro = $(this).data("idactividad_cnl");
            confirmation_sweetAlert(
                "Deseas continuar?",
                "Se procederá a eliminar la Actividad",
                "warning"
            ).then(function (isConfirm) {
                if (isConfirm.value) {
                    // enviando el parametro de la data que se procede a delete
                    destroy_acnl(idregistro);
                } else {
                    console.log("Cancelado");
                }
            });
        }
    );

    function destroy_acnl(idregistro) {
        $.ajax({
            headers: { "X-CSRF-TOKEN": $('input[name="_token"]').val() },
            type: "DELETE",
            url: "/admin/carga_nl/docente/destroy_acnl/" + idregistro,
            beforeSend: function () {},
            success: function (data) {
                if (data.status == true) {
                    list_DetalleCnl($("#text_hidden_iddocente_f15").val());
                    notificaciontoast("info", data.mensaje, "Éxito!");
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    $("#tabla_detalleActividadesNl tbody").on(
        "click",
        ".deleteBtn_hnl",
        function (e) {
            // borrar validaciones
            let idregistro = $(this).data("iddetalle_actividad_cnl");
            confirmation_sweetAlert(
                "Deseas continuar?",
                "Se procederá a eliminar el horario de la Actividad",
                "warning"
            ).then(function (isConfirm) {
                if (isConfirm.value) {
                    // enviando el parametro de la data que se procede a delete
                    destroy_dacnl(idregistro);
                } else {
                    console.log("Cancelado");
                }
            });
        }
    );

    function destroy_dacnl(idregistro) {
        $.ajax({
            headers: { "X-CSRF-TOKEN": $('input[name="_token"]').val() },
            type: "DELETE",
            url: "/admin/carga_nl/docente/destroy_dacnl/" + idregistro,
            beforeSend: function () {},
            success: function (data) {
                if (data.status == true) {
                    list_DetalleCnl($("#text_hidden_iddocente_f15").val());
                    notificaciontoast("info", data.mensaje, "Éxito!");
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }