var options = {
    title: {
        text: "2025",
        align: "center",
        style: { fontSize: "15px", fontWeight: 600, color: "#000" },
    },
    xaxis: {
        type: "category",
        labels: { style: { fontSize: "12px" } },
    },
    yaxis: {
        title: {
            text: "Monto (S/)",
            style: { fontSize: "14px", fontWeight: 600, color: "#000" },
        },
        labels: {
            formatter: (value) => "S/ " + value.toLocaleString("es-PE"),
        },
    },
    series: [],
    chart: {
        type: "line",
        height: 350,
        width: "100%",
        toolbar: {
            show: true,
            tools: {
                download: true,
                selection: false,
                zoom: false,
                zoomin: false,
                zoomout: false,
                pan: false,
                reset: false,
            },
            export: {
                csv: { filename: "recaudacion_mensual" },
                svg: { filename: "recaudacion_mensual" },
                png: { filename: "recaudacion_mensual" },
            },
        },
    },
    stroke: { curve: "smooth", width: 3 },
    dataLabels: { enabled: false },

    tooltip: {
        y: {
            formatter: (val) => "S/ " + val.toLocaleString("es-PE"),
        },
    },
    legend: {
        position: "top",
        horizontalAlign: "right",
    },
    colors: ["#06c788", "#0198ea"],
};

var chart = new ApexCharts(
    document.querySelector("#recaudacion_meses"),
    options
);
chart.render();

fetch("/home/dashboard/getRecaudacionPorMes")
    .then((res) => res.json())
    .then((data) => {
        const recaudado = data.map((item) => ({
            x: item.mes_nombre,
            y: item.recaudado,
        }));
        const porCobrar = data.map((item) => ({
            x: item.mes_nombre,
            y: item.por_cobrar,
        }));

        chart.updateSeries([
            { name: "Recaudado", data: recaudado },
            { name: "Por cobrar", data: porCobrar },
        ]);
    })
    .catch((err) => console.error("Error cargando datos:", err));

window.addEventListener("resize", () => chart.render());
