var options = {
    title: {
        text: "2025",
        align: "center",
        style: { fontSize: "15px", fontWeight: 600, color: "#000" },
    },
    xaxis: {
        categories: [],
        labels: {
            style: {
                fontSize: "12px",
                colors: "#000", // texto negro
            },
        },
    },
    yaxis: {
        title: {
            text: "Monto (S/)",
            style: { fontSize: "14px", fontWeight: 600, color: "#000" },
        },
        labels: {
            formatter: (val) => "S/ " + val.toLocaleString("es-PE"),
            // style: { colors: "#000" },
        },
    },
    series: [],
    chart: {
        type: "bar",
        height: 350,
        width: "100%",
        toolbar: {
            show: true,
            tools: {
                download: true,
                selection: false,
                zoom: false,
                zoomin: false,
                zoomout: false,
                pan: false,
                reset: false,
            },
            export: {
                csv: { filename: "recaudacion_conceptos" },
                svg: { filename: "recaudacion_conceptos" },
                png: { filename: "recaudacion_conceptos" },
            },
        },
    },
    plotOptions: {
        bar: {
            horizontal: false,
            columnWidth: "55%",
            borderRadius: 6,
            borderRadiusApplication: "end",
        },
    },
    dataLabels: { enabled: false },
    stroke: {
        show: true,
        width: 2,
        colors: ["transparent"],
    },
    tooltip: {
        y: {
            formatter: (val) => "S/ " + val.toLocaleString("es-PE"),
        },
    },
    legend: {
        position: "top",
        horizontalAlign: "right",
        labels: { colors: "#000" },
    },
    colors: ["#4CAF50", "#FFC107"],
};

var chart = new ApexCharts(
    document.querySelector("#recaudacion_conceptos"),
    options
);

chart.render();

fetch("/home/dashboard/getRecaudacionPorConcepto")
    .then((res) => res.json())
    .then((data) => {
        const categorias = data.map((item) => item.concepto);
        const recaudado = data.map((item) => Number(item.recaudado));
        const porCobrar = data.map((item) => Number(item.por_cobrar));

        // eje X
        chart.updateOptions({
            xaxis: { categories: categorias },
        });

        // datos
        chart.updateSeries([
            { name: "Recaudado", data: recaudado },
            { name: "Por cobrar", data: porCobrar },
        ]);
    })
    .catch((err) => console.error("Error cargando datos:", err));

window.addEventListener("resize", () => chart.render());
