window.addEventListener("DOMContentLoaded", async () => {
    const getStats = async () => {
        try {
            const response = await fetch("/home/dashboard/getStats");
            if (!response.ok)
                throw new Error("Error al obtener datos del servidor");

            const data = await response.json();

            updateDashboard(data);
        } catch (error) {
            console.error("Error en getStats:", error);
        }
    };

    const updateDashboard = (data) => {
        const map = {
            estudiantes: "total_estudiantes",
            docentes: "total_docentes",
            programas: "total_programas",
            administradores: "total_administradores",
        };

        data.forEach((item) => {
            const elementId = map[item.tipo];
            if (elementId) {
                const element = document.getElementById(elementId);
                if (element) element.textContent = item.cantidad;
            }
        });
    };

    // Ejecutar al cargar la página
    await getStats();
});
