var options = {
    title: {
        text: "2025",
        align: "center",
        style: { fontSize: "15px", fontWeight: 600, color: "#000" },
    },
    xaxis: {
        categories: [],
        labels: {
            style: {
                fontSize: "12px",
                colors: "#000",
            },
        },
    },
    yaxis: {
        title: {
            text: "Cantidad de estudiantes",
            style: { fontSize: "14px", fontWeight: 600, color: "#000" },
        },
        labels: {
            style: { colors: "#000" },
        },
    },
    series: [],
    chart: {
        type: "bar",
        height: 350,
        width: "100%",
        stacked: true,
        toolbar: {
            show: true,
            tools: {
                download: true,
                selection: false,
                zoom: false,
                zoomin: false,
                zoomout: false,
                pan: false,
                reset: false,
            },
            export: {
                csv: { filename: "estudiantes_programas" },
                svg: { filename: "estudiantes_programas" },
                png: { filename: "estudiantes_programas" },
            },
        },
    },
    plotOptions: {
        bar: {
            horizontal: false,
            columnWidth: "55%",
            borderRadius: 6,
            borderRadiusApplication: "end",
            dataLabels: {
                total: {
                    enabled: true,
                    style: {
                        fontSize: "13px",
                        fontWeight: 700,
                        color: "#000",
                    },
                },
            },
        },
    },
    dataLabels: { enabled: false },
    stroke: {
        show: true,
        width: 2,
        colors: ["transparent"],
    },
    tooltip: {
        y: {
            formatter: (val) => val + " estudiantes",
        },
    },
    legend: {
        position: "top",
        horizontalAlign: "right",
        labels: { colors: "#000" },
    },
    colors: ["#2196F3", "#E91E63", "#9C27B0"], // masculino, femenino, otros
    fill: { opacity: 1 },
};

var chart = new ApexCharts(
    document.querySelector("#estudiantes_programas"),
    options
);

chart.render();

fetch("/home/dashboard/getEstudiantesPrograma")
    .then((res) => res.json())
    .then((data) => {
        const categorias = data.map((item) => item.programa);
        const masculino = data.map((item) => Number(item.masculino));
        const femenino = data.map((item) => Number(item.femenino));
        const otros = data.map((item) => Number(item.otros));

        // eje X
        chart.updateOptions({
            xaxis: { categories: categorias },
        });

        // series apiladas
        chart.updateSeries([
            { name: "Masculino", data: masculino },
            { name: "Femenino", data: femenino },
            { name: "Otro", data: otros },
        ]);
    })
    .catch((err) => console.error("Error cargando datos:", err));

window.addEventListener("resize", () => chart.render());
