var options = {
    title: {
        text: "Histórico",
        align: "center",
        style: { fontSize: "15px", fontWeight: 600, color: "#000" },
    },
    xaxis: {
        categories: [],
        labels: { style: { fontSize: "12px", colors: "#000" } },
    },
    yaxis: {
        title: {
            text: "Total de egresados",
            style: { fontSize: "14px", fontWeight: 600, color: "#000" },
        },
        labels: { style: { colors: "#000" } },
    },
    series: [],
    chart: {
        type: "line",
        height: 350,
        width: "100%",
        toolbar: {
            show: true,
            tools: {
                download: true,
                selection: false,
                zoom: false,
                zoomin: false,
                zoomout: false,
                pan: false,
                reset: false,
            },
            export: {
                csv: { filename: "egresados_por_anho" },
                svg: { filename: "egresados_por_anho" },
                png: { filename: "egresados_por_anho" },
            },
        },
    },
    stroke: { curve: "smooth", width: 3 },
    dataLabels: { enabled: false },
    tooltip: {
        y: { formatter: (val) => val + " egresados" },
    },
    legend: {
        show: false, // no hay multiples series
    },
    colors: ["#4CAF50"],
};

var chart = new ApexCharts(document.querySelector("#egresados_anho"), options);
chart.render();

fetch("/home/dashboard/getEgresadosAnho")
    .then((res) => res.json())
    .then((data) => {
        const anhos = data.map((item) => item.anho_egreso);
        const totales = data.map((item) => Number(item.total_egresados));

        chart.updateOptions({
            xaxis: { categories: anhos },
        });

        chart.updateSeries([
            {
                name: "Egresados",
                data: totales,
            },
        ]);
    })
    .catch((err) => console.error("Error cargando datos:", err));

window.addEventListener("resize", () => chart.render());
