import { notificaciontoast } from "../../common/method_toast.js";
import { confirmation_sweetAlert } from "../../common/method_sweetAlert.js";
import { getButtonsSchema, languageSchema } from "../../common/schemas.js";

$(document).ready(function () {

    const tableName = "Estudiantes";

    var dt_idsemester = "all", dt_idprogram = "all", dt_idplan = "all";

    let table=$("#datatableGeneral").DataTable({
        createdRow: function (row, data, index) {
            $(row).addClass("selected");
        },
        order: [],
        ajax: {
            headers: { "X-CSRF-TOKEN": $('input[name="_token"]').val() },
            type: "POST",
            url: "/admin/consulta/primeros_puestos/list",
            data: function (d) {
                d.idsemester = dt_idsemester,
                d.idprogram = dt_idprogram,
                d.idplan = dt_idplan
            },
        },
        searching: false,
        paging: true,
        info: false,
        pageLength: 10,
        select: false,
        lengthChange: false,
        responsive: true,
        language: languageSchema,
        columns: [
            { data: "idstudent", className: "text-center" },
            { data: "programa", className: "text-center" },
            { data: "plan", className: "text-center" },
            { data: "estudiante", className: "text-center" },
            { data: "idstudent", sortable: false, className: "text-center",
                render: function (data, type, all, meta) {
                    return `
                    <div class="d-flex justify-content-center">
                        <a href="javascript:void(0);" class="btnViewEvaluations btn btn-success shadow btn-xs sharp"
                            data-idstudent="${all.idstudent}"
                            data-bs-placement="top"
                            title="Ver Evaluaciones">
                            <i class="fa-solid fa-eye fa-fade fa-xl"></i>
                        </a>
                    </div>
                    `;
                },
            },
            { data: "promedio_general", className: "text-center",
                render: function (data, type, all, meta) {
                    return all.promedio_general ?? '--';
                },
            },
        ],
        // rowsGroup: [
        //     'primero:name',
        //     'segundo:name',
        // ],
    });


    cb_semesters();
    function cb_semesters() {
        $("#txt-semesters").find("option").remove().end() // delete options
        $.ajax({
            type: "GET",
            url: '/ajax_all/semesters',
            dataType: 'json',
            beforeSend: function () { },
            success: function (response) {
                $("#txt-semesters").append('<option selected disabled value="">Seleccione periodo lectivo</option>');
                response.forEach((elemento) => {
                    $("#txt-semesters").append('<option' +
                        ' value="' + elemento.id + '" ' +
                        ' data-anho="' + elemento.anho + '" ' +
                        ' data-numero="' + elemento.numero + '" ' +
                        ' data-fecinicio="' + elemento.fecinicio + '" ' +
                        ' data-fecfin="' + elemento.fecfin + '" ' +
                        '>' + elemento.anho + " - " + elemento.numero + '</option>');
                })
                $("#txt-semesters").selectpicker("refresh");
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    // INICIO - SELECCIONAR PROGRAMA
    $(document).on("change", "#txt-semesters", function (e) {
        dt_idsemester = ($(this).val());
        table.ajax.reload();
    });
    // FIN - SELECCIONAR PROGRAMA

    cb_programs();
    function cb_programs() {
        $("#txt-programs").find("option").remove().end() // delete options
        $.ajax({
            type: "GET",
            url: '/ajax_all/programs',
            dataType: 'json',
            beforeSend: function () { },
            success: function (response) {
                $("#txt-programs").append('<option selected disabled value="">Seleccione una opción</option>');
                response.forEach((elemento) => {
                    $("#txt-programs").append('<option ' +
                        'value="' + elemento.id + '"' +
                        'data-codprograma="' + elemento.codprograma + '"' +
                        'data-nombre="' + elemento.nombre + '"' +
                        'data-nivel_formativo="' + elemento.nivel_formativo + '"' +
                        ' >' + elemento.nombre + '</option>');
                })
                $("#txt-programs").selectpicker("refresh");
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    // INICIO - SELECCIONAR PROGRAMA
    $(document).on("change", "#txt-programs", function (e) {
        dt_idprogram = ($(this).val());
        table.ajax.reload();
        cb_plans($(this).val());
    });
    // FIN - SELECCIONAR PROGRAMA

    function cb_plans(idprogram) {
        $("#txt-plans").find("option").remove().end() // delete options
        $.ajax({
            type: "GET",
            url: '/ajax_all/plans/' + idprogram,
            dataType: 'json',
            beforeSend: function () { },
            success: function (response) {
                $("#txt-plans").append('<option selected disabled value="">Seleccione una opción</option>');
                response.forEach((elemento) => {
                    $("#txt-plans").append('<option ' +
                        ' value="' + elemento.id + '"' +
                        ' data-nombre="' + elemento.nombre + '"' +
                        ' data-tipo="' + elemento.tipo + '"' +
                        ' data-modalidad="' + elemento.modalidad + '"' +
                        ' data-enfoque="' + elemento.enfoque + '"' +
                        ' >' + elemento.nombre + " - " + elemento.tipo + '</option>');
                })
                $("#txt-plans").selectpicker("refresh");
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    // INICIO - SELECCIONAR PLAN
    $(document).on("change", "#txt-plans", function (e) {
        dt_idplan = ($(this).val());
        table.ajax.reload();
    });
    // FIN - SELECCIONAR PLAN

    var valbtn, formCheck, formModal;

    // INICIO - MODAL VER Curso
    $("#datatableGeneral tbody").on("click", ".btnViewEvaluations", function (e) {
        dt_idsubject = $(this).data("idsubject");
        document.getElementById("modalDetalleNotasLabel").innerHTML = "Detalle notas del alumno: " + $(this).data("estudiante")
        // cargar tabla
        table_evaluations.ajax.reload();
        setTimeout(function () { $("#modalDetalleNotas").modal("show"); }, 500); // mostrar despues de x sec
        // mostrar modal
    });
    // FIN - MODAL VER Curso
});
