import { notificaciontoast } from "../../common/method_toast.js";
import { confirmation_sweetAlert } from "../../common/method_sweetAlert.js";
import { getButtonsSchema, languageSchema } from "../../common/schemas.js";

$(document).ready(function () {

    const tableName = "Estudiantes";
    var dt_idplan = "0";
    
    var dt_idStudent = 0;
    
    let table1=$("#datatableGeneral1").DataTable({
        createdRow: function (row, data, index) {
            $(row).addClass("selected");
        },
        order: [],
        ajax: {
            headers: { "X-CSRF-TOKEN": $('input[name="_token"]').val() },
            type: "POST",
            url: "/admin/consulta/indicadores_gestion/tasa_finalizacion",
        },
        searching: false,
        paging: true, // Deshabilita la paginación
        info: false, // Oculta la información de entradas
        pageLength: 80, // 12 filas
        select: false,
        lengthChange: false,
        responsive: true,
        language: languageSchema,
        columns: [
            { data: "semestre", className: "text-center", name: "primero"},
            { data: "programa", className: "text-center"},
            { data: "cantidad", className: "text-center",
                render: function (data, type, all, meta) {
                    return all.cantidad + ' (' + all.porcentaje + '%)';
                },
            },
            // { data: "accion", className: "text-center", sortable: false,
            //     render: function (data, type, all, meta) {
            //         return `
            //             <div class="d-flex justify-content-center">
            //                 <a href="/reportes/actas_oficiales/matricula/${all.idsemester}/${all.idperiod}" class="btn btn-primary shadow btn-xs me-2" target="_blank"
            //                     data-bs-placement="top"
            //                     title="Generar Acta">
            //                     Generar Acta
            //                 </a>
            //             </div>
            //             `;
            //     },
            // },
        ],
        rowGroup: {
            dataSrc: 'semestre', // Agrupa por "semestre" directamente
        },
    });

    let table2=$("#datatableGeneral2").DataTable({
        createdRow: function (row, data, index) {
            $(row).addClass("selected");
        },
        order: [],
        ajax: {
            headers: { "X-CSRF-TOKEN": $('input[name="_token"]').val() },
            type: "POST",
            url: "/admin/consulta/indicadores_gestion/tasa_abandono",
        },
        searching: false,
        paging: true, // Deshabilita la paginación
        info: false, // Oculta la información de entradas
        pageLength: 80, // 12 filas
        select: false,
        lengthChange: false,
        responsive: true,
        language: languageSchema,
        columns: [
            { data: "semestre", className: "text-center", name: "segundo"},
            { data: "programa", className: "text-center"},
            { data: "cantidad", className: "text-center",
                render: function (data, type, all, meta) {
                    return all.cantidad + ' (' + all.porcentaje + '%)';
                },
            },
            // { data: "accion", className: "text-center", sortable: false,
            //     render: function (data, type, all, meta) {
            //         return `
            //             <div class="d-flex justify-content-center">
            //                 <a href="/reportes/actas_oficiales/matricula/${all.idsemester}/${all.idperiod}" class="btn btn-primary shadow btn-xs me-2" target="_blank"
            //                     data-bs-placement="top"
            //                     title="Generar Acta">
            //                     Generar Acta
            //                 </a>
            //             </div>
            //             `;
            //     },
            // },
        ],
        rowGroup: {
            dataSrc: 'semestre', // Agrupa por "semestre" directamente
        },
    });
});
