import { notificaciontoast } from "../../common/method_toast.js";
import { confirmation_sweetAlert } from "../../common/method_sweetAlert.js";
import { getButtonsSchema, languageSchema } from "../../common/schemas.js";

$(document).ready(function () {

    const tableName = "Estudiantes";
    var dt_idplan = "0";

    var dt_idStudent = 0;

    let tableRecordAcademico = $("#datatableGeneralRecordAcademico").DataTable({
        createdRow: function (row, data, index) {
            $(row).addClass("selected");
        },
        order: [],
        ajax: {
            headers: { "X-CSRF-TOKEN": $('input[name="_token"]').val() },
            type: "POST",
            url: "/admin/seguimiento_egresado/record_academico/list",
            data: function (d) {
                d.idStudent = dt_idStudent;
            },
        },
        searching: false,
        paging: true,
        info: false,
        pageLength: 80,
        select: false,
        lengthChange: false,
        responsive: true,
        language: languageSchema,
        columns: [
            // { data: "estudiante_id", className: "text-center" },
            // { data: "plan", className: "text-center"},
            // { data: "modulo", className: "text-center", name: "primero" },
            {
                data: "numero_modulo", className: "text-center", name: "primero",
                render: function (data, type, all, meta) {
                    return `<div style='white-space: pre-wrap; word-wrap: break-word; word-break: break-word; width: 150px;'>
                                <h5>Modulo Formativo ${all.numero_modulo}</h5>
                                <b>Codigo Modular:</b> ${all.codigo_modulo}<br>
                                <b>Descripcion:</b> ${all.descripcion_modulo}
                            </div>
                            <div style="margin-top: 10px; display: flex; justify-content: center; align-items: center;">
                                <a href="/reportes/certificado_modular/${all.idstudent}/${all.idmodulo}" class="btn btn-info shadow btn-xs sharp me-2" target="_blank"
                                    data-idstudent="${all.idstudent}"
                                    data-idmodulo="${all.idmodulo}"
                                    data-bs-placement="top"
                                    title="Ver Record Académico">
                                    <i class="fa-solid fa-graduation-cap fa-xl"></i>
                                </a>
                            </div>
                            `;
                },
            },
            {
                data: "periodo", className: "text-center", name: "segundo",
                render: function (data, type, all, meta) {
                    return "<div>" +
                        "<h4>" + all.periodo + "</h4>" +
                        "</div>";
                },
            },
            { data: "codcurso", className: "text-center" },
            { data: "nombre_curso", className: "text-center" },
            { data: "creditos", className: "text-center" },
            { data: "horas", className: "text-center" },
            { data: "semestre", className: "text-center" },
            {
                data: "promedio_final", className: "text-center",
                render: function (data, type, all, meta) {
                    return all.promedio_final ?? '--';
                },
            },
            { data: "estado", className: "text-center" },
        ],
        rowsGroup: [
            'primero:name',
            'segundo:name',
        ],
    });

    // INICIO - MODAL
    $("tbody").on("click", ".btnVerRecordAcademico", function (e) {
        // setear data de idstudent
        const idStudent = $(this).data("idstudent")
        dt_idStudent = idStudent
        // cargar tabla
        tableRecordAcademico.ajax.reload();
    });
    // FIN - MODAL

    // FICHA SOCIOECONOMICA - INICIO
    $("tbody").on("click", ".btnInfoFicha", function (e) {
        // setear data de idstudent
        const idStudent = $(this).data("idstudent")
        dt_idStudent = idStudent;
        // show form
        setTimeout(function () { $("#modalFichaSocioeconomica").modal("show"); }, 500);
    });

    // FICHA SOCIOECONOMICA - FIN

    cb_programs();
    function cb_programs() {
        $("#txt-programs").find("option").remove().end()
        $.ajax({
            type: "GET",
            url: '/ajax_all/programs',
            dataType: 'json',
            beforeSend: function () { },
            success: function (response) {
                $("#txt-programs").append('<option selected disabled value="">Seleccione una opción</option>');
                response.forEach((elemento) => {
                    $("#txt-programs").append('<option ' +
                        'value="' + elemento.id + '"' +
                        'data-codprograma="' + elemento.codprograma + '"' +
                        'data-nombre="' + elemento.nombre + '"' +
                        'data-nivel_formativo="' + elemento.nivel_formativo + '"' +
                        ' >' + elemento.nombre + '</option>');
                })
                $("#txt-programs").selectpicker("refresh");
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    // INICIO - SELECCIONAR PROGRAMA
    $(document).on("change", "#txt-programs", function (e) {
        cb_plans($(this).val());
    });
    // FIN - SELECCIONAR PROGRAMA

    function cb_plans(idprogram) {
        $("#txt-plans").find("option").remove().end()
        $.ajax({
            type: "GET",
            url: '/ajax_all/plans/' + idprogram,
            dataType: 'json',
            beforeSend: function () { },
            success: function (response) {
                $("#txt-plans").append('<option selected disabled value="">Seleccione una opción</option>');
                response.forEach((elemento) => {
                    $("#txt-plans").append('<option ' +
                        ' value="' + elemento.id + '"' +
                        ' data-nombre="' + elemento.nombre + '"' +
                        ' data-tipo="' + elemento.tipo + '"' +
                        ' data-modalidad="' + elemento.modalidad + '"' +
                        ' data-enfoque="' + elemento.enfoque + '"' +
                        ' >' + elemento.nombre + " - " + elemento.tipo + '</option>');
                })
                $("#txt-plans").selectpicker("refresh");
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    // INICIO - SELECCIONAR PLAN
    $(document).on("change", "#txt-plans", function (e) {
        dt_idplan = ($(this).val());
        cb_students(dt_idplan);
    });

    function cb_students(idplan) {
        $("#txt-students").find("option").remove().end() // delete options
        $.ajax({
            type: "GET",
            url: '/admin/consulta/constancias_certificados/list_estudiantes/' + idplan,
            dataType: 'json',
            beforeSend: function () { },
            success: function (response) {
                console.log("Esta bien");
                $("#txt-students").append('<option selected disabled value="">Seleccione una opción</option>');
                response.forEach((elemento) => {
                    $("#txt-students").append('<option ' +
                        ' value="' + elemento.idstudent + '"' +
                        ' data-idstudent="' + elemento.idstudent + '"' +
                        ' data-nroidenti="' + elemento.nroidenti + '"' +
                        ' data-estudiante="' + elemento.estudiante + '"' +
                        ' >' + elemento.nroidenti + " - " + elemento.estudiante + '</option>');
                })
                $("#txt-students").selectpicker("refresh");
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    // INICIO - SELECCIONAR PLAN
    $(document).on("change", "#txt-students", function (e) {
        dt_idStudent = ($(this).val());
        tableRecordAcademico.ajax.reload();
    });
    // FIN - SELECCIONAR PLAN

    $(document).on("click", "#btnCertificadoEstudios", function () {
        setTimeout(function () { window.open('/reportes/certificado_general/' + dt_idStudent, '_blank'); }, 2000);
    });

    $(document).on("click", "#btnConstanciaEgresado", function () {
        setTimeout(function () { window.open('/reportes/constancia_egresado/' + dt_idStudent, '_blank'); }, 2000);
    });

    $(document).on("click", "#btnRecordNotas", function () {
        setTimeout(function () { window.open('/reportes/record_notas/' + dt_idStudent, '_blank'); }, 2000);
    });

    $(document).on("click", "#btnDiplomaEstudios", function () {
        setTimeout(function () { window.open('/reportes/diploma_estudios/' + dt_idStudent, '_blank'); }, 2000);
    });


    //Cetificado Modular - Especial - INICIO
    $('#datatableGeneralRecordAcademico tbody').on('click', 'a[href*="/reportes/certificado_modular/"]', function (e) {
        e.preventDefault();

        const certificateUrl = $(this).attr('href');


        $('#certificateIframe').attr('src', certificateUrl);
        $('#downloadCertificateBtn').attr('href', certificateUrl);

        $('#certificateModal').modal('show');
    });
    $('#certificateModal').on('hidden.bs.modal', function () {
        // Limpia el iframe para que no muestre el PDF anterior la próxima vez que se abra
        $('#certificateIframe').attr('src', 'about:blank');
    });
    //Cetificado Modular - Especial - FIN

    /*******************************************************************************************************
                                     Validaciones(Descomentar para usar)
     *******************************************************************************************************/

    /*
function validarCertificadoModular(event) {
        event.preventDefault(); // Detiene la navegación normal del enlace

        const $buttonLink = $(event.currentTarget);
        const studentId = $buttonLink.data('idstudent');
        const moduloId = $buttonLink.data('idmodulo');
        const urlReporte = `/reportes/certificado_modular/${studentId}/${moduloId}`;
        const originalIconHtml = $buttonLink.html();

        $buttonLink.html('<span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>');
        $buttonLink.addClass('disabled');

        // NOTA: Para desactivar la validación temporalmente, puedes comentar la línea 'url'
        // y el sistema asumirá que la respuesta es exitosa, mostrando el modal directamente.
        $.ajax({
            url: `/reportes/validar-certificado-modular/${studentId}/${moduloId}`,
            type: 'GET',
            dataType: 'json',
            success: function (response) {
                if (response.status) {

                    // ===== ¡AQUÍ ESTÁ LA CORRECCIÓN! =====
                    // En lugar de abrir una nueva ventana, hacemos esto:

                    // 1. Ponemos la URL del certificado en el iframe del modal.
                    $('#certificateIframe').attr('src', urlReporte);

                    // 2. Ponemos la misma URL en el botón de descarga.
                    $('#downloadCertificateBtn').attr('href', urlReporte);

                    // 3. Mostramos el modal.
                    $('#certificateModal').modal('show');

                    // =======================================

                } else {
                    // Si la validación falla, muestra el error.
                    let errorHtml = '<div class="text-start">';
                    if (response.errors && Array.isArray(response.errors.academic)) {
                        errorHtml += '<h5><i class="fa-solid fa-graduation-cap text-warning me-2"></i>Observaciones Académicas:</h5>';
                        errorHtml += '<ul class="list-unstyled ps-4">';
                        response.errors.academic.forEach(reason => {
                            errorHtml += `<li>- ${reason}</li>`;
                        });
                        errorHtml += '</ul>';
                    }
                    errorHtml += '</div>';

                    Swal.fire({
                        icon: 'error',
                        title: 'No se puede generar el certificado',
                        html: errorHtml,
                    });
                }
            },
            error: function () {
                // Este bloque se ejecutará si la ruta de validación no existe o falla.
                // Para probar sin validación, podemos asumir que fue exitoso y mostrar el modal.
                console.warn("Ruta de validación no encontrada o falló. Mostrando el certificado directamente.");

                $('#certificateIframe').attr('src', urlReporte);
                $('#downloadCertificateBtn').attr('href', urlReporte);
                $('#certificateModal').modal('show');
            },
            complete: function () {
                // Restaura el botón a su estado original.
                $buttonLink.html(originalIconHtml);
                $buttonLink.removeClass('disabled');
            }
        });
    }
    */

    // Función reutilizable que valida ANTES de abrir la URL del certificado
    // ===== INICIO: NUEVA LÓGICA CORRECTA CON VALIDACIÓN Y SWEETALERT =====

    // Función reutilizable que valida ANTES de abrir la URL del certificado
    // ===== INICIO: FUNCIÓN CORREGIDA CON VERIFICACIÓN DE ARRAYS =====
    /*
        function validarYGenerar(event, urlCertificado) {
            event.preventDefault();

            if (!dt_idStudent || dt_idStudent == "0") {
                Swal.fire({
                    icon: 'warning',
                    title: 'Seleccione un estudiante',
                    text: 'Por favor, elija un estudiante de la lista.'
                });
                return;
            }

            const $button = $(event.currentTarget);
            const originalHtml = $button.html();
            $button.html('<span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span> Verificando...').prop('disabled', true);

            $.ajax({
                url: '/reportes/validar-certificado/' + dt_idStudent,
                type: 'GET',
                dataType: 'json',
                success: function (response) {
                    if (response.status) {
                        window.open(urlCertificado, '_blank');
                    } else {
                        let errorHtml = '<div class="text-start">';

                        // *** INICIO DE LA CORRECCIÓN ***
                        // Verificamos si EXISTEN errores financieros Y si es un Array con contenido
                        if (response.errors && Array.isArray(response.errors.financial) && response.errors.financial.length > 0) {
                            errorHtml += '<h5><i class="fa-solid fa-file-invoice-dollar text-danger me-2"></i>Validación Financiera:</h5>';
                            errorHtml += '<ul class="list-unstyled ps-4">';
                            response.errors.financial.forEach(reason => {
                                errorHtml += `<li>- ${reason}</li>`;
                            });
                            errorHtml += '</ul>';
                        }

                        // Verificamos si EXISTEN errores académicos Y si es un Array con contenido
                        if (response.errors && Array.isArray(response.errors.academic) && response.errors.academic.length > 0) {
                            errorHtml += '<h5 class="mt-3"><i class="fa-solid fa-graduation-cap text-warning me-2"></i>Validación Académica:</h5>';
                            errorHtml += '<ul class="list-unstyled ps-4">';
                            response.errors.academic.forEach(reason => {
                                errorHtml += `<li>- ${reason}</li>`;
                            });
                            errorHtml += '</ul>';
                        }
                        // *** FIN DE LA CORRECCIÓN ***

                        errorHtml += '</div>';

                        Swal.fire({
                            icon: 'error',
                            title: 'No se puede generar el documento',
                            html: errorHtml,
                            confirmButtonColor: '#3085d6',
                            confirmButtonText: 'Entendido'
                        });
                    }
                },
                error: function () {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error Inesperado',
                        text: 'Ocurrió un problema al validar los requisitos.'
                    });
                },
                complete: function () {
                    $button.html(originalHtml).prop('disabled', false);
                }
            });
        }

        // 5. Asignamos la función a cada uno de los botones principales
        $(document).on("click", "#btnCertificadoEstudios", function (e) {
            validarYGenerar(e, '/reportes/certificado_general/' + dt_idStudent);
        });

        $(document).on("click", "#btnConstanciaEgresado", function (e) {
            validarYGenerar(e, '/reportes/constancia_egresado/' + dt_idStudent);
        });

        $(document).on("click", "#btnRecordNotas", function (e) {
            validarYGenerar(e, '/reportes/record_notas/' + dt_idStudent);
        });

        $(document).on("click", "#btnDiplomaEstudios", function (e) {
            validarYGenerar(e, '/reportes/diploma_estudios/' + dt_idStudent);
        });

        // 6. Manejo especial para el botón del certificado modular (que está dentro de la tabla)
        $('#datatableGeneralRecordAcademico tbody').on('click', 'a[href*="/reportes/certificado_modular/"]', function (e) {
            const studentId = $(this).data('idstudent');
            const moduloId = $(this).data('idmodulo');
            const url = `/reportes/certificado_modular/${studentId}/${moduloId}`;

            // Llamamos a la función de validación pasándole la URL correcta
            validarYGenerar(e, url);
        });

        // ===== FIN: NUEVA LÓGICA =====
    */
});
