import { notificaciontoast } from "../../common/method_toast.js";
import { confirmation_sweetAlert } from "../../common/method_sweetAlert.js";
import { getButtonsSchema, languageSchema } from "../../common/schemas.js";

$(document).ready(function () {

    const tableName = "Estudiantes";
    var dt_idplan = "0";

    var dt_idsemester = 0;

    let table = $("#datatableGeneral").DataTable({
        createdRow: function (row, data, index) {
            $(row).addClass("selected");
        },
        order: [],
        ajax: {
            headers: { "X-CSRF-TOKEN": $('input[name="_token"]').val() },
            type: "POST",
            url: "/admin/consulta/actas_oficiales/list_periodos",
            data: function (d) {
                d.idsemester = dt_idsemester;
            },
        },
        searching: false,
        paging: true, // Deshabilita la paginación
        info: false, // Oculta la información de entradas
        pageLength: 50, // 12 filas
        select: false,
        lengthChange: false,
        responsive: true,
        language: languageSchema,
        columns: [
            { data: "programa", className: "text-center", name: "primero",
                render: function (data, type, all, meta) {
                    return `
                    <div style='white-space: pre-wrap; word-wrap: break-word; word-break: break-word;   '>
                        <h5>${all.programa}</h5>
                    </div>
                    `;
                },
            },
            { data: "plan", className: "text-center", name: "segundo",
                render: function (data, type, all, meta) {
                    return `
                    <div>
                        <h5>${all.plan}</h5>
                    </div>
                    `;
                },
            },
            { data: "periodo", className: "text-center",
                render: function (data, type, all, meta) {
                    return `
                    <div>
                        <h5>Ciclo ${all.periodo}</h5>
                    </div>
                    `;
                },
            },
            { data: "accion", className: "text-center", sortable: false,
                render: function (data, type, all, meta) {
                    return `
                        <div class="d-flex justify-content-center">
                            <a href="/reportes/actas_oficiales/matricula/${all.idsemester}/${all.idperiod}" class="btn btn-primary shadow btn-xs me-2" target="_blank"
                                data-bs-placement="top"
                                title="Generar Acta">
                                Generar Acta
                            </a>
                        </div>
                        `;
                },
            },
        ],
        rowsGroup: [
            'primero:name',
            'segundo:name',
        ],
    });

    // INICIO - MODAL
    $(document).on("change", "#txt-semesters", function (e) {
        // setear data de idsemester
        dt_idsemester = $(this).val();
        // cargar tabla
        table.ajax.reload();
    });
    // FIN - MODAL
});
