"use strict";
import { notificaciontoast } from "../../common/method_toast.js";
import { confirmation_sweetAlert } from "../../common/method_sweetAlert.js";
import { getButtonsSchema, languageSchema } from "../../common/schemas.js";

$(document).ready(function () {
    const tableName = "Aulas ";
    var number = 0;
    // LISTAR DATATABLE
    var table = $("#datatableGeneral").DataTable({
        createdRow: function (row, data, index) {
            $(row).addClass("selected");
        },
        order: [],
        ajax: "/admin/citas_presenciales/gestionar/list",
        searching: true,
        dom: "Bfrtip",
        select: false,
        lengthChange: false,
        responsive: true,
        language: languageSchema,
        buttons: getButtonsSchema(tableName),
        columns: [
            { data: "id", className: "text-center" },
            { data: "fecha_hora", className: "text-center" },
            { data: "nroidenti", className: "text-center" },
            { data: "usuario1", className: "text-center" },
            { data: "datos_cita", className: "text-center" },
            { data: "estado", sortable: false, className: "text-center",
                render: function (data, type, all, meta) {
                    if (all.estado == "0") {
                        return `<span class="badge light badge-danger">No Atendido</span>`;
                    } else if (all.estado == "1") {
                        return `<span class="badge light badge-success">Atendido</span>`;
                    } 
                },
            },
            { data: "id", className: "text-center", sortable: false,
                render: function (data, type, all, meta) {
                    return `
                        <div class="d-flex justify-content-center">
                            <a href="javascript:void(0);" class="editBtn btn btn-warning shadow btn-xs sharp me-1"
                            data-id="${all.id}"
                            data-user2_id="${all.user2_id}"
                            data-nroidenti="${all.nroidenti}"
                            data-nombres="${all.nombres}"
                            data-apellido_pa="${all.apellido_pa}"
                            data-apellido_ma="${all.apellido_ma}"
                            data-email="${all.email}"
                            data-celular="${all.celular}"
                            data-asunto="${all.asunto}"
                            data-datos_cita="${all.datos_cita}"
                            data-fecha="${all.fecha}"
                            data-horaini="${all.horaini}"
                            data-horafin="${all.horafin}"
                            data-estado="${all.estado}"
                            data-bs-placement="top"
                            title="Editar registro">
                            <i class="fas fa-pencil-alt"></i>
                            </a>
                            
                            <a href="javascript:void(0);" class="deleteBtn btn btn-danger shadow btn-xs sharp"
                            data-id="${all.id}"
                            data-bs-placement="top"
                            title="Eliminar registro">
                            <i class="fas fa-trash"></i>
                            </a>
                        </div>
                    `;
                },
            },
        ],
    });

    // Agregar una columna de números automáticos
    table.on("order.dt search.dt", function () {
        table.column(0, { search: "applied", order: "applied" })
        .nodes().each(function (cell, i) { cell.innerHTML = i + 1; });
    }).draw();


    // - - - - - - - - - - M O D A L S - - - - - - - - - -
    // INICIO - MODAL CREATE
    $("#btnCreateModal").click(function () {
        // change value
        document.getElementById("btnCreateUpdate").setAttribute("value", "Create");
        document.getElementById("btnCreateUpdate").innerHTML = "Guardar";
        document.getElementById("modalCreateUpdateLabel").innerHTML = "Registrar datos de la cita";
        clearCheck(); // borrar validaciones
        Clearform();
    });
    // FIN - MODAL CREATE


    // INICIO - MODAL UPDATE
    $("#datatableGeneral tbody").on("click", ".editBtn", function (e) {
        clearCheck(); // borrar validaciones
        //cambiar el text del button
        document.getElementById("btnCreateUpdate").innerHTML = "Actualizar";
        document.getElementById("modalCreateUpdateLabel").innerHTML = "Actualizar datos de la cita";
        // setear data de cargo
        document.getElementById("txt-id").value = $(this).attr("data-id");
        document.getElementById("txt-nroidenti").value = $(this).attr("data-nroidenti");
        document.getElementById("txt-nombres").value = $(this).attr("data-nombres");
        document.getElementById("txt-apellido_pa").value = $(this).attr("data-apellido_pa");
        document.getElementById("txt-apellido_ma").value = $(this).attr("data-apellido_ma");
        document.getElementById("txt-email").value = $(this).attr("data-email");
        document.getElementById("txt-celular").value = $(this).attr("data-celular");
        document.getElementById("txt-asunto").value = $(this).attr("data-asunto");
        $("#txt-datos_cita").selectpicker("val", $(this).data("datos_cita"));
        document.getElementById("txt-fecha").value = $(this).attr("data-fecha");
        document.getElementById("txt-horaini").value = $(this).attr("data-horaini");
        document.getElementById("txt-horafin").value = $(this).attr("data-horafin");
        $("#txt-estado").selectpicker("val", "" + $(this).data("estado"));
        $("#txt-user2_id").selectpicker("val", "" + $(this).data("user2_id"));
        // show form
        $("#modalCreateUpdate").modal("show");
        // change value
        document.getElementById("btnCreateUpdate").setAttribute("value", "Update");
    });
    // FIN - MODAL UPDATE

    var valbtn, formCheck;
    // INICIO - FUNCION CREATE O UPDATE
    $("#btnCreateUpdate").on("click", function (event) {
        event.preventDefault();
        formCheck = $("#formModal")[0];
        if (!formCheck.checkValidity()) {
            event.preventDefault();
            event.stopPropagation();
            $(formCheck).addClass("was-validated"); // añadir validaciones
        } else {
            // obtener valor del boton
            valbtn = $("#btnCreateUpdate").val();
            // FUNCION CREAR
            if (valbtn === "Create") {
                // insertar tabla cargo
                store();
            }
            // FUNCION ACTUALIZAR
            if (valbtn === "Update") {
                // actualizar tabla cargo
                update();
            }
        }
    });
    // FIN - FUNCION CREATE O UPDATE

    // INICIO - MODAL DELETE
    $("#datatableGeneral tbody").on("click", ".deleteBtn", function (e) {
        var id = $(this).attr("data-id");
        // confirmacion
        confirmation_sweetAlert(
            "Deseas continuar?",
            "Se procederá a eliminar el registro de la base de datos",
            "warning"
        ).then(function (isConfirm) {
            if (isConfirm.value) {
                // enviando el parametro de la data que se procede a delete
                destroy(id);
            } else {
                console.log("Cancelado");
            }
        });
    });
    
    var formModal;
    
    cb_users1();
    function cb_users1() {
        let apenom;
        $("#txt-user2_id").find("option").remove().end() // delete options
        $.ajax({
            type: "GET",
            url: '/ajax_all/users/admin_docente',
            dataType: 'json',
            beforeSend: function () { },
            success: function (response) {
                $("#txt-user2_id").append('<option selected disabled value="">Buscar docente</option>');
                response.forEach((elemento) => {
                    apenom = elemento.apellido_pa + " " + elemento.apellido_ma + ", " + elemento.nombres;
                    $("#txt-user2_id").append('<option' +
                        ' value="' + elemento.iduser + '" ' +
                        ' data-subtext="' + elemento.nroidenti + '" ' +
                        '>' + apenom + '</option>');
                })
                $("#txt-user2_id").selectpicker("refresh");
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    // - - - - - - - - - - F U N C I O N E S - - - - - - - - - -
    function store() {
        formModal = $("#formModal");
        $.ajax({
            type: "POST",
            url: "/admin/citas_presenciales/gestionar/store",
            data: formModal.serialize(),
            dataType: "json",
            beforeSend: function () {},
            success: function (data) {
                if (data.status == true) {
                    table.ajax.reload();
                    formModal.addClass("was-validated"); // añadir validaciones
                    notificaciontoast("info", data.mensaje, "Éxito!");
                    setTimeout(function () {
                        $("#modalCreateUpdate").modal("hide");
                    }, 1000); // ocultar despues de 1 sec
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    function update() {
        formModal = $("#formModal");
        var id = document.getElementById("txt-id").value;
        var formData = $("#formModal").serialize();
        $.ajax({
            type: "PUT",
            url: "/admin/citas_presenciales/gestionar/update/" + id,
            data: formData,
            dataType: "json",
            beforeSend: function () {},
            success: function (data) {
                if (data.status == true) {
                    table.ajax.reload();
                    formModal.addClass("was-validated"); // añadir validaciones
                    notificaciontoast("info", data.mensaje, "Éxito!");
                    setTimeout(function () {
                        $("#modalCreateUpdate").modal("hide");
                    }, 1000); // ocultar despues de 1 sec
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    function destroy(id) {
        $.ajax({
            headers: { "X-CSRF-TOKEN": $('input[name="_token"]').val() },
            type: "DELETE",
            url: "/admin/citas_presenciales/gestionar/destroy/" + id,
            beforeSend: function () {},
            success: function (data) {
                if (data.status == true) {
                    notificaciontoast("info", data.mensaje, "Éxito!");
                    table.ajax.reload();
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    // LIMPIAR VALIDACIONES
    function clearCheck() {
        formCheck = $("#formModal")[0];
        $(formCheck).removeClass("was-validated"); // remover validaciones
    }

    // - - - - - - - - - - LIMPIAR CAMPOS - - - - - - - - - -
    function Clearform() {
        document.getElementById("txt-nroidenti").value = "";
        document.getElementById("txt-nombres").value = "";
        document.getElementById("txt-apellido_pa").value = "";
        document.getElementById("txt-apellido_ma").value = "";
        document.getElementById("txt-email").value = "";
        document.getElementById("txt-celular").value = "";
        document.getElementById("txt-asunto").value = "";
        $("#txt-datos_cita").selectpicker("val", "");
        document.getElementById("txt-fecha").value = "";
        document.getElementById("txt-horaini").value = "";
        document.getElementById("txt-horafin").value = "";
        $("#txt-user2_id").selectpicker("val", "");
        $("#txt-estado").selectpicker("val", "");
    }

    //Traer datos con el DNI desde la RENIEC
    $("#btn-querydata").on("click", function (event) {
        var nroidenti = $("#txt-nroidenti").val();
        $.ajax({
            type: "GET",
            url: '/admin/query_data/' + nroidenti,
            dataType: 'json',
            beforeSend: function () { },
            success: function (response) {
                const dataObj = JSON.parse(response.data);
                if (dataObj.hasOwnProperty('message')) {
                    console.log(dataObj.message);
                    notificaciontoast("error", "Datos del DNI no encontrado", "Error!", "top-center");
                } else {
                    $("#txt-nombres").val(convertirTexto(dataObj.nombres));
                    $("#txt-apellido_pa").val(convertirTexto(dataObj.apellidoPaterno));
                    $("#txt-apellido_ma").val(convertirTexto(dataObj.apellidoMaterno));

                    // setear data de programa
                    $("#txt-nombres").addClass("border border-info shadow");
                    $("#txt-apellido_pa").addClass("border border-info shadow");
                    $("#txt-apellido_ma").addClass("border border-info shadow");

                    setTimeout(function () {
                        $("#txt-nombres").removeClass("border border-info shadow");
                        $("#txt-apellido_pa").removeClass("border border-info shadow");
                        $("#txt-apellido_ma").removeClass("border border-info shadow");
                    }, 300);
                }
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    });

    function convertirTexto(texto) {
        // Convierte todo el texto a minúsculas
        texto = texto.toLowerCase();
        
        // Divide el texto en palabras
        var palabras = texto.split(' ');
        
        // Itera sobre cada palabra y capitaliza la primera letra
        for (var i = 0; i < palabras.length; i++) {
            palabras[i] = palabras[i].charAt(0).toUpperCase() + palabras[i].substring(1);
        }
        
        // Une las palabras de nuevo en un solo texto
        var resultado = palabras.join(' ');
        
        return resultado;
    }

});
