"use strict";
import { notificaciontoast } from "../../common/method_toast.js";
import { confirmation_sweetAlert } from "../../common/method_sweetAlert.js";
import { getButtonsSchema, languageSchema } from "../../common/schemas.js";

$(document).ready(function () {
    const tableName = "Tipos de Citas";
    var number = 0;
    // LISTAR DATATABLE
    var table = $("#datatableGeneral").DataTable({
        createdRow: function (row, data, index) {
            $(row).addClass("selected");
        },
        order: [],
        ajax: "/admin/centro_medico/citas/list",
        searching: true,
        dom: "Bfrtip",
        select: false,
        lengthChange: false,
        responsive: true,
        language: languageSchema,
        buttons: getButtonsSchema(tableName),
        columns: [
            { data: "idappointment", className: "text-center" },
            { data: "fecha_hora", className: "text-center" },
            { data: "tipo_cita", className: "text-center" },
            { data: "paciente", className: "text-center" },
            { data: "especialista", className: "text-center" },
            { data: "estado_cita", sortable: false, className: "text-center",
                render: function (data, type, all, meta) {
                    if (all.estado_cita == "0") {
                        return `<span class="badge light badge-danger">No Atendida</span>`;
                    } else if (all.estado_cita == "1") {
                        return `<span class="badge light badge-success">Atendida</span>`;
                    } else if (all.estado_cita == "2") {
                        return `<span class="badge light badge-dark">Cancelada</span>`;
                    }
                },
            },
            { data: "id", className: "text-center", sortable: false,
                render: function (data, type, all, meta) {
                    return `
                        <div class="d-flex justify-content-center">
                            <a href="javascript:void(0);" class="attentionBtn btn btn-success shadow btn-xs sharp me-1"
                                data-idappointment="${all.idappointment}"
                                data-diagnostico="${all.diagnostico}"
                                data-tratamiento="${all.tratamiento}"
                                data-observacion="${all.observacion}"
                                data-estado_atencion="${all.estado_atencion}"
                                data-bs-placement="top"
                                title="Atender Cita">
                                <i class="fas fa-solid fa-plus"></i>
                            </a>
                            
                            <a href="javascript:void(0);" class="editBtn btn btn-warning shadow btn-xs sharp me-1"
                            data-idappointment="${all.idappointment}"
                            data-idpatient="${all.idpatient}"
                            data-idspecialist="${all.idspecialist}"
                            data-idappointmenttype="${all.idappointmenttype}"
                            data-idclassroom="${all.idclassroom}"
                            data-descripcion="${all.descripcion}"
                            data-fecha="${all.fecha}"
                            data-hora_ini="${all.hora_ini}"
                            data-hora_fin="${all.hora_fin}"
                            data-motivo_cancelacion="${all.motivo_cancelacion}"
                            data-estado_cita="${all.estado_cita}"
                            data-bs-placement="top"
                            title="Editar registro">
                            <i class="fas fa-pencil-alt"></i>
                            </a>
                            
                            <a href="javascript:void(0);" class="deleteBtn btn btn-danger shadow btn-xs sharp"
                            data-idappointment="${all.idappointment}"
                            data-bs-placement="top"
                            title="Eliminar registro">
                            <i class="fas fa-trash"></i>
                            </a>
                        </div>
                    `;
                },
            },
        ],
    });

    // Agregar una columna de números automáticos
    table.on("order.dt search.dt", function () {
        table.column(0, { search: "applied", order: "applied" })
            .nodes()
            .each(function (cell, i) {
                cell.innerHTML = i + 1;
            });
    }).draw();

    cb_classrooms()
    function cb_classrooms() {
        $.ajax({
            type: "GET",
            url: "/ajax_all/classrooms",
            dataType: "json",
            beforeSend: function () {},
            success: function (response) {
                    $("#txt-classroom_id").append('<option selected disabled value="">Seleccione aula</option>');
                    response.forEach((elemento) => {
                        $("#txt-classroom_id").append('<option ' +
                            'value="' + elemento.id + '"' +
                            'data-tipo="' + elemento.tipo + '"' +
                            ' >' + elemento.tipo + ' - ' + elemento.numero + '</option>');
                    })
                    $("#txt-classroom_id").selectpicker("refresh");
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }
    
    cb_specialists();
    function cb_specialists() {
        let apenom;
        $("#txt-specialist_id").find("option").remove().end() // delete options
        $.ajax({
            type: "GET",
            url: '/ajax_all/users/admin_docente',
            dataType: 'json',
            beforeSend: function () { },
            success: function (response) {
                $("#txt-specialist_id").append('<option selected disabled value="">Selecciona una opción</option>');
                response.forEach((elemento) => {
                    apenom = elemento.apellido_pa + " " + elemento.apellido_ma + ", " + elemento.nombres;
                    $("#txt-specialist_id").append('<option' +
                        ' value="' + elemento.iduser + '" ' +
                        ' data-subtext="' + elemento.nroidenti + '" ' +
                        '>' + apenom + '</option>');
                })
                $("#txt-specialist_id").selectpicker("refresh");
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    cb_patients();
    function cb_patients() {
        let apenom;
        $("#txt-patient_id").find("option").remove().end() // delete options
        $.ajax({
            type: "GET",
            url: '/ajax_all/users/all',
            dataType: 'json',
            beforeSend: function () { },
            success: function (response) {
                $("#txt-patient_id").append('<option selected disabled value="">Selecciona una opción</option>');
                response.forEach((elemento) => {
                    apenom = elemento.apellido_pa + " " + elemento.apellido_ma + ", " + elemento.nombres;
                    $("#txt-patient_id").append('<option' +
                        ' value="' + elemento.iduser + '" ' +
                        ' data-subtext="' + elemento.nroidenti + '" ' +
                        '>' + apenom + '</option>');
                })
                $("#txt-patient_id").selectpicker("refresh");
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }
    
    // - - - - - - - - - - M O D A L S - - - - - - - - - -
    // INICIO - MODAL CREATE
    $("#btnCreateModal").click(function () {
        // change value
        document.getElementById("btnCreateUpdate").setAttribute("value", "Create");
        document.getElementById("btnCreateUpdate").innerHTML = "Guardar";
        document.getElementById("modalCreateUpdateLabel").innerHTML = "Registrar datos del tipo de cita";
        clearCheck(); // borrar validaciones
        Clearform();
    });
    // FIN - MODAL CREATE

    // INICIO - MODAL UPDATE
    $("#datatableGeneral tbody").on("click", ".editBtn", function (e) {
        clearCheck(); // borrar validaciones
        //cambiar el text del button
        document.getElementById("btnCreateUpdate").innerHTML = "Actualizar";
        document.getElementById("modalCreateUpdateLabel").innerHTML = "Actualizar datos de la cita médica";
        // setear data de cargo
        $("#txt-idappointment").val($(this).data("idappointment"));
        $("#txt-fecha").val($(this).data("fecha"));
        $("#txt-hora_ini").val($(this).data("hora_ini"));
        $("#txt-hora_fin").val($(this).data("hora_fin"));
        $("#txt-patient_id").selectpicker("val", $(this).attr("data-idpatient"));
        $("#txt-specialist_id").selectpicker("val", $(this).attr("data-idspecialist"));
        $("#txt-appointment_type_id").selectpicker("val", $(this).attr("data-idappointmenttype"));
        $("#txt-classroom_id").selectpicker("val", $(this).attr("data-idclassroom"));
        $("#txt-descripcion").val($(this).data("descripcion"));
        $("#txt-motivo_cancelacion").val($(this).data("motivo_cancelacion"));
        $("#txt-estado_cita").selectpicker("val", $(this).attr("data-estado_cita"));
        // show form
        $("#modalCreateUpdate").modal("show");
        // change value
        document.getElementById("btnCreateUpdate").setAttribute("value", "Update");
    });
    // FIN - MODAL UPDATE

    // INICIO - MODAL ATENTION
    $("#datatableGeneral tbody").on("click", ".attentionBtn", function (e) {
        clearCheck2(); // borrar validaciones
        //cambiar el text del button
        $("#txt-appointment_id").val($(this).data("idappointment"));
        $("#txt-diagnostico").val($(this).data("diagnostico"));
        $("#txt-tratamiento").val($(this).data("tratamiento"));
        $("#txt-observacion").val($(this).data("observacion"));
        $("#txt-estado_atencion").selectpicker("val", $(this).attr("data-estado_atencion"));
        // show form
        $("#modalAttention").modal("show");
        // change value
        document.getElementById("btnAttention").setAttribute("value", "Update");
    });
    // FIN - MODAL ATENTION

    var valbtn, formCheck;
    // INICIO - FUNCION CREATE O UPDATE
    $("#btnCreateUpdate").on("click", function (event) {
        event.preventDefault();
        formCheck = $("#formModal")[0];
        if (!formCheck.checkValidity()) {
            event.preventDefault();
            event.stopPropagation();
            $(formCheck).addClass("was-validated"); // añadir validaciones
        } else {
            // obtener valor del boton
            valbtn = $("#btnCreateUpdate").val();
            // FUNCION CREAR
            if (valbtn === "Create") {
                // insertar tabla cargo
                store();
            }
            // FUNCION ACTUALIZAR
            if (valbtn === "Update") {
                // actualizar tabla cargo
                update();
            }
        }
    });
    // FIN - FUNCION CREATE O UPDATE

    $("#btnAttention").on("click", function (event) {
        event.preventDefault();
        update_atention();
    });

    // INICIO - MODAL DELETE
    $("#datatableGeneral tbody").on("click", ".deleteBtn", function (e) {
        var id = $(this).attr("data-id");
        // confirmacion
        confirmation_sweetAlert(
            "Deseas continuar?",
            "Se procederá a eliminar el registro de la base de datos",
            "warning"
        ).then(function (isConfirm) {
            if (isConfirm.value) {
                // enviando el parametro de la data que se procede a delete
                destroy(id);
            } else {
                console.log("Cancelado");
            }
        });
    });

    var formModal;

    // - - - - - - - - - - F U N C I O N E S - - - - - - - - - -
    function store() {
        formModal = $("#formModal");
        $.ajax({
            type: "POST",
            url: "/admin/centro_medico/citas/store",
            data: formModal.serialize(),
            dataType: "json",
            beforeSend: function () {},
            success: function (data) {
                if (data.status == true) {
                    table.ajax.reload();
                    formModal.addClass("was-validated"); // añadir validaciones
                    notificaciontoast("info", data.mensaje, "Éxito!");
                    setTimeout(function () {
                        $("#modalCreateUpdate").modal("hide");
                    }, 1000); // ocultar despues de 1 sec
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    function update() {
        formModal = $("#formModal");
        var id = document.getElementById("txt-idappointment").value;
        var formData = $("#formModal").serialize();
        $.ajax({
            type: "PUT",
            url: "/admin/centro_medico/citas/update/" + id,
            data: formData,
            dataType: "json",
            beforeSend: function () {},
            success: function (data) {
                if (data.status == true) {
                    table.ajax.reload();
                    formModal.addClass("was-validated"); // añadir validaciones
                    notificaciontoast("info", data.mensaje, "Éxito!");
                    setTimeout(function () {
                        $("#modalCreateUpdate").modal("hide");
                    }, 1000); // ocultar despues de 1 sec
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    function destroy(id) {
        $.ajax({
            headers: { "X-CSRF-TOKEN": $('input[name="_token"]').val() },
            type: "DELETE",
            url: "/admin/centro_medico/citas/destroy/" + id,
            beforeSend: function () {},
            success: function (data) {
                if (data.status == true) {
                    notificaciontoast("info", data.mensaje, "Éxito!");
                    table.ajax.reload();
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    function update_atention() {
        formModal = $("#formModal2");
        var id = document.getElementById("txt-appointment_id").value;
        var formData = $("#formModal2").serialize();
        $.ajax({
            type: "PUT",
            url: "/admin/centro_medico/citas/update_attention/" + id,
            data: formData,
            dataType: "json",
            beforeSend: function () {},
            success: function (data) {
                if (data.status == true) {
                    table.ajax.reload();
                    formModal.addClass("was-validated"); // añadir validaciones
                    notificaciontoast("info", data.mensaje, "Éxito!");
                    setTimeout(function () {
                        $("#modalAttention").modal("hide");
                    }, 1000); // ocultar despues de 1 sec
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    // LIMPIAR VALIDACIONES
    function clearCheck() {
        formCheck = $("#formModal")[0];
        $(formCheck).removeClass("was-validated"); // remover validaciones
    }

    function clearCheck2() {
        formCheck = $("#formModal2")[0];
        $(formCheck).removeClass("was-validated"); // remover validaciones
    }

    // - - - - - - - - - - LIMPIAR CAMPOS - - - - - - - - - -
    function Clearform() {
        $("#txt-idappointment").val("");
        $("#txt-fecha").val("");
        $("#txt-hora_ini").val("");
        $("#txt-hora_fin").val("");
        $("#txt-descripcion").val("");
        $("#txt-motivo_cancelacion").val("");
        $("#txt-patient_id").selectpicker("val", "");
        $("#txt-appointment_type_id").selectpicker("val", "");
        $("#txt-specialist_id").selectpicker("val", "");
        $("#txt-classroom_id").selectpicker("val", "");
        $("#txt-estado_cita").selectpicker("val", "");
    }
});
