import { notificaciontoast } from "../../common/method_toast.js";
import { confirmation_sweetAlert } from "../../common/method_sweetAlert.js";
import { getButtonsSchema, languageSchema } from "../../common/schemas.js";

$(document).ready(function () {
    const tableName_categorias = "Categorias de Ofertas";

    // LISTAR DATATABLE CATEGORIAS
    var table_categorias = $("#datatableGeneral_categorias").DataTable({
        createdRow: function (row, data, index) {
            $(row).addClass("selected");
        },
        order: [],
        ajax: {
            headers: { "X-CSRF-TOKEN": $('input[name="_token"]').val() },
            type: "POST",
            url: "/admin/bolsa_laboral/categorias/list",
        },
        searching: true,
        dom: "Bfrtip",
        select: false,
        lengthChange: false,
        responsive: true,
        language: languageSchema,
        buttons: getButtonsSchema(tableName_categorias),
        columns: [
            { data: "idcategory", className: "text-center" },
            { data: "nombre", className: "text-center" },
            {
                data: "idcategory",
                className: "text-center noExport",
                sortable: false,
                searchable: false,
                render: function (data, type, all, meta) {
                    return `
                            <div class="d-flex justify-content-center">

                                <a href="javascript:void(0);" class="editBtn btn btn-warning shadow btn-xs sharp me-1"
                                data-idcategory="${all.idcategory}"
                                data-nombre="${all.nombre}"
                                data-bs-placement="top"
                                title="Editar registro">
                                <i class="fas fa-pencil-alt"></i>
                                </a>

                                <a href="javascript:void(0);" class="deleteBtn btn btn-danger shadow btn-xs sharp"
                                data-idcategory="${all.idcategory}"
                                data-bs-placement="top"
                                title="Eliminar registro">
                                <i class="fas fa-trash"></i>
                                </a>

                            </div>

                            `;
                },
            },
        ],
    });

    var valbtn, formCheck, formModal;

    // INICIO - CATEGORIAS SELECCIONADO
    $("#dt-categorias-tab").on("click", function (event) {
        event.preventDefault();
        $("#btnCreateUpdate").attr("value", "Create_Categoria");
        $("#btnCreateModal").html(`+ Nueva Categoría`);
        console.log("categorias seleccionado");
    });
    // FIN - CATEGORIAS SELECCIONADO

    // INICIO - MODAL CREATE
    $("#btnCreateModal").click(function () {
        valbtn = $("#btnCreateUpdate").val();
        $("#btnCreateUpdate").html("Registrar");
        if (valbtn === "Create_Categoria") {
            $("#modalCreateUpdateLabel").html("Registrar nueva categoria");
        }
        // limpiar validaciones
        formCheck = $("#formModal")[0];
        $(formCheck).removeClass("was-validated"); // remover validaciones
        clearForm();
    });
    // FIN - MODAL CREATE

    // INICIO - MODAL UPDATE CATEGORIAS
    $("#datatableGeneral_categorias tbody").on(
        "click",
        ".editBtn",
        function (e) {
            // limpiar validaciones
            formCheck = $("#formModal")[0];
            $(formCheck).removeClass("was-validated"); // remover validaciones
            //cambiar el text del button
            $("#btnCreateUpdate").attr("value", "Update_Categoria");
            $("#btnCreateUpdate").html("Actualizar");
            $("#modalCreateUpdateLabel").html(
                "Actualizar datos de la categoría"
            );
            // setear data de usuario
            $("#txt-idcategory").val($(this).data("idcategory"));
            $("#txt-nombre").val($(this).data("nombre"));
            // show form
            $("#modalCreateUpdate").modal("show");
        }
    );
    // FIN - MODAL UPDATE CATEGORIAS

    // Cuando se cierra el modal, limpia todo
    $('#modalCreateUpdate').on('hidden.bs.modal', function () {
        clearForm();
        // quitar validaciones visuales
        formCheck = $("#formModal")[0];
        $(formCheck).removeClass('was-validated');

        // restaurar texto y modo del botón
        $("#btnCreateUpdate").html("Registrar");
        $("#btnCreateUpdate").attr("value", "Create_Categoria");

        // restaurar título según pestaña activa
        if ($("#dt-categorias-tab").hasClass("active")) {
            $("#modalCreateUpdateLabel").html("Registrar nueva categoría");
        } else {
            $("#modalCreateUpdateLabel").html("Registrar nueva etiqueta");
        }
    });

    // INICIO - MODAL DELETE CATEGORIAS
    $("#datatableGeneral_categorias tbody").on(
        "click",
        ".deleteBtn",
        function (e) {
            let idcategory = $(this).data("idcategory");
            // confirmacion
            confirmation_sweetAlert(
                "Deseas continuar?",
                "Se procederá a eliminar el registro de la base de datos",
                "warning"
            ).then(function (isConfirm) {
                if (isConfirm.value) {
                    // enviando el parametro de la data que se procede a delete
                    destroy_category(idcategory);
                } else {
                    console.log("Cancelado");
                }
            });
        }
    );
    // FIN - MODAL DELETE CATEGORIAS

    // INICIO - FUNCION CREATE O UPDATE
    $("#btnCreateUpdate").on("click", function (event) {
        event.preventDefault();
        // Iterar sobre los formularios y evitar la acción predeterminada si no son válidos
        formCheck = $("#formModal")[0];
        if (!formCheck.checkValidity()) {
            event.preventDefault();
            event.stopPropagation();
        } else {
            valbtn = $("#btnCreateUpdate").val();
            if (valbtn === "Create_Categoria") {
                // insertar
                store_category();
            }
            if (valbtn === "Update_Categoria") {
                // actualizar
                update_category($("#txt-idcategory").val());
            }
        }
        $(formCheck).addClass("was-validated"); // añadir validaciones
    });
    // FIN - FUNCION CREATE O UPDATE

    function store_category() {
        formModal = $("#formModal");
        $.ajax({
            type: "POST",
            url: "/admin/bolsa_laboral/categorias/store",
            data: formModal.serialize(),
            dataType: "json",
            beforeSend: function () {},
            success: function (data) {
                if (data.status == true) {
                    table_categorias.ajax.reload();
                    setTimeout(function () {
                        notificaciontoast("info", data.mensaje, "Éxito!");
                        $("#modalCreateUpdate").modal("hide");
                    }, 1000); // ocultar despues de 1 sec
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    function update_category(idcategory) {
        formModal = $("#formModal");
        $.ajax({
            headers: { "X-CSRF-TOKEN": $('input[name="_token"]').val() },
            type: "PUT",
            url: "/admin/bolsa_laboral/categorias/update/" + idcategory,
            data: formModal.serialize(),
            dataType: "json",
            beforeSend: function () {},
            success: function (data) {
                if (data.status == true) {
                    table_categorias.ajax.reload();
                    setTimeout(function () {
                        notificaciontoast("info", data.mensaje, "Éxito!");
                        $("#modalCreateUpdate").modal("hide");
                    }, 1000); // ocultar despues de 1 sec
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    function destroy_category(idcategory) {
        $.ajax({
            headers: { "X-CSRF-TOKEN": $('input[name="_token"]').val() },
            type: "DELETE",
            url: "/admin/bolsa_laboral/categorias/destroy/" + idcategory,
            beforeSend: function () {},
            success: function (data) {
                if (data.status == true) {
                    table_categorias.ajax.reload();
                    notificaciontoast("info", data.mensaje, "Éxito!");
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    // LIMPIAR FORMULARIO
    function clearForm() {
        $("#txt-idcategory").val("");
        $("#txt-nombre").val("");
    }
});
