import { notificaciontoast } from "../../common/method_toast.js";
import { confirmation_sweetAlert } from "../../common/method_sweetAlert.js";
import { getButtonsSchema, languageSchema } from '../../common/schemas.js';
import { cb_plans_all } from '../../common/combobox/programs.js';

$(document).ready(function () {
    // Inicializa CKEditor solo si el elemento está presente
    let editorInstance;
    ClassicEditor
        .create(document.querySelector('#contenido'))
        .then(editor => {
            editorInstance = editor;
        })
        .catch(error => {
            console.error('Hubo un error al inicializar CKEditor:', error);
        });

    cb_plans_all();

    // Mostrar y cerrar modal
    $("#btn_add_publicacion").on("click", function () {
        $("#modalCreateUpdate").modal("show");
        clear_formModal();
    });

    $("#btnCloseModal").on("click", function () {
        $("#modalCreateUpdate").modal("hide");
    });

    // Función para listar publicaciones dinámicamente
    const listarPublicaciones = () => {
        $.ajax({
            type: "GET",
            url: '/institucion/bienestar/publicaciones/list',
            dataType: 'json',
            beforeSend: () => {},
            success: (response) => {
                const container = $("#DLAB_W_Contacts_Body");
                container.empty(); // Limpiar el contenedor antes de agregar publicaciones

                if (response.status) {
                    if (Array.isArray(response.data) && response.data.length > 0) {
                        response.data.forEach((elemento) => {
                            const cardHtml = `
                                <div class="card" style="height: auto;">
                                    <div class="card-body">
                                        <ul class="d-sm-flex d-block align-items-start justify-content-between">
                                            <li class="food-media">
                                                 <img src="/publicaciones/viewimg/${elemento.id}/${elemento.carpeta}/${elemento.imagen}" class="rounde food-image" alt="">
                                            </li>
                                            <li class="ms-sm-3 ms-0">
                                                <h4 class="heading">${elemento.titulo}</h4>
                                                <span class="badge badge-primary badge-sm mb-3">${elemento.fecharegistro}</span>
                                                <div>${elemento.contenido}</div>
                                            </li>
                                            <li>
                                                <div class="dropdown custom-dropdown">
                                                    <div class="btn sharp btn-light" data-bs-toggle="dropdown">
                                                        <svg width="24" height="6" viewBox="0 0 24 6" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                            <path d="M12.0012 0.359985C11.6543 0.359985 11.3109 0.428302 10.9904 0.561035C10.67 0.693767 10.3788 0.888317 10.1335 1.13358C9.88829 1.37883 9.69374 1.67 9.56101 1.99044C9.42828 2.31089 9.35996 2.65434 9.35996 3.00119C9.35996 3.34803 9.42828 3.69148 9.56101 4.01193C9.69374 4.33237 9.88829 4.62354 10.1335 4.8688C10.3788 5.11405 10.67 5.3086 10.9904 5.44134C11.3109 5.57407 11.6543 5.64239 12.0012 5.64239C12.7017 5.64223 13.3734 5.36381 13.8686 4.86837C14.3638 4.37294 14.6419 3.70108 14.6418 3.00059C14.6416 2.3001 14.3632 1.62836 13.8677 1.13315C13.3723 0.637942 12.7004 0.359826 12 0.359985H12.0012ZM3.60116 0.359985C3.25431 0.359985 2.91086 0.428302 2.59042 0.561035C2.26997 0.693767 1.97881 0.888317 1.73355 1.13358C1.48829 1.37883 1.29374 1.67 1.16101 1.99044C1.02828 2.31089 0.959961 2.65434 0.959961 3.00119C0.959961 3.34803 1.02828 3.69148 1.16101 4.01193C1.29374 4.33237 1.48829 4.62354 1.73355 4.8688C1.97881 5.11405 2.26997 5.3086 2.59042 5.44134C2.91086 5.57407 3.25431 5.64239 3.60116 5.64239C4.30165 5.64223 4.97339 5.36381 5.4686 4.86837C5.9638 4.37294 6.24192 3.70108 6.24176 3.00059C6.2416 2.3001 5.96318 1.62836 5.46775 1.13315C4.97231 0.637942 4.30045 0.359826 3.59996 0.359985H3.60116ZM20.4012 0.359985C20.0543 0.359985 19.7109 0.428302 19.3904 0.561035C19.07 0.693767 18.7788 0.888317 18.5336 1.13358C18.2883 1.37883 18.0937 1.67 17.961 1.99044C17.8283 2.31089 17.76 2.65434 17.76 3.00119C17.76 3.34803 17.8283 3.69148 17.961 4.01193C18.0937 4.33237 18.2883 4.62354 18.5336 4.8688C18.7788 5.11405 19.07 5.3086 19.3904 5.44134C19.7109 5.57407 20.0543 5.64239 20.4012 5.64239C21.1017 5.64223 21.7734 5.36381 22.2686 4.86837C22.7638 4.37294 23.0419 3.70108 23.0418 3.00059C23.0416 2.3001 22.7632 1.62836 22.2677 1.13315C21.7723 0.637942 21.1005 0.359826 20.4 0.359985H20.4012Z" fill="#A098AE"></path>
                                                        </svg>
                                                    </div>
                                                    <div class="dropdown-menu dropdown-menu-end">
                                                        <a class="dropdown-item edithBtn" data-idpublicacion="${elemento.id}" data-titulo="${elemento.titulo}"
                                                         data-contenido="${encodeURIComponent(elemento.contenido)}"
                                                        data-planid="${elemento.plan_id}"
                                                        href="javascript:void(0);">Editar</a>
                                                        <a class="dropdown-item deleteBtn" data-idpublicacion="${elemento.id}" href="javascript:void(0);">Eliminar</a>
                                                    </div>
                                                </div>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                                <hr>
                            `;
                            container.append(cardHtml);
                        });
                    } else {
                        container.append("<p>No hay publicaciones disponibles.</p>");
                    }
                } else {
                    console.error(response.mensaje);
                }
            },
            error: (error) => {
                console.error("Error", error);
            }
        });
    };
    listarPublicaciones();

    const listarPublicaciones_recientes = () => {
        $.ajax({
            type: "GET",
            url: '/institucion/bienestar/publicaciones/list/1',
            dataType: 'json',
            beforeSend: () => {},
            success: (response) => {
                const container = $("#list_recientes");
                container.empty(); // Limpiar el contenedor antes de agregar publicaciones

                if (response.status) {
                    if (Array.isArray(response.data) && response.data.length > 0) {
                        response.data.forEach((elemento) => {
                            // Lista de clases de color
                            const colorClasses = ['primary', 'warning', 'danger', 'success'];

                            // Seleccionar una clase aleatoria
                            const randomColor = colorClasses[Math.floor(Math.random() * colorClasses.length)];

                            // Generar el HTML con la clase aleatoria
                            const cardHtml = `
                                <li>
                                    <div class="timeline-badge ${randomColor}"></div>
                                    <a class="timeline-panel text-muted" href="javascript:void(0);">
                                        <span>${elemento.fecharegistro}</span>
                                        <h6 class="mb-0">${elemento.titulo}</h6>
                                        <strong class="text-danger"> Plan: ${elemento.nombre}</strong>
                                    </a>
                                </li>
                            `;

                            // Insertar el HTML en el contenedor
                            container.append(cardHtml);
                        });
                    } else {
                        container.append("<p>No hay publicaciones disponibles.</p>");
                    }
                } else {
                    console.log(response.mensaje);
                }
            },
            error: (error) => {
                console.error("Error", error);
            }
        });
    };
    listarPublicaciones_recientes();

    const listarPublicaciones_pasadas = () => {
        $.ajax({
            type: "GET",
            url: '/institucion/bienestar/publicaciones/list/2',
            dataType: 'json',
            beforeSend: () => {},
            success: (response) => {
                const container = $("#list_pasados");
                container.empty(); // Limpiar el contenedor antes de agregar publicaciones

                if (response.status) {
                    if (Array.isArray(response.data) && response.data.length > 0) {
                        response.data.forEach((elemento) => {
                            // Lista de clases de color
                            const colorClasses = ['primary', 'warning', 'danger', 'success'];

                            // Seleccionar una clase aleatoria
                            const randomColor = colorClasses[Math.floor(Math.random() * colorClasses.length)];

                            // Generar el HTML con la clase aleatoria
                            const cardHtml = `
                                <li>
                                    <div class="timeline-badge ${randomColor}"></div>
                                    <a class="timeline-panel text-muted" href="javascript:void(0);">
                                        <span>${elemento.fecharegistro}</span>
                                        <h6 class="mb-0">${elemento.titulo}</h6>
                                        <strong class="text-danger"> Plan: ${elemento.nombre}</strong>.
                                    </a>
                                </li>
                            `;

                            // Insertar el HTML en el contenedor
                            container.append(cardHtml);
                        });
                    } else {
                        container.append("<p>No hay publicaciones disponibles.</p>");
                    }
                } else {
                    console.log(response.mensaje);
                }
            },
            error: (error) => {
                console.error("Error", error);
            }
        });
    };
    listarPublicaciones_pasadas();


    $("#DLAB_W_Contacts_Body").on("click", ".edithBtn", function (e) {
        let idPublicacion = $(this).data("idpublicacion")
        let titulo = $(this).data("titulo")
        let contenido = decodeURIComponent($(this).data("contenido"));
        let planid = $(this).data("planid");
        // seteando
        $("#modalCreateUpdateLabel").html("Editando Contenido")
        $("#txt-idpublicacion").val(idPublicacion);
        $("#txt-titulo").val(titulo);
        editorInstance.setData(contenido); // Cargar el contenido en el editor
        $("#txt-plans").selectpicker("val", String(planid));
        $("#btnCreateUpdate").val("Update"); // Cambiar el texto del botón
        $("#btnCreateUpdate").html("Actualizar"); // Cambiar el texto del botón

        $("#modalCreateUpdate").modal("show");
    });

    // Crear o actualizar publicación
    $("#btnCreateUpdate").on("click", function () {
        const valbtn = $("#btnCreateUpdate").val();
        if (valbtn === "Create") {
            crearPublicacion();
        } else if (valbtn === "Update") {
            actualizarPublicacion();
        }
    });

    // Función para crear publicación
    const crearPublicacion = () => {
        const formData = new FormData($("#formModal")[0]);
        formData.set('contenido', editorInstance.getData()); // Agregar contenido del editor

        $.ajax({
            headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
            type: "POST",
            url: '/institucion/bienestar/publicaciones/store',
            data: formData,
            contentType: false,
            processData: false,
            beforeSend: () => console.log("Enviando datos..."),
            success: (data) => {
                if (data.status) {
                    notificaciontoast("info", data.mensaje, "Éxito!");
                    listarPublicaciones(); // Refrescar la lista de publicaciones
                    listarPublicaciones_recientes();
                    $("#modalCreateUpdate").modal("hide"); // Cerrar modal
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            clear_formModal();

            },
            error: (jqXHR) => {
                console.log(jqXHR)
                if (jqXHR.status === 422) {
                    // Manejo de errores de validación
                    const errors = jqXHR.responseJSON.errors;
                    for (const key in errors) {
                        notificaciontoast("error", errors[key][0], "Error de Validación");
                    }
                } else {
                    // Manejo de errores generales
                    console.error("Error inesperado:", jqXHR);
                    notificaciontoast("error", "Ocurrió un error inesperado. Inténtalo nuevamente.", "Error!");
                }
            }
        });
    };


    // Función para actualizar publicación (vacía por ahora)
    const actualizarPublicacion = () => {
        const formData = new FormData($("#formModal")[0]);
        formData.set('contenido', editorInstance.getData()); // Agregar contenido del editor
        let idPublicacion = $("#txt-idpublicacion").val();

        $.ajax({
            headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
            type: "POST",
            url: '/institucion/bienestar/publicaciones/update',
            data: formData,
            contentType: false,
            processData: false,
            beforeSend: () => console.log("Enviando datos..."),
            success: (data) => {
                if (data.status) {
                    notificaciontoast("info", data.mensaje, "Éxito!");
                    listarPublicaciones(); // Refrescar la lista de publicaciones
                    listarPublicaciones_recientes();
                    $("#modalCreateUpdate").modal("hide"); // Cerrar modal
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            clear_formModal();

            },
            error: (jqXHR) => {
                console.log(jqXHR)
                if (jqXHR.status === 422) {
                    // Manejo de errores de validación
                    const errors = jqXHR.responseJSON.errors;
                    for (const key in errors) {
                        notificaciontoast("error", errors[key][0], "Error de Validación");
                    }
                } else {
                    // Manejo de errores generales
                    console.error("Error inesperado:", jqXHR);
                    notificaciontoast("error", "Ocurrió un error inesperado. Inténtalo nuevamente.", "Error!");
                }
            }
        });
    };



    // INICIO - MODAL DELETE
    $("#DLAB_W_Contacts_Body").on("click", ".deleteBtn", function (e) {
        let idPublicacion = $(this).data("idpublicacion")

        // confirmacion
        confirmation_sweetAlert("Deseas continuar?", "Se procederá a eliminar el registro de la base de datos", "warning")
            .then(function (isConfirm) {
                if (isConfirm.value) {
                    // enviando el parametro de la data que se procede a delete
                    destroy(idPublicacion);
                } else {
                    console.log("Cancelado");
                }
            });
    });


    function destroy(idPublicacion) {
        $.ajax({
            headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
            type: "DELETE",
            url: '/institucion/bienestar/publicaciones/destroy/' + idPublicacion,
            beforeSend: function () { },
            success: function (data) {
                if (data.status == true) {
                    listarPublicaciones(); // Refrescar la lista de publicaciones
                    notificaciontoast("info", data.mensaje, "Éxito!");
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }
    // FIN - MODAL DELETE

    function clear_formModal(){
        $("#modalCreateUpdateLabel").html("Crear una publicación");
        $("#txt-titulo").val("");
        $("#formModal")[0].reset(); // Resetear el formulario
        $("#txt-plans").selectpicker("val", "0");
        editorInstance.setData(''); // Limpiar el contenido del editor
        $("#btnCreateUpdate").val("Create"); // Cambiar el texto del botón
        $("#btnCreateUpdate").html("Guardar"); // Cambiar el texto del botón
    }
});
