"use strict";
import { notificaciontoast } from "../../common/method_toast.js";
import { confirmation_sweetAlert } from "../../common/method_sweetAlert.js";
import { getButtonsSchema, languageSchema } from "../../common/schemas.js";
import { cb_programs } from '../../common/combobox/programs_v3.js';

$(document).ready(function () {
    const tableName = "Publicaciones";
    var number = 0;
    // LISTAR DATATABLE
    var table = $("#datatableGeneral").DataTable({
        createdRow: function (row, data, index) {
            $(row).addClass("selected");
        },
        order: [],
        ajax: "/institucion/bienestar/publicaciones/list",
        searching: true,
        dom: "Bfrtip",
        select: false,
        lengthChange: false,
        responsive: true,
        language: languageSchema,
        buttons: getButtonsSchema(tableName),
        columns: [
            { data: "id", className: "text-center" },
            { data: "titulo", className: "text-center" },
            {
                data: "contenido",
                className: "text-center",
                render: function (data, type, all, meta) {
                    return `
                                <button type="button" 
                                    class="btn btn-primary btn-sm viewContentBtn" 
                                    data-contenido="${encodeURIComponent(data)}"
                                    data-titulo="${all.titulo}"
                                    data-bs-toggle="modal" 
                                    data-bs-target="#modalContent">
                                    <i class="fas fa-eye"></i> Ver
                                </button>
                            `;
                },
            },

            {
                data: "id",
                className: "text-center",
                sortable: false,
                render: function (data, type, all, meta) {
                    return `
                                <button type="button" 
                                    class="btn btn-info btn-sm viewImageBtn" 
                                    data-img="/publicaciones/viewimg/${all.id}/${all.carpeta}/${all.imagen}" 
                                    data-bs-toggle="modal" 
                                    data-bs-target="#modalImage">
                                    <i class="fas fa-image"></i> Ver
                                </button>
                            `;
                },
            },
            { data: "nombre", className: "text-center" },
            { data: "dirigido_a", className: "text-center" },
            { data: "fecharegistro", className: "text-center" },
            {
                data: "id",
                className: "text-center",
                sortable: false,
                render: function (data, type, all, meta) {
                    return `
                        <div class="d-flex justify-content-center">
                            <a href="javascript:void(0);" class="editBtn btn btn-warning shadow btn-xs sharp me-1"
                            data-id="${all.id}"
                            data-titulo="${all.titulo}"
                            data-contenido="${encodeURIComponent(all.contenido)}"
                            data-carpeta="${all.carpeta}"
                            data-dirigido_a="${all.dirigido_a}"
                            data-imagen="${all.imagen}"
                            data-plan_id="${all.program_id}"
                            data-bs-placement="top"
                            title="Editar registro">
                            <i class="fas fa-pencil-alt"></i>
                            </a>

                            <a href="javascript:void(0);" class="deleteBtn btn btn-danger shadow btn-xs sharp"
                            data-id="${all.id}"
                            data-bs-placement="top"
                            title="Eliminar registro">
                            <i class="fas fa-trash"></i>
                            </a>
                        </div>
                    `;
                },
            },
        ],
    });

    // Agregar una columna de números automáticos
    table
        .on("order.dt search.dt", function () {
            table
                .column(0, { search: "applied", order: "applied" })
                .nodes()
                .each(function (cell, i) {
                    cell.innerHTML = i + 1;
                });
        })
        .draw();

    // - - - - - - - - - - M O D A L S - - - - - - - - - -
    // INICIO - MODAL CREATE
    $("#btnCreateModal").click(function () {
        // change value
        document
            .getElementById("btnCreateUpdate")
            .setAttribute("value", "Create");
        document.getElementById("btnCreateUpdate").innerHTML = "Guardar";
        document.getElementById("modalCreateUpdateLabel").innerHTML =
            "Registrar datos de la publicación";
        clearCheck(); // borrar validaciones
        Clearform();

        // poner imagen como obligatoria al crear
        $("#txt-imagen").attr("required", true);
    });
    // FIN - MODAL CREATE

    // INICIO - MODAL UPDATE
    $("#datatableGeneral tbody").on("click", ".editBtn", function (e) {
        clearCheck();

        document.getElementById("btnCreateUpdate").innerHTML = "Actualizar";
        document.getElementById("modalCreateUpdateLabel").innerHTML =
            "Actualizar datos de la publicación";

        // setear valores
        document.getElementById("txt-id").value = $(this).attr("data-id");
        $("#txt-program_id").val($(this).data("plan_id")).selectpicker("refresh");
        $("#txt-dirigido_a").selectpicker("val", $(this).data("dirigido_a"));
        document.getElementById("txt-titulo").value = $(this).attr("data-titulo");

        // almacenar contenido en TinyMCE}
        let contenido = decodeURIComponent($(this).data("contenido"));

        $("#modalCreateUpdate").one("shown.bs.modal", function () {
            let editor = tinymce.get("txt-contenido");
            if (editor) {
                editor.setContent(contenido);
            }
        });

        // mostrar modal
        $("#modalCreateUpdate").modal("show");

        // marcar botón como Update
        document.getElementById("btnCreateUpdate").setAttribute("value", "Update");

        // quitar required en modo actualizar
        $("#txt-imagen").removeAttr("required");
    });

    // FIN - MODAL UPDATE

    // Cuando se hace clic en el botón "Ver"
    $(document).on("click", ".viewImageBtn", function () {
        let imgUrl = $(this).data("img");
        $("#previewImage").attr("src", imgUrl);
    });

    // Evento para abrir modal con contenido
    $(document).on("click", ".viewContentBtn", function () {
        let contenido = decodeURIComponent($(this).data("contenido"));
        let titulo = $(this).data("titulo");

        $("#contentTitle").text(titulo);
        $("#contentBody").html(contenido); // usamos .html() por si hay texto con formato
    });


    var valbtn, formCheck;
    // INICIO - FUNCION CREATE O UPDATE
    $("#btnCreateUpdate").on("click", function (event) {
        event.preventDefault();
        formCheck = $("#formModal")[0];
        if (!formCheck.checkValidity()) {
            event.preventDefault();
            event.stopPropagation();
            $(formCheck).addClass("was-validated"); // añadir validaciones
        } else {
            // obtener valor del boton
            valbtn = $("#btnCreateUpdate").val();
            // FUNCION CREAR
            if (valbtn === "Create") {
                // insertar tabla cargo
                store();
            }
            // FUNCION ACTUALIZAR
            if (valbtn === "Update") {
                // actualizar tabla cargo
                update();
            }
        }
    });
    // FIN - FUNCION CREATE O UPDATE

    // INICIO - MODAL DELETE
    $("#datatableGeneral tbody").on("click", ".deleteBtn", function (e) {
        var id = $(this).attr("data-id");
        // confirmacion
        confirmation_sweetAlert(
            "Deseas continuar?",
            "Se procederá a eliminar el registro de la base de datos",
            "warning"
        ).then(function (isConfirm) {
            if (isConfirm.value) {
                // enviando el parametro de la data que se procede a delete
                destroy(id);
            } else {
                console.log("Cancelado");
            }
        });
    });

    var formModal;

    // - - - - - - - - - - F U N C I O N E S - - - - - - - - - -
    function store() {
        const formData = new FormData($("#formModal")[0]); // Captura todo el formulario, incluidos archivos
        formData.set('contenido', tinymce.get("txt-contenido").getContent()); // Sobrescribe contenido del editor

        $.ajax({
            headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
            type: "POST",
            url: '/institucion/bienestar/publicaciones/store',
            data: formData,
            contentType: false, // necesario para archivos
            processData: false, // necesario para archivos
            beforeSend: () => console.log("Enviando datos..."),
            success: (data) => {
                if (data.status) {
                    table.ajax.reload();
                    notificaciontoast("info", data.mensaje, "Éxito!");
                    setTimeout(() => $("#modalCreateUpdate").modal("hide"), 1000);
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
                clear_formModal(); // limpiar formulario
            },
            error: (jqXHR) => {
                console.log(jqXHR);
                if (jqXHR.status === 422) {
                    const errors = jqXHR.responseJSON.errors;
                    for (const key in errors) {
                        notificaciontoast("error", errors[key][0], "Error de Validación");
                    }
                } else {
                    notificaciontoast("error", "Ocurrió un error inesperado. Inténtalo nuevamente.", "Error!");
                }
            }
        });
    }


    function update() {
        let id = $("#txt-id").val();
        let contenido = tinymce.get("txt-contenido").getContent();

        let formData = $("#formModal").serializeArray();
        formData.push({ name: "contenido", value: contenido });

        $.ajax({
            headers: { "X-CSRF-TOKEN": $('input[name="_token"]').val() },
            type: "PUT",
            url: "/institucion/bienestar/publicaciones/update/" + id,
            data: $.param(formData),
            dataType: "json",
            success: function (data) {
                if (data.status == true) {
                    table.ajax.reload();
                    notificaciontoast("info", data.mensaje, "Éxito!");
                    setTimeout(() => $("#modalCreateUpdate").modal("hide"), 1000);
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
                clear_formModal();
            },
            error: function (jqXHR) {
                console.log(jqXHR);
                if (jqXHR.status === 422) {
                    const errors = jqXHR.responseJSON.errors;
                    for (const key in errors) {
                        notificaciontoast("error", errors[key][0], "Error de Validación");
                    }
                } else {
                    notificaciontoast("error", "Ocurrió un error inesperado. Inténtalo nuevamente.", "Error!");
                }
            }
        });
    }

    function destroy(id) {
        $.ajax({
            headers: { "X-CSRF-TOKEN": $('input[name="_token"]').val() },
            type: "DELETE",
            url: "/institucion/bienestar/publicaciones/destroy/" + id,
            success: function (data) {
                if (data.status == true) {
                    notificaciontoast("info", data.mensaje, "Éxito!");
                    table.ajax.reload();
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
            error: function (error) {
                console.log("Error", error);
            }
        });
    }

    // LIMPIAR VALIDACIONES
    function clearCheck() {
        formCheck = $("#formModal")[0];
        $(formCheck).removeClass("was-validated"); // remover validaciones
    }

    // - - - - - - - - - - LIMPIAR CAMPOS - - - - - - - - - -
    function Clearform() {
        $("#txt-id").val("");
        $('#txt-program_id').val('').selectpicker('refresh');
        $('#txt-dirigido_a').val('').selectpicker('refresh');
        $("#txt-titulo").val("");
        $("#txt-imagen").val("");

        let editor = tinymce.get("txt-contenido");
        if (editor) {
            editor.setContent("");
        } else {
            $("#txt-contenido").val("");
        }
    }

});
