import { notificaciontoast } from "../../common/method_toast.js";
import { confirmation_sweetAlert } from "../../common/method_sweetAlert.js";
import {QuestionsText, QuestionsTextList,} from "./plantillas_preguntas/text.js";
import {QuestionsUnica,QuestionsUnicaList} from "./plantillas_preguntas/unica.js";
import {QuestionsMultiple, QuestionsMultipleList } from "./plantillas_preguntas/multiple.js";

$(document).ready(function () {
    let formModal;

    //FUNCION LISTAR LAS PREGUNTAS Y LAS OPCIONES DE PGUNTAS DE LA ENCUESTA
    const ListarQuestions = () => {
        let idencuesta = $("#id_encuesta_form").val();
        $.ajax({
            type: "GET",
            url:
                "/institucion/bienestar/encuestas/questions/list/" + idencuesta,
            dataType: "json",
            beforeSend: () => {},
            success: (response) => {
                const container = $("#DZ_W_TimeLine");
                container.empty(); // Limpiar el contenedor antes de agregar publicaciones
                let cardHtml;
                if (response.status) {
                    if (
                        Array.isArray(response.preguntas) &&
                        response.preguntas.length > 0
                    ) {
                        $("#total_texto").html(response.total_opciones[0].total_texto);
                        $("#total_respuestaunica").html(response.total_opciones[0].total_opcion_unica);
                        $("#total_multiple").html(response.total_opciones[0].total_multiple);

                        response.preguntas.forEach((elemento) => {
                            if (elemento.tipo == "texto") {
                                cardHtml = QuestionsTextList(
                                    elemento.pregunta,
                                    elemento.tipo,
                                    elemento.id
                                );
                            } else if (elemento.tipo == "opcion_unica") {
                                cardHtml = QuestionsUnicaList(
                                    elemento.pregunta,
                                    elemento.tipo,
                                    elemento.id,
                                    elemento.opciones,
                                );
                            } else {
                                cardHtml = QuestionsMultipleList(
                                    elemento.pregunta,
                                    elemento.tipo,
                                    elemento.id,
                                    elemento.opciones,
                                );
                            }
                            container.append(cardHtml);
                        });
                    } else {
                        container.append(
                            "<p>No hay publicaciones disponibles.</p>"
                        );
                    }
                } else {
                    console.error(response.mensaje);
                    notificaciontoast("warning", response.mensaje, "Informativo!");
                }
            },
            error: (error) => {
                console.error("Error", error);
            },
        });
    };
    ListarQuestions();
    //FIN FUNCION

    // FUNCION PARA MOSTRAR EL MODAL DE AGREGAR OPCIONES DE PREGUNTA
    $("#btn_createQuestions").on("click", function () {
        $("#modalCreateUpdate").modal("show");
        clear_formPreguntas();
    });
    //FIN FUNCION

    //FUNCION CERRAR EL MODAL CON EL BOTON DEL MODAL
    $("#btnCloseModal").on("click", function () {
        $("#modalCreateUpdate").modal("hide");
        clear_formPreguntas();
    });
    //FIN FUNCION

    $("#DZ_W_TimeLine").on("click", ".edithBtnPreguntaOpcion", function (e) {
        let idPregunta = $(e.currentTarget).attr("data-idPregunta");
        let idopcion = $(e.currentTarget).attr("data-idopcion");
        let titulo = $(e.currentTarget).attr("data-titulo");
        let clickpreguntaOpcion = $(e.currentTarget).attr("data-var");

        if(clickpreguntaOpcion){
                // seteando
                $("#modalCreateUpdateLabelEdith").html("Actualizar Pregunta");
                $("#labelpreguntayopcion").html("Pregunta");
                $("#txt-PreguntaoOpcion").val("pregunta");
                $("#txt-idpopcionpregunta").val(idPregunta);


        }else{
                // seteando
                $("#modalCreateUpdateLabelEdith").html("Actualizar titulo de opcion");
                $("#labelpreguntayopcion").html("Opcion");
                $("#txt-PreguntaoOpcion").val("opcion");
                $("#txt-idpopcionpregunta").val(idopcion);


        }
        $("#text_opcionyopcion").val(titulo);
        $("#modalCreateUpdateQuestionOption").modal("show");
    });

    // Crear o actualizar publicación
    $("#btnCreateUpdate").on("click", function () {
        const valbtn = $("#btnCreateUpdate").val();
        if (valbtn === "Create") {
            crearPreguntas();
        }
    });
    const crearPreguntas = () => {
        formModal = $("#formModal");
        $.ajax({
            headers: { "X-CSRF-TOKEN": $('input[name="_token"]').val() },
            type: "POST",
            url: "/institucion/bienestar/encuestas/questions/store",
            data: formModal.serialize(),
            dataType: "json",
            beforeSend: () => console.log("Enviando datos..."),
            success: (data) => {
                if (data.status) {
                    notificaciontoast("info", data.mensaje, "Éxito!");
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
                clear_formPreguntas();
                ListarQuestions();
                $("#modalCreateUpdate").modal("hide");
            },
            error: (jqXHR) => {
                console.log(jqXHR);
                if (jqXHR.status === 422) {
                    // Manejo de errores de validación
                    const errors = jqXHR.responseJSON.errors;
                    for (const key in errors) {
                        notificaciontoast(
                            "error",
                            errors[key][0],
                            "Error de Validación"
                        );
                    }
                } else {
                    // Manejo de errores generales
                    console.error("Error inesperado:", jqXHR);
                    notificaciontoast(
                        "error",
                        "Ocurrió un error inesperado. Inténtalo nuevamente.",
                        "Error!"
                    );
                }
            },
        });
    };
    //FIN FUNCION

    // Función para actualizar publicación (vacía por ahora)
    $("#btnUpdate").on("click", function () {
        const valbtn = $("#btnUpdate").val();
        if (valbtn === "Update") {
            actualizarTituloQuestionOption();
        }
    });
    const actualizarTituloQuestionOption = () => {
        var PreuntaoOpcion = $("#txt-PreguntaoOpcion").val();
        var idpreguntaoOpcion = $("#txt-idpopcionpregunta").val();

        $.ajax({
            headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
            type: "PUT",
            url: '/institucion/bienestar/encuestas/questions/option/update/'+ PreuntaoOpcion + '/' + idpreguntaoOpcion,
            data:  $("#formModalEditTitulo").serialize(),
            dataType: "json",
            beforeSend: () => console.log("Enviando datos..."),
            success: (data) => {
                console.log(data)
                if (data.status) {
                    ListarQuestions();
                    $("#modalCreateUpdateQuestionOption").modal("hide");
                    notificaciontoast("info", data.mensaje, "Éxito!");
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
            error: (jqXHR) => {
                console.log(jqXHR)
                if (jqXHR.status === 422) {
                    // Manejo de errores de validación
                    const errors = jqXHR.responseJSON.errors;
                    for (const key in errors) {
                        notificaciontoast("error", errors[key][0], "Error de Validación");
                    }
                } else {
                    // Manejo de errores generales
                    console.error("Error inesperado:", jqXHR);
                    notificaciontoast("error", "Ocurrió un error inesperado. Inténtalo nuevamente.", "Error!");
                }
            }
        });
    };

    // INICIO - ELIMINAR PREGUNTA
    $("#DZ_W_TimeLine").on("click", ".deleteBtn", function (e) {
        // Puedes obtener atributos del elemento directamente
        let idPregunta = $(e.target).attr("data-idPregunta");
        // confirmacion
        confirmation_sweetAlert(
            "Deseas continuar?",
            "Se procederá a eliminar el registro de la base de datos",
            "warning"
        ).then(function (isConfirm) {
            if (isConfirm.value) {
                // enviando el parametro de la data que se procede a delete
                destroy(idPregunta);
            } else {
                console.log("Cancelado");
            }
        });
    });

    function destroy(idPregunta) {
        $.ajax({
            headers: { "X-CSRF-TOKEN": $('input[name="_token"]').val() },
            type: "DELETE",
            url:
                "/institucion/bienestar/encuestas/questions/destroy/"+idPregunta,
            beforeSend: function () {},
            success: function (data) {
                console.log(data)
                if (data.status == true) {
                    ListarQuestions();
                    notificaciontoast("info", data.mensaje, "Éxito!");
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }
    // FIN - ELIMINAR PREGUNTA



     // INICIO - ELIMINAR OPCION DE PREGUNTA
    $("#DZ_W_TimeLine").on("click", ".dleteBtn-opcion", function (e) {
        // Puedes obtener atributos del elemento directamente
        let idopcion = $(e.currentTarget).attr("data-idopcion");
        let idPregunta = $(e.currentTarget).attr("data-idPregunta");

        console.log(e)
        console.log(idopcion, idPregunta)

        // confirmacion
        confirmation_sweetAlert(
            "Deseas continuar?",
            "Se procederá a eliminar la opcion de respuesta de la pregunta",
            "warning"
        ).then(function (isConfirm) {
            if (isConfirm.value) {
                // enviando el parametro de la data que se procede a delete
                destroyopcion(idPregunta,idopcion);
            } else {
                console.log("Cancelado");
            }
        });
    });

    function destroyopcion(idPregunta,idopcion) {
        $.ajax({
            headers: { "X-CSRF-TOKEN": $('input[name="_token"]').val() },
            type: "DELETE",
            url:
                "/institucion/bienestar/encuestas/questions/opcion/destroy/"+idPregunta+'/'+idopcion,
            beforeSend: function () {},
            success: function (data) {
                console.log(data)
                if (data.status == true) {
                    ListarQuestions();
                    notificaciontoast("info", data.mensaje, "Éxito!");
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }
     // FIN - ELIMINAR OPCION DE PREGUNTA


    // INYECTAR SECCION DE TIPO DE PREGUNTA SENCILLA O MULTIPLE O TEXTO
    $("#txt-tiprespuesta").on("change", function (e) {
        var valorSeleccionado = $(this).val();
        const container = $("#sectionTipoPregunta");
        container.empty();
        // confirmacion
        switch (valorSeleccionado) {
            case "texto":
                // Mostrar algo para la opción 1
                container.html(QuestionsText);
                break;
            case "opcion_unica":
                // Mostrar algo para la opción 2
                container.html(QuestionsUnica);
                break;
            case "multiple":
                // Mostrar algo para la opción 3
                container.html(QuestionsMultiple);
                break;
            default:
                // Si no se selecciona ninguna opción esperada
                console.log("Opción no válida");
        }
    });
    // FIN




    // AGREGA UNA OPCION DENTRO DE GRUPO DE TIPO DE PREGUNTA SENCILLA O MULTIPLE O TEXTO
     let count1 = 3;
     let count2 = 3;
    $("#sectionTipoPregunta").on("click", ".btn_AddOpcion", function (e) {
        let opcion = $(this).data("opcion");
        let html;

        switch (opcion) {
            case "unica":
                // Mostrar algo para la opción 1
                html = `
                    <div class="row m-0 justify-content-between" id="seccionOpcionRadio${count1}">
                        <div class="col-sm-11 form-check mb-2">
                            <input class="form-check-input" type="radio">
                            <label class="row m-0 px-2 form-check-label">
                                <input type="text" name="text_preguntaradio[]" class="form-control form-control-sm" required>
                            </label>
                        </div>
                         <div class="col-sm-1 mb-2 pt-3 text-end">
                            <a class="text-danger dleteBtn-opcionModal"  data-idopcionModal="seccionOpcionRadio${count1}" href="#"><svg xmlns="http://www.w3.org/2000/svg" height="16px" viewBox="0 -960 960 960" width="24px" fill="#5f6368"><path d="M280-120q-33 0-56.5-23.5T200-200v-520h-40v-80h200v-40h240v40h200v80h-40v520q0 33-23.5 56.5T680-120H280Zm400-600H280v520h400v-520ZM360-280h80v-360h-80v360Zm160 0h80v-360h-80v360ZM280-720v520-520Z"/></svg></a>
                        </div>
                    </div>
                  `;
                  count1 = count1 +1;
                break;
            case "multiple":
                // Mostrar algo para la opción 3
                html = `
                      <div class="row m-0 justify-content-between" id="seccionOpcionCheck${count2}">
                           <div class="col-sm-11 form-check mb-2">
                               <input class="form-check-input" type="checkbox">
                               <label class="row m-0 px-2 form-check-label">
                                <input type="text" name="text_preguntacheck[]" class="form-control form-control-sm" required>

                               </label>
                           </div>
                           <div class="col-sm-1 mb-2 pt-3 text-end">
                                   <a class="text-danger dleteBtn-opcionModal"  data-idopcionModal="seccionOpcionCheck${count1}"  href="#"><svg xmlns="http://www.w3.org/2000/svg" height="16px" viewBox="0 -960 960 960" width="24px" fill="#5f6368"><path d="M280-120q-33 0-56.5-23.5T200-200v-520h-40v-80h200v-40h240v40h200v80h-40v520q0 33-23.5 56.5T680-120H280Zm400-600H280v520h400v-520ZM360-280h80v-360h-80v360Zm160 0h80v-360h-80v360ZM280-720v520-520Z"/></svg></a>
                           </div>
                       </div>
                    `;
                    count2 = count2 +1;
                break;
            default:
                // Si no se selecciona ninguna opción esperada
                console.log("Opción no válida");
        }
        $("#container_opciones").append(html);
    });
    // ELIMINAR UNA OPCION AGREGADA DENTRO DE GRUPO DE TIPO DE PREGUNTA
    $("#sectionTipoPregunta").on("click", ".dleteBtn-opcionModal", function (e) {
        // Puedes obtener atributos del elemento directamente
        let idopcionModal = $(e.currentTarget).attr("data-idopcionModal");
        $("#" + idopcionModal).remove();
    });
   // FIN



    //RESET EL MODAL DE AGREGAR PREGUNTAS
    function clear_formPreguntas() {
        $("#id_encuesta_hidden").val("");
        $("#formModal")[0].reset(); // Resetear el formulario
        $("#txt-tiprespuesta").selectpicker("val", "0");
        const container = $("#sectionTipoPregunta");
        container.empty();
        $("#btnCreateUpdate").val("Create"); // Cambiar el texto del botón
        $("#btnCreateUpdate").html("Guardar"); // Cambiar el texto del botón
    }

    function clear_formEdittitulos() {
        $("#txt-PreguntaoOpcion").val("");
        $("#txt-idpopcionpregunta").val("");

        $("#formModalEditTitulo")[0].reset(); // Resetear el formulario
    }
    //FIN FUNCION
});
