import { notificaciontoast } from "../../common/method_toast.js";
import { confirmation_sweetAlert } from "../../common/method_sweetAlert.js";
import { getButtonsSchema, languageSchema } from "../../common/schemas.js";
import { cb_provincias, cb_distritos, ubigeo_for_update, vaciar_distritos, vaciar_provincias } from "../../common/combobox/ubigeo.js";
import { cb_identificationtypes_applicants } from "../../common/combobox/identificationtypes.js";

$(document).ready(function () {
    var dt_idplan, gb_estado_admision, gb_idadmissionplan, gb_fecfin_postulacion;
    const tableName = "Postulantes";

    // LISTAR DATATABLE ************************* LISTO
    var table = $("#datatableGeneral").DataTable({
        createdRow: function (row, data, index) {
            $(row).addClass("selected");
        },
        order: [],
        ajax: {
            type: "GET",
            url: "/admin/admision/postulantes/list",
            data: function (d) {
                d.idplan = dt_idplan;
            },
        },
        searching: true,
        dom: "Bfrtip",
        select: false,
        lengthChange: false,
        responsive: true,
        language: languageSchema,
        buttons: getButtonsSchema(tableName),
        columns: [
            { data: "modalidad", className: "text-center" },
            { data: "tipomod", className: "text-center" },
            { data: "tipoidenti", className: "text-center",
                render: function (data, type, all, meta) {
                    if (all.tipoidenti == "Carnet de extranjería") {
                        return "Carnet de ext.";
                    } else {
                        return all.tipoidenti;
                    }
                },
            },
            { data: "nroidenti", className: "text-center" },
            { data: "apellidos", className: "text-center",
                render: function (data, type, all, meta) {
                    return all.apellido_pa + " " + all.apellido_ma;
                },
            },
            { data: "nombres", className: "text-center" },
            { data: "nota", className: "text-center",
                render: function (data, type, all, meta) {
                    return all.nota;
                },
            },
            { data: "docdni", className: "text-center",
                render: function (data, type, all, meta) {
                    if (all.docdni == null) {
                        return "--";
                    } else if (all.docdni == "--" || all.docdni == "") {
                        return `
                        <div class="d-flex justify-content-center">
                            --
                        </div>
                        `;
                    } else {
                        return `
                        <div class="d-flex justify-content-center">
                            <a href="/verPostulanteDNI/${all.idapplicant}" class="btn btn-info shadow btn-xs sharp me-1"
                            target="_blank"
                            data-bs-placement="top"
                            title="Ver Doc. DNI">
                            <i class="fas fa-file-lines fa-lg"></i>
                            </a>
                        </div>
                        `;
                    }
                },
            },
            { data: "doccertif", className: "text-center",
                render: function (data, type, all, meta) {
                    if (all.doccertif == null) {
                        return "--";
                    } else if (all.doccertif == "--" || all.doccertif == "") {
                        return `
                        <div class="d-flex justify-content-center">
                            --
                        </div>
                        `;
                    } else {
                        return `
                        <div class="d-flex justify-content-center">
                            <a href="/verPostulanteCertificado/${all.idapplicant}" class="btn btn-info shadow btn-xs sharp me-1"
                            target="_blank"
                            data-bs-placement="top"
                            title="Ver Doc. DNI">
                            <i class="fas fa-file-lines fa-lg"></i>
                            </a>
                        </div>
                        `;
                    }
                },
            },
            { data: "docboucher", className: "text-center",
                render: function (data, type, all, meta) {
                    if (all.docboucher == null) {
                        return "--";
                    } else if (all.docboucher == "--" || all.docboucher == "") {
                        return `
                        <div class="d-flex justify-content-center">
                            --
                        </div>
                        `;
                    } else {
                        return `
                        <div class="d-flex justify-content-center">
                            <a href="/verPostulanteBoucher/${all.idapplicant}" class="btn btn-info shadow btn-xs sharp me-1"
                            target="_blank"
                            data-bs-placement="top"
                            title="Ver Doc. DNI">
                            <i class="fas fa-file-lines fa-lg"></i>
                            </a>
                        </div>
                        `;
                    }
                },
            },
            { data: "docdatosper", className: "text-center",
                render: function (data, type, all, meta) {
                    if (all.docdatosper == null) {
                        return "--";
                    } else if (
                        all.docdatosper == "--" ||
                        all.docdatosper == ""
                    ) {
                        return `
                        <div class="d-flex justify-content-center">
                            --
                        </div>
                        `;
                    } else {
                        return `
                        <div class="d-flex justify-content-center">
                            <a href="/verPostulanteDatosPersonales/${all.idapplicant}" class="btn btn-info shadow btn-xs sharp me-1"
                            target="_blank"
                            data-bs-placement="top"
                            title="Ver Doc. DNI">
                            <i class="fas fa-file-lines fa-lg"></i>
                            </a>
                        </div>
                        `;
                    }
                },
            },
            { data: "estado", sortable: false, className: "text-center",
                render: function (data, type, all, meta) {
                    if (all.estado_postulante == "Admitido") {
                        return `<h5 class="mb-0"><span class="badge light badge-success">Admitido</span></h5>`;
                    } else {
                        return `<h5 class="mb-0"><span class="badge light badge-danger">No Admitido</span></h5>`;
                    }
                },
            },
            { data: "id", className: "text-center noExport", sortable: false, searchable: false,
                render: function (data, type, all, meta) {
                    if (all.estado == "9") {
                        return "--";
                    } else if (all.estado == "4" || all.estado == "6") {
                        return `
                                <div class="d-flex justify-content-center">
                                    <a href="javascript:void(0);" class="btnAprobarInscripcion btn btn-success shadow btn-xs sharp me-2"
                                    data-idapplicant="${all.id}"
                                    data-bs-placement="top"
                                    title="Aprobar Inscripción">
                                    <i class="fas fa-check"></i>
                                    </a>
                                    <a href="javascript:void(0);" class="btnRechazarInscripcion btn btn-danger shadow btn-xs sharp"
                                    data-idapplicant="${all.id}"
                                    data-bs-placement="top"
                                    title="Rechazar Inscripción">
                                    <i class="fas fa-x"></i>
                                    </a>
                                </div">
                            `;
                    } else {
                        return `
                                <div class="d-flex justify-content-center">
                                    <!-- <a href="javascript:void(0);" class="modalUpdateNota btn btn-warning shadow btn-xs sharp me-1"
                                        data-id="${all.id}"
                                        data-nota="${all.nota}"
                                        data-estado="${all.estado}"
                                        data-bs-placement="top"
                                        title="Actualizar nota del postulante">
                                        <i class="fas fa-pencil-alt"></i>
                                    </a> -->

                                    <a href="javascript:void(0);" class="editBtn btn btn-warning shadow btn-xs sharp me-1"
                                        data-id="${all.id}"
                                        data-ididentificationtype="${all.ididentificationtype}"
                                        data-tipoidenti="${all.tipoidenti}"
                                        data-nroidenti="${all.nroidenti}"
                                        data-nombres="${all.nombres}"
                                        data-apellido_ma="${all.apellido_ma}"
                                        data-apellido_pa="${all.apellido_pa}"
                                        data-fecnac="${all.fecnac}"
                                        data-correo="${all.correo}"
                                        data-tlf="${all.tlf}"
                                        data-celular="${all.celular}"
                                        data-lugarnac="${all.lugarnac}"
                                        data-direccion="${all.direccion}"
                                        data-nota="${all.nota}"
                                        data-comentario="${all.comentario}"
                                        data-modalidad="${all.modalidad}"
                                        data-tipomod="${all.tipomod}"
                                        data-genero="${all.genero}"
                                        data-estado="${all.estado}"
                                        data-idubigeo="${all.idubigeo}"
                                        data-idgenre="${all.idgenre}"
                                        data-iddepartamento="${all.iddepartamento}"
                                        data-departamento="${all.departamento}"
                                        data-idprovincia="${all.idprovincia}"
                                        data-provincia="${all.provincia}"
                                        data-iddistrito="${all.iddistrito}"
                                        data-distrito="${all.distrito}"
                                        data-bs-placement="top"
                                        title="Editar Postulante">
                                        <i class="fas fa-pencil-alt"></i>
                                    </a>

                                    <a href="javascript:void(0);" class="btnConvertirEstudiante btn btn-dark shadow btn-xs sharp me-1"
                                        data-id="${all.id}"
                                        data-ididentificationtype="${all.ididentificationtype}"
                                        data-tipoidenti="${all.tipoidenti}"
                                        data-nroidenti="${all.nroidenti}"
                                        data-nombres="${all.nombres}"
                                        data-apellido_ma="${all.apellido_ma}"
                                        data-apellido_pa="${all.apellido_pa}"
                                        data-fecnac="${all.fecnac}"
                                        data-correo="${all.correo}"
                                        data-tlf="${all.tlf}"
                                        data-celular="${all.celular}"
                                        data-lugarnac="${all.lugarnac}"
                                        data-direccion="${all.direccion}"
                                        data-nota="${all.nota}"
                                        data-comentario="${all.comentario}"
                                        data-modalidad="${all.modalidad}"
                                        data-tipomod="${all.tipomod}"
                                        data-genero="${all.genero}"
                                        data-estado="${all.estado}"
                                        data-idubigeo="${all.idubigeo}"
                                        data-idgenre="${all.idgenre}"
                                        data-bs-placement="top"
                                        title="Convertir postulante a estudiante">
                                        <i class="fas fa-user-check fa-lg"></i>
                                    </a>

                                    <a href="javascript:void(0);" class="deleteBtn btn btn-danger shadow btn-xs sharp"
                                    data-idaplicant="${all.id}"
                                    data-bs-placement="top"
                                    title="Eliminar registro">
                                    <i class="fas fa-trash"></i>
                                    </a>
                                </div">
                            `;
                    }
                },
            },
        ],
    });

    cb_identificationtypes_applicants();

    // LIMPIAR VALIDACIONES  ************************* LISTO
    function clearCheck() {
        formCheck = $("#formModal2")[0];
        $(formCheck).removeClass("was-validated"); // remover validaciones
    }

    var valbtn, formCheck;

    // INICIO - MODAL CREATE ************************* LISTO
    $("#btnCreateModal").click(function () {
        if (isPostulacionClosed()) {
            notificaciontoast("error", "El periodo de postulación ha finalizado.", "Error");
            return;
        }
        // change value
        $("#btnCreateUpdate").attr("value", "Create");
        $("#btnCreateUpdate").html("Registrar");
        $("#modalCreateUpdateLabel").html("Registrar datos del Postulante");
        // mostrar contraseña
        $("#div_txt_password").removeAttr("style");
        clearCheckModal();
        clearFormModal();
        
        if ($("#name_plan_title").val() != "") {
            $("#modalCreateUpdate").modal("show");
        } else {
            notificaciontoast("error", "Seleccione un Programa / Plan de estudio", "Error");
        }
    });
    // FIN - MODAL CREATE


    // INICIO - MODAL UPDATE
    $("#datatableGeneral tbody").on("click", ".editBtn", function (e) {
        clearCheckModal();   // borrar validaciones
        //cambiar el text del button
        $("#btnCreateUpdate").html("Actualizar");
        $("#modalCreateUpdateLabel").html("Actualizar datos del Administrador");
        
        // setear data de usuario
        $("#txt_idplicant").val($(this).data("id"));
        $("#txt_nroidenti").val($(this).data("nroidenti"));
        $("#txt_modalidad").selectpicker("val", $(this).attr("data-modalidad"));
        $("#txt_tipomodalidad").selectpicker("val", $(this).attr("data-tipomod"));
        $("#txt_nombres").val($(this).data("nombres"));
        $("#txt_apellido_pa").val($(this).data("apellido_pa"));
        $("#txt_apellido_ma").val($(this).data("apellido_ma"));
        $("#txt_lugar_nac").val($(this).data("lugarnac"));
        $("#txt_fecnac").val($(this).data("fecnac"));
        $("#txt_correo").val($(this).data("correo"));
        $("#txt_tlf").val($(this).data("tlf"));
        $("#txt_celular").val($(this).data("celular"));
        $("#txt_genre_id").selectpicker("val", $(this).attr("data-idgenre"));
        $("#txt_direccion").val($(this).data("direccion"));
        $("#txt_nota").val($(this).data("nota"));
        $("#txt_comentario").val($(this).data("comentario"));
        // ubigeo
        $("#txt_departamento").selectpicker("val", $(this).attr("data-iddepartamento"));
        let sl_departamento = $(this).data("departamento");
        let sl_provincia = $(this).data("provincia");
        let sl_distrito = $(this).data("distrito");
        ubigeo_for_update(sl_departamento, sl_provincia, sl_distrito);
        // obtener datos del administrador
        $("#txt_idadministrador").val($(this).data("idadministrador"));
        $("#txt_role_id").selectpicker("val", $(this).attr("data-role_id"));
        // show form
        $("#modalCreateUpdate").modal("show");
        // change value
        $("#btnCreateUpdate").attr("value", "Update");
    });
    // FIN - MODAL UPDATE

    // INICIO - FUNCION CREATE O UPDATE
    $("#btnCreateUpdate").on("click", function (event) {
        event.preventDefault();
        // Iterar sobre los formularios y evitar la acción predeterminada si no son válidos
        formCheck = $("#formModal")[0];
        if (!formCheck.checkValidity()) {
            event.preventDefault();
            event.stopPropagation();
        } else {
            valbtn = $("#btnCreateUpdate").val();
            // FUNCION CREAR
            if (valbtn === "Create") {
                // insertar
                store_applicant();
                document.getElementById("title_programa").innerHTML = "";
                document.getElementById("name_programa_title").value = "";
                document.getElementById("title_plan").innerHTML = "";
                document.getElementById("name_plan_title").value = "";
            }
            // FUNCION ACTUALIZAR
            if (valbtn === "Update") {
                // actualizar
                // update_applicant($("#txt_iduser").val());
                update_applicant($("#txt_idplicant").val());
            }
        }
        $(formCheck).addClass("was-validated"); // añadir validaciones
    });
    // FIN - FUNCION CREATE O UPDATE

    $("#datatableGeneral tbody").on("click", ".deleteBtn", function (e) {
        let idaplicant = $(this).data("idaplicant");
        // confirmacion
        confirmation_sweetAlert("Deseas continuar?", "Se procederá a eliminar el registro de la base de datos", "warning"
        ).then(function (isConfirm) {
            if (isConfirm.value) {
                // enviando el parametro de la data que se procede a delete
                destroyaplicants(idaplicant);
            } else {
            }
        });
    });

    function destroyaplicants(idaplicant) {
        $.ajax({
            headers: { "X-CSRF-TOKEN": $('input[name="_token"]').val() },
            type: "DELETE",
            url: "/admin/inscripciones/postulantes/destroy/" + idaplicant,
            beforeSend: function () {
                $("#loader").show(); // Show loader
            },
            success: function (data) {
                $("#loader").hide(); // Hide loader
                if (data.status == true) {
                    table.ajax.reload();
                    notificaciontoast("info", data.mensaje, "Éxito!");
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
            error: function (error) {
                $("#loader").hide(); // Hide loader
                console.log("Error", error);
            },
        });
    }

    var formModal, formData;
    //FUNCION CREAR UN REGISRO   ************************* LISTO
    function store_applicant() {
        formData = new FormData(document.getElementById("formModal"));
        formModal = $("#formModal");
        $.ajax({
            type: "POST",
            url: "/admin/inscripciones/postulantes/store",
            data: formData,
            processData: false,
            contentType: false,
            beforeSend: function () {
                $("#btnCreateUpdate").addClass("disabled");
            },
            success: function (data) {
                $("#loader").hide(); // Hide loader
                if (data.status == "validators") {
                    for (var campo in data.mensaje) {
                        if (data.mensaje.hasOwnProperty(campo)) {
                            var mensajes = data.mensaje[campo];
                            for (var i = 0; i < mensajes.length; i++) {
                                var mensaje = mensajes[i];
                                notificaciontoast(
                                    "error",
                                    mensaje,
                                    "Error!",
                                    "bottom-right",
                                    2000
                                );
                            }
                        }
                    }
                    $("#btnCreateUpdate").removeClass("disabled");
                } else if (data.status == true) {
                    setTimeout(function () {
                        table.ajax.reload(); // añadir validaciones
                        formModal.addClass("was-validated");
                        notificaciontoast("info", data.mensaje, "Éxito!");
                        $("#modalCreateUpdate").modal("hide");
                        $("#btnCreateUpdate").removeClass("disabled");
                        clearFormModal();
                        clearCheckModal();
                    }, 1000); // ocultar despues de 1 sec
                } else if (data.status == false) {
                    notificaciontoast("error", data.mensaje, "Error!");
                    $("#btnCreateUpdate").removeClass("disabled");
                }
            },
            error: function (error) {
                $("#loader").hide(); // Hide loader
                console.log("Error", error);
                $("#btnCreateUpdate").removeClass("disabled");
            },
        });
    }

    function update_applicant(idaplicant) {
        formData = new FormData(document.getElementById("formModal"));
        formModal = $("#formModal");
        $.ajax({
            headers: { "X-CSRF-TOKEN": $('input[name="_token"]').val() },
            type: "POST",
            url: "/admin/inscripciones/postulantes/update/" + idaplicant,
            data: formData,
            processData: false,
            contentType: false,
            dataType: "json",
            beforeSend: function () {
                $("#btnCreateUpdate").addClass("disabled");
            },
            success: function (data) {
                $("#loader").hide(); // Hide loader
                if (data.status == true) {
                    table.ajax.reload();
                    formModal.addClass("was-validated"); // añadir validaciones
                    notificaciontoast("info", data.mensaje, "Éxito!");
                    $("#modalCreateUpdate").modal("hide");
                    $("#btnCreateUpdate").removeClass("disabled");
                    clearFormModal();
                    clearCheckModal();
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
            error: function (error) {
                $("#loader").hide(); // Hide loader
                console.log("Error", error);
            },
        });
    }


    // INICIO - MODAL UPDATE PASSWORD ************************* LISTO
    $("#datatableGeneral tbody").on("click", ".modalUpdateNota", function (e) {
        clearCheck(); // borrar validaciones
        $("#btnUpdateNota").html("Actualizar");
        // borrar validaciones
        formCheck = $("#formModal2")[0];
        $(formCheck).removeClass("was-validated"); // remover validaciones
        // setear data de usuario
        $("#txt_iduser2").val($(this).data("id"));
        
        let estado = $(this).attr("data-estado");
        let nombreestado = "";
        if (estado == "4") {
            nombreestado = "Inscrito (documentos)";
        } else if (estado == "5") {
            nombreestado = "Inscripción aprobada";
        } else if (estado == "7") {
            nombreestado = "Nota editada";
        } else if (estado == "9") {
            nombreestado = "Ingresante";
        }
        $("#txt_estado").val(nombreestado);
        let nota = $(this).data("nota");
        $("#txt-nota").val(nota);
        // show form
        $("#modalUpdateNota").modal("show");
        $("#btnUpdateNota").attr("value", "Update");
    });

    // INICIO - FUNCION NOTAS
    $("#btnUpdateNota").on("click", function (event) {
        event.preventDefault();
        // Iterar sobre los formularios y evitar la acción predeterminada si no son válidos
        formCheck = $("#formModal2")[0];
        if (!formCheck.checkValidity()) {
            event.preventDefault();
            event.stopPropagation();
        } else {
            valbtn = $("#btnUpdateNota").val();
            // FUNCION ACTUALIZAR
            if (valbtn === "Update") {
                // actualizar
                update($("#txt_iduser2").val());
            }
        }
        $(formCheck).addClass("was-validated"); // añadir validaciones
    });

    function update(iduser) {
        $.ajax({
            headers: { "X-CSRF-TOKEN": $('input[name="_token"]').val() },
            type: "PUT",
            url: "/admin/inscripciones/postulantes/updateNota/" + iduser,
            data: $("#formModal2").serialize(),
            dataType: "json",
            beforeSend: function () {
                notificaciontoast(
                    "warning",
                    "Procesando solicitud",
                    "Mesanje!"
                );
                $("#loader").show(); // Show loader
            },
            success: function (data) {
                $("#loader").hide(); // Hide loader
                if (data.status == true) {
                    table.ajax.reload();
                    notificaciontoast("info", data.mensaje, "Éxito!");
                    setTimeout(function () {
                        $("#modalUpdateNota").modal("hide");
                    }, 1000); // ocultar despues de 1 sec
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
            error: function (error) {
                $("#loader").hide(); // Hide loader
                console.log("Error", error);
            },
        });
    }

    // INICIO - MODAL CONVERTIR POSTULANTE A ESTUDIANTE ************************* LISTO
    $("#datatableGeneral tbody").on("click", ".btnConvertirEstudiante",
        function (e) {
            let objDatosStudents = {
                idapplicant: $(this).data("id"),
                idplan: $("#txt-idplan").val(),
                anho: $("#txt-anho").val(),
                identificationtype_id: $(this).data("ididentificationtype"),
                nroidenti: $(this).data("nroidenti"),
                nombres: $(this).data("nombres"),
                apellido_ma: $(this).data("apellido_ma"),
                apellido_pa: $(this).data("apellido_pa"),
                fecnac: $(this).data("fecnac"),
                correo: $(this).data("correo"),
                tlf: $(this).data("tlf"),
                celular: $(this).data("celular"),
                lugarnac: $(this).data("lugarnac"),
                direccion: $(this).data("direccion"),
                nota: $(this).data("nota"),
                comentario: $(this).data("comentario"),
                modalidad: $(this).data("modalidad"),
                tipomod: $(this).data("tipomod"),
                genero: $(this).data("genero"),
                idubigeo: $(this).data("idubigeo"),
                idgenre: $(this).data("idgenre"),
            };
            // confirmacion
            confirmation_sweetAlert(
                "Deseas continuar?",
                "¿Estás seguro de convertir al postulante a estudiante?",
                "warning"
            ).then(function (isConfirm) {
                if (isConfirm.value) {
                    ConvertPostulante(objDatosStudents);
                }
            });
        }
    );
    // FIN - MODAL DELETE

    // INICIO - FUNCION INSERTAR PLANTILLA
    $("#btn_insert_plantilla").click(function () {
        // if (isPostulacionClosed()) {
        //     notificaciontoast("error", "El periodo de postulación ha finalizado.", "Error");
        //     return;
        // }
        if ($("#name_plan_title").val() != "") {
            if (datajsondos.length > 0) {
                // confirmacion
                confirmation_sweetAlert( "Deseas continuar?", "Se procederá a insertar la plantilla a la base de datos, consideras que los datos enviados son los correctos", "warning")
                .then(function (isConfirm) {
                    if (isConfirm.value) {
                        store_plantilla();
                    } 
                });
            } else {
                notificaciontoast(
                    "error",
                    "Seleccione una plantilla y previsualice",
                    "Error"
                );
            }
        } else {
            notificaciontoast(
                "error",
                "Seleccione un programa / Plan de estudio",
                "Error",
            );
        }
    });
    // FIN

    // FUNCION CONVERTIR POSTULANTE A ESTUDIANTE ************************* LISTO
    function ConvertPostulante(objDatosStudents) {
        $.ajax({
            headers: { "X-CSRF-TOKEN": $('input[name="_token"]').val() },
            type: "POST",
            url: "/admin/inscripciones/postulantes/transformApplicantToStudent",
            data: JSON.stringify(objDatosStudents),
            contentType: "application/json; charset=utf-8",
            dataType: "json",
            beforeSend: function () {
                notificaciontoast(
                    "warning",
                    "Procesando solicitud!",
                    "Mensaje!"
                );
                $("#loader").show(); // Show loader
            },
            success: function (data) {
                $("#loader").hide(); // Hide loader
                if (data.status == true) {
                    table.ajax.reload();
                    notificaciontoast("info", data.mensaje, "Éxito!");
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
            error: function (error) {
                $("#loader").hide(); // Hide loader
                console.log("Error", error);
            },
        });
    }

    // LIMPIAR VALIDACIONES  ************************* LISTO
    function clearCheckModal() {
        formCheck = $("#formModal")[0];
        $(formCheck).removeClass("was-validated"); // remover validaciones
    }

    // LIMPIAR FORMULARIO ************************* LISTO
    function clearFormModal() {
        $("#txt_idplicant").val("");
        $("#txt-identificationtype").selectpicker("val", "");
        $("#txt_nroidenti").val("");
        $("#txt_modalidad").selectpicker("val", "");
        $("#txt_tipomodalidad").selectpicker("val", "");
        $("#txt_nombres").val("");
        $("#txt_apellido_pa").val("");
        $("#txt_apellido_ma").val("");
        $("#txt_lugar_nac").val("");
        $("#txt_fecnac").val("");
        $("#txt_correo").val("");
        $("#txt_tlf").val("");
        $("#txt_celular").val("");
        $("#txt_genre_id").selectpicker("val", "");
        $("#txt_departamento").selectpicker("val", "");
        $("#txt-docdni").val("");
        $("#txt-doccertif").val("");
        $("#txt-docboucher").val("");
        $("#txt-docdatosper").val("");
        vaciar_provincias();
        vaciar_distritos();

        $("#txt_nota").val("");
        $("#txt_comentario").val("");

        $("#txt_direccion").val("");
    }

    //Traer datos con el DNI desde la base de datos
    $("#btn-querybd").on("click", function (event) {
        var nroidenti = $("#txt_nroidenti").val();
        $.ajax({
            type: "GET",
            url: "/admin/query_bd/" + nroidenti,
            dataType: "json",
            beforeSend: function () {},
            success: function (response) {
                if (response.data.length == 0) {
                    notificaciontoast(
                        "error",
                        "El usuario no existe en la base de datos",
                        "Error!",
                        "top-center"
                    );
                } else {
                    const dataObj = response.data;
                    for (const key in dataObj) {
                        if (dataObj.hasOwnProperty(key)) {
                            const user = dataObj[key];
                            
                            // setear data de programa
                            $("#txt_nombres").val(convertirTexto(user.nombres));
                            $("#txt_apellido_pa").val(convertirTexto(user.apellido_pa));
                            $("#txt_apellido_ma").val(convertirTexto(user.apellido_ma));
                            $("#txt_fecnac").val(user.fecnac);
                            $("#txt_correo").val(user.correo);
                            $("#txt_tlf").val(user.telefono);
                            $("#txt_celular").val(user.celular);
                            $("#txt_direccion").val(user.direccion);
                            $("#txt_estado").selectpicker("val", String(user.estado));
                            $("#txt_genre_id").selectpicker("val", String(user.idgenre));
                            $("#txt_departamento").selectpicker("val", user.iddepartamento);
                            let sl_departamento = user.departamento;
                            let sl_provincia = user.provincia;
                            let sl_distrito = user.distrito;
                            ubigeo_for_update(
                                sl_departamento,
                                sl_provincia,
                                sl_distrito
                            );
                            
                            // añadir clases
                            $("#txt_nombres").addClass("border border-info shadow");
                            $("#txt_apellido_pa").addClass("border border-info shadow");
                            $("#txt_apellido_ma").addClass("border border-info shadow");
                            $("#txt_fecnac").addClass("border border-info shadow");
                            $("#txt_correo").addClass("border border-info shadow");
                            $("#txt_tlf").addClass("border border-info shadow");
                            $("#txt_celular").addClass("border border-info shadow");
                            $("#txt_direccion").addClass("border border-info shadow");
                            $("#txt_estado").siblings('button[type="button"]').addClass("border border-info shadow");
                            $("#txt_genre_id").siblings('button[type="button"]').addClass("border border-info shadow");
                            $("#txt_departamento").siblings('button[type="button"]').addClass("border border-info shadow");
                            $("#txt_provincia").addClass("border border-info shadow");
                            $("#txt_distrito").addClass("border border-info shadow");
                            
                            // remover clases después de un tiempo
                            setTimeout(function () {
                                clearClasses();
                            }, 1000);
                        }
                    }
                }
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    });

    //Traer datos con el DNI desde la RENIEC
    $("#btn-querydata").on("click", function (event) {
        var nroidenti = $("#txt_nroidenti").val();
        $.ajax({
            type: "GET",
            url: "/admin/query_data/" + nroidenti,
            dataType: "json",
            beforeSend: function () {},
            success: function (response) {
                const dataObj = JSON.parse(response.data);
                if (dataObj.hasOwnProperty("message")) {
                    console.log(dataObj.message);
                    notificaciontoast(
                        "error",
                        "Datos del DNI no encontrado",
                        "Error!",
                        "top-center"
                    );
                } else {
                    $("#txt_nombres").val(convertirTexto(dataObj.nombres));
                    $("#txt_apellido_pa").val(
                        convertirTexto(dataObj.apellidoPaterno)
                    );
                    $("#txt_apellido_ma").val(
                        convertirTexto(dataObj.apellidoMaterno)
                    );

                    // setear data de programa
                    $("#txt_nombres").addClass("border border-info shadow");
                    $("#txt_apellido_pa").addClass("border border-info shadow");
                    $("#txt_apellido_ma").addClass("border border-info shadow");

                    setTimeout(function () {
                        $("#txt_nombres").removeClass(
                            "border border-info shadow"
                        );
                        $("#txt_apellido_pa").removeClass(
                            "border border-info shadow"
                        );
                        $("#txt_apellido_ma").removeClass(
                            "border border-info shadow"
                        );
                    }, 300);
                }
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    });

    function convertirTexto(texto) {
        // Convierte todo el texto a minúsculas
        texto = texto.toLowerCase();

        // Divide el texto en palabras
        var palabras = texto.split(" ");

        // Itera sobre cada palabra y capitaliza la primera letra
        for (var i = 0; i < palabras.length; i++) {
            palabras[i] =
                palabras[i].charAt(0).toUpperCase() + palabras[i].substring(1);
        }

        // Une las palabras de nuevo en un solo texto
        var resultado = palabras.join(" ");

        return resultado;
    }

    //INSERTAR STUDENTS DE PLANTILLA EXCEL
    function store_plantilla() {
        $.ajax({
            headers: { "X-CSRF-TOKEN": $('input[name="_token"]').val() },
            type: "POST",
            url: "/admin/inscripciones/postulantes/storePlantilla",
            data: {
                datajsondos: datajsondos,
                idadmissionplan: gb_idadmissionplan,
                estado_admision: gb_estado_admision,
            },
            dataType: "json",
            beforeSend: function () {
                // mostrar preloader
                $("#modalCargandoExcel").modal("show");
                document.getElementById(
                    "div_progressbar_modal_preload"
                ).innerHTML = ` <div class="drive-content mt-2 mx-2 p-1">
                        <div class="progress default-progress">
                            <div class="progress-bar bg-vigit progress-animated bg-info" style="width: 100%; height:100%;" role="progressbar">
                                <span id="txt_title_progressbar">... Cargando!</span>
                            </div>
                        </div>
                    </div>`;
                document.getElementById("id_preload_excel").innerHTML =
                    " Registrando";
            },
            success: function (data) {
                if (data.status == true) {
                    notificaciontoast("info", data.mensaje, "Éxito!");
                    document.getElementById("id_preload_excel").innerHTML =
                        " " + data.mensaje;
                    table.ajax.reload();
                    document.getElementById("hiddenswitch").value = "1";
                    if (document.getElementById("hiddenswitch").value == "1") {
                        document.getElementById("hiddenswitch").value = "0";
                        setTimeout(function () {
                            // limpiar preloader
                            document.getElementById(
                                "div_progressbar_modal_preload"
                            ).innerHTML = "";
                            document.getElementById(
                                "id_preload_excel"
                            ).innerHTML = "";
                            $("#modalCargandoExcel").modal("hide");
                            datajsondos.splice(0, datajsondos.length);
                            // limpiart tabla
                            $("#datatableGeneral_preview_Excel")
                                .DataTable()
                                .clear()
                                .draw();
                        }, 3500);
                    }
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                    document.getElementById("hiddenswitch").value = "1";
                    if (document.getElementById("hiddenswitch").value == "1") {
                        document.getElementById("hiddenswitch").value = "0";
                        setTimeout(function () {
                            // limpiar preloader
                            document.getElementById(
                                "div_progressbar_modal_preload"
                            ).innerHTML = "";
                            document.getElementById(
                                "id_preload_excel"
                            ).innerHTML = "";
                            $("#modalCargandoExcel").modal("hide");
                            $("#file_select_plantilla").val("");
                            $("#btn_previsualizar_plantilla").prop(
                                "disabled",
                                true
                            );
                            datajsondos.splice(0, datajsondos.length);
                            // limpiart tabla
                            $("#datatableGeneral_preview_Excel")
                                .DataTable()
                                .clear()
                                .draw();
                        }, 3500);
                    }
                }
            },
            error: function (error) {
                document.getElementById(
                    "div_progressbar_modal_preload"
                ).innerHTML = "";
                document.getElementById("id_preload_excel").innerHTML = "";
                $("#modalCargandoExcel").modal("hide");
                console.log("Error", error);
            },
        });
    }

    /* ---------------------------------  METODO CARGAR PLANTILLA DE EXCEL ------------------------------------------------- */
    var datajsondos = [];
    var clickdato = true;

    //activar boton cargar excel una ves que se haya selecionado el archivo excel en el input type "file"
    $("#file_select_plantilla").change(function () {
        $("#btn_previsualizar_plantilla").prop(
            "disabled",
            this.files.length == 0
        );
    });

    function CargardatosdelExcel() {
        // Obtener el archivo seleccionado
        var archivo = document.getElementById("file_select_plantilla").files[0];
        // Crear un objeto FileReader para leer el archivo
        var reader = new FileReader();
        reader.onload = function (e) {
            // Obtener los datos del archivo
            var data = e.target.result;
            var workbook = XLSX.read(data, {
                type: "binary",
            });

            // Obtener los datos de la primera hoja del archivo
            var sheetName = workbook.SheetNames[0];
            var sheet = workbook.Sheets[sheetName];

            var rangoInicio = "A4"; // Cambia la celda de inicio según sea necesario (columna B, fila 2)

            var rangoCompleto = sheet["!ref"]; // Obtiene el rango completo de la hoja
            var rangoFinal = rangoCompleto.split(":")[1]; // Obtiene la celda final del rango completo

            var rango = rangoInicio + ":" + rangoFinal;

            var datajson = XLSX.utils.sheet_to_json(sheet, {
                header: 1, // Indica que la primera fila es el encabezado
                range: rango, // Empieza desde la fila 2 (cero-indexed)
            });

            //recorremos el datajson del excel este contiene dato con filas nulas o no definidas
            datajson.forEach((row) => {
                // Si la fila tiene al menos un valor distinto de null o undefined
                if (row.some((cell) => cell !== null && cell !== undefined)) {
                    //llenamos el array de javaScript
                    datajsondos.push(row);
                }
            });

            $("#datatableGeneral_preview_Excel").DataTable({
                data: datajsondos,
                order: [],
                searching: true,
                dom: "Bfrtip",
                select: false,
                lengthChange: false,
                responsive: true,
                language: languageSchema,
                buttons: getButtonsSchema("Busqueda de Partidas"),
                fnCreatedRow: function (row, data, dataIndex) {
                    $(row).attr("id", "fila-" + dataIndex);
                    $(row)
                        .find("td")
                        .each(function (i) {
                            $(this).attr(
                                "id",
                                "fila-" + dataIndex + "-col-" + i
                            );
                        });
                },
                columns: [
                    {
                        data: `${[0]}`,
                        render: function (data, type, row, meta) {
                            return `${row[0]}`;
                        },
                    },
                    {
                        data: `${[1]}`,
                        render: function (data, type, row, meta) {
                            return `${row[1]}`;
                        },
                    },
                    {
                        data: [2],
                        className: "text-start",
                        render: function (data, type, row, meta) {
                            return `${row[2]}`;
                        },
                    },
                    {
                        data: [3],
                        className: "text-start",
                        render: function (data, type, row, meta) {
                            return `${row[3]}`;
                        },
                    },
                    {
                        data: [4],
                        className: "text-start",
                        render: function (data, type, row, meta) {
                            return `${row[4]}`;
                        },
                    },
                    {
                        data: [5],
                        className: "text-start",
                        render: function (data, type, row, meta) {
                            return `${row[5]}`;
                        },
                    },
                    {
                        data: [6],
                        className: "text-start",
                        render: function (data, type, row, meta) {
                            return `${row[6]}`;
                        },
                    },
                    {
                        data: [7],
                        className: "text-start",
                        render: function (data, type, row, meta) {
                            return `${row[7]}`;
                        },
                    },
                    {
                        data: [8],
                        className: "text-start",
                        render: function (data, type, row, meta) {
                            return `${row[8]}`;
                        },
                    },
                    {
                        data: [9],
                        className: "text-start",
                        render: function (data, type, row, meta) {
                            return `${row[9]}`;
                        },
                    },
                    {
                        data: [10],
                        className: "text-start",
                        render: function (data, type, row, meta) {
                            return `${row[10]}`;
                        },
                    },
                    {
                        data: [11],
                        className: "text-start",
                        render: function (data, type, row, meta) {
                            return `${row[11]}`;
                        },
                    },
                    {
                        data: [12],
                        className: "text-start",
                        render: function (data, type, row, meta) {
                            return `${row[12]}`;
                        },
                    },
                    {
                        data: [13],
                        className: "text-start",
                        render: function (data, type, row, meta) {
                            return `${row[13]}`;
                        },
                    },
                    {
                        data: [14],
                        className: "text-start",
                        render: function (data, type, row, meta) {
                            return `${row[14]}`;
                        },
                    },
                    {
                        data: [15],
                        className: "text-start",
                        render: function (data, type, row, meta) {
                            return `${row[15]}`;
                        },
                    },
                ],
            });
        };
        reader.readAsBinaryString(archivo);
    }

    let btnjs_btn_previsualizar_plantilla = document.querySelector(
        "#btn_previsualizar_plantilla"
    );
    btnjs_btn_previsualizar_plantilla.addEventListener("click", function (e) {
        e.preventDefault();

        if (clickdato == true) {
            CargardatosdelExcel();
            clickdato = false;
            datajsondos.splice(0, datajsondos.length);
        } else {
            datajsondos.splice(0, datajsondos.length);
            $("#datatableGeneral_preview_Excel").DataTable().destroy();
            CargardatosdelExcel();
        }
    });

    /*-----------------------------------------------------------------------------------*/
    list_admission();
    function list_admission() {
        $.ajax({
            type: "GET",
            url: "/admin/admision/listadmision",
            dataType: "json",
            beforeSend: function () {
                $("#loader").show(); // Show loader
            },
            success: function (response) {
                $("#loader").hide(); // Hide loader
                response.forEach((elemento) => {
                    document.getElementById(
                        "div_admission"
                    ).innerHTML += `<li class="btn-admission"
                            data-idadmission="${elemento.idadmission}"
                            data-anho="${elemento.anho}"
                            data-estado_admision="${elemento.estado}"
                            data-informacion="${elemento.informacion}"
                            data-fecfin_postulacion="${elemento.fecfin_postulacion}"
                        >
                        <div class="timeline-badge primary"></div>
                        <div class="drive mx-4 py-1 rounded border border-primary position-relative">
                            <div class="dz-folder">
                            <i class="fa-solid fa-file-signature fa-2xl text-primary"></i>
                            </div>
                            <div class="drive-content">
                                <h4 class="title mb-1">Año: ${elemento.anho}</h4>
                                <span class="fs-14">Fechas: ${elemento.fecinicio} - ${elemento.fecfin}</span>
                            </div>
                            <div class="info-card d-flex justify-content-center align-items-center p-2 position-absolute"
                                style="background-color: #007bff; border-radius: 25%; width: 35px; height: 35px; cursor: pointer; top: 10px; right: 10px; z-index: 99;"
                                data-bs-toggle="modal" data-bs-target="#modalInformation" data-informacion="${elemento.informacion}">
                                <i class="bi bi-info-circle" style="color: #ffffff; font-size: 1.2rem;"></i>
                            </div>
                        </div>
                    </li>`;
                });
            },
            error: function (error) {
                $("#loader").hide(); // Hide loader
                console.log("Error", error);
            },
        });
    }

    // Mostrar información en el modal
    $(document).on("click", ".info-card", function () {
        let informacion = $(this).data("informacion");
        $("#infoLoader").removeClass("d-none");
        $("#infoContent").addClass("d-none");
        $("#infoText").html("No hay información disponible.");

        if (informacion) {
            $("#infoText").html(informacion);
        } else {
            $("#infoText").html("No hay información disponible.");
        }
        $("#infoLoader").addClass("d-none");
        $("#infoContent").removeClass("d-none");
    });

    $(document).on("click", ".btn-admission", function () {
        let idadmission = $(this).attr("data-idadmission");
        list_admision_plans(idadmission);
        document.getElementById("title_programa").innerHTML =
            $(this).attr("data-anho");
        document.getElementById("name_programa_title").value =
            $(this).attr("data-anho");
        document.getElementById("txt-anho").value = $(this).attr("data-anho");

        document.getElementById("txt-idaddmisionplans").value = "";
        document.getElementById("title_plan").innerHTML = "";
        document.getElementById("name_plan_title").value = "";
        document.getElementById("txt-idplan").value = "";
        gb_estado_admision = $(this).attr("data-estado_admision");
        gb_fecfin_postulacion = $(this).attr("data-fecfin_postulacion");
        dt_idplan = "null";
        table.ajax.reload();
    });
    /*-----------------------------------------------------------------------------------*/

    function list_admision_plans(idadmission) {
        // window.idadmissionplan = idadmission;
        document.getElementById("div_admissionplan").innerHTML = "";
        $.ajax({
            headers: { "X-CSRF-TOKEN": $('input[name="_token"]').val() },
            type: "GET",
            url: "/admin/admision/listadmissionplan/" + idadmission,
            dataType: "json",
            beforeSend: function () {
                $("#loader").show(); // Show loader
            },
            success: function (response) {
                $("#loader").hide(); // Hide loader
                response.forEach((elemento) => {
                    document.getElementById(
                        "div_admissionplan"
                    ).innerHTML += `<li class="btn-plan"
                            data-idadmissionplan="${elemento.idadmissionplan}"
                            data-idplan="${elemento.idplan}"
                            data-plan="${elemento.programa}"
                        >
                            <div class="timeline-badge primary"></div>
                            <div class="drive mx-4 py-1 rounded border border-primary">
                                <div class="dz-folder">
                                <i class="fa-solid fa-graduation-cap fa-2xl text-primary"></i>
                                </div>
                                <div class="drive-content">
                                    <h4 class="title mb-1">Programa: ${elemento.programa}</h4>
                                    <span class="fs-14">Plan: ${elemento.plan}  |  Tipo: ${elemento.tipo}</span>
                                </div>
                            </div>
                        </li>`;
                });
                // document.getElementById('txt_title_progressbar').innerHTML = "Carga completada";
            },
            error: function (error) {
                $("#loader").hide(); // Hide loader
                console.log("Error", error);
            },
        });
    }

    $(document).on("click", ".btn-plan", function () {
        dt_idplan = $(this).attr("data-idplan");
        gb_idadmissionplan = $(this).attr("data-idadmissionplan");
        document.getElementById("txt-idaddmisionplans").value = $(this).attr(
            "data-idadmissionplan"
        );
        document.getElementById("title_plan").innerHTML =
            $(this).attr("data-plan");
        document.getElementById("name_plan_title").value =
            $(this).attr("data-plan");
        $("#txt-idplan").val($(this).data("idplan"));
        table.ajax.reload();
    });

    // APROBAR POSTULACION
    $("#datatableGeneral tbody").on(
        "click",
        ".btnAprobarInscripcion",
        function (e) {
            let idapplicant = $(this).data("idapplicant");
            // confirmacion
            confirmation_sweetAlert(
                "Deseas continuar?",
                "Se procederá a aprobar la inscripción del postulante",
                "warning"
            ).then(function (isConfirm) {
                if (isConfirm.value) {
                    // enviando el parametro de la data que se procede a delete
                    aprobarInscripcion(idapplicant);
                } else {
                }
            });
        }
    );

    function aprobarInscripcion(idapplicant) {
        $.ajax({
            headers: { "X-CSRF-TOKEN": $('input[name="_token"]').val() },
            type: "PUT",
            url:
                "/admin/inscripciones/postulantes/aprobarInscripcion/" +
                idapplicant,
            beforeSend: function () {
                $("#loader").show(); // Show loader
            },
            success: function (data) {
                $("#loader").hide(); // Hide loader
                if (data.status == true) {
                    table.ajax.reload();
                    notificaciontoast("info", data.mensaje, "Éxito!");
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
            error: function (error) {
                $("#loader").hide(); // Hide loader
                console.log("Error", error);
            },
        });
    }

    // RECHAZAR POSTULACION
    $("#datatableGeneral tbody").on(
        "click",
        ".btnRechazarInscripcion",
        function (e) {
            let idapplicant = $(this).data("idapplicant");
            // confirmacion
            confirmation_sweetAlert(
                "Deseas continuar?",
                "Se procederá a rechazar la inscripción del postulante",
                "warning"
            ).then(function (isConfirm) {
                if (isConfirm.value) {
                    // enviando el parametro de la data que se procede a delete
                    rechazarInscripcion(idapplicant);
                } else {
                }
            });
        }
    );

    function rechazarInscripcion(idapplicant) {
        $.ajax({
            headers: { "X-CSRF-TOKEN": $('input[name="_token"]').val() },
            type: "PUT",
            url:
                "/admin/inscripciones/postulantes/rechazarInscripcion/" +
                idapplicant,
            beforeSend: function () {
                $("#loader").show(); // Show loader
            },
            success: function (data) {
                $("#loader").hide(); // Hide loader
                if (data.status == true) {
                    table.ajax.reload();
                    notificaciontoast("info", data.mensaje, "Éxito!");
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
            error: function (error) {
                $("#loader").hide(); // Hide loader
                console.log("Error", error);
            },
        });
    }

    function isPostulacionClosed() {
        const currentDate = new Date();
        const fecfinPostulacion = new Date(gb_fecfin_postulacion);
        // Ajustar la fecha límite para que sea al final del día
        fecfinPostulacion.setHours(23, 59, 59, 999);
        return currentDate <= fecfinPostulacion;
    }

    $("#btnCreateModal, #btn_insert_plantilla").click(function() {
        if (isPostulacionClosed()) {
            notificaciontoast(
                "error",
                "El periodo de postulación ha finalizado.",
                "Error",
                "bottom-right",
                "2500"
            );
            return;
        }
        // ...existing code...
    });

});
