import { notificaciontoast } from "../../common/method_toast.js";
import { confirmation_sweetAlert } from "../../common/method_sweetAlert.js";

$(document).ready(function () {

    var dt_idplan, gb_estado_admision, gb_idadmissionplan;
    const tableName = "Administradores";

    cb_admissions();
    // listar programas
    function cb_admissions() {
        $("#txt-idadmissionplan").find("option").remove().end() // delete options
        $.ajax({
            type: "GET",
            url: '/ajax_all/programs_online',
            dataType: 'json',
            beforeSend: function () { },
            success: function (response) {
                $("#txt-idadmissionplan").append('<option selected disabled value="">Seleccione programa</option>');
                response.forEach((elemento) => {
                    $("#txt-idadmissionplan").append('<option ' +
                        'value="' + elemento.idadmissionplan + '"' +
                        'data-idprogram="' + elemento.idprogram + '"' +
                        'data-codprograma="' + elemento.codprograma + '"' +
                        'data-nomprograma="' + elemento.nomprograma + '"' +
                        'data-nivel_formativo="' + elemento.nivel_formativo + '"' +
                        ' >' + elemento.anho + ' - ' + elemento.nomprograma + '</option>');
                });
                $("#txt-idadmissionplan").selectpicker("refresh");
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }


    cb_identificationtypes();
    function cb_identificationtypes() {
        $.ajax({
            type: "GET",
            url: "/ajax_all/identificationtypes",
            dataType: "json",
            beforeSend: function () { },
            success: function (response) {
                // $("#txt-identificationtype").append('<option selected disabled value="">Seleccione una opcion</option>');
                response.forEach((elemento) => {
                    $("#txt-identificationtype_aplicants").append('<option ' +
                        'value="' + elemento.id + '" ' +
                        'data-tipo="' + elemento.tipo + '"' +
                        ' >' + elemento.tipo + '</option>');
                })
                $("#txt-identificationtype_aplicants").selectpicker("refresh");
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    // LIMPIAR VALIDACIONES  ************************* LISTO
    function clearCheck() {
        formCheck = $("#formModal2")[0];
        $(formCheck).removeClass("was-validated"); // remover validaciones
    }

    var formCheck;


    // INICIO - FUNCION CREATE O UPDATE
    $("#btnCreateUpdate").on("click", function (event) {
        event.preventDefault();
        // Iterar sobre los formularios y evitar la acción predeterminada si no son válidos
        formCheck = $("#formModal")[0];
        if (!formCheck.checkValidity()) {
            event.preventDefault();
            event.stopPropagation();
        } else {
            store();
        }
        $(formCheck).addClass("was-validated"); // añadir validaciones
    });
    // FIN - FUNCION CREATE O UPDATE


    var formData;
    //FUNCION CREAR UN REGISTRO
    function store() {
        formData = new FormData(document.getElementById('formModal'));
        $.ajax({
            headers: { "X-CSRF-TOKEN": $('input[name="_token"]').val() },
            type: "POST",
            url: "/admision/store",
            data: formData,
            processData: false,
            contentType: false,
            beforeSend: function () {
                $('#btnCreateUpdate').addClass('disabled');
            },
            success: function (data) {
                // validators
                if (data.status == 'validators') {
                    for (var campo in data.mensaje) {
                        if (data.mensaje.hasOwnProperty(campo)) {
                            var mensajes = data.mensaje[campo];
                            for (var i = 0; i < mensajes.length; i++) {
                                var mensaje = mensajes[i];
                                notificaciontoast("error", mensaje, "Error!", "bottom-right", 2000);
                            }
                        }
                    }
                    $('#btnCreateUpdate').removeClass('disabled');
                }
                else if (data.status == true) {
                    setTimeout(function () {
                        notificaciontoast("info", data.mensaje, "Éxito!");
                        $("#modalCreateUpdate").modal("hide");
                        $('#btnCreateUpdate').removeClass('disabled');
                        clearFormModal();
                        clearCheckModal();
                    }, 1000); // ocultar despues de 1 sec
                } else if (data.status == false) {
                    notificaciontoast("error", data.mensaje, "Error!");
                    $('#btnCreateUpdate').removeClass('disabled');
                }
            },
            error: function (error) {
                console.log("Error", error.mensaje);
                $('#btnCreateUpdate').removeClass('disabled');
            },
        });
    }


    // LIMPIAR VALIDACIONES  ************************* LISTO
    function clearCheckModal() {
        formCheck = $("#formModal")[0];
        $(formCheck).removeClass("was-validated"); // remover validaciones
    }


    // LIMPIAR FORMULARIO ************************* LISTO
    function clearFormModal() {
        $('#txt-idadmissionplan').selectpicker('val','');
        $('#txt-identificationtype_aplicants').selectpicker('val','1');
        $('#txt-nroidenti').val('');
        $('#txt-docdni').val('');
        $('#txt-doccertif').val('');
        $('#txt-docboucher').val('');
        $('#txt-docdatosper').val('');
        $('#txt-modalidad_aplicants').selectpicker('val','Ordinario');
        $('#txt-tipomodalidad').selectpicker('val','');
        $('#txt-nombres').val('');
        $('#txt-apellido_pa').val('');
        $('#txt-apellido_ma').val('');
        $('#txt-lugar_nac').val('');
        $('#txt-fecnac').val('');
        $('#txt-correo').val('');
        $('#txt-telefono').val('');
        $('#txt-celular').val('');
        $('#txt-genre_id').selectpicker('val','');
        $('#txt-departamento').selectpicker('val','');
        vaciar_provincias();
        vaciar_distritos();
        $('#txt-direccion').val('');
    }


    //Traer datos con el DNI desde la base de datos
    $("#btn-querybd").on("click", function (event) {
        var nroidenti = $("#txt_nroidenti").val();
        $.ajax({
            type: "GET",
            url: '/admin/query_bd/' + nroidenti,
            dataType: 'json',
            beforeSend: function () { },
            success: function (response) {
                if (response.data.length == 0) {
                    notificaciontoast("error", "El usuario no existe en la base de datos", "Error!", "top-center");
                } else {
                    const dataObj = response.data;
                    for (const key in dataObj) {
                        if (dataObj.hasOwnProperty(key)) {
                            const user = dataObj[key];

                            // setear data de programa
                            $("#txt_nombres").val(convertirTexto(user.nombres));
                            $("#txt_apellido_pa").val(convertirTexto(user.apellido_pa));
                            $("#txt_apellido_ma").val(convertirTexto(user.apellido_ma));
                            $("#txt_fecnac").val(user.fecnac);
                            $("#txt_correo").val(user.correo);
                            $("#txt_telefono").val(user.telefono);
                            $("#txt_celular").val(user.celular);
                            $("#txt_direccion").val(user.direccion);
                            $("#txt_estado").selectpicker("val", String(user.estado));
                            $("#txt_genre_id").selectpicker("val", String(user.idgenre));
                            $("#txt_departamento").selectpicker("val", user.iddepartamento);
                            let sl_departamento = user.departamento;
                            let sl_provincia = user.provincia;
                            let sl_distrito = user.distrito;
                            ubigeo_for_update(sl_departamento, sl_provincia, sl_distrito);

                            // añadir clases
                            $("#txt_nombres").addClass("border border-info shadow");
                            $("#txt_apellido_pa").addClass("border border-info shadow");
                            $("#txt_apellido_ma").addClass("border border-info shadow");
                            $("#txt_fecnac").addClass("border border-info shadow");
                            $("#txt_correo").addClass("border border-info shadow");
                            $("#txt_telefono").addClass("border border-info shadow");
                            $("#txt_celular").addClass("border border-info shadow");
                            $("#txt_direccion").addClass("border border-info shadow");
                            $("#txt_estado").siblings('button[type="button"]').addClass("border border-info shadow");
                            $("#txt_genre_id").siblings('button[type="button"]').addClass("border border-info shadow");
                            $("#txt_departamento").siblings('button[type="button"]').addClass("border border-info shadow");
                            $("#txt_provincia").addClass("border border-info shadow");
                            $("#txt_distrito").addClass("border border-info shadow");

                            // remover clases después de un tiempo
                            setTimeout(function () {
                                clearClasses();
                            }, 1000);
                        }
                    }
                }
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    });


    //Traer datos con el DNI desde la RENIEC
    $("#btn-querydata").on("click", function (event) {
        var nroidenti = $("#txt_nroidenti").val();
        $.ajax({
            type: "GET",
            url: '/admin/query_data/' + nroidenti,
            dataType: 'json',
            beforeSend: function () { },
            success: function (response) {
                const dataObj = JSON.parse(response.data);
                if (dataObj.hasOwnProperty('message')) {
                    console.log(dataObj.message);
                    notificaciontoast("error", "Datos del DNI no encontrado", "Error!", "top-center");
                } else {
                    $("#txt_nombres").val(convertirTexto(dataObj.nombres));
                    $("#txt_apellido_pa").val(convertirTexto(dataObj.apellidoPaterno));
                    $("#txt_apellido_ma").val(convertirTexto(dataObj.apellidoMaterno));

                    // setear data de programa
                    $("#txt_nombres").addClass("border border-info shadow");
                    $("#txt_apellido_pa").addClass("border border-info shadow");
                    $("#txt_apellido_ma").addClass("border border-info shadow");

                    setTimeout(function () {
                        $("#txt_nombres").removeClass("border border-info shadow");
                        $("#txt_apellido_pa").removeClass("border border-info shadow");
                        $("#txt_apellido_ma").removeClass("border border-info shadow");
                    }, 300);
                }
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    });

    function convertirTexto(texto) {
        // Convierte todo el texto a minúsculas
        texto = texto.toLowerCase();

        // Divide el texto en palabras
        var palabras = texto.split(' ');

        // Itera sobre cada palabra y capitaliza la primera letra
        for (var i = 0; i < palabras.length; i++) {
            palabras[i] = palabras[i].charAt(0).toUpperCase() + palabras[i].substring(1);
        }

        // Une las palabras de nuevo en un solo texto
        var resultado = palabras.join(' ');

        return resultado;
    }

});
