import { notificaciontoast } from "../../common/method_toast.js";
import { confirmation_sweetAlert } from "../../common/method_sweetAlert.js";
import { getButtonsSchema, languageSchema } from "../../common/schemas.js";
import { cb_programs, cb_plans } from "../../common/combobox/programs.js";

$(document).ready(function () {

    const tableName = "Administradores";

    // LISTAR DATATABLE
    var table = $('#datatableGeneral').DataTable({
        createdRow: function (row, data, index) {
            $(row).addClass("selected");
        },
        order: [],
        ajax: {
            headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
            type: 'POST',
            url: '/admin/admision/admisiones/list',
        },
        searching: true,
        dom: "Bfrtip",
        select: false,
        lengthChange: false,
        responsive: true,
        language: languageSchema,
        buttons: getButtonsSchema(tableName),
        columns: [
            { data: "idadmission", className: "text-center",
                render: function (data, type, all, meta) {
                    var estado = "";
                    if (all.estado == "0") {
                        estado = `<h4><span class="badge light badge-danger">Cerrado</span></h4>`;
                    } else if (all.estado == "1") {
                        estado = `<h4><span class="badge light badge-success">Aperturado</span></h4>`;
                    } else if (all.estado == "2") {
                        estado = `<h4><span class="badge light badge-warning">Extraordinario</span></h4>`;
                    }
                    return "<h4 class='mb-0'>" + all.anho + "</h4>" + "<b>Inicio: </b>" + all.ffecinicio + "<br>" + "<b>Fin: </b>" + all.ffecfin + "<br>" + estado;
                },
                name: "primero",
            },
            { data: "idadmission", className: "text-center noExport", sortable: false, searchable: false,
                render: function (data, type, all, meta) {
                    return `
                            <div class="d-flex justify-content-center">

                                <a href="javascript:void(0);" class="modalEstadisticas btn btn-dark shadow btn-xs sharp me-2"
                                    data-idadmission="${all.idadmission}"
                                    data-bs-placement="top"
                                    title="Ver Estadísticas">
                                    <i class="fas fa-eye fa-lg"></i>
                                </a>

                                <a href="javascript:void(0);" class="modalUpdate btn btn-warning shadow btn-xs sharp me-2"
                                data-idadmission="${all.idadmission}"
                                data-anho="${all.anho}"
                                data-fecinicio="${all.fecinicio}"
                                data-fecfin="${all.fecfin}"
                                data-fecfin_postulacion="${all.fecfin_postulacion}"
                                data-informacion="${all.informacion}"
                                data-estado="${all.estado}"
                                data-bs-placement="top"
                                title="Editar Admisión">
                                <i class="fas fa-pencil-alt fa-lg"></i>
                                </a>

                                <a href="javascript:void(0);" class="modalDelete btn btn-danger shadow btn-xs sharp me-2"
                                data-idadmission="${all.idadmission}"
                                data-bs-placement="top"
                                title="Eliminar Admisión">
                                <i class="fas fa-trash fa-lg"></i>
                                </a>

                                <a href="javascript:void(0);" class="modalAddAdmissionplan btn btn-info shadow btn-xs sharp me-2"
                                data-idadmission="${all.idadmission}"
                                data-bs-placement="top"
                                title="Añadir Programa">
                                <i class="fas fa-plus fa-lg"></i>
                                </a>

                                <a href="javascript:void(0);" class="modalInformation btn btn-purple shadow btn-xs sharp"
                                data-idadmission="${all.idadmission}"
                                data-bs-placement="top"
                                title="Información">
                                <i class="fas fa-info-circle fa-lg" style="color: #ffffff;"></i>
                                </a>
                            </div>
                            `;
                },
                name: "acciones",
            },
            { data: 'nomprogram', sortable: false, className: 'text-center',
                render: function (data, type, all, meta) {
                    if (all.nomprogram == null) {
                        return "--";
                    }
                    else {
                        return all.nomprogram + '<br> Plan: ' + all.nomplan;
                    }
                },
            },
            { data: 'vacantes', sortable: false, className: 'text-center',
                render: function (data, type, all, meta) {
                    if (all.vacantes_ordinario == null) {
                        return "--";
                    }
                    else {
                        return 'Ordinario: ' + all.vacantes_ordinario +
                            '<br>' +
                            'Exoneración: ' + all.vacantes_exoneracion;
                    }
                },
            },
            { data: "puntaje_minimo", className: "text-center" },
            { data: "idadmissionplan", className: "text-center noExport", sortable: false, searchable: false,
                render: function (data, type, all, meta) {
                    if (all.nomplan == null) {
                        return "--";
                    }
                    else {
                        return `
                            <div class="d-flex justify-content-center">

                                <a href="javascript:void(0);" class="modalUpdateAdmissionplan btn btn-warning shadow btn-xs sharp me-2"
                                data-idadmissionplan="${all.idadmissionplan}"
                                data-vacantes_ordinario="${all.vacantes_ordinario}"
                                data-vacantes_exoneracion="${all.vacantes_exoneracion}"
                                data-puntaje_minimo="${all.puntaje_minimo}"
                                data-bs-placement="top"
                                title="Editar Vacantes">
                                <i class="fas fa-pencil-alt fa-lg"></i>
                                </a>

                                <a href="javascript:void(0);" class="modalDeleteAdmissionplan btn btn-danger shadow btn-xs sharp"
                                data-idadmissionplan="${all.idadmissionplan}"
                                data-bs-placement="top"
                                title="Quitar Plan">
                                <i class="fas fa-trash fa-lg"></i>
                                </a>

                            </div>
                            `;
                    }
                },
            },
        ],
        rowsGroup: [
            'primero:name',
            'acciones:name',
        ],
        orderFixed: [0, 'desc'], // Fija el orden por defecto de la primera columna
    });


    var valbtn, formCheck;


    // INICIO - MODAL CREATE
    $("#btnCreateModal").click(function () {
        // change value
        $("#btnCreateUpdate").attr("value", "Create");
        $("#btnCreateUpdate").html("Registrar");
        $("#modalCreateUpdateLabel").html("Registrar Proceso de Admisión");
        // ocultar div
        $("#div-txt-estado").css("display", "none");
        clearCheck();
        clearForm();
        $("#txt-estado").selectpicker("val", "0"); // para poder pasar el check validity
    });
    // FIN - MODAL CREATE

    // INICIO - MODAL UPDATE
    $("#datatableGeneral tbody").on("click", ".modalUpdate", function (e) {
        clearCheck();   // borrar validaciones
        //cambiar el text del button
        $("#btnCreateUpdate").html("Actualizar");
        $("#modalCreateUpdateLabel").html("Actualizar datos del Proceso de Admisión");
        // mostrar div
        $("#div-txt-estado").removeAttr("style");
        // setear data de usuario
        $("#txt-idadmission").val($(this).data("idadmission"));
        $("#txt-anho").val($(this).data("anho"));
        $("#txt-fecinicio").val($(this).data("fecinicio"));
        $("#txt-fecfin").val($(this).data("fecfin")).prop("disabled", false);
        $("#txt-fecfin_postulacion").val($(this).data("fecfin_postulacion")).prop("disabled", false);
        $("#txt-informacion").val($(this).data("informacion"));
        $("#txt-estado").selectpicker("val", $(this).attr("data-estado"));  // no se puede this.data por ser nro
        // showform
        tinymce.get("txt-informacion").setContent($(this).data("informacion") || "No hay información");

        $("#modalCreateUpdate").modal("show");
        // change value
        $("#btnCreateUpdate").attr("value", "Update");
    });
    // FIN - MODAL UPDATE

    // INICIO - MODAL DELETE
    $("#datatableGeneral tbody").on("click", ".modalDelete", function (e) {
        let idadmission = $(this).data("idadmission")
        // confirmacion
        confirmation_sweetAlert("Deseas continuar?", "Se procederá a eliminar el registro de la base de datos", "warning")
            .then(function (isConfirm) {
                if (isConfirm.value) {
                    // enviando el parametro de la data que se procede a delete
                    destroy(idadmission);
                } else {
                    console.log("Cancelado");
                }
            });
    });
    // FIN - MODAL DELETE


    // INICIO - FUNCION CREATE O UPDATE
    $("#btnCreateUpdate").on("click", function (event) {
        event.preventDefault();
        // Iterar sobre los formularios y evitar la acción predeterminada si no son válidos
        formCheck = $("#formModal")[0];
        if (!formCheck.checkValidity() || tinymce.get("txt-informacion").getContent() === "") {
            event.preventDefault();
            event.stopPropagation();
            $(formCheck).addClass('was-validated'); // añadir validaciones
            showToast('error', 'Por favor, complete todos los campos requeridos.');
        } else {
            valbtn = $("#btnCreateUpdate").val();
            // FUNCION CREAR
            if (valbtn === "Create") {
                // insertar
                store();
            }
            // FUNCION ACTUALIZAR
            if (valbtn === "Update") {
                // actualizar
                update($("#txt-idadmission").val());
            }
        }
    });
    // FIN - FUNCION CREATE O UPDATE


    var dt_valor = "", dt_idplan = "";

    // INICIO - MODAL ESTADISTICAS
    $("#datatableGeneral tbody").on("click", ".modalEstadisticas", function (e) {
        dt_idplan = $(this).data("idadmission");
        $('#txt-tipo').selectpicker('val', '');
        // show form
        $("#modalEstadisticas").modal("show");
    });
    // FIN - MODAL ESTADISTICAS

    $(document).on("change", "#txt-tipo", function (e) {
        dt_valor = $(this).val();
        table2.ajax.reload();
    });

    // LISTAR DATATABLE
    var table2 = $('#datatableGeneral2').DataTable({
        createdRow: function (row, data, index) {
            $(row).addClass("selected");
        },
        order: [],
        ajax: {
            headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
            type: 'POST',
            url: '/admin/admision/admisiones/statistics',
            data: function (d) {
                d.valor = dt_valor;
                d.idplan = dt_idplan;
            },
        },
        searching: false,
        paging: true, // Deshabilita la paginación
        info: false, // Oculta la información de entradas
        pageLength: 20,
        dom: "Bfrtip",
        select: false,
        lengthChange: false,
        responsive: true,
        language: false,
        buttons: [],
        columns: [
            { data: "dato", className: "text-center" },
            { data: "cantidad", className: "text-center" },
        ],
    });


    var formModal;


    function store() {
        if(tinymce.get("txt-informacion").getContent() == ""){
            tinymce.get("txt-informacion").setContent("No hay información");
        }

        // Obtener el contenido del editor TinyMCE
        var informacion = tinymce.get("txt-informacion").getContent();

        // Serializar el formulario y convertirlo en un objeto de datos
        var formData = $("#formModal").serializeArray();

        // Agregar el contenido del editor al objeto de datos
        formData.push({name: "informacion", value: informacion});

        // Convertir el objeto de datos a una cadena de consulta
        var queryString = $.param(formData);

        formModal = $('#formModal');
        $.ajax({
            type: "POST",
            url: '/admin/admision/admisiones/store',
            data: queryString,
            dataType: 'json',
            beforeSend: function () { },
            success: function (data) {
                if (data.status == true) {
                    table.ajax.reload();
                    formModal.addClass("was-validated");    // añadir validaciones
                    notificaciontoast("info", data.mensaje, "Éxito!");
                    setTimeout(function () { $("#modalCreateUpdate").modal("hide"); }, 1000); // ocultar despues de 1 sec
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }


    function update(idadmission) {
        if(tinymce.get("txt-informacion").getContent() == ""){
            tinymce.get("txt-informacion").setContent("No hay información");
        }

        // Obtener el contenido del editor TinyMCE
        var informacion = tinymce.get("txt-informacion").getContent();

        // Serializar el formulario y convertirlo en un objeto de datos
        var formData = $("#formModal").serializeArray();

        // Agregar el contenido del editor al objeto de datos
        formData.push({name: "informacion", value: informacion});

        // Convertir el objeto de datos a una cadena de consulta
        var queryString = $.param(formData);

        formModal = $('#formModal');
        $.ajax({
            headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
            type: 'PUT',
            url: '/admin/admision/admisiones/update/' + idadmission,
            data: queryString,
            dataType: 'json',
            beforeSend: function () { },
            success: function (data) {
                if (data.status == true) {
                    table.ajax.reload();
                    formModal.addClass("was-validated");    // añadir validaciones
                    notificaciontoast("info", data.mensaje, "Éxito!");
                    setTimeout(function () { $("#modalCreateUpdate").modal("hide"); }, 1000);   // ocultar despues de 1 sec
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
            error: function (error) {
                console.log('Error', error)
            }
        })
    }


    function destroy(idadmission) {
        $.ajax({
            headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
            type: "DELETE",
            url: '/admin/admision/admisiones/destroy/' + idadmission,
            beforeSend: function () { },
            success: function (data) {
                if (data.status == true) {
                    table.ajax.reload();
                    notificaciontoast("info", data.mensaje, "Éxito!");
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }


    // LIMPIAR VALIDACIONES
    function clearCheck() {
        formCheck = $("#formModal")[0];
        $(formCheck).removeClass('was-validated'); // remover validaciones
    }


    // LIMPIAR FORMULARIO
    function clearForm() {
        $("#txt-idadmission").val("");
        $("#txt-anho").val("");
        $("#txt-fecinicio").val("");
        $("#txt-fecfin").val("");
        $("#txt-fecfin_postulacion").val("");
        tinymce.get("txt-informacion").setContent("No hay informacion");
        $("#txt-estado").selectpicker("val", "");
    }


    // LIMPIAR FORMULARIO
    function clearForm2() {
        $('#txt-programs').selectpicker('val', '');
        $('#txt-plans').find('option').remove().end(); // delete options
        $('#txt-plans').append('<option selected disabled value="">Seleccione plan</option>');
        $('#txt-plans').selectpicker('refresh');
        $('#txt-vacantes_ordinario').val('');
        $('#txt-vacantes_exoneracion').val('');
    }

    // LIMPIAR VALIDACIONES
    function clearCheck2() {
        formCheck = $("#formModal2")[0];
        $(formCheck).removeClass('was-validated'); // remover validaciones
    }


    // INICIO - MODAL ADD PROGRAM
    $("#datatableGeneral tbody").on("click", ".modalAddAdmissionplan", function (e) {
        // change value
        $("#btnCreateUpdateAdmissionplan").html("Registrar");
        $("#btnCreateUpdateAdmissionplan").attr("value", "Create");
        $("#modalCreateUpdateAdmissionplanLabel").html("Añadir programa a la admisión");
        // setear data de usuario
        $("#txt-idadmission").val($(this).data("idadmission"));
        // mostrar div
        $("#div-txt-programs").removeAttr("style");
        $("#div-txt-plans").removeAttr("style");
        // clean form
        clearCheck2();
        clearForm2();
        // show form
        $("#modalCreateUpdateAdmissionplan").modal("show");
    });
    // FIN - MODAL ADD PROGRAM


    // INICIO - MODAL UPDATE
    $("#datatableGeneral tbody").on("click", ".modalUpdateAdmissionplan", function (e) {
        clearCheck2();   // borrar validaciones
        //cambiar el text del button
        $("#btnCreateUpdateAdmissionplan").html("Actualizar");
        $("#btnCreateUpdateAdmissionplan").attr("value", "Update");
        $("#modalCreateUpdateAdmissionplanLabel").html("Actualizar vacantes");
        // ocultar div
        $("#div-txt-programs").css("display", "none");
        $("#div-txt-plans").css("display", "none");
        // setear data de usuario
        $("#txt-idadmissionplan").val($(this).data("idadmissionplan"));
        $("#txt-vacantes_ordinario").val($(this).data("vacantes_ordinario"));
        $("#txt-vacantes_exoneracion").val($(this).data("vacantes_exoneracion"));
        $("#txt-puntaje_minimo").val($(this).data("puntaje_minimo"));
        $("#txt-programs").selectpicker("val", "1"); // para poder pasar el check validity
        // agregar opcion a txt-plans para pasar check validity
        $('#txt-plans').find('option').remove().end(); // delete options
        $('#txt-plans').append('<option selected disabled value="0">Seleccione plan</option>');
        $('#txt-plans').selectpicker('refresh');
        $("#txt-plans").selectpicker("val", "0"); // para poder pasar el check validity
        // show form
        $("#modalCreateUpdateAdmissionplan").modal("show");
        // change value

    });
    // FIN - MODAL UPDATE


    // on change programas
    $("#txt-programs").on('change', function () {
        let idprogram = $(this).val();
        cb_plans(idprogram);
    });


    // INICIO - FUNCION CREATE O UPDATE
    $("#btnCreateUpdateAdmissionplan").on("click", function (event) {
        event.preventDefault();
        // Iterar sobre los formularios y evitar la acción predeterminada si no son válidos
        formCheck = $("#formModal2")[0];
        if (!formCheck.checkValidity()) {
            event.preventDefault();
            event.stopPropagation();
            $(formCheck).addClass('was-validated'); // añadir validaciones
        } else {
            valbtn = $("#btnCreateUpdateAdmissionplan").val();
            // FUNCION CREAR
            if (valbtn === "Create") {
                // insertar
                store_admissionplan($("#txt-idadmission").val());
            }
            // FUNCION ACTUALIZAR
            if (valbtn === "Update") {
                // actualizar
                update_admissionplan($("#txt-idadmissionplan").val());
            }
        }
    });
    // FIN - FUNCION CREATE O UPDATE


    function store_admissionplan(idadmission) {
        formModal = $('#formModal2');
        $.ajax({
            type: "POST",
            url: '/admin/admision/admisiones/store_admissionplan/' + idadmission,
            data: formModal.serialize(),
            dataType: 'json',
            beforeSend: function () { },
            success: function (data) {
                if (data.status == true) {
                    table.ajax.reload();
                    formModal.addClass("was-validated");    // añadir validaciones
                    notificaciontoast("info", data.mensaje, "Éxito!");
                    setTimeout(function () { $("#modalCreateUpdateAdmissionplan").modal("hide"); }, 1000); // ocultar despues de 1 sec
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }


    function update_admissionplan(idadmissionplan) {
        formModal = $('#formModal2');
        $.ajax({
            headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
            type: 'PUT',
            url: '/admin/admision/admisiones/update_admissionplan/' + idadmissionplan,
            data: formModal.serialize(),
            dataType: 'json',
            beforeSend: function () { },
            success: function (data) {
                if (data.status == true) {
                    table.ajax.reload();
                    formModal.addClass("was-validated");    // añadir validaciones
                    notificaciontoast("info", data.mensaje, "Éxito!");
                    setTimeout(function () { $("#modalCreateUpdateAdmissionplan").modal("hide"); }, 1000);   // ocultar despues de 1 sec
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
            error: function (error) {
                console.log('Error', error)
            }
        })
    }


    // INICIO - MODAL DELETE
    $("#datatableGeneral tbody").on("click", ".modalDeleteAdmissionplan", function (e) {
        let idadmissionplan = $(this).data("idadmissionplan")
        // confirmacion
        confirmation_sweetAlert("Deseas continuar?", "Se procederá a quitar el plan del proceso de admisión", "warning")
            .then(function (isConfirm) {
                if (isConfirm.value) {
                    // enviando el parametro de la data que se procede a delete
                    destroy_admissionplan(idadmissionplan);
                } else {
                    console.log("Cancelado");
                }
            });
    });
    // FIN - MODAL DELETE


    function destroy_admissionplan(idadmissionplan) {
        $.ajax({
            headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
            type: "DELETE",
            url: '/admin/admision/admisiones/destroy_admissionplan/' + idadmissionplan,
            beforeSend: function () { },
            success: function (data) {
                if (data.status == true) {
                    table.ajax.reload();
                    notificaciontoast("info", data.mensaje, "Éxito!");
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    // Mostrar información en el modal
    $("#datatableGeneral tbody").on("click", ".modalInformation", function (e) {
        let idadmission = $(this).data("idadmission");
        $("#infoLoader").removeClass("d-none");
        $("#infoContent").addClass("d-none");
        $("#infoText").html("No hay información disponible.");
        $("#modalInformation").modal("show");

        $.ajax({
            url: `/admin/admision/admisiones/informacion/${idadmission}`,
            type: 'GET',
            success: function (response) {
                if (response.status) {
                    $("#infoText").html(response.informacion);
                } else {
                    $("#infoText").html("No hay información disponible.");
                }
                $("#infoLoader").addClass("d-none");
                $("#infoContent").removeClass("d-none");
            },
            error: function () {
                $("#infoText").html("Error al cargar la información.");
                $("#infoLoader").addClass("d-none");
                $("#infoContent").removeClass("d-none");
            }
        });
    });

});


