<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('parametros_academicos', function (Blueprint $table) {
            $table->id();

            $table->string('short_name', 100)->unique();
            $table->string('name', 100);
            $table->string('value', 100);
            $table->string('description', 225)->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('parametros_academicos');
    }
};
