<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('sedes', function (Blueprint $table) {
            $table->id();

            $table->string('tipo_sede', 50);       // Tipo de campus (Central, Anexo, Filial, etc.)
            $table->string('codigo', 50);
            $table->string('nombre', 50);
            $table->string('nombre_corto', 50)->nullable();
            $table->string('direccion', 255);
            $table->string('telefono', 50)->nullable();
            $table->string('correo', 50)->nullable();
            $table->string('nombre_representante', 50)->nullable();
            $table->string('horas_servicio', 50)->nullable();

            $table->timestamps();

        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('sedes');
    }
};
