<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('auditorias', function (Blueprint $table) {
            $table->id();
            
            $table->unsignedBigInteger('user_id');
            
            $table->string('tabla_id', 255)->nullable();
            $table->string('tabla_modelo', 255)->nullable();
            $table->string('tabla_nombre', 255)->nullable();
            $table->time('accion')->nullable();
            $table->text('informacion')->nullable();
            $table->time('fecha_hora')->nullable();
            
            $table->foreign('user_id')->references('id')->on('usuarios');
            
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('auditorias');
    }
};
