<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('detalle_actividades_cnl', function (Blueprint $table) {
            $table->id();
            $table->string('dia', 45);
            $table->time('horaini');
            $table->time('horafin');
            $table->time('duracion')->nullable();
            $table->unsignedBigInteger('actividad_cnl_id');
            $table->foreign('actividad_cnl_id')->references('id')->on('actividades_cnl')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('deatalle_actividades_cnl');
    }
};
