<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('actividades_cnl', function (Blueprint $table) {
            $table->id();
            $table->time('total_horas')->nullable();
            $table->string('nombre', length: 350);
            $table->text('descripcion')->nullable();
            $table->enum('estado', ['activa', 'inactiva']);
            $table->unsignedBigInteger('docente_id');
            $table->foreign('docente_id')->references('id')->on('docentes')->onDelete('cascade');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('actividades_cnl');
    }
};
