<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('citas_presenciales', function (Blueprint $table) {
            $table->id();
            
            $table->unsignedBigInteger('user_id')->nullable(); 
            $table->unsignedBigInteger('user2_id')->nullable(); 
            $table->string('dni', 256)->nullable(); 
            $table->string('nombres', 256)->nullable(); 
            $table->string('apellido_pa', 256)->nullable(); 
            $table->string('apellido_ma', 256)->nullable(); 
            $table->string('email', 256)->nullable(); 
            $table->string('celular', 256)->nullable();
            $table->text('datos_cita')->nullable();
            $table->text('asunto')->nullable();
            $table->date('fecha')->nullable();
            $table->time('horaini')->nullable();
            $table->time('horafin')->nullable(); 
            $table->tinyInteger('estado')->nullable();
            
            $table->foreign('user_id')->references('id')->on('usuarios');
            $table->foreign('user2_id')->references('id')->on('usuarios');
            
            $table->timestamps();
        });
    }
    
    public function down(): void
    {
        Schema::dropIfExists('citas_presenciales');
    }
};
