<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('efsrt_estudiantes', function (Blueprint $table) {
            $table->id();
            
            $table->unsignedBigInteger('efsrt_id'); 
            $table->unsignedBigInteger('agreement_id');
            $table->integer('horas')->nullable(); 
            $table->tinyInteger('estado')->nullable();
            
            $table->foreign('efsrt_id')->references('id')->on('efsrts');
            $table->foreign('agreement_id')->references('id')->on('convenios_efsrt');
            
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('efsrt_estudiantes');
    }
};
