<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('efsrts', function (Blueprint $table) {
            $table->id();

            $table->unsignedBigInteger('user_id'); // instructor (administrador o docente)
            $table->unsignedBigInteger('module_training_id');
            $table->integer('total_horas')->nullable();
            $table->tinyInteger('estado')->nullable();

            $table->foreign('student_id')->references('id')->on('estudiantes');
            $table->foreign('module_training_id')->references('id')->on('modulos_formativos');

            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('efsrts');
    }
};
