<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('citas', function (Blueprint $table) {
            $table->id();

            $table->unsignedBigInteger('user_id');
            $table->unsignedBigInteger('appointment_type_id')->nullable();
            $table->string('asunto', 255)->nullable();
            $table->text('descripcion')->nullable();
            $table->dateTime('fecha_ini')->nullable();
            $table->dateTime('fecha_fin')->nullable();
            $table->string('ubicacion', 255)->nullable();
            $table->text('motivo_cancelacion')->nullable();
            $table->dateTime('fecha_ini_rep')->nullable();
            $table->dateTime('fecha_fin_rep')->nullable();
            $table->tinyInteger('estado')->nullable();

            $table->foreign('user_id')->references('id')->on('usuarios');
            $table->foreign('appointment_type_id')->references('id')->on('tipos_citas');

            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('citas');
    }
};
