<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('respuestas_foros', function (Blueprint $table) {
            $table->id();

            $table->unsignedBigInteger('forum_id');
            $table->unsignedBigInteger('student_id');
            $table->text('comentario')->nullable();

            $table->foreign('forum_id')->references('id')->on('foros');
            $table->foreign('student_id')->references('id')->on('estudiantes');

            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('respuestas_foros');
    }
};
