<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('foros', function (Blueprint $table) {
            $table->id();

            $table->unsignedBigInteger('subject_id');
            $table->text('titulo');
            $table->text('descripcion')->nullable();
            $table->date('fecinicio');
            $table->date('fecfin');
            $table->text('ruta')->nullable();
            $table->string('archivo',250)->nullable();

            $table->foreign('subject_id')->references('id')->on('asignaturas');

            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('foros');
    }
};
